/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.KnnByteVectorField;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.opensearch.common.Explicit;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.VectorField;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.KNNMappingConfig;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapperUtil;
import org.opensearch.knn.index.mapper.KNNVectorFieldType;
import org.opensearch.knn.index.mapper.Mode;
import org.opensearch.knn.index.mapper.OriginalMappingParameters;
import org.opensearch.knn.index.mapper.PerDimensionProcessor;
import org.opensearch.knn.index.mapper.PerDimensionValidator;
import org.opensearch.knn.index.mapper.VectorValidator;

public class LuceneFieldMapper
extends KNNVectorFieldMapper {
    private final FieldType vectorFieldType;
    private final PerDimensionProcessor perDimensionProcessor;
    private final PerDimensionValidator perDimensionValidator;
    private final VectorValidator vectorValidator;

    static LuceneFieldMapper createFieldMapper(String fullname, Map<String, String> metaValue, final KNNMethodConfigContext knnMethodConfigContext, CreateLuceneFieldMapperInput createLuceneFieldMapperInput, final OriginalMappingParameters originalMappingParameters) {
        KNNVectorFieldType mappedFieldType = new KNNVectorFieldType(fullname, metaValue, knnMethodConfigContext.getVectorDataType(), new KNNMappingConfig(){

            @Override
            public Optional<KNNMethodContext> getKnnMethodContext() {
                return Optional.of(originalMappingParameters.getResolvedKnnMethodContext());
            }

            @Override
            public int getDimension() {
                return knnMethodConfigContext.getDimension();
            }

            @Override
            public Mode getMode() {
                return knnMethodConfigContext.getMode();
            }

            @Override
            public CompressionLevel getCompressionLevel() {
                return knnMethodConfigContext.getCompressionLevel();
            }
        });
        return new LuceneFieldMapper(mappedFieldType, createLuceneFieldMapperInput, knnMethodConfigContext, originalMappingParameters);
    }

    private LuceneFieldMapper(KNNVectorFieldType mappedFieldType, CreateLuceneFieldMapperInput input, KNNMethodConfigContext knnMethodConfigContext, OriginalMappingParameters originalMappingParameters) {
        super(input.getName(), mappedFieldType, input.getMultiFields(), input.getCopyTo(), input.getIgnoreMalformed(), input.isStored(), input.isHasDocValues(), knnMethodConfigContext.getVersionCreated(), originalMappingParameters);
        KNNMappingConfig knnMappingConfig = mappedFieldType.getKnnMappingConfig();
        KNNMethodContext resolvedKnnMethodContext = originalMappingParameters.getResolvedKnnMethodContext();
        VectorDataType vectorDataType = mappedFieldType.getVectorDataType();
        VectorSimilarityFunction vectorSimilarityFunction = resolvedKnnMethodContext.getSpaceType().getKnnVectorSimilarityFunction().getVectorSimilarityFunction();
        this.fieldType = vectorDataType.createKnnVectorFieldType(knnMappingConfig.getDimension(), vectorSimilarityFunction);
        this.vectorFieldType = this.hasDocValues ? KNNVectorFieldMapperUtil.buildDocValuesFieldType(resolvedKnnMethodContext.getKnnEngine()) : null;
        KNNLibraryIndexingContext knnLibraryIndexingContext = resolvedKnnMethodContext.getKnnEngine().getKNNLibraryIndexingContext(resolvedKnnMethodContext, knnMethodConfigContext);
        this.perDimensionProcessor = knnLibraryIndexingContext.getPerDimensionProcessor();
        this.perDimensionValidator = knnLibraryIndexingContext.getPerDimensionValidator();
        this.vectorValidator = knnLibraryIndexingContext.getVectorValidator();
    }

    @Override
    protected List<Field> getFieldsForFloatVector(float[] array) {
        ArrayList<Field> fieldsToBeAdded = new ArrayList<Field>();
        fieldsToBeAdded.add((Field)new KnnFloatVectorField(this.name(), array, this.fieldType));
        if (this.hasDocValues && this.vectorFieldType != null) {
            fieldsToBeAdded.add(new VectorField(this.name(), array, (IndexableFieldType)this.vectorFieldType));
        }
        if (this.stored) {
            fieldsToBeAdded.add((Field)KNNVectorFieldMapperUtil.createStoredFieldForFloatVector(this.name(), array));
        }
        return fieldsToBeAdded;
    }

    @Override
    protected List<Field> getFieldsForByteVector(byte[] array) {
        ArrayList<Field> fieldsToBeAdded = new ArrayList<Field>();
        fieldsToBeAdded.add((Field)new KnnByteVectorField(this.name(), array, this.fieldType));
        if (this.hasDocValues && this.vectorFieldType != null) {
            fieldsToBeAdded.add(new VectorField(this.name(), array, (IndexableFieldType)this.vectorFieldType));
        }
        if (this.stored) {
            fieldsToBeAdded.add((Field)KNNVectorFieldMapperUtil.createStoredFieldForByteVector(this.name(), array));
        }
        return fieldsToBeAdded;
    }

    @Override
    protected VectorValidator getVectorValidator() {
        return this.vectorValidator;
    }

    @Override
    protected PerDimensionValidator getPerDimensionValidator() {
        return this.perDimensionValidator;
    }

    @Override
    protected PerDimensionProcessor getPerDimensionProcessor() {
        return this.perDimensionProcessor;
    }

    @Override
    void updateEngineStats() {
        KNNEngine.LUCENE.setInitialized(true);
    }

    static class CreateLuceneFieldMapperInput {
        @NonNull
        String name;
        @NonNull
        FieldMapper.MultiFields multiFields;
        @NonNull
        FieldMapper.CopyTo copyTo;
        @NonNull
        Explicit<Boolean> ignoreMalformed;
        boolean stored;
        boolean hasDocValues;
        KNNMethodContext originalKnnMethodContext;

        @Generated
        public static CreateLuceneFieldMapperInputBuilder builder() {
            return new CreateLuceneFieldMapperInputBuilder();
        }

        @Generated
        public CreateLuceneFieldMapperInput(@NonNull String name, @NonNull FieldMapper.MultiFields multiFields, @NonNull FieldMapper.CopyTo copyTo, @NonNull Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, KNNMethodContext originalKnnMethodContext) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (multiFields == null) {
                throw new NullPointerException("multiFields is marked non-null but is null");
            }
            if (copyTo == null) {
                throw new NullPointerException("copyTo is marked non-null but is null");
            }
            if (ignoreMalformed == null) {
                throw new NullPointerException("ignoreMalformed is marked non-null but is null");
            }
            this.name = name;
            this.multiFields = multiFields;
            this.copyTo = copyTo;
            this.ignoreMalformed = ignoreMalformed;
            this.stored = stored;
            this.hasDocValues = hasDocValues;
            this.originalKnnMethodContext = originalKnnMethodContext;
        }

        @NonNull
        @Generated
        public String getName() {
            return this.name;
        }

        @NonNull
        @Generated
        public FieldMapper.MultiFields getMultiFields() {
            return this.multiFields;
        }

        @NonNull
        @Generated
        public FieldMapper.CopyTo getCopyTo() {
            return this.copyTo;
        }

        @NonNull
        @Generated
        public Explicit<Boolean> getIgnoreMalformed() {
            return this.ignoreMalformed;
        }

        @Generated
        public boolean isStored() {
            return this.stored;
        }

        @Generated
        public boolean isHasDocValues() {
            return this.hasDocValues;
        }

        @Generated
        public KNNMethodContext getOriginalKnnMethodContext() {
            return this.originalKnnMethodContext;
        }

        @Generated
        public static class CreateLuceneFieldMapperInputBuilder {
            @Generated
            private String name;
            @Generated
            private FieldMapper.MultiFields multiFields;
            @Generated
            private FieldMapper.CopyTo copyTo;
            @Generated
            private Explicit<Boolean> ignoreMalformed;
            @Generated
            private boolean stored;
            @Generated
            private boolean hasDocValues;
            @Generated
            private KNNMethodContext originalKnnMethodContext;

            @Generated
            CreateLuceneFieldMapperInputBuilder() {
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder multiFields(@NonNull FieldMapper.MultiFields multiFields) {
                if (multiFields == null) {
                    throw new NullPointerException("multiFields is marked non-null but is null");
                }
                this.multiFields = multiFields;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder copyTo(@NonNull FieldMapper.CopyTo copyTo) {
                if (copyTo == null) {
                    throw new NullPointerException("copyTo is marked non-null but is null");
                }
                this.copyTo = copyTo;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder ignoreMalformed(@NonNull Explicit<Boolean> ignoreMalformed) {
                if (ignoreMalformed == null) {
                    throw new NullPointerException("ignoreMalformed is marked non-null but is null");
                }
                this.ignoreMalformed = ignoreMalformed;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder stored(boolean stored) {
                this.stored = stored;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder hasDocValues(boolean hasDocValues) {
                this.hasDocValues = hasDocValues;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInputBuilder originalKnnMethodContext(KNNMethodContext originalKnnMethodContext) {
                this.originalKnnMethodContext = originalKnnMethodContext;
                return this;
            }

            @Generated
            public CreateLuceneFieldMapperInput build() {
                return new CreateLuceneFieldMapperInput(this.name, this.multiFields, this.copyTo, this.ignoreMalformed, this.stored, this.hasDocValues, this.originalKnnMethodContext);
            }

            @Generated
            public String toString() {
                return "LuceneFieldMapper.CreateLuceneFieldMapperInput.CreateLuceneFieldMapperInputBuilder(name=" + this.name + ", multiFields=" + this.multiFields + ", copyTo=" + this.copyTo + ", ignoreMalformed=" + this.ignoreMalformed + ", stored=" + this.stored + ", hasDocValues=" + this.hasDocValues + ", originalKnnMethodContext=" + this.originalKnnMethodContext + ")";
            }
        }
    }
}

