/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.training;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.UUIDs;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.Mode;
import org.opensearch.knn.index.memory.NativeMemoryAllocation;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;
import org.opensearch.knn.index.memory.NativeMemoryEntryContext;
import org.opensearch.knn.indices.Model;
import org.opensearch.knn.indices.ModelMetadata;
import org.opensearch.knn.indices.ModelState;
import org.opensearch.knn.jni.JNIService;
import org.opensearch.knn.plugin.stats.KNNCounter;

public class TrainingJob
implements Runnable {
    public static Logger logger = LogManager.getLogger(TrainingJob.class);
    private final KNNMethodContext knnMethodContext;
    private final KNNMethodConfigContext knnMethodConfigContext;
    private final NativeMemoryCacheManager nativeMemoryCacheManager;
    private final NativeMemoryEntryContext.TrainingDataEntryContext trainingDataEntryContext;
    private final NativeMemoryEntryContext.AnonymousEntryContext modelAnonymousEntryContext;
    private final Model model;
    private final String modelId;

    public TrainingJob(String modelId, KNNMethodContext knnMethodContext, NativeMemoryCacheManager nativeMemoryCacheManager, NativeMemoryEntryContext.TrainingDataEntryContext trainingDataEntryContext, NativeMemoryEntryContext.AnonymousEntryContext modelAnonymousEntryContext, KNNMethodConfigContext knnMethodConfigContext, String description, String nodeAssignment, Mode mode, CompressionLevel compressionLevel) {
        this.modelId = StringUtils.isNotBlank((String)modelId) ? modelId : UUIDs.randomBase64UUID();
        this.knnMethodContext = Objects.requireNonNull(knnMethodContext, "MethodContext cannot be null.");
        this.knnMethodConfigContext = knnMethodConfigContext;
        this.nativeMemoryCacheManager = Objects.requireNonNull(nativeMemoryCacheManager, "NativeMemoryCacheManager cannot be null.");
        this.trainingDataEntryContext = Objects.requireNonNull(trainingDataEntryContext, "TrainingDataEntryContext cannot be null.");
        this.modelAnonymousEntryContext = Objects.requireNonNull(modelAnonymousEntryContext, "AnonymousEntryContext cannot be null.");
        this.model = new Model(new ModelMetadata(knnMethodContext.getKnnEngine(), knnMethodContext.getSpaceType(), knnMethodConfigContext.getDimension(), ModelState.TRAINING, ZonedDateTime.now(ZoneOffset.UTC).toString(), description, "", nodeAssignment, knnMethodContext.getMethodComponentContext(), knnMethodConfigContext.getVectorDataType(), mode, compressionLevel, knnMethodConfigContext.getVersionCreated()), null, this.modelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NativeMemoryAllocation trainingDataAllocation = null;
        NativeMemoryAllocation modelAnonymousAllocation = null;
        ModelMetadata modelMetadata = this.model.getModelMetadata();
        try {
            trainingDataAllocation = this.nativeMemoryCacheManager.get(this.trainingDataEntryContext, false);
            trainingDataAllocation.readLock();
        }
        catch (Exception e) {
            logger.error("Failed to get training data for model \"" + this.modelId + "\": " + e.getMessage());
            modelMetadata.setState(ModelState.FAILED);
            modelMetadata.setError("Failed to load training data into memory. Check if there is enough memory to perform the request.");
            if (trainingDataAllocation != null) {
                this.nativeMemoryCacheManager.invalidate(this.trainingDataEntryContext.getKey());
            }
            KNNCounter.TRAINING_ERRORS.increment();
            return;
        }
        try {
            modelAnonymousAllocation = this.nativeMemoryCacheManager.get(this.modelAnonymousEntryContext, false);
            modelAnonymousAllocation.readLock();
        }
        catch (Exception e) {
            logger.error("Failed to allocate space in native memory for model \"" + this.modelId + "\": " + e.getMessage());
            modelMetadata.setState(ModelState.FAILED);
            modelMetadata.setError("Failed to allocate space in native memory for the model. Check if there is enough memory to perform the request.");
            trainingDataAllocation.readUnlock();
            this.nativeMemoryCacheManager.invalidate(this.trainingDataEntryContext.getKey());
            if (modelAnonymousAllocation != null) {
                this.nativeMemoryCacheManager.invalidate(this.modelAnonymousEntryContext.getKey());
            }
            KNNCounter.TRAINING_ERRORS.increment();
            return;
        }
        try {
            if (modelAnonymousAllocation.isClosed()) {
                throw new RuntimeException("Unable to reserve memory for model: allocation is already closed");
            }
            if (trainingDataAllocation.isClosed()) {
                throw new RuntimeException("Unable to load training data into memory: allocation is already closed");
            }
            KNNLibraryIndexingContext libraryIndexingContext = this.model.getModelMetadata().getKnnEngine().getKNNLibraryIndexingContext(this.knnMethodContext, this.knnMethodConfigContext);
            Map<String, Object> trainParameters = libraryIndexingContext.getLibraryParameters();
            trainParameters.put("indexThreadQty", KNNSettings.state().getSettingValue("knn.algo_param.index_thread_qty"));
            if (libraryIndexingContext.getQuantizationConfig() != QuantizationConfig.EMPTY) {
                trainParameters.put("data_type", VectorDataType.BINARY.getValue());
            } else {
                trainParameters.put("data_type", modelMetadata.getVectorDataType().getValue());
            }
            byte[] modelBlob = JNIService.trainIndex(trainParameters, this.model.getModelMetadata().getDimension(), trainingDataAllocation.getMemoryAddress(), this.model.getModelMetadata().getKnnEngine());
            this.model.setModelBlob(modelBlob);
            modelMetadata.setState(ModelState.CREATED);
        }
        catch (Exception e) {
            logger.error("Failed to run training job for model \"" + this.modelId + "\": ", (Throwable)e);
            modelMetadata.setState(ModelState.FAILED);
            modelMetadata.setError("Failed to execute training. May be caused by an invalid method definition or not enough memory to perform training.");
            KNNCounter.TRAINING_ERRORS.increment();
        }
        finally {
            trainingDataAllocation.readUnlock();
            modelAnonymousAllocation.readUnlock();
            this.nativeMemoryCacheManager.invalidate(this.trainingDataEntryContext.getKey());
            this.nativeMemoryCacheManager.invalidate(this.modelAnonymousEntryContext.getKey());
        }
    }

    @Generated
    public Model getModel() {
        return this.model;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }
}

