/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.controller;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.controller.MLRateLimiter;
import org.opensearch.ml.common.utils.StringUtils;

public class MLController
implements ToXContentObject,
Writeable {
    public static final String MODEL_ID_FIELD = "model_id";
    public static final String USER_RATE_LIMITER = "user_rate_limiter";
    private String modelId;
    private Map<String, MLRateLimiter> userRateLimiter;

    public MLController(String modelId, Map<String, MLRateLimiter> userRateLimiter) {
        this.modelId = modelId;
        this.userRateLimiter = userRateLimiter;
    }

    public static MLController parse(XContentParser parser) throws IOException {
        String modelId = null;
        HashMap<String, MLRateLimiter> userRateLimiter = new HashMap<String, MLRateLimiter>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "model_id": {
                    modelId = parser.text();
                    continue block8;
                }
                case "user_rate_limiter": {
                    Map<String, String> userRateLimiterStringMap = StringUtils.getParameterMap(parser.map());
                    userRateLimiterStringMap.forEach((user, rateLimiterString) -> {
                        try {
                            XContentParser rateLimiterParser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, rateLimiterString);
                            rateLimiterParser.nextToken();
                            MLRateLimiter rateLimiter = MLRateLimiter.parse(rateLimiterParser);
                            if (!rateLimiter.isEmpty()) {
                                userRateLimiter.put((String)user, rateLimiter);
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    continue block8;
                }
            }
            parser.skipChildren();
        }
        return new MLController(modelId, userRateLimiter);
    }

    public MLController(StreamInput in) throws IOException {
        this.modelId = in.readString();
        if (in.readBoolean()) {
            this.userRateLimiter = in.readMap(StreamInput::readString, MLRateLimiter::new);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        if (this.userRateLimiter != null) {
            out.writeBoolean(true);
            out.writeMap(this.userRateLimiter, StreamOutput::writeString, (streamOutput, rateLimiter) -> rateLimiter.writeTo(streamOutput));
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODEL_ID_FIELD, this.modelId);
        if (this.userRateLimiter != null) {
            builder.field(USER_RATE_LIMITER, this.userRateLimiter);
        }
        builder.endObject();
        return builder;
    }

    public boolean isDeployRequiredAfterUpdate(MLController updateContent) {
        if (updateContent != null && updateContent.getUserRateLimiter() != null && !updateContent.getUserRateLimiter().isEmpty()) {
            Map<String, MLRateLimiter> updateUserRateLimiter = updateContent.getUserRateLimiter();
            for (Map.Entry<String, MLRateLimiter> entry : updateUserRateLimiter.entrySet()) {
                MLRateLimiter oldRateLimiter;
                String newUser = entry.getKey();
                MLRateLimiter newRateLimiter = entry.getValue();
                if (!(this.userRateLimiter.containsKey(newUser) ? MLRateLimiter.isDeployRequiredAfterUpdate(oldRateLimiter = this.userRateLimiter.get(newUser), newRateLimiter) : newRateLimiter.isValid())) continue;
                return true;
            }
        }
        return false;
    }

    public void update(MLController updateContent) {
        Map<String, MLRateLimiter> updateUserRateLimiter = updateContent.getUserRateLimiter();
        if (updateUserRateLimiter != null && !updateUserRateLimiter.isEmpty()) {
            updateUserRateLimiter.forEach((user, rateLimiter) -> {
                if (this.userRateLimiter.containsKey(user)) {
                    this.userRateLimiter.get(user).update((MLRateLimiter)rateLimiter);
                } else {
                    this.userRateLimiter.put((String)user, (MLRateLimiter)rateLimiter);
                }
            });
        }
    }

    @Generated
    public static MLControllerBuilder builder() {
        return new MLControllerBuilder();
    }

    @Generated
    public MLControllerBuilder toBuilder() {
        return new MLControllerBuilder().modelId(this.modelId).userRateLimiter(this.userRateLimiter);
    }

    @Generated
    public Map<String, MLRateLimiter> getUserRateLimiter() {
        return this.userRateLimiter;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setUserRateLimiter(Map<String, MLRateLimiter> userRateLimiter) {
        this.userRateLimiter = userRateLimiter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLController)) {
            return false;
        }
        MLController other = (MLController)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$modelId = this.getModelId();
        String other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
            return false;
        }
        Map<String, MLRateLimiter> this$userRateLimiter = this.getUserRateLimiter();
        Map<String, MLRateLimiter> other$userRateLimiter = other.getUserRateLimiter();
        return !(this$userRateLimiter == null ? other$userRateLimiter != null : !((Object)this$userRateLimiter).equals(other$userRateLimiter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLController;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
        Map<String, MLRateLimiter> $userRateLimiter = this.getUserRateLimiter();
        result = result * 59 + ($userRateLimiter == null ? 43 : ((Object)$userRateLimiter).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLController(modelId=" + this.getModelId() + ", userRateLimiter=" + this.getUserRateLimiter() + ")";
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public static class MLControllerBuilder {
        @Generated
        private String modelId;
        @Generated
        private Map<String, MLRateLimiter> userRateLimiter;

        @Generated
        MLControllerBuilder() {
        }

        @Generated
        public MLControllerBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public MLControllerBuilder userRateLimiter(Map<String, MLRateLimiter> userRateLimiter) {
            this.userRateLimiter = userRateLimiter;
            return this;
        }

        @Generated
        public MLController build() {
            return new MLController(this.modelId, this.userRateLimiter);
        }

        @Generated
        public String toString() {
            return "MLController.MLControllerBuilder(modelId=" + this.modelId + ", userRateLimiter=" + this.userRateLimiter + ")";
        }
    }
}

