/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.matching;

import com.facebook.presto.matching.PatternVisitor;
import com.facebook.presto.matching.pattern.CapturePattern;
import com.facebook.presto.matching.pattern.EqualsPattern;
import com.facebook.presto.matching.pattern.FilterPattern;
import com.facebook.presto.matching.pattern.TypeOfPattern;
import com.facebook.presto.matching.pattern.WithPattern;
import com.google.common.base.Strings;

public class DefaultPrinter
implements PatternVisitor {
    private final StringBuilder result = new StringBuilder();
    private int level;

    public String result() {
        return this.result.toString();
    }

    @Override
    public void visitTypeOf(TypeOfPattern<?> pattern) {
        this.visitPrevious(pattern);
        this.appendLine("typeOf(%s)", pattern.expectedClass().getSimpleName());
    }

    @Override
    public void visitWith(WithPattern<?> pattern) {
        this.visitPrevious(pattern);
        this.appendLine("with(%s)", pattern.getProperty().getName());
        ++this.level;
        pattern.getPattern().accept(this);
        --this.level;
    }

    @Override
    public void visitCapture(CapturePattern<?> pattern) {
        this.visitPrevious(pattern);
        this.appendLine("capturedAs(%s)", pattern.capture().description());
    }

    @Override
    public void visitEquals(EqualsPattern<?> pattern) {
        this.visitPrevious(pattern);
        this.appendLine("equals(%s)", pattern.expectedValue());
    }

    @Override
    public void visitFilter(FilterPattern<?> pattern) {
        this.visitPrevious(pattern);
        this.appendLine("filter(%s)", pattern.predicate());
    }

    private void appendLine(String template, Object ... arguments) {
        this.result.append(Strings.repeat((String)"\t", (int)this.level)).append(String.format(template + "\n", arguments));
    }
}

