/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.latex;

import java.awt.Container;
import java.util.Set;
import javax.swing.JComponent;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.map.INodeView;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.ui.INodeViewLifeCycleListener;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.plugin.latex.LatexExtension;
import org.freeplane.plugin.latex.LatexViewer;
import org.freeplane.plugin.latex.LegacyLatexEditor;
import org.freeplane.view.swing.map.NodeView;

@NodeHookDescriptor(hookName="plugins/latex/LatexNodeHook.properties", onceForMap=false)
class LatexNodeHook
extends PersistentNodeHook
implements INodeViewLifeCycleListener {
    static final int VIEWER_POSITION = 4;

    public LatexNodeHook() {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addINodeViewLifeCycleListener((INodeViewLifeCycleListener)this);
    }

    public void add(NodeModel node, IExtension extension) {
        LatexExtension latexExtension = (LatexExtension)extension;
        for (NodeModel nodeClone : node.allClones()) {
            for (INodeView iNodeView : nodeClone.getViewers()) {
                NodeView view = (NodeView)iNodeView;
                this.createViewer(latexExtension, view);
            }
        }
        super.add(node, extension);
    }

    protected IExtension createExtension(NodeModel node, XMLElement element) {
        LatexExtension latexExtension = new LatexExtension();
        if (element != null) {
            String equation = element.getAttribute("EQUATION", null);
            if (equation == null) {
                return null;
            }
            latexExtension.setEquation(equation);
            Controller.getCurrentModeController().getMapController().nodeChanged(node, NodeModel.UNKNOWN_PROPERTY, null, null);
        }
        return latexExtension;
    }

    protected PersistentNodeHook.HookAction createHookAction() {
        return null;
    }

    void createViewer(LatexExtension model, NodeView view) {
        LatexViewer comp = new LatexViewer(this, model);
        Set<NodeView> viewers = model.getViewers();
        viewers.add(view);
        view.addContent((JComponent)comp, 4);
    }

    void deleteViewer(LatexExtension model, NodeView nodeView) {
        Set<NodeView> viewers = model.getViewers();
        if (!viewers.contains(nodeView)) {
            return;
        }
        nodeView.removeContent(4);
        viewers.remove(nodeView);
    }

    protected Class<LatexExtension> getExtensionClass() {
        return LatexExtension.class;
    }

    public void onViewCreated(Container container) {
        NodeView nodeView = (NodeView)container;
        LatexExtension latexExtension = (LatexExtension)nodeView.getNode().getExtension(LatexExtension.class);
        if (latexExtension == null) {
            return;
        }
        this.createViewer(latexExtension, nodeView);
    }

    public void onViewRemoved(Container container) {
        NodeView nodeView = (NodeView)container;
        LatexExtension latexExtension = (LatexExtension)nodeView.getNode().getExtension(LatexExtension.class);
        if (latexExtension == null) {
            return;
        }
        this.deleteViewer(latexExtension, nodeView);
    }

    protected void remove(NodeModel node, IExtension extension) {
        LatexExtension latexExtension = (LatexExtension)extension;
        latexExtension.removeViewers();
        super.remove(node, extension);
    }

    protected void saveExtension(IExtension extension, XMLElement element) {
        LatexExtension latexExtension = (LatexExtension)extension;
        element.setAttribute("EQUATION", latexExtension.getEquation());
        super.saveExtension(extension, element);
    }

    void setEquationUndoable(final LatexExtension model, final String newEquation) {
        final String equation = model.getEquation();
        if (equation.equals(newEquation)) {
            return;
        }
        IActor actor = new IActor(){
            private final String oldEquation;
            {
                this.oldEquation = equation;
            }

            public void act() {
                model.setEquation(newEquation);
                MapModel map = Controller.getCurrentModeController().getController().getMap();
                Controller.getCurrentModeController().getMapController().mapSaved(map, false);
            }

            public String getDescription() {
                return "setLatexEquationUndoable";
            }

            public void undo() {
                model.setEquation(this.oldEquation);
            }
        };
        Controller.getCurrentModeController().execute(actor, Controller.getCurrentModeController().getController().getMap());
    }

    public void undoableToggleHook(NodeModel node, IExtension extension) {
        if (extension != null) {
            super.undoableToggleHook(node, extension);
            return;
        }
        String equation = LegacyLatexEditor.editLatex("", node);
        if (equation == null || "".equals(equation.trim())) {
            return;
        }
        super.undoableToggleHook(node, null);
        LatexExtension latexExtension = (LatexExtension)node.getExtension(LatexExtension.class);
        this.setEquationUndoable(latexExtension, equation);
    }

    void editLatexInEditor(NodeModel node) {
        LatexExtension latexExtension = (LatexExtension)node.getExtension(LatexExtension.class);
        String equation = latexExtension == null ? LegacyLatexEditor.editLatex("", node) : LegacyLatexEditor.editLatex(latexExtension.getEquation(), node);
        if (equation == null) {
            return;
        }
        if (!"".equals(equation.trim())) {
            if (latexExtension == null) {
                latexExtension = new LatexExtension();
                this.undoableActivateHook(node, latexExtension);
            }
            this.setEquationUndoable(latexExtension, equation);
        } else if (latexExtension != null) {
            this.undoableDeactivateHook(node);
        }
    }
}

