/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.Database;
import org.hsqldb.DatabaseType;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TransactionManagerMV2PL;
import org.hsqldb.TransactionManagerMVCC;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.IndexAVLMemory;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.EventLogInterface;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.InputStreamInterface;
import org.hsqldb.lib.InputStreamWrapper;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.tar.DbBackup;
import org.hsqldb.lib.tar.TarMalformatException;
import org.hsqldb.persist.Crypto;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.LockFile;
import org.hsqldb.persist.Log;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RAShadowFile;
import org.hsqldb.persist.RowStoreAVLDisk;
import org.hsqldb.persist.RowStoreAVLDiskData;
import org.hsqldb.persist.RowStoreAVLHybrid;
import org.hsqldb.persist.RowStoreAVLHybridExtended;
import org.hsqldb.persist.RowStoreAVLMemory;
import org.hsqldb.persist.RowStoreDataChange;
import org.hsqldb.persist.TextTableStorageManager;
import org.hsqldb.result.Result;
import org.hsqldb.scriptio.ScriptWriterBase;
import org.hsqldb.scriptio.ScriptWriterText;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class Logger
implements EventLogInterface {
    public SimpleLog appLog;
    public SimpleLog sqlLog;
    FrameworkLogger fwLogger;
    FrameworkLogger sqlLogger;
    private Database database;
    private boolean logsStatements;
    private boolean loggingEnabled;
    private boolean propIsFileDatabase;
    boolean propNioDataFile;
    long propNioMaxSize = 0x10000000L;
    int propMaxFreeBlocks = 512;
    private int propCacheMaxRows;
    private long propCacheMaxSize;
    int propDataFileDefragLimit;
    private int propDataFileScale;
    int propDataFileSpace;
    String propTextSourceDefault = "";
    boolean propTextAllowFullPath;
    private int propWriteDelay;
    private int propLogSize;
    private boolean propLogData = true;
    private int propExternalEventLogLevel;
    private int propEventLogLevel;
    int propSqlLogLevel;
    int propGC;
    int propTxMode = 0;
    boolean propRefIntegrity = true;
    int propLobBlockSize = 32768;
    boolean propCompressLobs;
    int propScriptFormat = 0;
    boolean propLargeData;
    long propFilesTimestamp;
    Log log;
    private LockFile lockFile;
    private Crypto crypto;
    boolean cryptLobs;
    public FileAccess fileAccess;
    String tempDirectoryPath;
    public TextTableStorageManager textTableManager = new TextTableStorageManager();
    public boolean isNewDatabase;
    public boolean isSingleFile;
    AtomicInteger backupState = new AtomicInteger();
    AtomicInteger checkpointState = new AtomicInteger();
    long maxLogSize;
    static final int largeDataFactor = 128;
    static final int stateNormal = 0;
    static final int stateBackup = 1;
    static final int stateCheckpoint = 2;
    static final int stateCheckpointNormal = 0;
    static final int stateCheckpointRequired = 1;
    static final int stateCheckpointDue = 2;
    public static final String oldFileExtension = ".old";
    public static final String newFileExtension = ".new";
    public static final String appLogFileExtension = ".app.log";
    public static final String sqlLogFileExtension = ".sql.log";
    public static final String logFileExtension = ".log";
    public static final String scriptFileExtension = ".script";
    public static final String propertiesFileExtension = ".properties";
    public static final String dataFileExtension = ".data";
    public static final String backupFileExtension = ".backup";
    public static final String lobsFileExtension = ".lobs";
    public static final String lockFileExtension = ".lck";
    public SimpleDateFormat fileDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private static char runtimeFileDelim = System.getProperty("file.separator").charAt(0);
    DbBackup backup;

    public Logger(Database database) {
        this.database = database;
    }

    public void open() {
        int n;
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        this.fileAccess = FileUtil.getFileAccess(this.database.isFilesInJar());
        this.propIsFileDatabase = this.database.getType().isFileBased();
        this.database.databaseProperties = new HsqlDatabaseProperties(this.database);
        this.propTextAllowFullPath = this.database.databaseProperties.isPropertyTrue("textdb.allow_full_path");
        if (this.propIsFileDatabase) {
            bl2 = this.database.databaseProperties.load();
            bl3 = this.fileAccess.isStreamElement(this.database.getPath() + scriptFileExtension);
            boolean bl4 = this.database.databaseProperties.isVersion18();
            if (bl4) {
                throw Error.error(453, "unsupported old database version");
            }
            bl = bl3;
            if (!bl) {
                bl = this.fileAccess.isStreamElement(this.database.getPath() + ".script.new");
                if (bl) {
                    this.database.databaseProperties.setDBModified(2);
                } else {
                    bl = this.fileAccess.isStreamElement(this.database.getPath() + dataFileExtension);
                    if (bl) {
                        throw Error.error(466, "database files not complete");
                    }
                    bl = this.fileAccess.isStreamElement(this.database.getPath() + backupFileExtension);
                    if (bl) {
                        throw Error.error(466, "database files not complete");
                    }
                }
            }
            this.isNewDatabase = !bl;
        } else {
            this.isNewDatabase = true;
        }
        if (this.isNewDatabase) {
            String string = this.newUniqueName();
            this.database.setDatabaseName(string);
            bl = this.database.isFilesInJar();
            if (bl |= this.database.urlProperties.isPropertyTrue("ifexists") || !this.database.urlProperties.isPropertyTrue("create", true)) {
                throw Error.error(465, this.database.getPath());
            }
            this.database.databaseProperties.setURLProperties(this.database.urlProperties);
        } else {
            if (!bl2) {
                this.database.databaseProperties.setDBModified(1);
            }
            if (this.database.urlProperties.isPropertyTrue("files_readonly")) {
                this.database.databaseProperties.setProperty("files_readonly", true);
            }
            if (this.database.urlProperties.isPropertyTrue("readonly")) {
                this.database.databaseProperties.setProperty("readonly", true);
            }
            if (!this.database.urlProperties.isPropertyTrue("hsqldb.lock_file", true)) {
                this.database.databaseProperties.setProperty("hsqldb.lock_file", false);
            }
        }
        this.setVariables();
        String string = null;
        String string2 = null;
        if (this.propIsFileDatabase && !this.database.isFilesReadOnly()) {
            string = this.database.getPath() + appLogFileExtension;
            string2 = this.database.getPath() + sqlLogFileExtension;
        }
        this.appLog = new SimpleLog(string, this.propEventLogLevel, false);
        this.sqlLog = new SimpleLog(string2, this.propSqlLogLevel, true);
        this.database.setReferentialIntegrity(this.propRefIntegrity);
        if (!this.isFileDatabase()) {
            return;
        }
        this.checkpointState.set(0);
        this.logsStatements = false;
        boolean bl5 = this.database.getProperties().isPropertyTrue("hsqldb.lock_file");
        if (bl5 && !this.database.isFilesReadOnly()) {
            this.acquireLock(this.database.getPath());
        }
        this.log = new Log(this.database);
        this.log.open();
        this.logsStatements = true;
        boolean bl6 = this.loggingEnabled = this.propLogData && !this.database.isFilesReadOnly();
        if (this.database.getNameString().isEmpty()) {
            this.database.setDatabaseName(this.newUniqueName());
        }
        if ((n = this.database.urlProperties.getIntegerProperty("hsqldb.applog", -1)) >= 0) {
            this.setEventLogLevel(n, false);
        }
        if ((n = this.database.urlProperties.getIntegerProperty("hsqldb.extlog", -1)) >= 0) {
            this.setExternalEventLogLevel(n);
        }
        if ((n = this.database.urlProperties.getIntegerProperty("hsqldb.sqllog", -1)) >= 0) {
            this.setEventLogLevel(n, true);
        }
    }

    private void setVariables() {
        String string;
        String string2;
        String string3;
        String string4 = this.database.urlProperties.getProperty("crypt_key");
        if (string4 != null) {
            string3 = this.database.urlProperties.getProperty("crypt_type");
            string2 = this.database.urlProperties.getProperty("crypt_provider");
            string = this.database.urlProperties.getProperty("crypt_iv");
            this.crypto = new Crypto(string4, string, string3, string2);
            this.cryptLobs = this.database.urlProperties.isPropertyTrue("crypt_lobs", true);
        }
        if (this.database.databaseProperties.isPropertyTrue("readonly")) {
            this.database.setReadOnly();
        }
        if (this.database.databaseProperties.isPropertyTrue("files_readonly")) {
            this.database.setFilesReadOnly();
        }
        if (!this.database.isFilesReadOnly()) {
            this.tempDirectoryPath = this.database.getType() == DatabaseType.DB_MEM ? this.database.getProperties().getStringProperty("hsqldb.temp_directory") : this.database.getPath() + ".tmp";
            if (this.tempDirectoryPath != null) {
                this.tempDirectoryPath = FileUtil.makeDirectories(this.tempDirectoryPath);
            }
        }
        this.propScriptFormat = this.database.databaseProperties.getIntegerProperty("hsqldb.script_format");
        this.propMaxFreeBlocks = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_free_count");
        this.propMaxFreeBlocks = ArrayUtil.getTwoPowerFloor(this.propMaxFreeBlocks);
        if (this.database.urlProperties.isPropertyTrue("hsqldb.large_data", false)) {
            this.propLargeData = true;
        }
        if (!this.database.databaseProperties.isPropertyTrue("sql.pad_space", true)) {
            this.database.collation.setPadding(false);
        }
        string3 = this.database.getProperties().getStringProperty("hsqldb.digest");
        this.database.granteeManager.setDigestAlgo(string3);
        if (!this.isNewDatabase) {
            return;
        }
        if (this.tempDirectoryPath != null) {
            int n = this.database.databaseProperties.getIntegerProperty("hsqldb.result_max_memory_rows");
            this.database.setResultMaxMemoryRows(n);
        }
        if ("CACHED".equalsIgnoreCase(string2 = this.database.databaseProperties.getStringProperty("hsqldb.default_table_type"))) {
            this.database.schemaManager.setDefaultTableType(5);
        }
        if ("MVCC".equalsIgnoreCase(string = this.database.databaseProperties.getStringProperty("hsqldb.tx"))) {
            this.propTxMode = 2;
        } else if ("MVLOCKS".equalsIgnoreCase(string)) {
            this.propTxMode = 1;
        } else if ("LOCKS".equalsIgnoreCase(string)) {
            this.propTxMode = 0;
        }
        switch (this.propTxMode) {
            case 0: {
                break;
            }
            case 1: {
                this.database.txManager = new TransactionManagerMV2PL(this.database);
                break;
            }
            case 2: {
                this.database.txManager = new TransactionManagerMVCC(this.database);
            }
        }
        String string5 = this.database.databaseProperties.getStringProperty("hsqldb.tx_level");
        this.database.defaultIsolationLevel = "SERIALIZABLE".equalsIgnoreCase(string5) ? 8 : 2;
        this.database.txConflictRollback = this.database.databaseProperties.isPropertyTrue("hsqldb.tx_conflict_rollback");
        this.database.txInterruptRollback = this.database.databaseProperties.isPropertyTrue("hsqldb.tx_interrupt_rollback");
        this.database.sqlRestrictExec = this.database.databaseProperties.isPropertyTrue("sql.restrict_exec");
        this.database.sqlEnforceNames = this.database.databaseProperties.isPropertyTrue("sql.enforce_names");
        this.database.sqlRegularNames = this.database.databaseProperties.isPropertyTrue("sql.regular_names");
        this.database.sqlEnforceRefs = this.database.databaseProperties.isPropertyTrue("sql.enforce_refs");
        this.database.sqlEnforceSize = this.database.databaseProperties.isPropertyTrue("sql.enforce_size");
        this.database.sqlEnforceTypes = this.database.databaseProperties.isPropertyTrue("sql.enforce_types");
        this.database.sqlEnforceTDCD = this.database.databaseProperties.isPropertyTrue("sql.enforce_tdc_delete");
        this.database.sqlEnforceTDCU = this.database.databaseProperties.isPropertyTrue("sql.enforce_tdc_update");
        this.database.sqlTranslateTTI = this.database.databaseProperties.isPropertyTrue("jdbc.translate_tti_types");
        this.database.sqlLiveObject = this.database.databaseProperties.isPropertyTrue("sql.live_object");
        this.database.sqlCharLiteral = this.database.databaseProperties.isPropertyTrue("sql.char_literal");
        this.database.sqlConcatNulls = this.database.databaseProperties.isPropertyTrue("sql.concat_nulls");
        this.database.sqlNullsFirst = this.database.databaseProperties.isPropertyTrue("sql.nulls_first");
        this.database.sqlNullsOrder = this.database.databaseProperties.isPropertyTrue("sql.nulls_order");
        this.database.sqlUniqueNulls = this.database.databaseProperties.isPropertyTrue("sql.unique_nulls");
        this.database.sqlConvertTruncate = this.database.databaseProperties.isPropertyTrue("sql.convert_trunc");
        this.database.sqlTruncateTrailing = this.database.databaseProperties.isPropertyTrue("sql.truncate_trailing");
        this.database.sqlAvgScale = this.database.databaseProperties.getIntegerProperty("sql.avg_scale");
        this.database.sqlMaxRecursive = this.database.databaseProperties.getIntegerProperty("sql.max_recursive");
        this.database.sqlDoubleNaN = this.database.databaseProperties.isPropertyTrue("sql.double_nan");
        this.database.sqlLongvarIsLob = this.database.databaseProperties.isPropertyTrue("sql.longvar_is_lob");
        this.database.sqlIgnoreCase = this.database.databaseProperties.isPropertyTrue("sql.ignore_case");
        this.database.sqlSyntaxDb2 = this.database.databaseProperties.isPropertyTrue("sql.syntax_db2");
        this.database.sqlSyntaxMss = this.database.databaseProperties.isPropertyTrue("sql.syntax_mss");
        this.database.sqlSyntaxMys = this.database.databaseProperties.isPropertyTrue("sql.syntax_mys");
        this.database.sqlSyntaxOra = this.database.databaseProperties.isPropertyTrue("sql.syntax_ora");
        this.database.sqlSyntaxPgs = this.database.databaseProperties.isPropertyTrue("sql.syntax_pgs");
        this.database.sqlSysIndexNames = this.database.databaseProperties.isPropertyTrue("sql.sys_index_names");
        this.database.sqlLowerCaseIdentifier = this.database.databaseProperties.isPropertyTrue("sql.lowercase_ident");
        if (this.database.databaseProperties.isPropertyTrue("sql.compare_in_locale")) {
            this.database.collation.setCollationAsLocale();
        }
        this.propEventLogLevel = this.database.databaseProperties.getIntegerProperty("hsqldb.applog");
        this.propExternalEventLogLevel = this.database.databaseProperties.getIntegerProperty("hsqldb.extlog");
        this.propSqlLogLevel = this.database.databaseProperties.getIntegerProperty("hsqldb.sqllog");
        if (this.database.databaseProperties.isPropertyTrue("files_readonly")) {
            this.database.setFilesReadOnly();
        }
        if (this.database.databaseProperties.isPropertyTrue("readonly")) {
            this.database.setReadOnly();
        }
        this.propNioDataFile = this.database.databaseProperties.isPropertyTrue("hsqldb.nio_data_file");
        this.propNioMaxSize = (long)this.database.databaseProperties.getIntegerProperty("hsqldb.nio_max_size") * 1024L * 1024L;
        this.propCacheMaxRows = this.database.databaseProperties.getIntegerProperty("hsqldb.cache_rows");
        this.propCacheMaxSize = (long)this.database.databaseProperties.getIntegerProperty("hsqldb.cache_size") * 1024L;
        this.setLobFileScaleNoCheck(this.database.databaseProperties.getIntegerProperty("hsqldb.lob_file_scale"));
        this.setLobFileCompressedNoCheck(this.database.databaseProperties.isPropertyTrue("hsqldb.lob_compressed"));
        this.setDataFileScaleNoCheck(this.database.databaseProperties.getIntegerProperty("hsqldb.cache_file_scale"));
        boolean bl = this.database.databaseProperties.isPropertyTrue("hsqldb.files_space");
        this.setDataFileSpace(bl);
        this.propDataFileDefragLimit = this.database.databaseProperties.getIntegerProperty("hsqldb.defrag_limit");
        this.propWriteDelay = this.database.databaseProperties.getIntegerProperty("hsqldb.write_delay_millis");
        if (!this.database.databaseProperties.isPropertyTrue("hsqldb.write_delay")) {
            this.propWriteDelay = 0;
        }
        this.setLogSize(this.database.databaseProperties.getIntegerProperty("hsqldb.log_size"));
        this.propLogData = this.database.databaseProperties.isPropertyTrue("hsqldb.log_data");
        this.propGC = this.database.databaseProperties.getIntegerProperty("runtime.gc_interval");
        this.propRefIntegrity = this.database.databaseProperties.isPropertyTrue("sql.ref_integrity");
    }

    public boolean close(int n) {
        boolean bl = true;
        if (this.log == null) {
            this.textTableManager.closeAllTextCaches(false);
            return true;
        }
        this.log.synchLog();
        this.database.lobManager.synch();
        try {
            switch (n) {
                case 1: {
                    this.log.closeImmediately();
                    break;
                }
                case 2: {
                    this.log.close(false);
                    break;
                }
                case 3: 
                case 4: {
                    this.log.close(true);
                }
            }
            this.database.persistentStoreCollection.release();
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("error closing log", throwable);
            bl = false;
        }
        this.logInfoEvent("Database closed");
        this.log = null;
        this.appLog.close();
        this.sqlLog.close();
        this.logsStatements = false;
        this.loggingEnabled = false;
        return bl;
    }

    String newUniqueName() {
        Object object = StringUtil.toPaddedString(Long.toHexString(System.currentTimeMillis()), 16, '0', false);
        object = "HSQLDB" + ((String)object).substring(6).toUpperCase(Locale.ENGLISH);
        return object;
    }

    public boolean isLogged() {
        return this.propIsFileDatabase && !this.database.isFilesReadOnly();
    }

    public boolean isCurrentlyLogged() {
        return this.loggingEnabled;
    }

    public boolean isAllowedFullPath() {
        return this.propTextAllowFullPath;
    }

    private void getEventLogger() {
        if (this.fwLogger != null) {
            return;
        }
        String string = this.database.getNameString();
        if (string.isEmpty()) {
            return;
        }
        this.fwLogger = FrameworkLogger.getLog("ENGINE", "hsqldb.db." + this.database.getNameString());
    }

    public void setEventLogLevel(int n, boolean bl) {
        if (n < 0 || n > 4) {
            throw Error.error(5556);
        }
        if (bl) {
            this.propSqlLogLevel = n;
            this.sqlLog.setLevel(n);
        } else {
            this.propEventLogLevel = n;
            this.appLog.setLevel(n);
        }
    }

    public void setExternalEventLogLevel(int n) {
        if (n < 0 || n > 4) {
            throw Error.error(5556);
        }
        this.propExternalEventLogLevel = n;
    }

    @Override
    public void logSevereEvent(String string, Throwable throwable) {
        this.getEventLogger();
        if (this.fwLogger != null && this.propExternalEventLogLevel >= 1) {
            this.fwLogger.severe(string, throwable);
        }
        if (this.appLog != null) {
            if (throwable == null) {
                this.appLog.logContext(1, string);
            } else {
                this.appLog.logContext(throwable, string, 1);
            }
        }
    }

    @Override
    public void logWarningEvent(String string, Throwable throwable) {
        this.getEventLogger();
        if (this.fwLogger != null && this.propExternalEventLogLevel >= 2) {
            this.fwLogger.warning(string, throwable);
        }
        this.appLog.logContext(throwable, string, 2);
    }

    @Override
    public void logInfoEvent(String string) {
        this.getEventLogger();
        if (this.fwLogger != null && this.propExternalEventLogLevel >= 3) {
            this.fwLogger.info(string);
        }
        this.appLog.logContext(3, string);
    }

    @Override
    public void logDetailEvent(String string) {
        this.getEventLogger();
        if (this.fwLogger != null && this.propExternalEventLogLevel >= 4) {
            this.fwLogger.finest(string);
        }
        if (this.appLog != null) {
            this.appLog.logContext(4, string);
        }
    }

    public void logStatementEvent(Session session, Statement statement, Object[] objectArray, Result result, int n) {
        if (this.sqlLog != null && n <= this.propSqlLogLevel) {
            String string = Long.toString(session.getId());
            String string2 = statement.getSQL();
            String string3 = "";
            int n2 = 0;
            if (this.propSqlLogLevel < 4) {
                if (string2.length() > 256) {
                    string2 = string2.substring(0, 256);
                }
                n2 = 32;
            }
            if (objectArray != null && objectArray.length > 0) {
                string3 = RowType.convertToSQLString(objectArray, statement.getParametersMetaData().getParameterTypes(), n2);
            }
            if (this.propSqlLogLevel == 4) {
                StringBuilder stringBuilder = new StringBuilder(string3);
                stringBuilder.append(' ').append('[');
                if (result.isError()) {
                    stringBuilder.append(result.getErrorCode());
                } else if (result.isData()) {
                    stringBuilder.append(result.getNavigator().getSize());
                } else if (result.isUpdateCount()) {
                    stringBuilder.append(result.getUpdateCount());
                }
                stringBuilder.append(']');
                string3 = stringBuilder.toString();
            }
            this.sqlLog.logContext(n, string, string2, string3);
        }
    }

    public int getSqlEventLogLevel() {
        return this.propSqlLogLevel;
    }

    public DataFileCache getCache() {
        if (this.log == null) {
            return null;
        }
        return this.log.getCache();
    }

    public boolean hasCache() {
        if (this.log == null) {
            return false;
        }
        return this.log.hasCache();
    }

    public synchronized void writeOtherStatement(Session session, String string) {
        if (this.loggingEnabled) {
            this.log.writeOtherStatement(session, string);
        }
    }

    public synchronized void writeInsertStatement(Session session, Row row, Table table) {
        if (this.loggingEnabled) {
            this.log.writeInsertStatement(session, row, table);
        }
    }

    public synchronized void writeDeleteStatement(Session session, Table table, Object[] objectArray) {
        if (this.loggingEnabled) {
            this.log.writeDeleteStatement(session, table, objectArray);
        }
    }

    public synchronized void writeSequenceStatement(Session session, NumberSequence numberSequence) {
        if (this.loggingEnabled) {
            this.log.writeSequenceStatement(session, numberSequence);
        }
    }

    public synchronized void writeCommitStatement(Session session) {
        if (this.loggingEnabled) {
            this.log.writeCommitStatement(session);
        } else if (this.maxLogSize > 0L && this.database.lobManager.getUsageChanged() > this.maxLogSize) {
            this.setCheckpointRequired();
        }
    }

    public synchronized void synchLog() {
        if (this.loggingEnabled) {
            this.log.synchLog();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpoint(Session session, boolean bl, boolean bl2) {
        if (!this.backupState.compareAndSet(0, 2)) {
            throw Error.error(457);
        }
        this.database.lobManager.lock();
        try {
            Logger logger = this;
            synchronized (logger) {
                this.checkpointInternal(session, bl);
                if (bl2) {
                    Result result = this.database.lobManager.deleteUnusedLobs();
                    if (this.log != null && result.getUpdateCount() > 0) {
                        this.log.synchLog();
                        this.logDetailEvent("Deleted unused LOBs, count: " + result.getUpdateCount());
                    }
                }
            }
        }
        finally {
            this.backupState.set(0);
            this.checkpointState.set(0);
            this.database.lobManager.unlock();
        }
    }

    private void checkpointInternal(Session session, boolean bl) {
        if (this.logsStatements) {
            this.logInfoEvent("Checkpoint start");
            this.log.checkpoint(session, bl);
            this.logInfoEvent("Checkpoint end - txts: " + this.database.txManager.getSystemChangeNumber());
        }
    }

    public synchronized void setLogSize(int n) {
        this.propLogSize = n;
        this.maxLogSize = (long)this.propLogSize * 1024L * 1024L;
        if (this.log != null) {
            this.log.setLogSize(this.propLogSize);
        }
    }

    public synchronized void setLogData(boolean bl) {
        this.propLogData = bl;
        this.loggingEnabled = this.propLogData && !this.database.isFilesReadOnly();
        this.loggingEnabled &= this.logsStatements;
    }

    public synchronized void setScriptType(int n) {
        if (n == this.propScriptFormat) {
            return;
        }
        this.propScriptFormat = n;
        this.checkpointState.compareAndSet(0, 1);
    }

    public synchronized void setWriteDelay(int n) {
        this.propWriteDelay = n;
        if (this.log != null) {
            this.log.setWriteDelay(n);
        }
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public int getWriteDelay() {
        return this.propWriteDelay;
    }

    public int getLogSize() {
        return this.propLogSize;
    }

    public int getLobBlockSize() {
        return this.propLobBlockSize;
    }

    public void setCacheMaxRows(int n) {
        this.propCacheMaxRows = n;
    }

    public int getCacheMaxRows() {
        return this.propCacheMaxRows;
    }

    public void setCacheSize(int n) {
        this.propCacheMaxSize = (long)n * 1024L;
    }

    public long getCacheSize() {
        return this.propCacheMaxSize;
    }

    public void setDataFileScale(int n) {
        if (n < 16) {
            throw Error.error(5556);
        }
        this.setDataFileScaleNoCheck(n);
    }

    public void setDataFileScaleNoCheck(int n) {
        Logger.checkPower(n, 10);
        if (n < 8 && n != 1) {
            throw Error.error(5556);
        }
        this.propDataFileScale = n;
        if (this.propDataFileSpace > 0) {
            this.propDataFileSpace = this.propDataFileScale / 16;
        }
    }

    public int getDataFileScale() {
        return this.propDataFileScale;
    }

    public int getDataFileFactor() {
        return this.propLargeData ? 128 : 1;
    }

    public void setDataFileSpace(boolean bl) {
        if (bl) {
            this.setDataFileSpace(this.propDataFileScale / 16);
        } else {
            this.setDataFileSpace(0);
        }
    }

    public void setDataFileSpace(int n) {
        if (n != 0) {
            Logger.checkPower(n, 6);
        }
        if (n > this.propDataFileScale / 16) {
            n = this.propDataFileScale / 16;
        }
        this.propDataFileSpace = n;
    }

    public int getDataFileSpace() {
        return this.propDataFileSpace;
    }

    public long getFilesTimestamp() {
        return this.propFilesTimestamp;
    }

    public void setFilesTimestamp(long l) {
        this.propFilesTimestamp = l;
    }

    public void setLobFileScale(int n) {
        if (this.propLobBlockSize == n * 1024) {
            return;
        }
        Logger.checkPower(n, 5);
        if (this.database.lobManager.getLobCount() > 0) {
            throw Error.error(469);
        }
        this.propLobBlockSize = n * 1024;
        this.database.lobManager.close();
        this.database.lobManager.open();
    }

    public void setLobFileScaleNoCheck(int n) {
        Logger.checkPower(n, 5);
        this.propLobBlockSize = n * 1024;
    }

    public int getLobFileScale() {
        return this.propLobBlockSize / 1024;
    }

    public void setLobFileCompressed(boolean bl) {
        if (this.propCompressLobs == bl) {
            return;
        }
        if (this.database.lobManager.getLobCount() > 0) {
            throw Error.error(469);
        }
        this.propCompressLobs = bl;
        this.database.lobManager.close();
        this.database.lobManager.open();
    }

    public void setLobFileCompressedNoCheck(boolean bl) {
        this.propCompressLobs = bl;
    }

    public void setDefagLimit(int n) {
        if (n > 0 && n < 25) {
            n = 25;
        }
        this.propDataFileDefragLimit = n;
    }

    public int getDefragLimit() {
        return this.propDataFileDefragLimit;
    }

    public void setDefaultTextTableProperties(String string, HsqlProperties hsqlProperties) {
        hsqlProperties.setProperty("check_props", true);
        this.database.getProperties().setURLProperties(hsqlProperties);
        this.propTextSourceDefault = string;
    }

    public void setNioDataFile(boolean bl) {
        this.propNioDataFile = bl;
    }

    public void setNioMaxSize(int n) {
        if ((n = ArrayUtil.getTwoPowerFloor(n)) < 64) {
            n = 64;
        }
        this.propNioMaxSize = (long)n * 1024L * 1024L;
    }

    public FileAccess getFileAccess() {
        return this.fileAccess;
    }

    public boolean isFileDatabase() {
        return this.propIsFileDatabase;
    }

    public String getTempDirectoryPath() {
        return this.tempDirectoryPath;
    }

    static void checkPower(int n, int n2) {
        if (!ArrayUtil.isTwoPower(n, n2)) {
            throw Error.error(5556);
        }
    }

    public void setCheckpointRequired() {
        this.checkpointState.compareAndSet(0, 1);
    }

    public boolean needsCheckpointReset() {
        return this.checkpointState.compareAndSet(1, 2);
    }

    public boolean hasLockFile() {
        return this.lockFile != null;
    }

    public void acquireLock(String string) {
        if (this.lockFile != null) {
            return;
        }
        this.lockFile = LockFile.newLockFileLock(string);
    }

    public void releaseLock() {
        try {
            if (this.lockFile != null) {
                this.lockFile.tryRelease();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lockFile = null;
    }

    public PersistentStore newStore(Session session, PersistentStoreCollection persistentStoreCollection, TableBase tableBase) {
        switch (tableBase.getTableType()) {
            case 5: {
                DataFileCache dataFileCache = this.getCache();
                if (dataFileCache == null) break;
                return new RowStoreAVLDisk(dataFileCache, (Table)tableBase);
            }
            case 4: 
            case 12: {
                return new RowStoreAVLMemory((Table)tableBase);
            }
            case 7: {
                return new RowStoreAVLDiskData((Table)tableBase);
            }
            case 1: {
                return new RowStoreAVLHybridExtended(session, tableBase, false);
            }
            case 3: {
                return new RowStoreAVLHybridExtended(session, tableBase, true);
            }
            case 13: {
                return new RowStoreDataChange(session, tableBase);
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (session == null) {
                    return null;
                }
                return new RowStoreAVLHybrid(session, tableBase, true);
            }
        }
        throw Error.runtimeError(201, "Logger");
    }

    public Index newIndex(HsqlNameManager.HsqlName hsqlName, long l, TableBase tableBase, int[] nArray, boolean[] blArray, boolean[] blArray2, Type[] typeArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        switch (tableBase.getTableType()) {
            case 1: 
            case 4: 
            case 12: {
                return new IndexAVLMemory(hsqlName, l, tableBase, nArray, blArray, blArray2, typeArray, bl, bl2, bl3, bl4);
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return new IndexAVL(hsqlName, l, tableBase, nArray, blArray, blArray2, typeArray, bl, bl2, bl3, bl4);
            }
        }
        throw Error.runtimeError(201, "Logger");
    }

    public HashMap getPropertyValueMap(Session session) {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = null;
        hashMap.put("sql.avg_scale", String.valueOf(this.database.sqlAvgScale));
        hashMap.put("sql.char_literal", String.valueOf(this.database.sqlCharLiteral));
        hashMap.put("sql.concat_nulls", String.valueOf(this.database.sqlConcatNulls));
        hashMap.put("sql.convert_trunc", String.valueOf(this.database.sqlConvertTruncate));
        hashMap.put("sql.default_collation", String.valueOf(this.database.collation.getName().name));
        hashMap.put("sql.truncate_trailing", String.valueOf(this.database.sqlTruncateTrailing));
        hashMap.put("sql.double_nan", String.valueOf(this.database.sqlDoubleNaN));
        hashMap.put("sql.enforce_names", String.valueOf(this.database.sqlEnforceNames));
        hashMap.put("sql.enforce_refs", String.valueOf(this.database.sqlEnforceRefs));
        hashMap.put("sql.enforce_size", String.valueOf(this.database.sqlEnforceSize));
        hashMap.put("sql.enforce_tdc_delete", String.valueOf(this.database.sqlEnforceTDCD));
        hashMap.put("sql.enforce_tdc_update", String.valueOf(this.database.sqlEnforceTDCU));
        hashMap.put("sql.enforce_types", String.valueOf(this.database.sqlEnforceTypes));
        hashMap.put("sql.ignore_case", String.valueOf(this.database.sqlIgnoreCase));
        hashMap.put("sql.live_object", String.valueOf(this.database.sqlLiveObject));
        hashMap.put("sql.longvar_is_lob", String.valueOf(this.database.sqlLongvarIsLob));
        hashMap.put("sql.lowercase_ident", String.valueOf(this.database.sqlLowerCaseIdentifier));
        hashMap.put("sql.max_recursive", String.valueOf(this.database.sqlMaxRecursive));
        hashMap.put("sql.nulls_first", String.valueOf(this.database.sqlNullsFirst));
        hashMap.put("sql.nulls_order", String.valueOf(this.database.sqlNullsOrder));
        hashMap.put("sql.pad_space", String.valueOf(this.database.collation.isPadSpace()));
        hashMap.put("sql.ref_integrity", String.valueOf(this.database.isReferentialIntegrity()));
        hashMap.put("sql.regular_names", String.valueOf(this.database.sqlRegularNames));
        hashMap.put("sql.restrict_exec", String.valueOf(this.database.sqlRestrictExec));
        hashMap.put("sql.syntax_db2", String.valueOf(this.database.sqlSyntaxDb2));
        hashMap.put("sql.syntax_mss", String.valueOf(this.database.sqlSyntaxMss));
        hashMap.put("sql.syntax_mys", String.valueOf(this.database.sqlSyntaxMys));
        hashMap.put("sql.syntax_ora", String.valueOf(this.database.sqlSyntaxOra));
        hashMap.put("sql.syntax_pgs", String.valueOf(this.database.sqlSyntaxPgs));
        hashMap.put("sql.sys_index_names", String.valueOf(this.database.sqlSysIndexNames));
        hashMap.put("sql.unique_nulls", String.valueOf(this.database.sqlUniqueNulls));
        hashMap.put("jdbc.translate_tti_types", String.valueOf(this.database.sqlTranslateTTI));
        switch (this.database.txManager.getTransactionControl()) {
            case 2: {
                string2 = "MVCC";
                break;
            }
            case 1: {
                string2 = "MVLOCKS";
                break;
            }
            case 0: {
                string2 = "LOCKS";
            }
        }
        hashMap.put("hsqldb.tx", string2);
        switch (this.database.defaultIsolationLevel) {
            case 2: {
                string2 = "READ" + '_' + "COMMITTED";
                break;
            }
            case 8: {
                string2 = "SERIALIZABLE";
            }
        }
        hashMap.put("hsqldb.tx_level", string2);
        hashMap.put("hsqldb.reconfig_logging", System.getProperty("hsqldb.reconfig_logging"));
        if (HsqlDatabaseProperties.methodClassNames != null) {
            hashMap.put("hsqldb.method_class_names", HsqlDatabaseProperties.methodClassNames);
        }
        hashMap.put("hsqldb.applog", String.valueOf(this.appLog.getLevel()));
        hashMap.put("hsqldb.extlog", String.valueOf(this.propExternalEventLogLevel));
        hashMap.put("hsqldb.sqllog", String.valueOf(this.sqlLog.getLevel()));
        hashMap.put("hsqldb.lob_file_scale", String.valueOf(this.propLobBlockSize / 1024));
        hashMap.put("hsqldb.lob_compressed", String.valueOf(this.propCompressLobs));
        hashMap.put("hsqldb.cache_file_scale", String.valueOf(this.propDataFileScale));
        hashMap.put("hsqldb.cache_free_count", String.valueOf(this.propMaxFreeBlocks));
        hashMap.put("hsqldb.cache_rows", String.valueOf(this.propCacheMaxRows));
        hashMap.put("hsqldb.cache_size", String.valueOf(this.propCacheMaxSize / 1024L));
        switch (this.database.schemaManager.getDefaultTableType()) {
            case 5: {
                string = "CACHED";
                break;
            }
            default: {
                string = "MEMORY";
            }
        }
        hashMap.put("hsqldb.default_table_type", string);
        hashMap.put("hsqldb.defrag_limit", String.valueOf(this.propDataFileDefragLimit));
        hashMap.put("hsqldb.files_space", String.valueOf(this.propDataFileSpace));
        hashMap.put("files_readonly", this.database.databaseProperties.isPropertyTrue("files_readonly") ? "true" : "false");
        hashMap.put("hsqldb.large_data", String.valueOf(this.propLargeData));
        hashMap.put("hsqldb.lock_file", this.database.databaseProperties.isPropertyTrue("hsqldb.lock_file") ? "true" : "false");
        hashMap.put("hsqldb.log_data", String.valueOf(this.propLogData));
        hashMap.put("hsqldb.log_size", String.valueOf(this.propLogSize));
        hashMap.put("hsqldb.nio_data_file", String.valueOf(this.propNioDataFile));
        hashMap.put("hsqldb.nio_max_size", String.valueOf(this.propNioMaxSize / 0x100000L));
        hashMap.put("hsqldb.script_format", ScriptWriterBase.LIST_SCRIPT_FORMATS[this.propScriptFormat].toLowerCase());
        hashMap.put("hsqldb.temp_directory", this.tempDirectoryPath);
        hashMap.put("hsqldb.tx_conflict_rollback", String.valueOf(this.database.txConflictRollback));
        hashMap.put("hsqldb.tx_interrupt_rollback", String.valueOf(this.database.txInterruptRollback));
        hashMap.put("hsqldb.result_max_memory_rows", String.valueOf(this.database.getResultMaxMemoryRows()));
        hashMap.put("readonly", this.database.isReadOnly() ? "true" : "false");
        hashMap.put("files_readonly", this.database.isFilesReadOnly() ? "true" : "false");
        hashMap.put("hsqldb.write_delay", String.valueOf(this.propWriteDelay != 0));
        hashMap.put("hsqldb.write_delay_millis", String.valueOf(this.propWriteDelay));
        hashMap.put("hsqldb.digest", this.database.granteeManager.getDigestAlgo());
        return hashMap;
    }

    public String[] getPropertiesSQL(boolean bl) {
        int n;
        boolean bl2;
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SET DATABASE ").append("UNIQUE").append(' ');
        stringBuilder.append("NAME").append(' ').append(this.database.getNameString());
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET DATABASE ").append("DEFAULT").append(' ');
        stringBuilder.append("RESULT").append(' ').append("MEMORY");
        stringBuilder.append(' ').append("ROWS").append(' ');
        stringBuilder.append(this.database.getResultMaxMemoryRows());
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET DATABASE ").append("EVENT").append(' ');
        stringBuilder.append("LOG").append(' ').append("LEVEL");
        stringBuilder.append(' ').append(this.propEventLogLevel);
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        if (this.propExternalEventLogLevel != 0) {
            stringBuilder.append("SET DATABASE ").append("EXTERNAL").append(' ');
            stringBuilder.append("EVENT").append(' ');
            stringBuilder.append("LOG").append(' ').append("LEVEL");
            stringBuilder.append(' ').append(this.propExternalEventLogLevel);
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        if (this.propSqlLogLevel != 0) {
            stringBuilder.append("SET DATABASE ").append("EVENT").append(' ');
            stringBuilder.append("LOG").append(' ').append("SQL");
            stringBuilder.append(' ').append("LEVEL");
            stringBuilder.append(' ').append(this.propEventLogLevel);
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        stringBuilder.append("SET DATABASE ").append("TRANSACTION");
        stringBuilder.append(' ').append("CONTROL").append(' ');
        switch (this.database.txManager.getTransactionControl()) {
            case 2: {
                stringBuilder.append("MVCC");
                break;
            }
            case 1: {
                stringBuilder.append("MVLOCKS");
                break;
            }
            case 0: {
                stringBuilder.append("LOCKS");
            }
        }
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET DATABASE ").append("DEFAULT").append(' ');
        stringBuilder.append("ISOLATION").append(' ').append("LEVEL");
        stringBuilder.append(' ');
        switch (this.database.defaultIsolationLevel) {
            case 2: {
                stringBuilder.append("READ").append(' ').append("COMMITTED");
                break;
            }
            case 8: {
                stringBuilder.append("SERIALIZABLE");
            }
        }
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET DATABASE ").append("TRANSACTION").append(' ');
        stringBuilder.append("ROLLBACK").append(' ');
        stringBuilder.append("ON").append(' ');
        stringBuilder.append("CONFLICT").append(' ');
        stringBuilder.append(this.database.txConflictRollback ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        if (this.database.txInterruptRollback) {
            stringBuilder.append("SET DATABASE ").append("TRANSACTION");
            stringBuilder.append(' ').append("ROLLBACK").append(' ');
            stringBuilder.append("ON").append(' ');
            stringBuilder.append("INTERRUPT").append(' ');
            stringBuilder.append(this.database.txInterruptRollback ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        stringBuilder.append("SET DATABASE ").append("TEXT").append(' ');
        stringBuilder.append("TABLE").append(' ').append("DEFAULTS");
        stringBuilder.append(' ').append('\'');
        stringBuilder.append(this.propTextSourceDefault).append('\'');
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        String string = HsqlDatabaseProperties.getStringPropertyDefault("hsqldb.digest");
        if (!string.equals(this.database.granteeManager.getDigestAlgo())) {
            stringBuilder.append("SET DATABASE ").append("PASSWORD").append(' ');
            stringBuilder.append("DIGEST").append(' ').append('\'');
            stringBuilder.append(this.database.granteeManager.getDigestAlgo()).append('\'');
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        if (this.database.schemaManager.getDefaultTableType() == 5) {
            stringBuilder.append("SET DATABASE ").append("DEFAULT").append(' ');
            stringBuilder.append("TABLE").append(' ');
            stringBuilder.append("TYPE").append(' ');
            stringBuilder.append("CACHED");
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
        stringBuilder.append("NAMES").append(' ');
        stringBuilder.append(this.database.sqlEnforceNames ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
        stringBuilder.append("RESTRICT").append(' ');
        stringBuilder.append("EXEC").append(' ');
        stringBuilder.append(this.database.sqlRestrictExec ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        if (!this.database.sqlRegularNames) {
            stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
            stringBuilder.append("REGULAR").append(' ');
            stringBuilder.append("NAMES").append(' ');
            stringBuilder.append(this.database.sqlRegularNames ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
        stringBuilder.append("REFERENCES").append(' ');
        stringBuilder.append(this.database.sqlEnforceRefs ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
        stringBuilder.append("SIZE").append(' ');
        stringBuilder.append(this.database.sqlEnforceSize ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
        stringBuilder.append("TYPES").append(' ');
        stringBuilder.append(this.database.sqlEnforceTypes ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
        stringBuilder.append("TDC").append(' ');
        stringBuilder.append("DELETE").append(' ');
        stringBuilder.append(this.database.sqlEnforceTDCD ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
        stringBuilder.append("TDC").append(' ');
        stringBuilder.append("UPDATE").append(' ');
        stringBuilder.append(this.database.sqlEnforceTDCU ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuilder.toString());
        if (!this.database.sqlTranslateTTI) {
            stringBuilder.setLength(0);
            stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
            stringBuilder.append("TRANSLATE").append(' ').append("TTI");
            stringBuilder.append(' ').append("TYPES").append(' ');
            stringBuilder.append(this.database.sqlTranslateTTI ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
        }
        stringBuilder.setLength(0);
        stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
        stringBuilder.append("SYS").append(' ').append("INDEX");
        stringBuilder.append(' ').append("NAMES").append(' ');
        stringBuilder.append(this.database.sqlSysIndexNames ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuilder.toString());
        if (!this.database.sqlCharLiteral) {
            stringBuilder.setLength(0);
            stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
            stringBuilder.append("CHARACTER").append(' ');
            stringBuilder.append("LITERAL").append(' ');
            stringBuilder.append(this.database.sqlCharLiteral ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
        }
        stringBuilder.setLength(0);
        stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
        stringBuilder.append("CONCAT").append(' ');
        stringBuilder.append("NULLS").append(' ');
        stringBuilder.append(this.database.sqlConcatNulls ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuilder.toString());
        if (!this.database.sqlNullsFirst) {
            stringBuilder.setLength(0);
            stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
            stringBuilder.append("NULLS").append(' ');
            stringBuilder.append("FIRST").append(' ');
            stringBuilder.append(this.database.sqlNullsFirst ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
        }
        if (!this.database.sqlNullsOrder) {
            stringBuilder.setLength(0);
            stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
            stringBuilder.append("NULLS").append(' ');
            stringBuilder.append("ORDER").append(' ');
            stringBuilder.append(this.database.sqlNullsOrder ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
        }
        stringBuilder.setLength(0);
        stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
        stringBuilder.append("UNIQUE").append(' ');
        stringBuilder.append("NULLS").append(' ');
        stringBuilder.append(this.database.sqlUniqueNulls ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
        stringBuilder.append("CONVERT").append(' ');
        stringBuilder.append("TRUNCATE").append(' ');
        stringBuilder.append(this.database.sqlConvertTruncate ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
        stringBuilder.append("AVG").append(' ');
        stringBuilder.append("SCALE").append(' ');
        stringBuilder.append(this.database.sqlAvgScale);
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        if (this.database.sqlMaxRecursive != HsqlDatabaseProperties.getIntegerPropertyDefault("sql.max_recursive")) {
            stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
            stringBuilder.append("MAX").append(' ');
            stringBuilder.append("RECURSIVE").append(' ');
            stringBuilder.append(this.database.sqlMaxRecursive);
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
        stringBuilder.append("DOUBLE").append(' ');
        stringBuilder.append("NAN").append(' ');
        stringBuilder.append(this.database.sqlDoubleNaN ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        if (this.database.sqlIgnoreCase) {
            stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
            stringBuilder.append("IGNORECASE").append(' ');
            stringBuilder.append(this.database.sqlIgnoreCase ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        if (this.database.sqlLongvarIsLob) {
            stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
            stringBuilder.append("LONGVAR").append(' ');
            stringBuilder.append("IS").append(' ');
            stringBuilder.append("LOB").append(' ');
            stringBuilder.append(this.database.sqlLongvarIsLob ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        if (this.database.sqlLowerCaseIdentifier) {
            stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
            stringBuilder.append("LOWER").append(' ');
            stringBuilder.append("CASE").append(' ');
            stringBuilder.append("IDENTIFIER").append(' ');
            stringBuilder.append(this.database.sqlLowerCaseIdentifier ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        if (!this.database.sqlTruncateTrailing) {
            stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
            stringBuilder.append("TRUNCATE").append(' ');
            stringBuilder.append("TRAILING").append(' ');
            stringBuilder.append(this.database.sqlTruncateTrailing ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        if (this.database.sqlSyntaxDb2) {
            stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
            stringBuilder.append("SYNTAX").append(' ');
            stringBuilder.append("DB2").append(' ');
            stringBuilder.append(this.database.sqlSyntaxDb2 ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        if (this.database.sqlSyntaxMss) {
            stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
            stringBuilder.append("SYNTAX").append(' ');
            stringBuilder.append("MSS").append(' ');
            stringBuilder.append(this.database.sqlSyntaxMss ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        if (this.database.sqlSyntaxMys) {
            stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
            stringBuilder.append("SYNTAX").append(' ');
            stringBuilder.append("MYS").append(' ');
            stringBuilder.append(this.database.sqlSyntaxMys ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        if (this.database.sqlSyntaxOra) {
            stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
            stringBuilder.append("SYNTAX").append(' ');
            stringBuilder.append("ORA").append(' ');
            stringBuilder.append(this.database.sqlSyntaxOra ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        if (this.database.sqlSyntaxPgs) {
            stringBuilder.append("SET DATABASE ").append("SQL").append(' ');
            stringBuilder.append("SYNTAX").append(' ');
            stringBuilder.append("PGS").append(' ');
            stringBuilder.append(this.database.sqlSyntaxPgs ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        boolean bl3 = bl2 = (n = this.propWriteDelay) > 0 && n < 1000;
        if (bl2) {
            if (n < 20) {
                n = 20;
            }
        } else {
            n /= 1000;
        }
        stringBuilder.append("SET FILES ").append("WRITE").append(' ');
        stringBuilder.append("DELAY").append(' ').append(n);
        if (bl2) {
            stringBuilder.append(' ').append("MILLIS");
        }
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET FILES ").append("BACKUP");
        stringBuilder.append(' ').append("INCREMENT").append(' ');
        stringBuilder.append("TRUE");
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET FILES ").append("CACHE");
        stringBuilder.append(' ').append("SIZE").append(' ');
        stringBuilder.append(this.propCacheMaxSize / 1024L);
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET FILES ").append("CACHE");
        stringBuilder.append(' ').append("ROWS").append(' ');
        stringBuilder.append(this.propCacheMaxRows);
        hsqlArrayList.add(stringBuilder.toString());
        int n2 = this.propDataFileScale;
        if (!bl && n2 < 32) {
            n2 = 32;
        }
        stringBuilder.setLength(0);
        stringBuilder.append("SET FILES ").append("SCALE");
        stringBuilder.append(' ').append(n2);
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        if (this.propDataFileSpace != 0) {
            stringBuilder.append("SET FILES ").append("SPACE").append(' ');
            stringBuilder.append(this.propDataFileSpace);
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        stringBuilder.append("SET FILES ").append("LOB").append(' ');
        stringBuilder.append("SCALE");
        stringBuilder.append(' ').append(this.getLobFileScale());
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        if (this.propCompressLobs) {
            stringBuilder.append("SET FILES ").append("LOB").append(' ');
            stringBuilder.append("COMPRESSED").append(' ');
            stringBuilder.append(this.propCompressLobs ? "TRUE" : "FALSE");
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        stringBuilder.append("SET FILES ").append("DEFRAG").append(' ');
        stringBuilder.append(this.propDataFileDefragLimit);
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET FILES ").append("NIO").append(' ');
        stringBuilder.append(this.propNioDataFile ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET FILES ").append("NIO").append(' ');
        stringBuilder.append("SIZE").append(' ');
        stringBuilder.append(this.propNioMaxSize / 0x100000L);
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET FILES ").append("LOG").append(' ');
        stringBuilder.append(this.propLogData ? "TRUE" : "FALSE");
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET FILES ").append("LOG").append(' ');
        stringBuilder.append("SIZE").append(' ').append(this.propLogSize);
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("SET FILES ").append("CHECK").append(' ');
        stringBuilder.append(this.propFilesTimestamp);
        hsqlArrayList.add(stringBuilder.toString());
        stringBuilder.setLength(0);
        String[] stringArray = new String[hsqlArrayList.size()];
        hsqlArrayList.toArray(stringArray);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        block11: {
            if (!this.backupState.compareAndSet(0, 1)) {
                throw Error.error(470, "backup in progress");
            }
            if (bl2) {
                this.database.lobManager.lock();
                try {
                    Logger logger = this;
                    synchronized (logger) {
                        this.backupInternal(string, bl, bl2, bl3, bl4);
                        break block11;
                    }
                }
                finally {
                    this.backupState.set(0);
                    this.database.lobManager.unlock();
                }
            }
            try {
                this.backupInternal(string, bl, bl2, bl3, bl4);
            }
            finally {
                this.backupState.set(0);
            }
        }
    }

    void backupInternal(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        block28: {
            Object object;
            File file;
            boolean bl5;
            String string2 = null;
            String string3 = this.database.getPath();
            String string4 = new File(string3).getName();
            char c = string.charAt(string.length() - 1);
            boolean bl6 = bl5 = c == '/' || c == runtimeFileDelim;
            if (bl4) {
                if (!bl5) {
                    throw Error.error(null, 462, 0, new String[]{"", "/"});
                }
                if ((string = this.getSecurePath(string, true, false)) == null) {
                    throw Error.error(470, "access to directory denied");
                }
                file = new File(string);
                file.mkdirs();
                object = FileUtil.getDatabaseMainFileList(string + string4);
                if (object == null || ((File[])object).length != 0) {
                    throw Error.error(470, "files exist in directory");
                }
            } else {
                boolean bl7;
                object = bl3 ? ".tar.gz" : ".tar";
                file = bl5 ? new File(string.substring(0, string.length() - 1), string4 + "-" + this.fileDateFormat.format(new Date()) + (String)object) : new File(string);
                boolean bl8 = bl7 = file.getName().endsWith(".tar.gz") || file.getName().endsWith(".tgz");
                if (!bl7 && !file.getName().endsWith(".tar")) {
                    throw Error.error(null, 462, 0, new String[]{file.getName(), ".tar, .tar.gz, .tgz"});
                }
                if (bl3 != bl7) {
                    throw Error.error(null, 463, 0, new String[]{String.valueOf(bl3), file.getName()});
                }
                if (file.exists()) {
                    throw Error.error(470, "file exists :" + file.getName());
                }
            }
            if (bl2) {
                this.log.checkpointClose();
            }
            try {
                this.logInfoEvent("Initiating backup of instance '" + string4 + "'");
                if (bl) {
                    object = this.getTempDirectoryPath();
                    if (object == null) {
                        return;
                    }
                    object = (String)object + "/" + new File(this.database.getPath()).getName();
                    string2 = (String)object + scriptFileExtension;
                    ScriptWriterText scriptWriterText = new ScriptWriterText(this.database, string2, true, true, true);
                    scriptWriterText.writeAll();
                    scriptWriterText.close();
                    this.backup = new DbBackup(file, (String)object, true);
                    this.backup.write();
                } else {
                    this.backup = new DbBackup(file, string3);
                    this.backup.setAbortUponModify(false);
                    if (!bl2) {
                        long l;
                        File file2 = null;
                        if (this.hasCache()) {
                            DataFileCache dataFileCache = this.getCache();
                            RAShadowFile rAShadowFile = dataFileCache.getShadowFile();
                            file2 = new File(dataFileCache.dataFileName);
                            object = new InputStreamWrapper(new FileInputStream(file2));
                            ((InputStreamWrapper)object).setSizeLimit(dataFileCache.fileStartFreePosition);
                            this.backup.setStream(dataFileExtension, (InputStreamInterface)object);
                            InputStreamInterface inputStreamInterface = rAShadowFile.getInputStream();
                            this.backup.setStream(backupFileExtension, inputStreamInterface);
                        }
                        if ((l = (file2 = new File(this.log.getLogFileName())).length()) == 0L) {
                            this.backup.setFileIgnore(logFileExtension);
                        } else {
                            object = new InputStreamWrapper(new FileInputStream(file2));
                            ((InputStreamWrapper)object).setSizeLimit(l);
                            this.backup.setStream(logFileExtension, (InputStreamInterface)object);
                        }
                    }
                    if (bl4) {
                        this.backup.writeAsFiles();
                    } else {
                        this.backup.write();
                    }
                }
                this.logInfoEvent("Successfully backed up instance '" + string4 + "' to '" + string + "'");
                if (string2 == null) break block28;
                FileUtil.getFileUtil().delete(string2);
            }
            catch (IOException iOException) {
                throw Error.error(iOException, 452, iOException.toString());
            }
            catch (TarMalformatException tarMalformatException) {
                throw Error.error(tarMalformatException, 452, tarMalformatException.toString());
            }
            finally {
                if (string2 != null) {
                    FileUtil.getFileUtil().delete(string2);
                }
                if (bl2) {
                    this.log.checkpointReopen();
                }
            }
        }
        if (bl2) {
            this.log.checkpointReopen();
        }
    }

    public String getSecurePath(String object, boolean bl, boolean bl2) {
        if (this.database.getType() == DatabaseType.DB_RES) {
            if (bl2) {
                return object;
            }
            return null;
        }
        if (this.database.getType() == DatabaseType.DB_MEM) {
            if (this.propTextAllowFullPath) {
                return object;
            }
            return null;
        }
        if (((String)object).startsWith("/") || ((String)object).startsWith("\\") || ((String)object).contains(":")) {
            if (bl || this.propTextAllowFullPath) {
                return object;
            }
            return null;
        }
        if (((String)object).contains("..") && !bl && !this.propTextAllowFullPath) {
            return null;
        }
        String string = new File(new File(this.database.getPath() + propertiesFileExtension).getAbsolutePath()).getParent();
        if (string != null) {
            object = string + File.separator + (String)object;
        }
        return object;
    }

    public boolean isNewDatabase() {
        return this.isNewDatabase;
    }
}

