/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsRequest;
import software.amazon.awssdk.services.ec2.model.GetAssociatedIpv6PoolCidrsResponse;
import software.amazon.awssdk.services.ec2.model.Ipv6CidrAssociation;

public class GetAssociatedIpv6PoolCidrsIterable
implements SdkIterable<GetAssociatedIpv6PoolCidrsResponse> {
    private final Ec2Client client;
    private final GetAssociatedIpv6PoolCidrsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetAssociatedIpv6PoolCidrsIterable(Ec2Client client, GetAssociatedIpv6PoolCidrsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetAssociatedIpv6PoolCidrsResponseFetcher();
    }

    public Iterator<GetAssociatedIpv6PoolCidrsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Ipv6CidrAssociation> ipv6CidrAssociations() {
        Function<GetAssociatedIpv6PoolCidrsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipv6CidrAssociations() != null) {
                return response.ipv6CidrAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetAssociatedIpv6PoolCidrsResponseFetcher
    implements SyncPageFetcher<GetAssociatedIpv6PoolCidrsResponse> {
        private GetAssociatedIpv6PoolCidrsResponseFetcher() {
        }

        public boolean hasNextPage(GetAssociatedIpv6PoolCidrsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetAssociatedIpv6PoolCidrsResponse nextPage(GetAssociatedIpv6PoolCidrsResponse previousPage) {
            if (previousPage == null) {
                return GetAssociatedIpv6PoolCidrsIterable.this.client.getAssociatedIpv6PoolCidrs(GetAssociatedIpv6PoolCidrsIterable.this.firstRequest);
            }
            return GetAssociatedIpv6PoolCidrsIterable.this.client.getAssociatedIpv6PoolCidrs((GetAssociatedIpv6PoolCidrsRequest)((Object)GetAssociatedIpv6PoolCidrsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

