/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.action.delete;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.indexmanagement.rollup.action.delete.DeleteRollupRequest;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.util.RollupUtilsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001&B7\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J&\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0016\u0010\u0019\u001a\n \u0017*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006'"}, d2={"Lorg/opensearch/indexmanagement/rollup/action/delete/TransportDeleteRollupAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/rollup/action/delete/DeleteRollupRequest;", "Lorg/opensearch/action/delete/DeleteResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/core/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "log", "Lorg/apache/logging/log4j/Logger;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "request", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "DeleteRollupHandler", "opensearch-index-management"})
public final class TransportDeleteRollupAction
extends HandledTransportAction<DeleteRollupRequest, DeleteResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;
    private final Logger log;

    @Inject
    public TransportDeleteRollupAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull ActionFilters actionFilters, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/rollup/delete", transportService, actionFilters, DeleteRollupRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportDeleteRollupAction._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    protected void doExecute(@NotNull Task task, @NotNull DeleteRollupRequest request, @NotNull ActionListener<DeleteResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        new DeleteRollupHandler(this, this.client, actionListener, request, null, 8, null).start();
    }

    private static final void _init_$lambda$0(TransportDeleteRollupAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }

    public static final /* synthetic */ Boolean access$getFilterByEnabled$p(TransportDeleteRollupAction $this) {
        return $this.filterByEnabled;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002J\u0006\u0010\u000f\u001a\u00020\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/opensearch/indexmanagement/rollup/action/delete/TransportDeleteRollupAction$DeleteRollupHandler;", "", "client", "Lorg/opensearch/client/Client;", "actionListener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/action/delete/DeleteResponse;", "request", "Lorg/opensearch/indexmanagement/rollup/action/delete/DeleteRollupRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "(Lorg/opensearch/indexmanagement/rollup/action/delete/TransportDeleteRollupAction;Lorg/opensearch/client/Client;Lorg/opensearch/core/action/ActionListener;Lorg/opensearch/indexmanagement/rollup/action/delete/DeleteRollupRequest;Lorg/opensearch/commons/authuser/User;)V", "delete", "", "getRollup", "start", "opensearch-index-management"})
    public final class DeleteRollupHandler {
        @NotNull
        private final Client client;
        @NotNull
        private final ActionListener<DeleteResponse> actionListener;
        @NotNull
        private final DeleteRollupRequest request;
        @Nullable
        private final User user;
        final /* synthetic */ TransportDeleteRollupAction this$0;

        public DeleteRollupHandler(@NotNull TransportDeleteRollupAction this$0, @NotNull Client client, @NotNull ActionListener<DeleteResponse> actionListener, @Nullable DeleteRollupRequest request, User user) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
            Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
            this.this$0 = this$0;
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = user;
        }

        public /* synthetic */ DeleteRollupHandler(TransportDeleteRollupAction transportDeleteRollupAction, Client client, ActionListener actionListener, DeleteRollupRequest deleteRollupRequest, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                ThreadContext threadContext = client.threadPool().getThreadContext();
                Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"client.threadPool().threadContext");
                user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
            }
            this(transportDeleteRollupAction, client, (ActionListener<DeleteResponse>)actionListener, deleteRollupRequest, user);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void start() {
            this.this$0.log.debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
                boolean bl = false;
                this.getRollup();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private final void getRollup() {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", this.request.id());
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(this, this.this$0){
                final /* synthetic */ DeleteRollupHandler this$0;
                final /* synthetic */ TransportDeleteRollupAction this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void onResponse(@NotNull GetResponse response2) {
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    if (!response2.isExists()) {
                        DeleteRollupHandler.access$getActionListener$p(this.this$0).onFailure((Exception)((Object)new OpenSearchStatusException("Rollup " + DeleteRollupHandler.access$getRequest$p(this.this$0).id() + " is not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    Rollup rollup2 = null;
                    try {
                        rollup2 = RollupUtilsKt.parseRollup(response2, this.this$1.getXContentRegistry());
                    }
                    catch (IllegalArgumentException e) {
                        DeleteRollupHandler.access$getActionListener$p(this.this$0).onFailure((Exception)((Object)new OpenSearchStatusException("Rollup " + DeleteRollupHandler.access$getRequest$p(this.this$0).id() + " is not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    User user = DeleteRollupHandler.access$getUser$p(this.this$0);
                    User user2 = rollup2.getUser();
                    Boolean bl = TransportDeleteRollupAction.access$getFilterByEnabled$p(this.this$1);
                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"filterByEnabled");
                    if (!SecurityUtils.Companion.userHasPermissionForResource(user, user2, bl, "rollup", rollup2.getId(), DeleteRollupHandler.access$getActionListener$p(this.this$0))) {
                        return;
                    }
                    DeleteRollupHandler.access$delete(this.this$0);
                }

                public void onFailure(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ActionListener actionListener = DeleteRollupHandler.access$getActionListener$p(this.this$0);
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)e);
                    Intrinsics.checkNotNull((Object)throwable, (String)"null cannot be cast to non-null type java.lang.Exception");
                    actionListener.onFailure((Exception)throwable);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void delete() {
            DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(".opendistro-ism-config", this.request.id()).setRefreshPolicy(this.request.getRefreshPolicy());
            AutoCloseable autoCloseable = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
            Throwable throwable = null;
            try {
                ThreadContext.StoredContext it = (ThreadContext.StoredContext)autoCloseable;
                boolean bl = false;
                this.client.delete(deleteRequest, this.actionListener);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        public static final /* synthetic */ ActionListener access$getActionListener$p(DeleteRollupHandler $this) {
            return $this.actionListener;
        }

        public static final /* synthetic */ DeleteRollupRequest access$getRequest$p(DeleteRollupHandler $this) {
            return $this.request;
        }

        public static final /* synthetic */ User access$getUser$p(DeleteRollupHandler $this) {
            return $this.user;
        }

        public static final /* synthetic */ void access$delete(DeleteRollupHandler $this) {
            $this.delete();
        }
    }
}

