/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Arrays;
import org.jooq.AlterTableAlterStep;
import org.jooq.AlterTableDropStep;
import org.jooq.AlterTableFinalStep;
import org.jooq.AlterTableRenameColumnToStep;
import org.jooq.AlterTableRenameConstraintToStep;
import org.jooq.AlterTableRenameIndexToStep;
import org.jooq.AlterTableStep;
import org.jooq.AlterTableUsingIndexStep;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Constraint;
import org.jooq.Context;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Index;
import org.jooq.Name;
import org.jooq.Nullability;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class AlterTableImpl
extends AbstractQuery
implements AlterTableStep,
AlterTableDropStep,
AlterTableAlterStep,
AlterTableUsingIndexStep,
AlterTableRenameColumnToStep,
AlterTableRenameIndexToStep,
AlterTableRenameConstraintToStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.ALTER_TABLE};
    private final Table<?> table;
    private final boolean ifExists;
    private Table<?> renameTo;
    private Field<?> renameColumn;
    private Field<?> renameColumnTo;
    private Index renameIndex;
    private Index renameIndexTo;
    private Constraint renameConstraint;
    private Constraint renameConstraintTo;
    private Field<?> addColumn;
    private DataType<?> addColumnType;
    private Constraint addConstraint;
    private Field<?> alterColumn;
    private Nullability alterColumnNullability;
    private DataType<?> alterColumnType;
    private Field<?> alterColumnDefault;
    private Field<?> dropColumn;
    private boolean dropColumnCascade;
    private Constraint dropConstraint;

    AlterTableImpl(Configuration configuration, Table<?> table) {
        this(configuration, table, false);
    }

    AlterTableImpl(Configuration configuration, Table<?> table, boolean ifExists) {
        super(configuration);
        this.table = table;
        this.ifExists = ifExists;
    }

    @Override
    public final AlterTableImpl renameTo(Table<?> newName) {
        this.renameTo = newName;
        return this;
    }

    @Override
    public final AlterTableImpl renameTo(Name newName) {
        return this.renameTo((Table)DSL.table(newName));
    }

    @Override
    public final AlterTableImpl renameTo(String newName) {
        return this.renameTo(DSL.name(newName));
    }

    @Override
    public final AlterTableImpl renameColumn(Field<?> oldName) {
        this.renameColumn = oldName;
        return this;
    }

    @Override
    public final AlterTableImpl renameColumn(Name oldName) {
        return this.renameColumn((Field)DSL.field(oldName));
    }

    @Override
    public final AlterTableImpl renameColumn(String oldName) {
        return this.renameColumn(DSL.name(oldName));
    }

    @Override
    public final AlterTableImpl renameConstraint(Constraint oldName) {
        this.renameConstraint = oldName;
        return this;
    }

    @Override
    public final AlterTableImpl renameIndex(String oldName) {
        return this.renameIndex(DSL.name(oldName));
    }

    @Override
    public final AlterTableImpl renameIndex(Name oldName) {
        return this.renameIndex(DSL.index(oldName));
    }

    @Override
    public final AlterTableImpl renameIndex(Index oldName) {
        this.renameIndex = oldName;
        return this;
    }

    @Override
    public final AlterTableImpl renameConstraint(Name oldName) {
        return this.renameConstraint(DSL.constraint(oldName));
    }

    @Override
    public final AlterTableImpl renameConstraint(String oldName) {
        return this.renameConstraint(DSL.name(oldName));
    }

    @Override
    public final AlterTableImpl to(String newName) {
        return this.to(DSL.name(newName));
    }

    @Override
    public final AlterTableImpl to(Name newName) {
        if (this.renameColumn != null) {
            return this.to((Field)DSL.field(newName));
        }
        if (this.renameConstraint != null) {
            return this.to(DSL.constraint(newName));
        }
        if (this.renameIndex != null) {
            return this.to(DSL.index(newName));
        }
        throw new IllegalStateException();
    }

    @Override
    public final AlterTableImpl to(Field<?> newName) {
        if (this.renameColumn == null) {
            throw new IllegalStateException();
        }
        this.renameColumnTo = newName;
        return this;
    }

    @Override
    public final AlterTableImpl to(Constraint newName) {
        if (this.renameConstraint == null) {
            throw new IllegalStateException();
        }
        this.renameConstraintTo = newName;
        return this;
    }

    @Override
    public final AlterTableImpl to(Index newName) {
        if (this.renameIndex == null) {
            throw new IllegalStateException();
        }
        this.renameIndexTo = newName;
        return this;
    }

    @Override
    public final <T> AlterTableImpl add(Field<T> field, DataType<T> type) {
        return this.addColumn((Field)field, (DataType)type);
    }

    @Override
    public final AlterTableImpl add(Name field, DataType<?> type) {
        return this.addColumn(field, (DataType)type);
    }

    @Override
    public final AlterTableImpl add(String field, DataType<?> type) {
        return this.addColumn(field, (DataType)type);
    }

    @Override
    public final AlterTableImpl addColumn(String field, DataType<?> type) {
        return this.addColumn(DSL.name(field), (DataType)type);
    }

    @Override
    public final AlterTableImpl addColumn(Name field, DataType<?> type) {
        return this.addColumn((Field)DSL.field(field, type), (DataType)type);
    }

    @Override
    public final <T> AlterTableImpl addColumn(Field<T> field, DataType<T> type) {
        this.addColumn = field;
        this.addColumnType = type;
        return this;
    }

    @Override
    public final AlterTableImpl add(Constraint constraint) {
        this.addConstraint = constraint;
        return this;
    }

    public final <T> AlterTableImpl alter(Field<T> field) {
        return this.alterColumn((Field)field);
    }

    public final AlterTableImpl alter(Name field) {
        return this.alterColumn(field);
    }

    public final AlterTableImpl alter(String field) {
        return this.alterColumn(field);
    }

    public final AlterTableImpl alterColumn(Name field) {
        return this.alterColumn((Field)DSL.field(field));
    }

    public final AlterTableImpl alterColumn(String field) {
        return this.alterColumn(DSL.name(field));
    }

    public final <T> AlterTableImpl alterColumn(Field<T> field) {
        this.alterColumn = field;
        return this;
    }

    public final AlterTableImpl set(DataType type) {
        this.alterColumnType = type;
        return this;
    }

    @Override
    public final AlterTableImpl setNotNull() {
        this.alterColumnNullability = Nullability.NOT_NULL;
        return this;
    }

    @Override
    public final AlterTableImpl dropNotNull() {
        this.alterColumnNullability = Nullability.NULL;
        return this;
    }

    public final AlterTableImpl defaultValue(Object literal) {
        return this.defaultValue((Field)Tools.field(literal));
    }

    public final AlterTableImpl defaultValue(Field expression) {
        this.alterColumnDefault = expression;
        return this;
    }

    @Override
    public final AlterTableImpl drop(Field<?> field) {
        return this.dropColumn((Field)field);
    }

    @Override
    public final AlterTableImpl drop(Name field) {
        return this.dropColumn(field);
    }

    @Override
    public final AlterTableImpl drop(String field) {
        return this.dropColumn(field);
    }

    @Override
    public final AlterTableImpl dropColumn(Name field) {
        return this.dropColumn((Field)DSL.field(field));
    }

    @Override
    public final AlterTableImpl dropColumn(String field) {
        return this.dropColumn(DSL.name(field));
    }

    @Override
    public final AlterTableImpl dropColumn(Field<?> field) {
        this.dropColumn = field;
        return this;
    }

    @Override
    public final AlterTableImpl drop(Constraint constraint) {
        this.dropConstraint = constraint;
        return this;
    }

    @Override
    public final AlterTableImpl dropConstraint(Name constraint) {
        return this.drop(DSL.constraint(constraint));
    }

    @Override
    public final AlterTableImpl dropConstraint(String constraint) {
        return this.drop(DSL.constraint(constraint));
    }

    @Override
    public final AlterTableFinalStep cascade() {
        this.dropColumnCascade = true;
        return this;
    }

    @Override
    public final AlterTableFinalStep restrict() {
        this.dropColumnCascade = false;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !Arrays.asList(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD).contains((Object)ctx.family());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatchIfExists(ctx, DDLStatementType.ALTER_TABLE, this.table);
            this.accept0(ctx);
            Tools.endTryCatchIfExists(ctx, DDLStatementType.ALTER_TABLE, this.table);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        SQLDialect family = ctx.family();
        if (this.renameIndexTo != null) {
            switch (family) {
                case MYSQL: {
                    break;
                }
                default: {
                    ctx.visit(DSL.alterIndex(this.renameIndex).renameTo(this.renameIndexTo));
                    return;
                }
            }
        }
        if (this.alterColumnType != null && this.alterColumnType.nullability() != Nullability.DEFAULT) {
            switch (family) {
                case POSTGRES: {
                    this.alterColumnTypeAndNullabilityInBlock(ctx);
                    return;
                }
            }
        }
        this.accept1(ctx);
    }

    private final void accept1(Context<?> ctx) {
        boolean renameTable;
        SQLDialect family = ctx.family();
        boolean omitAlterTable = family == SQLDialect.HSQLDB && this.renameConstraint != null || family == SQLDialect.DERBY && this.renameColumn != null;
        boolean bl = renameTable = Arrays.asList(SQLDialect.DERBY).contains((Object)family) && this.renameTo != null;
        if (!omitAlterTable) {
            ctx.start(Clause.ALTER_TABLE_TABLE).visit(renameTable ? Keywords.K_RENAME_TABLE : Keywords.K_ALTER_TABLE);
            if (this.ifExists && this.supportsIfExists(ctx)) {
                ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
            }
            ctx.sql(' ').visit(this.table).end(Clause.ALTER_TABLE_TABLE).formatIndentStart().formatSeparator();
        }
        if (this.renameTo != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_RENAME).qualify(false).visit(renameTable ? Keywords.K_TO : Keywords.K_RENAME_TO).sql(' ').visit(this.renameTo).qualify(qualify).end(Clause.ALTER_TABLE_RENAME);
        } else if (this.renameColumn != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_RENAME_COLUMN);
            switch (ctx.family()) {
                case DERBY: {
                    ctx.visit(Keywords.K_RENAME_COLUMN).sql(' ').visit(this.renameColumn).formatSeparator().visit(Keywords.K_TO).sql(' ').qualify(false).visit(this.renameColumnTo).qualify(qualify);
                    break;
                }
                case H2: 
                case HSQLDB: {
                    ctx.qualify(false).visit(Keywords.K_ALTER_COLUMN).sql(' ').visit(this.renameColumn).formatSeparator().visit(Keywords.K_RENAME_TO).sql(' ').visit(this.renameColumnTo).qualify(qualify);
                    break;
                }
                default: {
                    ctx.qualify(false).visit(Keywords.K_RENAME_COLUMN).sql(' ').visit(this.renameColumn).formatSeparator().visit(Keywords.K_TO).sql(' ').visit(this.renameColumnTo).qualify(qualify);
                }
            }
            ctx.end(Clause.ALTER_TABLE_RENAME_COLUMN);
        } else if (this.renameIndex != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_RENAME_INDEX).qualify(false).visit(Keywords.K_RENAME_INDEX).sql(' ').visit(this.renameIndex).formatSeparator().visit(Keywords.K_TO).sql(' ').visit(this.renameIndexTo).qualify(qualify).end(Clause.ALTER_TABLE_RENAME_INDEX);
        } else if (this.renameConstraint != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_RENAME_CONSTRAINT);
            ctx.data((Object)Tools.DataKey.DATA_CONSTRAINT_REFERENCE, true);
            if (family == SQLDialect.HSQLDB) {
                ctx.qualify(false).visit(Keywords.K_ALTER_CONSTRAINT).sql(' ').visit(this.renameConstraint).formatSeparator().visit(Keywords.K_RENAME_TO).sql(' ').visit(this.renameConstraintTo).qualify(qualify);
            } else {
                ctx.qualify(false).visit(Keywords.K_RENAME_CONSTRAINT).sql(' ').visit(this.renameConstraint).formatSeparator().visit(Keywords.K_TO).sql(' ').visit(this.renameConstraintTo).qualify(qualify);
            }
            ctx.data().remove((Object)Tools.DataKey.DATA_CONSTRAINT_REFERENCE);
            ctx.end(Clause.ALTER_TABLE_RENAME_CONSTRAINT);
        } else if (this.addColumn != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_ADD).visit(Keywords.K_ADD).sql(' ');
            ctx.qualify(false).visit(this.addColumn).sql(' ').qualify(qualify);
            Tools.toSQLDDLTypeDeclarationForAddition(ctx, this.addColumnType);
            ctx.end(Clause.ALTER_TABLE_ADD);
        } else if (this.addConstraint != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_TABLE_ADD);
            ctx.visit(Keywords.K_ADD).sql(' ').qualify(false).visit(this.addConstraint).qualify(qualify);
            ctx.end(Clause.ALTER_TABLE_ADD);
        } else if (this.alterColumn != null) {
            ctx.start(Clause.ALTER_TABLE_ALTER);
            switch (family) {
                case MYSQL: 
                case CUBRID: 
                case MARIADB: {
                    if (this.alterColumnDefault == null) {
                        ctx.visit(Keywords.K_CHANGE_COLUMN).sql(' ').qualify(false).visit(this.alterColumn).qualify(true);
                        break;
                    }
                    ctx.visit(Keywords.K_ALTER_COLUMN);
                    break;
                }
                default: {
                    ctx.visit(Keywords.K_ALTER);
                }
            }
            ctx.sql(' ').qualify(false).visit(this.alterColumn).qualify(true);
            if (this.alterColumnType != null) {
                switch (family) {
                    case DERBY: {
                        ctx.sql(' ').visit(Keywords.K_SET_DATA_TYPE);
                        break;
                    }
                    case POSTGRES: {
                        ctx.sql(' ').visit(Keywords.K_TYPE);
                    }
                }
                ctx.sql(' ');
                Tools.toSQLDDLTypeDeclaration(ctx, this.alterColumnType);
                if (!Arrays.asList(SQLDialect.POSTGRES).contains((Object)family)) {
                    switch (this.alterColumnType.nullability()) {
                        case NULL: {
                            ctx.sql(' ').visit(Keywords.K_NULL);
                            break;
                        }
                        case NOT_NULL: {
                            ctx.sql(' ').visit(Keywords.K_NOT_NULL);
                            break;
                        }
                    }
                }
            } else if (this.alterColumnDefault != null) {
                ctx.start(Clause.ALTER_TABLE_ALTER_DEFAULT);
                switch (family) {
                    default: 
                }
                ctx.visit(Keywords.K_SET_DEFAULT);
                ctx.sql(' ').visit(this.alterColumnDefault).end(Clause.ALTER_TABLE_ALTER_DEFAULT);
            } else if (this.alterColumnNullability != null) {
                ctx.start(Clause.ALTER_TABLE_ALTER_NULL).sql(' ').visit(this.alterColumnNullability.nullable() ? Keywords.K_DROP_NOT_NULL : Keywords.K_SET_NOT_NULL).end(Clause.ALTER_TABLE_ALTER_NULL);
            }
            ctx.end(Clause.ALTER_TABLE_ALTER);
        } else if (this.dropColumn != null) {
            ctx.start(Clause.ALTER_TABLE_DROP);
            switch (family) {
                default: 
            }
            ctx.visit(Keywords.K_DROP);
            ctx.sql(' ').qualify(false).visit(this.dropColumn).qualify(true);
            switch (family) {
                default: 
            }
            if (this.dropColumnCascade) {
                ctx.sql(' ').visit(Keywords.K_CASCADE);
            }
            ctx.end(Clause.ALTER_TABLE_DROP);
        } else if (this.dropConstraint != null) {
            ctx.start(Clause.ALTER_TABLE_DROP);
            ctx.data((Object)Tools.DataKey.DATA_CONSTRAINT_REFERENCE, true);
            ctx.visit(Keywords.K_DROP_CONSTRAINT).sql(' ').visit(this.dropConstraint);
            ctx.data().remove((Object)Tools.DataKey.DATA_CONSTRAINT_REFERENCE);
            ctx.end(Clause.ALTER_TABLE_DROP);
        }
        if (!omitAlterTable) {
            ctx.formatIndentEnd();
        }
    }

    private final void alterColumnTypeAndNullabilityInBlock(Context<?> ctx) {
        Tools.begin(ctx);
        this.accept1(ctx);
        ctx.sql(';').formatSeparator();
        switch (ctx.family()) {
            case POSTGRES: {
                AlterTableAlterStep<?> step = ctx.dsl().alterTable(this.table).alterColumn(this.alterColumn);
                ctx.visit(this.alterColumnType.nullable() ? step.dropNotNull() : step.setNotNull());
                break;
            }
        }
        Tools.end(ctx);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

