/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Iterator;
import lombok.Generated;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.core.common.io.stream.BytesStreamInput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.NoCursorException;
import org.opensearch.sql.executor.pagination.PlanSerializer;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.request.OpenSearchScrollRequest;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;
import org.opensearch.sql.opensearch.storage.OpenSearchStorageEngine;
import org.opensearch.sql.planner.SerializablePlan;
import org.opensearch.sql.storage.TableScanOperator;

public class OpenSearchIndexScan
extends TableScanOperator
implements SerializablePlan {
    private OpenSearchClient client;
    private OpenSearchRequest request;
    private int maxResponseSize;
    private Integer queryCount;
    private Iterator<ExprValue> iterator;

    public OpenSearchIndexScan(OpenSearchClient client, int maxResponseSize, OpenSearchRequest request) {
        this.client = client;
        this.maxResponseSize = maxResponseSize;
        this.request = request;
    }

    public void open() {
        super.open();
        this.iterator = Collections.emptyIterator();
        this.queryCount = 0;
        this.fetchNextBatch();
    }

    public boolean hasNext() {
        if (this.queryCount >= this.maxResponseSize) {
            this.iterator = Collections.emptyIterator();
        } else if (!this.iterator.hasNext()) {
            this.fetchNextBatch();
        }
        return this.iterator.hasNext();
    }

    public ExprValue next() {
        Integer n = this.queryCount;
        Integer n2 = this.queryCount = Integer.valueOf(this.queryCount + 1);
        return this.iterator.next();
    }

    private void fetchNextBatch() {
        OpenSearchResponse response = this.client.search(this.request);
        if (!response.isEmpty()) {
            this.iterator = response.iterator();
        }
    }

    public void close() {
        super.close();
        this.client.cleanup(this.request);
    }

    public String explain() {
        return this.request.toString();
    }

    @Deprecated(since="introduction")
    public OpenSearchIndexScan() {
    }

    public void readExternal(ObjectInput in) throws IOException {
        int currentRead;
        int reqSize = in.readInt();
        byte[] requestStream = new byte[reqSize];
        int read = 0;
        do {
            if ((currentRead = in.read(requestStream, read, reqSize - read)) != -1) continue;
            throw new IOException();
        } while ((read += currentRead) < reqSize);
        OpenSearchStorageEngine engine = (OpenSearchStorageEngine)((PlanSerializer.CursorDeserializationStream)in).resolveObject((Object)"engine");
        try (BytesStreamInput bsi = new BytesStreamInput(requestStream);){
            this.request = new OpenSearchScrollRequest((StreamInput)bsi, engine);
        }
        this.maxResponseSize = in.readInt();
        this.client = engine.getClient();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (!this.request.hasAnotherBatch()) {
            throw new NoCursorException();
        }
        BytesStreamOutput reqOut = new BytesStreamOutput();
        this.request.writeTo((StreamOutput)reqOut);
        reqOut.flush();
        byte[] reqAsBytes = reqOut.bytes().toBytesRef().bytes;
        out.writeInt(reqOut.size());
        out.write(reqAsBytes, 0, reqOut.size());
        out.writeInt(this.maxResponseSize);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchIndexScan)) {
            return false;
        }
        OpenSearchIndexScan other = (OpenSearchIndexScan)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.maxResponseSize != other.maxResponseSize) {
            return false;
        }
        OpenSearchRequest this$request = this.request;
        OpenSearchRequest other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchIndexScan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.maxResponseSize;
        OpenSearchRequest $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OpenSearchIndexScan(request=" + this.request + ", maxResponseSize=" + this.maxResponseSize + ")";
    }
}

