import { EventEmitter } from 'node:events';
import { Adapter, Events as AdapterEvents } from '../adapter';
import * as Zcl from '../zspec/zcl';
import { GreenPowerDeviceJoinedPayload } from './tstype';
declare const enum ZigbeeNWKGPAppId {
    DEFAULT = 0,
    LPED = 1,
    ZGP = 2
}
declare const enum ZigbeeNWKGPSecurityLevel {
    /** No Security  */
    NO = 0,
    /** Reserved?  */
    ONELSB = 1,
    /** 4 Byte Frame Counter and 4 Byte MIC */
    FULL = 2,
    /** 4 Byte Frame Counter and 4 Byte MIC with encryption */
    FULLENCR = 3
}
declare const enum ZigbeeNWKGPSecurityKeyType {
    NO_KEY = 0,
    ZB_NWK_KEY = 1,
    GPD_GROUP_KEY = 2,
    NWK_KEY_DERIVED_GPD_KEY_GROUP_KEY = 3,
    PRECONFIGURED_INDIVIDUAL_GPD_KEY = 4,
    DERIVED_INDIVIDUAL_GPD_KEY = 7
}
declare const enum GPCommunicationMode {
    FULL_UNICAST = 0,
    GROUPCAST_TO_DGROUPID = 1,
    GROUPCAST_TO_PRECOMMISSIONED_GROUPID = 2,
    LIGHTWEIGHT_UNICAST = 3
}
type PairingOptions = {
    appId: ZigbeeNWKGPAppId;
    addSink: boolean;
    removeGpd: boolean;
    communicationMode: GPCommunicationMode;
    gpdFixed: boolean;
    gpdMacSeqNumCapabilities: boolean;
    securityLevel: ZigbeeNWKGPSecurityLevel;
    securityKeyType: ZigbeeNWKGPSecurityKeyType;
    gpdSecurityFrameCounterPresent: boolean;
    gpdSecurityKeyPresent: boolean;
    assignedAliasPresent: boolean;
    groupcastRadiusPresent: boolean;
};
type CommissioningModeOptions = {
    action: number;
    commissioningWindowPresent: boolean;
    /** Bits: 0: On first Pairing success | 1: On GP Proxy Commissioning Mode (exit) */
    exitMode: number;
    /** should always be always false in current spec (1.1.2) */
    channelPresent: boolean;
    unicastCommunication: boolean;
};
interface GreenPowerEventMap {
    deviceJoined: [payload: GreenPowerDeviceJoinedPayload];
    deviceLeave: [sourceID: number];
}
export declare class GreenPower extends EventEmitter<GreenPowerEventMap> {
    private adapter;
    constructor(adapter: Adapter);
    private encryptSecurityKey;
    private decryptPayload;
    static encodePairingOptions(options: PairingOptions): number;
    static decodePairingOptions(byte: number): PairingOptions;
    /** see 14-0563-19 A.3.3.5.2 */
    private sendPairingCommand;
    onZclGreenPowerData(dataPayload: AdapterEvents.ZclPayload, frame: Zcl.Frame, securityKey?: Buffer): Promise<Zcl.Frame>;
    static encodeCommissioningModeOptions(options: CommissioningModeOptions): number;
    static decodeCommissioningModeOptions(byte: number): CommissioningModeOptions;
    permitJoin(time: number, networkAddress?: number): Promise<void>;
}
export default GreenPower;
//# sourceMappingURL=greenPower.d.ts.map