/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.protobuf;

import java.util.Arrays;
import org.openstreetmap.josm.data.protobuf.ProtobufParser;

public class ProtobufPacked {
    private final byte[] bytes;
    private final long[] numbers;
    private int location = 0;

    public ProtobufPacked(byte[] bytes) {
        this.bytes = bytes;
        long[] numbersT = new long[bytes.length];
        int index = 0;
        while (this.location < bytes.length) {
            int start = this.location;
            numbersT[index] = ProtobufParser.convertByteArray(this.bytes, (byte)7, start, this.nextVarInt());
            ++index;
        }
        this.numbers = numbersT.length == index ? numbersT : Arrays.copyOf(numbersT, index);
    }

    public long[] getArray() {
        return this.numbers;
    }

    private int nextVarInt() {
        while ((this.bytes[this.location] & 0xFFFFFF80) == -128) {
            this.bytes[this.location] = (byte)(this.bytes[this.location] ^ 0xFFFFFF80);
            ++this.location;
        }
        return ++this.location;
    }
}

