/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.util.Objects;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.TextLabel;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.CompletelyInsideAreaStrategy;
import org.openstreetmap.josm.gui.mappaint.styleelement.placement.PositionForAreaStrategy;

public class TextElement
extends StyleElement {
    private final TextLabel text;
    private final PositionForAreaStrategy labelPositionStrategy;

    protected TextElement(Cascade c, TextLabel text, PositionForAreaStrategy labelPositionStrategy) {
        super(c, 4.9f);
        this.text = Objects.requireNonNull(text, "text");
        this.labelPositionStrategy = Objects.requireNonNull(labelPositionStrategy, "labelPositionStrategy");
    }

    public PositionForAreaStrategy getLabelPositionStrategy() {
        return this.labelPositionStrategy;
    }

    public static TextElement create(Environment env) {
        TextLabel text = TextLabel.create(env, PaintColors.TEXT.get(), false);
        if (text == null) {
            return null;
        }
        Cascade c = env.getCascade();
        Keyword positionKeyword = c.get("text-position", null, Keyword.class);
        PositionForAreaStrategy position = PositionForAreaStrategy.forKeyword(positionKeyword);
        position = position.withAddedOffset(TextLabel.getTextOffset(c));
        return new TextElement(c, text, position);
    }

    public static TextElement createForContent(Environment env) {
        Cascade c = env.getCascade();
        Keyword positionKeyword = c.get("text-position", null, Keyword.class);
        if (positionKeyword != null) {
            return null;
        }
        TextLabel text = TextLabel.create(env, PaintColors.TEXT.get(), true);
        if (text == null) {
            return null;
        }
        return new TextElement(c, text, CompletelyInsideAreaStrategy.INSTANCE);
    }

    @Override
    public void paintPrimitive(IPrimitive primitive, MapPaintSettings paintSettings, StyledMapRenderer painter, boolean selected, boolean outermember, boolean member) {
        painter.drawText(primitive, this.text, this.getLabelPositionStrategy());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TextElement that = (TextElement)obj;
        return Objects.equals(this.labelPositionStrategy, that.labelPositionStrategy) && Objects.equals(this.text, that.text);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.text, this.labelPositionStrategy);
    }

    @Override
    public String toString() {
        return "TextElement{" + super.toString() + "text=" + this.text + " labelPositionStrategy=" + this.labelPositionStrategy + "}";
    }
}

