/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.platform.macos.macho;

import com.install4j.runtime.installer.platform.macos.macho.FatMachoFile;
import com.install4j.runtime.installer.platform.macos.macho.MachoFile;
import com.install4j.runtime.util.BinaryUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jetbrains.annotations.NotNull;

public class SignatureRemover {
    public static void removeFat(File file) throws IOException {
        if (file.length() < 4L) {
            throw new MachoFile.NoMachoException(file);
        }
        FatMachoFile fatMachoFile = new FatMachoFile(file);
        if (!fatMachoFile.isFat()) {
            SignatureRemover.removeThin(file);
        } else {
            for (FatMachoFile.Architecture architecture : fatMachoFile.getArchitectures()) {
                architecture.setData(SignatureRemover.removeThin(architecture.getData()));
            }
            fatMachoFile.write();
        }
    }

    private static void removeThin(File file) throws IOException {
        try (RandomAccessFile raFile = new RandomAccessFile(file, "rw");
             FileChannel channel = raFile.getChannel();){
            ByteBuffer data = ByteBuffer.allocate((int)file.length());
            BinaryUtil.readFully(channel, data);
            data = SignatureRemover.removeThin((ByteBuffer)data.position(0));
            raFile.seek(0L);
            BinaryUtil.writeFully(channel, data);
            raFile.setLength(data.limit());
        }
    }

    private static ByteBuffer removeThin(@NotNull ByteBuffer data) throws IOException {
        MachoFile machoFile = new MachoFile(data);
        machoFile.removeSignature();
        machoFile.writeHeaderAndCommands();
        return machoFile.getData();
    }
}

