/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.Axiomatic;
import org.apache.lucene.search.similarities.BasicStats;

public class AxiomaticF1EXP
extends Axiomatic {
    public AxiomaticF1EXP(float s2, float k) {
        super(s2, 1, k);
    }

    public AxiomaticF1EXP(float s2) {
        this(s2, 0.35f);
    }

    public AxiomaticF1EXP() {
    }

    @Override
    public String toString() {
        return "F1EXP";
    }

    @Override
    protected double tf(BasicStats stats, double freq, double docLen) {
        return 1.0 + Math.log(1.0 + Math.log(freq += 1.0));
    }

    @Override
    protected double ln(BasicStats stats, double freq, double docLen) {
        return (stats.getAvgFieldLength() + (double)this.s) / (stats.getAvgFieldLength() + docLen * (double)this.s);
    }

    @Override
    protected double tfln(BasicStats stats, double freq, double docLen) {
        return 1.0;
    }

    @Override
    protected double idf(BasicStats stats, double freq, double docLen) {
        return Math.pow(((double)stats.getNumberOfDocuments() + 1.0) / (double)stats.getDocFreq(), this.k);
    }

    @Override
    protected double gamma(BasicStats stats, double freq, double docLen) {
        return 0.0;
    }

    @Override
    protected Explanation tfExplain(BasicStats stats, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.tf(stats, freq, docLen)), "tf, term frequency computed as 1 + log(1 + log(freq)) from:", Explanation.match((Number)Float.valueOf((float)freq), "freq, number of occurrences of term in the document", new Explanation[0]));
    }

    @Override
    protected Explanation lnExplain(BasicStats stats, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.ln(stats, freq, docLen)), "ln, document length computed as (avgdl + s) / (avgdl + dl * s) from:", Explanation.match((Number)Float.valueOf((float)stats.getAvgFieldLength()), "avgdl, average length of field across all documents", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)docLen), "dl, length of field", new Explanation[0]));
    }

    @Override
    protected Explanation tflnExplain(BasicStats stats, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.tfln(stats, freq, docLen)), "tfln, mixed term frequency and document length, equals to 1", new Explanation[0]);
    }

    @Override
    protected Explanation idfExplain(BasicStats stats, double freq, double docLen) {
        return Explanation.match((Number)Float.valueOf((float)this.idf(stats, freq, docLen)), "idf, inverted document frequency computed as Math.pow((N + 1) / n, k) from:", Explanation.match((Number)Float.valueOf(stats.getNumberOfDocuments()), "N, total number of documents with field", new Explanation[0]), Explanation.match((Number)Float.valueOf(stats.getDocFreq()), "n, number of documents containing term", new Explanation[0]));
    }
}

