/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.io.IOException;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchException;
import org.opensearch.action.OriginalIndices;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.action.ShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.search.SearchException;
import org.opensearch.search.SearchShardTarget;

@PublicApi(since="1.0.0")
public class ShardSearchFailure
extends ShardOperationFailedException {
    private static final String REASON_FIELD = "reason";
    private static final String NODE_FIELD = "node";
    private static final String INDEX_FIELD = "index";
    private static final String SHARD_FIELD = "shard";
    public static final ShardSearchFailure[] EMPTY_ARRAY = new ShardSearchFailure[0];
    private SearchShardTarget shardTarget;

    ShardSearchFailure(StreamInput in) throws IOException {
        this.shardTarget = (SearchShardTarget)in.readOptionalWriteable(SearchShardTarget::new);
        if (this.shardTarget != null) {
            this.index = this.shardTarget.getFullyQualifiedIndexName();
            this.shardId = this.shardTarget.getShardId().getId();
        }
        this.reason = in.readString();
        this.status = RestStatus.readFrom((StreamInput)in);
        this.cause = in.readException();
    }

    public ShardSearchFailure(Exception e) {
        this(e, null);
    }

    public ShardSearchFailure(Exception e, @Nullable SearchShardTarget shardTarget) {
        this(e, ExceptionsHelper.unwrapCause((Throwable)e), shardTarget);
    }

    private ShardSearchFailure(Exception e, Throwable unwrappedCause, @Nullable SearchShardTarget shardTarget) {
        super(shardTarget == null ? null : shardTarget.getFullyQualifiedIndexName(), shardTarget == null ? -1 : shardTarget.getShardId().getId(), ExceptionsHelper.detailedMessage((Throwable)e), ExceptionsHelper.status((Throwable)unwrappedCause), unwrappedCause);
        if (unwrappedCause instanceof SearchException) {
            this.shardTarget = ((SearchException)((Object)unwrappedCause)).shard();
        } else if (shardTarget != null) {
            this.shardTarget = shardTarget;
        }
    }

    @Nullable
    public SearchShardTarget shard() {
        return this.shardTarget;
    }

    public String toString() {
        return "shard [" + (Comparable)(this.shardTarget == null ? "_na" : this.shardTarget) + "], reason [" + this.reason + "], cause [" + (this.cause == null ? "_na" : ExceptionsHelper.stackTrace((Throwable)this.cause)) + "]";
    }

    public static ShardSearchFailure readShardSearchFailure(StreamInput in) throws IOException {
        return new ShardSearchFailure(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable((Writeable)this.shardTarget);
        out.writeString(this.reason);
        RestStatus.writeTo((StreamOutput)out, (RestStatus)this.status);
        out.writeException(this.cause);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SHARD_FIELD, this.shardId());
        builder.field(INDEX_FIELD, this.index());
        if (this.shardTarget != null) {
            builder.field(NODE_FIELD, this.shardTarget.getNodeId());
        }
        builder.field(REASON_FIELD);
        builder.startObject();
        OpenSearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)this.cause);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static ShardSearchFailure fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        String currentFieldName = null;
        int shardId = -1;
        String indexName = null;
        String clusterAlias = null;
        String nodeId = null;
        OpenSearchException exception = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (SHARD_FIELD.equals(currentFieldName)) {
                    shardId = parser.intValue();
                    continue;
                }
                if (INDEX_FIELD.equals(currentFieldName)) {
                    indexName = parser.text();
                    int indexOf = indexName.indexOf(58);
                    if (indexOf <= 0) continue;
                    clusterAlias = indexName.substring(0, indexOf);
                    indexName = indexName.substring(indexOf + 1);
                    continue;
                }
                if (NODE_FIELD.equals(currentFieldName)) {
                    nodeId = parser.text();
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (REASON_FIELD.equals(currentFieldName)) {
                    exception = OpenSearchException.fromXContent((XContentParser)parser);
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            parser.skipChildren();
        }
        SearchShardTarget searchShardTarget = null;
        if (nodeId != null) {
            searchShardTarget = new SearchShardTarget(nodeId, new ShardId(new Index(indexName, "_na_"), shardId), clusterAlias, OriginalIndices.NONE);
        }
        return new ShardSearchFailure((Exception)((Object)exception), searchShardTarget);
    }
}

