/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.composite;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene99.Lucene99Codec;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.index.codec.composite.composite99.Composite99Codec;
import org.opensearch.index.mapper.MapperService;

@ExperimentalApi
public class CompositeCodecFactory {
    public static final String COMPOSITE_CODEC = "Composite99Codec";

    public Map<String, Codec> getCompositeIndexCodecs(MapperService mapperService, Logger logger) {
        HashMap<String, Codec> codecs = new HashMap<String, Codec>();
        codecs.put("default", (Codec)new Composite99Codec(Lucene99Codec.Mode.BEST_SPEED, mapperService, logger));
        codecs.put("lz4", (Codec)new Composite99Codec(Lucene99Codec.Mode.BEST_SPEED, mapperService, logger));
        codecs.put("best_compression", (Codec)new Composite99Codec(Lucene99Codec.Mode.BEST_COMPRESSION, mapperService, logger));
        codecs.put("zlib", (Codec)new Composite99Codec(Lucene99Codec.Mode.BEST_COMPRESSION, mapperService, logger));
        return codecs;
    }
}

