/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedNumericDocValuesWriterWrapper;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.NumericUtils;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.compositeindex.datacube.Metric;
import org.opensearch.index.compositeindex.datacube.MetricStat;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeDocument;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeField;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeFieldConfiguration;
import org.opensearch.index.compositeindex.datacube.startree.aggregators.MetricAggregatorInfo;
import org.opensearch.index.compositeindex.datacube.startree.aggregators.ValueAggregator;
import org.opensearch.index.compositeindex.datacube.startree.builder.StarTreeBuilder;
import org.opensearch.index.compositeindex.datacube.startree.fileformats.StarTreeWriter;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.node.InMemoryTreeNode;
import org.opensearch.index.compositeindex.datacube.startree.node.StarTreeNodeType;
import org.opensearch.index.compositeindex.datacube.startree.utils.SequentialDocValuesIterator;
import org.opensearch.index.compositeindex.datacube.startree.utils.StarTreeUtils;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.FieldValueConverter;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.NumberFieldMapper;

public abstract class BaseStarTreeBuilder
implements StarTreeBuilder {
    private static final Logger logger = LogManager.getLogger(BaseStarTreeBuilder.class);
    public static final Long STAR_IN_DOC_VALUES_INDEX = null;
    protected final Set<Integer> skipStarNodeCreationForDimensions;
    protected final List<MetricAggregatorInfo> metricAggregatorInfos;
    protected final int numMetrics;
    protected final int numDimensions;
    protected int numStarTreeDocs;
    protected int totalSegmentDocs;
    protected int numStarTreeNodes;
    protected final int maxLeafDocuments;
    protected final InMemoryTreeNode rootNode = this.getNewNode();
    protected final StarTreeField starTreeField;
    private final SegmentWriteState writeState;
    private final IndexOutput metaOut;
    private final IndexOutput dataOut;

    protected BaseStarTreeBuilder(IndexOutput metaOut, IndexOutput dataOut, StarTreeField starTreeField, SegmentWriteState writeState, MapperService mapperService) {
        logger.debug("Building star tree : {}", (Object)starTreeField.getName());
        this.metaOut = metaOut;
        this.dataOut = dataOut;
        this.starTreeField = starTreeField;
        StarTreeFieldConfiguration starTreeFieldSpec = starTreeField.getStarTreeConfig();
        List<Dimension> dimensionsSplitOrder = starTreeField.getDimensionsOrder();
        this.numDimensions = dimensionsSplitOrder.size();
        this.skipStarNodeCreationForDimensions = new HashSet<Integer>();
        this.totalSegmentDocs = writeState.segmentInfo.maxDoc();
        this.writeState = writeState;
        Set<String> skipStarNodeCreationForDimensions = starTreeFieldSpec.getSkipStarNodeCreationInDims();
        for (int i = 0; i < this.numDimensions; ++i) {
            if (!skipStarNodeCreationForDimensions.contains(dimensionsSplitOrder.get(i).getField())) continue;
            this.skipStarNodeCreationForDimensions.add(i);
        }
        this.metricAggregatorInfos = this.generateMetricAggregatorInfos(mapperService);
        this.numMetrics = this.metricAggregatorInfos.size();
        this.maxLeafDocuments = starTreeFieldSpec.maxLeafDocs();
    }

    public List<MetricAggregatorInfo> generateMetricAggregatorInfos(MapperService mapperService) {
        ArrayList<MetricAggregatorInfo> metricAggregatorInfos = new ArrayList<MetricAggregatorInfo>();
        for (Metric metric : this.starTreeField.getMetrics()) {
            if (metric.getField().equals("_doc_count")) {
                MetricAggregatorInfo metricAggregatorInfo = new MetricAggregatorInfo(MetricStat.DOC_COUNT, metric.getField(), this.starTreeField.getName(), NumberFieldMapper.NumberType.LONG);
                metricAggregatorInfos.add(metricAggregatorInfo);
                continue;
            }
            for (MetricStat metricStat : metric.getBaseMetrics()) {
                Mapper fieldMapper = mapperService.documentMapper().mappers().getMapper(metric.getField());
                if (!(fieldMapper instanceof FieldMapper) || !(((FieldMapper)fieldMapper).fieldType() instanceof FieldValueConverter)) {
                    logger.error("unsupported mapper type");
                    throw new IllegalStateException("unsupported mapper type");
                }
                FieldValueConverter fieldValueConverter = (FieldValueConverter)((Object)((FieldMapper)fieldMapper).fieldType());
                MetricAggregatorInfo metricAggregatorInfo = new MetricAggregatorInfo(metricStat, metric.getField(), this.starTreeField.getName(), fieldValueConverter);
                metricAggregatorInfos.add(metricAggregatorInfo);
            }
        }
        return metricAggregatorInfos;
    }

    public List<SequentialDocValuesIterator> getMetricReaders(SegmentWriteState state, Map<String, DocValuesProducer> fieldProducerMap) throws IOException {
        ArrayList<SequentialDocValuesIterator> metricReaders = new ArrayList<SequentialDocValuesIterator>();
        for (Metric metric : this.starTreeField.getMetrics()) {
            for (MetricStat metricStat : metric.getBaseMetrics()) {
                SequentialDocValuesIterator metricReader;
                FieldInfo metricFieldInfo = state.fieldInfos.fieldInfo(metric.getField());
                if (metricStat.equals((Object)MetricStat.DOC_COUNT)) {
                    metricReader = this.getIteratorForNumericField(fieldProducerMap, metricFieldInfo, "_doc_count");
                } else {
                    if (metricFieldInfo == null) {
                        metricFieldInfo = StarTreeUtils.getFieldInfo(metric.getField(), DocValuesType.SORTED_NUMERIC);
                    }
                    metricReader = new SequentialDocValuesIterator((DocIdSetIterator)fieldProducerMap.get(metricFieldInfo.name).getSortedNumeric(metricFieldInfo));
                }
                metricReaders.add(metricReader);
            }
        }
        return metricReaders;
    }

    @Override
    public void build(Map<String, DocValuesProducer> fieldProducerMap, AtomicInteger fieldNumberAcrossStarTrees, DocValuesConsumer starTreeDocValuesConsumer) throws IOException {
        long startTime = System.currentTimeMillis();
        logger.debug("Star-tree build is a go with star tree field {}", (Object)this.starTreeField.getName());
        List<SequentialDocValuesIterator> metricReaders = this.getMetricReaders(this.writeState, fieldProducerMap);
        List<Dimension> dimensionsSplitOrder = this.starTreeField.getDimensionsOrder();
        SequentialDocValuesIterator[] dimensionReaders = new SequentialDocValuesIterator[dimensionsSplitOrder.size()];
        for (int i = 0; i < this.numDimensions; ++i) {
            String dimension = dimensionsSplitOrder.get(i).getField();
            FieldInfo dimensionFieldInfo = this.writeState.fieldInfos.fieldInfo(dimension);
            if (dimensionFieldInfo == null) {
                dimensionFieldInfo = StarTreeUtils.getFieldInfo(dimension, DocValuesType.SORTED_NUMERIC);
            }
            dimensionReaders[i] = new SequentialDocValuesIterator((DocIdSetIterator)fieldProducerMap.get(dimensionFieldInfo.name).getSortedNumeric(dimensionFieldInfo));
        }
        Iterator<StarTreeDocument> starTreeDocumentIterator = this.sortAndAggregateSegmentDocuments(dimensionReaders, metricReaders);
        logger.debug("Sorting and aggregating star-tree in ms : {}", (Object)(System.currentTimeMillis() - startTime));
        this.build(starTreeDocumentIterator, fieldNumberAcrossStarTrees, starTreeDocValuesConsumer);
        logger.debug("Finished Building star-tree in ms : {}", (Object)(System.currentTimeMillis() - startTime));
    }

    public void build(Iterator<StarTreeDocument> starTreeDocumentIterator, AtomicInteger fieldNumberAcrossStarTrees, DocValuesConsumer starTreeDocValuesConsumer) throws IOException {
        int numSegmentStarTreeDocument = this.totalSegmentDocs;
        this.appendDocumentsToStarTree(starTreeDocumentIterator);
        int numStarTreeDocument = this.numStarTreeDocs;
        logger.debug("Generated star tree docs : [{}] from segment docs : [{}]", (Object)numStarTreeDocument, (Object)numSegmentStarTreeDocument);
        if (this.numStarTreeDocs == 0) {
            this.serializeStarTree(numStarTreeDocument, this.numStarTreeDocs);
            return;
        }
        this.constructStarTree(this.rootNode, 0, this.numStarTreeDocs);
        int numStarTreeDocumentUnderStarNode = this.numStarTreeDocs - numStarTreeDocument;
        logger.debug("Finished constructing star-tree, got [ {} ] tree nodes and [ {} ] starTreeDocument under star-node", (Object)this.numStarTreeNodes, (Object)numStarTreeDocumentUnderStarNode);
        this.createAggregatedDocs(this.rootNode);
        int numAggregatedStarTreeDocument = this.numStarTreeDocs - numStarTreeDocument - numStarTreeDocumentUnderStarNode;
        logger.debug("Finished creating aggregated documents : {}", (Object)numAggregatedStarTreeDocument);
        this.createSortedDocValuesIndices(starTreeDocValuesConsumer, fieldNumberAcrossStarTrees);
        this.serializeStarTree(numStarTreeDocument, this.numStarTreeDocs);
    }

    void appendDocumentsToStarTree(Iterator<StarTreeDocument> starTreeDocumentIterator) throws IOException {
        while (starTreeDocumentIterator.hasNext()) {
            this.appendToStarTree(starTreeDocumentIterator.next());
        }
    }

    private void serializeStarTree(int numSegmentStarTreeDocument, int numStarTreeDocs) throws IOException {
        long dataFilePointer = this.dataOut.getFilePointer();
        StarTreeWriter starTreeWriter = new StarTreeWriter();
        long totalStarTreeDataLength = starTreeWriter.writeStarTree(this.dataOut, this.rootNode, this.numStarTreeNodes, this.starTreeField.getName());
        starTreeWriter.writeStarTreeMetadata(this.metaOut, this.starTreeField, this.metricAggregatorInfos, this.numStarTreeNodes, numSegmentStarTreeDocument, numStarTreeDocs, dataFilePointer, totalStarTreeDataLength);
    }

    private void createSortedDocValuesIndices(DocValuesConsumer docValuesConsumer, AtomicInteger fieldNumberAcrossStarTrees) throws IOException {
        FieldInfo fi;
        int i;
        ArrayList<SortedNumericDocValuesWriterWrapper> dimensionWriters = new ArrayList<SortedNumericDocValuesWriterWrapper>();
        ArrayList<SortedNumericDocValuesWriterWrapper> metricWriters = new ArrayList<SortedNumericDocValuesWriterWrapper>();
        FieldInfo[] dimensionFieldInfoList = new FieldInfo[this.starTreeField.getDimensionsOrder().size()];
        FieldInfo[] metricFieldInfoList = new FieldInfo[this.metricAggregatorInfos.size()];
        for (i = 0; i < dimensionFieldInfoList.length; ++i) {
            dimensionFieldInfoList[i] = fi = StarTreeUtils.getFieldInfo(StarTreeUtils.fullyQualifiedFieldNameForStarTreeDimensionsDocValues(this.starTreeField.getName(), this.starTreeField.getDimensionsOrder().get(i).getField()), DocValuesType.SORTED_NUMERIC, fieldNumberAcrossStarTrees.getAndIncrement());
            dimensionWriters.add(new SortedNumericDocValuesWriterWrapper(fi, Counter.newCounter()));
        }
        for (i = 0; i < this.metricAggregatorInfos.size(); ++i) {
            metricFieldInfoList[i] = fi = StarTreeUtils.getFieldInfo(StarTreeUtils.fullyQualifiedFieldNameForStarTreeMetricsDocValues(this.starTreeField.getName(), this.metricAggregatorInfos.get(i).getField(), this.metricAggregatorInfos.get(i).getMetricStat().getTypeName()), DocValuesType.SORTED_NUMERIC, fieldNumberAcrossStarTrees.getAndIncrement());
            metricWriters.add(new SortedNumericDocValuesWriterWrapper(fi, Counter.newCounter()));
        }
        for (int docId = 0; docId < this.numStarTreeDocs; ++docId) {
            int i2;
            StarTreeDocument starTreeDocument = this.getStarTreeDocument(docId);
            for (i2 = 0; i2 < starTreeDocument.dimensions.length; ++i2) {
                if (starTreeDocument.dimensions[i2] == null) continue;
                ((SortedNumericDocValuesWriterWrapper)dimensionWriters.get(i2)).addValue(docId, starTreeDocument.dimensions[i2]);
            }
            for (i2 = 0; i2 < starTreeDocument.metrics.length; ++i2) {
                try {
                    FieldValueConverter aggregatedValueType = this.metricAggregatorInfos.get(i2).getValueAggregators().getAggregatedValueType();
                    if (aggregatedValueType.equals(NumberFieldMapper.NumberType.LONG)) {
                        if (starTreeDocument.metrics[i2] != null) {
                            ((SortedNumericDocValuesWriterWrapper)metricWriters.get(i2)).addValue(docId, (Long)starTreeDocument.metrics[i2]);
                        }
                        continue;
                    }
                    if (aggregatedValueType.equals(NumberFieldMapper.NumberType.DOUBLE)) {
                        if (starTreeDocument.metrics[i2] != null) {
                            ((SortedNumericDocValuesWriterWrapper)metricWriters.get(i2)).addValue(docId, NumericUtils.doubleToSortableLong((double)((Double)starTreeDocument.metrics[i2])));
                        }
                        continue;
                    }
                    throw new IllegalStateException("Unknown metric doc value type");
                }
                catch (IllegalArgumentException e) {
                    logger.error("could not parse the value, exiting creation of star tree");
                }
            }
        }
        this.addStarTreeDocValueFields(docValuesConsumer, dimensionWriters, dimensionFieldInfoList, this.starTreeField.getDimensionsOrder().size());
        this.addStarTreeDocValueFields(docValuesConsumer, metricWriters, metricFieldInfoList, this.metricAggregatorInfos.size());
    }

    private void addStarTreeDocValueFields(DocValuesConsumer docValuesConsumer, final List<SortedNumericDocValuesWriterWrapper> docValuesWriters, FieldInfo[] fieldInfoList, int fieldCount) throws IOException {
        for (int i = 0; i < fieldCount; ++i) {
            final int writerIndex = i;
            EmptyDocValuesProducer docValuesProducer = new EmptyDocValuesProducer(){

                public SortedNumericDocValues getSortedNumeric(FieldInfo field) {
                    return ((SortedNumericDocValuesWriterWrapper)docValuesWriters.get(writerIndex)).getDocValues();
                }
            };
            docValuesConsumer.addSortedNumericField(fieldInfoList[i], (DocValuesProducer)docValuesProducer);
        }
    }

    protected StarTreeDocument getStarTreeDocument(int currentDocId, SequentialDocValuesIterator[] dimensionReaders, List<SequentialDocValuesIterator> metricReaders) throws IOException {
        Long[] dims = new Long[this.numDimensions];
        int i = 0;
        for (SequentialDocValuesIterator dimensionDocValueIterator : dimensionReaders) {
            Long val;
            dimensionDocValueIterator.nextDoc(currentDocId);
            dims[i] = val = dimensionDocValueIterator.value(currentDocId);
            ++i;
        }
        i = 0;
        Object[] metrics = new Object[metricReaders.size()];
        for (SequentialDocValuesIterator metricDocValuesIterator : metricReaders) {
            metricDocValuesIterator.nextDoc(currentDocId);
            metrics[i] = this.metricAggregatorInfos.get(i).getValueAggregators().toAggregatedValueType(metricDocValuesIterator.value(currentDocId));
            ++i;
        }
        return new StarTreeDocument(dims, metrics);
    }

    public abstract void appendStarTreeDocument(StarTreeDocument var1) throws IOException;

    public abstract StarTreeDocument getStarTreeDocument(int var1) throws IOException;

    public abstract List<StarTreeDocument> getStarTreeDocuments() throws IOException;

    public abstract Long getDimensionValue(int var1, int var2) throws IOException;

    public abstract Iterator<StarTreeDocument> sortAndAggregateSegmentDocuments(SequentialDocValuesIterator[] var1, List<SequentialDocValuesIterator> var2) throws IOException;

    public abstract Iterator<StarTreeDocument> generateStarTreeDocumentsForStarNode(int var1, int var2, int var3) throws IOException;

    protected StarTreeDocument getSegmentStarTreeDocument(int currentDocId, SequentialDocValuesIterator[] dimensionReaders, List<SequentialDocValuesIterator> metricReaders) throws IOException {
        Long[] dimensions = this.getStarTreeDimensionsFromSegment(currentDocId, dimensionReaders);
        Object[] metrics = this.getStarTreeMetricsFromSegment(currentDocId, metricReaders);
        return new StarTreeDocument(dimensions, metrics);
    }

    Long[] getStarTreeDimensionsFromSegment(int currentDocId, SequentialDocValuesIterator[] dimensionReaders) throws IOException {
        Long[] dimensions = new Long[this.numDimensions];
        for (int i = 0; i < this.numDimensions; ++i) {
            if (dimensionReaders[i] != null) {
                try {
                    dimensionReaders[i].nextDoc(currentDocId);
                }
                catch (IOException e) {
                    logger.error("unable to iterate to next doc", (Throwable)e);
                    throw new RuntimeException("unable to iterate to next doc", e);
                }
                catch (Exception e) {
                    logger.error("unable to read the dimension values from the segment", (Throwable)e);
                    throw new IllegalStateException("unable to read the dimension values from the segment", e);
                }
            } else {
                throw new IllegalStateException("dimension readers are empty");
            }
            dimensions[i] = dimensionReaders[i].value(currentDocId);
        }
        return dimensions;
    }

    private Object[] getStarTreeMetricsFromSegment(int currentDocId, List<SequentialDocValuesIterator> metricsReaders) throws IOException {
        Object[] metrics = new Object[this.numMetrics];
        for (int i = 0; i < this.numMetrics; ++i) {
            SequentialDocValuesIterator metricStatReader = metricsReaders.get(i);
            if (metricStatReader != null) {
                try {
                    metricStatReader.nextDoc(currentDocId);
                }
                catch (IOException e) {
                    logger.error("unable to iterate to next doc", (Throwable)e);
                    throw new RuntimeException("unable to iterate to next doc", e);
                }
                catch (Exception e) {
                    logger.error("unable to read the metric values from the segment", (Throwable)e);
                    throw new IllegalStateException("unable to read the metric values from the segment", e);
                }
            } else {
                throw new IllegalStateException("metric readers are empty");
            }
            metrics[i] = metricStatReader.value(currentDocId);
        }
        return metrics;
    }

    protected StarTreeDocument reduceSegmentStarTreeDocuments(StarTreeDocument aggregatedSegmentDocument, StarTreeDocument segmentDocument, boolean isMerge) {
        if (aggregatedSegmentDocument == null) {
            Long[] dimensions = Arrays.copyOf(segmentDocument.dimensions, this.numDimensions);
            Object[] metrics = new Object[this.numMetrics];
            for (int i = 0; i < this.numMetrics; ++i) {
                try {
                    ValueAggregator metricValueAggregator = this.metricAggregatorInfos.get(i).getValueAggregators();
                    if (isMerge) {
                        metrics[i] = metricValueAggregator.getInitialAggregatedValue(segmentDocument.metrics[i]);
                        continue;
                    }
                    metrics[i] = metricValueAggregator.getInitialAggregatedValueForSegmentDocValue(BaseStarTreeBuilder.getLong(segmentDocument.metrics[i]));
                    continue;
                }
                catch (Exception e) {
                    logger.error("Cannot parse initial segment doc value", (Throwable)e);
                    throw new IllegalStateException("Cannot parse initial segment doc value [" + segmentDocument.metrics[i] + "]");
                }
            }
            return new StarTreeDocument(dimensions, metrics);
        }
        for (int i = 0; i < this.numMetrics; ++i) {
            try {
                ValueAggregator metricValueAggregator = this.metricAggregatorInfos.get(i).getValueAggregators();
                if (isMerge) {
                    aggregatedSegmentDocument.metrics[i] = metricValueAggregator.mergeAggregatedValues(segmentDocument.metrics[i], aggregatedSegmentDocument.metrics[i]);
                    continue;
                }
                aggregatedSegmentDocument.metrics[i] = metricValueAggregator.mergeAggregatedValueAndSegmentValue(aggregatedSegmentDocument.metrics[i], BaseStarTreeBuilder.getLong(segmentDocument.metrics[i]));
                continue;
            }
            catch (Exception e) {
                logger.error("Cannot apply segment doc value for aggregation", (Throwable)e);
                throw new IllegalStateException("Cannot apply segment doc value for aggregation [" + segmentDocument.metrics[i] + "]");
            }
        }
        return aggregatedSegmentDocument;
    }

    private static Long getLong(Object metric) {
        Long metricValue = null;
        if (metric instanceof Long) {
            metricValue = (long)((Long)metric);
        }
        return metricValue;
    }

    public StarTreeDocument reduceStarTreeDocuments(StarTreeDocument aggregatedDocument, StarTreeDocument starTreeDocument) {
        if (aggregatedDocument == null) {
            Long[] dimensions = Arrays.copyOf(starTreeDocument.dimensions, this.numDimensions);
            Object[] metrics = new Object[this.numMetrics];
            for (int i = 0; i < this.numMetrics; ++i) {
                try {
                    metrics[i] = this.metricAggregatorInfos.get(i).getValueAggregators().getInitialAggregatedValue(starTreeDocument.metrics[i]);
                    continue;
                }
                catch (Exception e) {
                    logger.error("Cannot get value for aggregation", (Throwable)e);
                    throw new IllegalStateException("Cannot get value for aggregation[" + starTreeDocument.metrics[i] + "]");
                }
            }
            return new StarTreeDocument(dimensions, metrics);
        }
        for (int i = 0; i < this.numMetrics; ++i) {
            try {
                aggregatedDocument.metrics[i] = this.metricAggregatorInfos.get(i).getValueAggregators().mergeAggregatedValues(starTreeDocument.metrics[i], aggregatedDocument.metrics[i]);
                continue;
            }
            catch (Exception e) {
                logger.error("Cannot apply value to aggregated document for aggregation", (Throwable)e);
                throw new IllegalStateException("Cannot apply value to aggregated document for aggregation [" + starTreeDocument.metrics[i] + "]");
            }
        }
        return aggregatedDocument;
    }

    private SequentialDocValuesIterator getIteratorForNumericField(Map<String, DocValuesProducer> fieldProducerMap, FieldInfo fieldInfo, String name) throws IOException {
        if (fieldInfo == null) {
            fieldInfo = StarTreeUtils.getFieldInfo(name, DocValuesType.NUMERIC);
        }
        assert (fieldProducerMap.containsKey(fieldInfo.name));
        SequentialDocValuesIterator sequentialDocValuesIterator = new SequentialDocValuesIterator((DocIdSetIterator)DocValues.singleton((NumericDocValues)fieldProducerMap.get(fieldInfo.name).getNumeric(fieldInfo)));
        return sequentialDocValuesIterator;
    }

    private void appendToStarTree(StarTreeDocument starTreeDocument) throws IOException {
        this.appendStarTreeDocument(starTreeDocument);
        ++this.numStarTreeDocs;
    }

    private InMemoryTreeNode getNewNode() {
        ++this.numStarTreeNodes;
        return new InMemoryTreeNode();
    }

    private InMemoryTreeNode getNewNode(int dimensionId, int startDocId, int endDocId, byte nodeType, long dimensionValue) {
        ++this.numStarTreeNodes;
        return new InMemoryTreeNode(dimensionId, startDocId, endDocId, nodeType, dimensionValue);
    }

    private void constructStarTree(InMemoryTreeNode node, int startDocId, int endDocId) throws IOException {
        int childDimensionId = node.getDimensionId() + 1;
        if (childDimensionId == this.numDimensions) {
            return;
        }
        node.setChildDimensionId(childDimensionId);
        this.constructNonStarNodes(node, startDocId, endDocId, childDimensionId);
        if (!this.skipStarNodeCreationForDimensions.contains(childDimensionId) && node.getChildren().size() > 1) {
            node.addChildNode(this.constructStarNode(startDocId, endDocId, childDimensionId), -1L);
        }
        if (node.getChildStarNode() != null && node.getChildStarNode().getEndDocId() - node.getChildStarNode().getStartDocId() > this.maxLeafDocuments) {
            this.constructStarTree(node.getChildStarNode(), node.getChildStarNode().getStartDocId(), node.getChildStarNode().getEndDocId());
        }
        for (InMemoryTreeNode child : node.getChildren().values()) {
            if (child.getEndDocId() - child.getStartDocId() <= this.maxLeafDocuments) continue;
            this.constructStarTree(child, child.getStartDocId(), child.getEndDocId());
        }
    }

    private void constructNonStarNodes(InMemoryTreeNode node, int startDocId, int endDocId, int dimensionId) throws IOException {
        int nodeStartDocId = startDocId;
        Long nodeDimensionValue = this.getDimensionValue(startDocId, dimensionId);
        for (int i = startDocId + 1; i < endDocId; ++i) {
            Long dimensionValue = this.getDimensionValue(i, dimensionId);
            if (Objects.equals(dimensionValue, nodeDimensionValue)) continue;
            this.addChildNode(node, i, dimensionId, nodeStartDocId, nodeDimensionValue);
            nodeStartDocId = i;
            nodeDimensionValue = dimensionValue;
        }
        this.addChildNode(node, endDocId, dimensionId, nodeStartDocId, nodeDimensionValue);
    }

    private void addChildNode(InMemoryTreeNode node, int endDocId, int dimensionId, int nodeStartDocId, Long nodeDimensionValue) {
        byte childNodeType;
        long childNodeDimensionValue;
        if (nodeDimensionValue == null) {
            childNodeDimensionValue = -1L;
            childNodeType = StarTreeNodeType.NULL.getValue();
        } else {
            childNodeDimensionValue = nodeDimensionValue;
            childNodeType = StarTreeNodeType.DEFAULT.getValue();
        }
        InMemoryTreeNode lastNode = this.getNewNode(dimensionId, nodeStartDocId, endDocId, childNodeType, childNodeDimensionValue);
        node.addChildNode(lastNode, nodeDimensionValue);
    }

    private InMemoryTreeNode constructStarNode(int startDocId, int endDocId, int dimensionId) throws IOException {
        int starNodeStartDocId = this.numStarTreeDocs;
        Iterator<StarTreeDocument> starTreeDocumentIterator = this.generateStarTreeDocumentsForStarNode(startDocId, endDocId, dimensionId);
        this.appendDocumentsToStarTree(starTreeDocumentIterator);
        return this.getNewNode(dimensionId, starNodeStartDocId, this.numStarTreeDocs, StarTreeNodeType.STAR.getValue(), -1L);
    }

    private StarTreeDocument createAggregatedDocs(InMemoryTreeNode node) throws IOException {
        StarTreeDocument aggregatedStarTreeDocument = null;
        if (!node.hasChild()) {
            if (node.getStartDocId() == node.getEndDocId() - 1) {
                aggregatedStarTreeDocument = this.getStarTreeDocument(node.getStartDocId());
                node.setAggregatedDocId(node.getStartDocId());
            } else {
                int i;
                for (i = node.getStartDocId(); i < node.getEndDocId(); ++i) {
                    aggregatedStarTreeDocument = this.reduceStarTreeDocuments(aggregatedStarTreeDocument, this.getStarTreeDocument(i));
                }
                if (null == aggregatedStarTreeDocument) {
                    throw new IllegalStateException("aggregated star-tree document is null after reducing the documents");
                }
                for (i = node.getDimensionId() + 1; i < this.numDimensions; ++i) {
                    aggregatedStarTreeDocument.dimensions[i] = STAR_IN_DOC_VALUES_INDEX;
                }
                node.setAggregatedDocId(this.numStarTreeDocs);
                this.appendToStarTree(aggregatedStarTreeDocument);
            }
        } else if (node.getChildStarNode() != null) {
            aggregatedStarTreeDocument = this.createAggregatedDocs(node.getChildStarNode());
            node.setAggregatedDocId(node.getChildStarNode().getAggregatedDocId());
            for (InMemoryTreeNode child : node.getChildren().values()) {
                this.createAggregatedDocs(child);
            }
        } else if (node.getChildren().values().size() == 1) {
            for (InMemoryTreeNode child : node.getChildren().values()) {
                aggregatedStarTreeDocument = this.reduceStarTreeDocuments(aggregatedStarTreeDocument, this.createAggregatedDocs(child));
                node.setAggregatedDocId(child.getAggregatedDocId());
            }
        } else {
            for (InMemoryTreeNode child : node.getChildren().values()) {
                aggregatedStarTreeDocument = this.reduceStarTreeDocuments(aggregatedStarTreeDocument, this.createAggregatedDocs(child));
            }
            if (null == aggregatedStarTreeDocument) {
                throw new IllegalStateException("aggregated star-tree document is null after reducing the documents");
            }
            for (int i = node.getDimensionId() + 1; i < this.numDimensions; ++i) {
                aggregatedStarTreeDocument.dimensions[i] = STAR_IN_DOC_VALUES_INDEX;
            }
            node.setAggregatedDocId(this.numStarTreeDocs);
            this.appendToStarTree(aggregatedStarTreeDocument);
        }
        return aggregatedStarTreeDocument;
    }

    private long handleDateDimension(String fieldName, long val) {
        return val;
    }

    @Override
    public void close() throws IOException {
    }

    abstract Iterator<StarTreeDocument> mergeStarTrees(List<StarTreeValues> var1) throws IOException;

    public InMemoryTreeNode getRootNode() {
        return this.rootNode;
    }
}

