/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.s3.async;

import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.blobstore.stream.write.WritePriority;
import org.opensearch.repositories.s3.GenericStatsMetricPublisher;

public class TransferSemaphoresHolder {
    private static final Logger log = LogManager.getLogger(TransferSemaphoresHolder.class);
    protected TypeSemaphore lowPrioritySemaphore;
    protected TypeSemaphore normalPrioritySemaphore;
    private final int normalPriorityPermits;
    private final int lowPriorityPermits;
    private final int acquireWaitDuration;
    private final TimeUnit acquireWaitDurationUnit;

    public TransferSemaphoresHolder(int normalPriorityPermits, int lowPriorityPermits, int acquireWaitDuration, TimeUnit timeUnit, GenericStatsMetricPublisher genericStatsPublisher) {
        this.normalPriorityPermits = normalPriorityPermits;
        this.lowPriorityPermits = lowPriorityPermits;
        this.normalPrioritySemaphore = new TypeSemaphore(normalPriorityPermits, TypeSemaphore.PermitType.NORMAL, genericStatsPublisher::updateNormalPermits);
        this.lowPrioritySemaphore = new TypeSemaphore(lowPriorityPermits, TypeSemaphore.PermitType.LOW, genericStatsPublisher::updateLowPermits);
        this.acquireWaitDuration = acquireWaitDuration;
        this.acquireWaitDurationUnit = timeUnit;
    }

    public RequestContext createRequestContext() {
        return new RequestContext(this.lowPrioritySemaphore.availablePermits() == this.lowPriorityPermits);
    }

    public TypeSemaphore acquirePermit(WritePriority writePriority, RequestContext requestContext) throws InterruptedException {
        log.debug(() -> "Acquire permit request for transfer type: " + writePriority + ". Available high priority permits: " + this.normalPrioritySemaphore.availablePermits() + " and low priority permits: " + this.lowPrioritySemaphore.availablePermits());
        if (Objects.requireNonNull(writePriority) == WritePriority.LOW) {
            if (this.lowPrioritySemaphore.tryAcquire()) {
                return this.lowPrioritySemaphore;
            }
            if ((double)this.normalPrioritySemaphore.availablePermits() > 0.4 * (double)this.normalPriorityPermits && this.normalPrioritySemaphore.tryAcquire()) {
                return this.normalPrioritySemaphore;
            }
            if (this.lowPrioritySemaphore.tryAcquire(this.acquireWaitDuration, this.acquireWaitDurationUnit)) {
                return this.lowPrioritySemaphore;
            }
            return null;
        }
        if (this.normalPrioritySemaphore.tryAcquire()) {
            return this.normalPrioritySemaphore;
        }
        if (requestContext.lowPriorityPermitsConsumable && this.lowPrioritySemaphore.tryAcquire()) {
            return this.lowPrioritySemaphore;
        }
        if (this.normalPrioritySemaphore.tryAcquire(this.acquireWaitDuration, this.acquireWaitDurationUnit)) {
            return this.normalPrioritySemaphore;
        }
        return null;
    }

    public int getNormalPriorityPermits() {
        return this.normalPriorityPermits;
    }

    public int getLowPriorityPermits() {
        return this.lowPriorityPermits;
    }

    public static class TypeSemaphore
    extends Semaphore {
        private final PermitType permitType;
        private final Consumer<Boolean> permitChangeConsumer;

        public TypeSemaphore(int permits, PermitType permitType, Consumer<Boolean> permitChangeConsumer) {
            super(permits);
            this.permitType = permitType;
            this.permitChangeConsumer = permitChangeConsumer;
        }

        public PermitType getType() {
            return this.permitType;
        }

        @Override
        public boolean tryAcquire() {
            boolean acquired = super.tryAcquire();
            if (acquired) {
                this.permitChangeConsumer.accept(true);
            }
            return acquired;
        }

        @Override
        public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
            boolean acquired = super.tryAcquire(timeout, unit);
            if (acquired) {
                this.permitChangeConsumer.accept(true);
            }
            return acquired;
        }

        @Override
        public void release() {
            super.release();
            this.permitChangeConsumer.accept(false);
        }

        public static enum PermitType {
            NORMAL,
            LOW;

        }
    }

    public static class RequestContext {
        private final boolean lowPriorityPermitsConsumable;

        private RequestContext(boolean lowPriorityPermitsConsumable) {
            this.lowPriorityPermitsConsumable = lowPriorityPermitsConsumable;
        }
    }
}

