/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.Date;
import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.util.ConfigurationUtils;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.FilterHelper;

public class ResolveOptions
extends LogOptions {
    public static final String[] RESOLVEMODES = new String[]{"default", "dynamic"};
    private String[] confs = new String[]{"*"};
    private String revision = null;
    private Date date = null;
    private boolean validate = true;
    private boolean useCacheOnly = false;
    private boolean transitive = true;
    private boolean download = true;
    private boolean outputReport = true;
    private Filter artifactFilter = FilterHelper.NO_FILTER;
    private String resolveMode;
    private String resolveId;
    private boolean refresh;
    private boolean checkIfChanged = false;

    public ResolveOptions() {
    }

    public ResolveOptions(ResolveOptions resolveOptions) {
        super(resolveOptions);
        this.confs = resolveOptions.confs;
        this.revision = resolveOptions.revision;
        this.date = resolveOptions.date;
        this.validate = resolveOptions.validate;
        this.refresh = resolveOptions.refresh;
        this.useCacheOnly = resolveOptions.useCacheOnly;
        this.transitive = resolveOptions.transitive;
        this.download = resolveOptions.download;
        this.outputReport = resolveOptions.outputReport;
        this.resolveMode = resolveOptions.resolveMode;
        this.artifactFilter = resolveOptions.artifactFilter;
        this.resolveId = resolveOptions.resolveId;
        this.checkIfChanged = resolveOptions.checkIfChanged;
    }

    public Filter getArtifactFilter() {
        return this.artifactFilter;
    }

    public String getResolveMode() {
        return this.resolveMode;
    }

    public String[] getConfs(ModuleDescriptor moduleDescriptor) {
        return ConfigurationUtils.replaceWildcards(this.confs, moduleDescriptor);
    }

    public ResolveOptions setConfs(String[] stringArray) {
        this.confs = stringArray;
        return this;
    }

    public Date getDate() {
        return this.date;
    }

    public boolean isDownload() {
        return this.download;
    }

    public ResolveOptions setDownload(boolean bl) {
        this.download = bl;
        return this;
    }

    public boolean isOutputReport() {
        return this.outputReport;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public boolean isUseCacheOnly() {
        return this.useCacheOnly;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public ResolveOptions setValidate(boolean bl) {
        this.validate = bl;
        return this;
    }

    public String getResolveId() {
        return this.resolveId;
    }

    public ResolveOptions setResolveId(String string) {
        this.resolveId = string;
        return this;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public ResolveOptions setCheckIfChanged(boolean bl) {
        this.checkIfChanged = bl;
        return this;
    }

    public boolean getCheckIfChanged() {
        return this.checkIfChanged;
    }

    public static String getDefaultResolveId(ModuleDescriptor object) {
        object = object.getModuleRevisionId().getModuleId();
        return ResolveOptions.getDefaultResolveId((ModuleId)object);
    }

    public static String getDefaultResolveId(ModuleId moduleId) {
        return moduleId.getOrganisation() + "-" + moduleId.getName();
    }
}

