/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Iterator;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.descriptor.web.ResourceBase;
import org.apache.tomcat.util.security.Escape;

public class StoreAppender {
    private static Class<?>[] persistables = new Class[]{String.class, Integer.class, Integer.TYPE, Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE, InetAddress.class};
    private int pos = 0;

    public void printCloseTag(PrintWriter printWriter, StoreDescription storeDescription) throws Exception {
        printWriter.print("</");
        printWriter.print(storeDescription.getTag());
        printWriter.println(">");
    }

    public void printOpenTag(PrintWriter printWriter, int n, Object object, StoreDescription storeDescription) throws Exception {
        printWriter.print("<");
        printWriter.print(storeDescription.getTag());
        if (storeDescription.isAttributes() && object != null) {
            this.printAttributes(printWriter, n, object, storeDescription);
        }
        printWriter.println(">");
    }

    public void printTag(PrintWriter printWriter, int n, Object object, StoreDescription storeDescription) throws Exception {
        printWriter.print("<");
        printWriter.print(storeDescription.getTag());
        if (storeDescription.isAttributes() && object != null) {
            this.printAttributes(printWriter, n, object, storeDescription);
        }
        printWriter.println("/>");
    }

    public void printTagContent(PrintWriter printWriter, String string, String string2) throws Exception {
        printWriter.print("<");
        printWriter.print(string);
        printWriter.print(">");
        printWriter.print(Escape.xml((String)string2));
        printWriter.print("</");
        printWriter.print(string);
        printWriter.println(">");
    }

    public void printTagValueArray(PrintWriter printWriter, String string, int n, String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.printIndent(printWriter, n + 2);
            printWriter.print("<");
            printWriter.print(string);
            printWriter.print(">");
            for (int i = 0; i < stringArray.length; ++i) {
                this.printIndent(printWriter, n + 4);
                printWriter.print(stringArray[i]);
                if (i + 1 >= stringArray.length) continue;
                printWriter.println(",");
            }
            this.printIndent(printWriter, n + 2);
            printWriter.print("</");
            printWriter.print(string);
            printWriter.println(">");
        }
    }

    public void printTagArray(PrintWriter printWriter, String string, int n, String[] stringArray) throws Exception {
        if (stringArray != null) {
            for (String string2 : stringArray) {
                this.printIndent(printWriter, n);
                this.printTagContent(printWriter, string, string2);
            }
        }
    }

    public void printIndent(PrintWriter printWriter, int n) {
        for (int i = 0; i < n; ++i) {
            printWriter.print(' ');
        }
        this.pos = n;
    }

    public void printAttributes(PrintWriter printWriter, int n, Object object, StoreDescription storeDescription) throws Exception {
        this.printAttributes(printWriter, n, true, object, storeDescription);
    }

    public void printAttributes(PrintWriter printWriter, int n, boolean bl, Object object, StoreDescription storeDescription) throws Exception {
        PropertyDescriptor[] propertyDescriptorArray;
        if (bl && !storeDescription.isStandard()) {
            printWriter.print(" className=\"");
            printWriter.print(object.getClass().getName());
            printWriter.print("\"");
        }
        if ((propertyDescriptorArray = Introspector.getBeanInfo(object.getClass()).getPropertyDescriptors()) == null) {
            propertyDescriptorArray = new PropertyDescriptor[]{};
        }
        Object object2 = this.defaultInstance(object);
        for (PropertyDescriptor object3 : propertyDescriptorArray) {
            Object object4 = this.checkAttribute(storeDescription, object3, object3.getName(), object, object2);
            if (object4 == null) continue;
            this.printAttribute(printWriter, n, object, storeDescription, object3.getName(), object2, object4);
        }
        if (object instanceof ResourceBase) {
            PropertyDescriptor[] propertyDescriptorArray2 = (PropertyDescriptor[])object;
            Iterator iterator = propertyDescriptorArray2.listProperties();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object object5 = propertyDescriptorArray2.getProperty(string);
                if (!this.isPersistable(object5.getClass()) || storeDescription.isTransientAttribute(string)) continue;
                this.printValue(printWriter, n, string, object5);
            }
        }
    }

    protected Object checkAttribute(StoreDescription storeDescription, PropertyDescriptor propertyDescriptor, String string, Object object, Object object2) {
        if (propertyDescriptor instanceof IndexedPropertyDescriptor) {
            return null;
        }
        if (!this.isPersistable(propertyDescriptor.getPropertyType()) || propertyDescriptor.getReadMethod() == null || propertyDescriptor.getWriteMethod() == null) {
            return null;
        }
        if (storeDescription.isTransientAttribute(propertyDescriptor.getName())) {
            return null;
        }
        Object object3 = IntrospectionUtils.getProperty((Object)object, (String)propertyDescriptor.getName());
        if (object3 == null) {
            return null;
        }
        Object object4 = IntrospectionUtils.getProperty((Object)object2, (String)propertyDescriptor.getName());
        if (object3.equals(object4)) {
            return null;
        }
        return object3;
    }

    protected void printAttribute(PrintWriter printWriter, int n, Object object, StoreDescription storeDescription, String string, Object object2, Object object3) {
        if (this.isPrintValue(object, object2, string, storeDescription)) {
            this.printValue(printWriter, n, string, object3);
        }
    }

    public boolean isPrintValue(Object object, Object object2, String string, StoreDescription storeDescription) {
        return true;
    }

    public Object defaultInstance(Object object) throws ReflectiveOperationException {
        return object.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public void printValue(PrintWriter printWriter, int n, String string, Object object) {
        if (object instanceof InetAddress) {
            object = ((InetAddress)object).getHostAddress();
        }
        if (!(object instanceof String)) {
            object = object.toString();
        }
        String string2 = Escape.xml((String)((String)object));
        this.pos = this.pos + string.length() + string2.length();
        if (this.pos > 60) {
            printWriter.println();
            this.printIndent(printWriter, n + 4);
        } else {
            printWriter.print(' ');
        }
        printWriter.print(string);
        printWriter.print("=\"");
        printWriter.print(string2);
        printWriter.print("\"");
    }

    @Deprecated
    public String convertStr(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected boolean isPersistable(Class<?> clazz) {
        for (Class<?> clazz2 : persistables) {
            if (clazz2 != clazz && !clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }
}

