/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.io.File;
import vtk.vtkFileOutputWindow;

public enum vtkNativeLibrary {
    vtkWebCore("vtkWebCoreJava"),
    vtkWebGLExporter("vtkWebGLExporterJava"),
    vtkViewsInfovis("vtkViewsInfovisJava"),
    vtkViewsContext2D("vtkViewsContext2DJava"),
    vtkViewsCore("vtkViewsCoreJava"),
    vtkTestingRendering("vtkTestingRenderingJava"),
    vtkRenderingRayTracing("vtkRenderingRayTracingJava"),
    vtkRenderingVolumeAMR("vtkRenderingVolumeAMRJava"),
    vtkRenderingQt("vtkRenderingQtJava"),
    vtkPythonContext2D("vtkPythonContext2DJava"),
    vtkRenderingParallelLIC("vtkRenderingParallelLICJava"),
    vtkRenderingParallel("vtkRenderingParallelJava"),
    vtkRenderingOpenXR("vtkRenderingOpenXRJava"),
    vtkRenderingOpenVR("vtkRenderingOpenVRJava"),
    vtkRenderingVR("vtkRenderingVRJava"),
    vtkRenderingVRModels("vtkRenderingVRModelsJava"),
    vtkRenderingMatplotlib("vtkRenderingMatplotlibJava"),
    vtkRenderingLabel("vtkRenderingLabelJava"),
    vtkRenderingLOD("vtkRenderingLODJava"),
    vtkRenderingLICOpenGL2("vtkRenderingLICOpenGL2Java"),
    vtkRenderingImage("vtkRenderingImageJava"),
    vtkRenderingFFMPEGOpenGL2("vtkRenderingFFMPEGOpenGL2Java"),
    vtkRenderingExternal("vtkRenderingExternalJava"),
    vtkRenderingContextOpenGL2("vtkRenderingContextOpenGL2Java"),
    vtkRenderingCellGrid("vtkRenderingCellGridJava"),
    vtkRenderingVolumeOpenGL2("vtkRenderingVolumeOpenGL2Java"),
    vtkParallelMPI4Py("vtkParallelMPI4PyJava"),
    vtkIOXdmf2("vtkIOXdmf2Java"),
    vtkIOVeraOut("vtkIOVeraOutJava"),
    vtkIOVPIC("vtkIOVPICJava"),
    vtkIOTecplotTable("vtkIOTecplotTableJava"),
    vtkIOTRUCHAS("vtkIOTRUCHASJava"),
    vtkIOSegY("vtkIOSegYJava"),
    vtkIOPostgreSQL("vtkIOPostgreSQLJava"),
    vtkIOParallelXdmf3("vtkIOParallelXdmf3Java"),
    vtkIOXdmf3("vtkIOXdmf3Java"),
    vtkIOParallelXML("vtkIOParallelXMLJava"),
    vtkIOParallelNetCDF("vtkIOParallelNetCDFJava"),
    vtkIOParallelLSDyna("vtkIOParallelLSDynaJava"),
    vtkIOParallelExodus("vtkIOParallelExodusJava"),
    vtkIOPLY("vtkIOPLYJava"),
    vtkIOPIO("vtkIOPIOJava"),
    vtkIOPDAL("vtkIOPDALJava"),
    vtkIOOpenVDB("vtkIOOpenVDBJava"),
    vtkIOOggTheora("vtkIOOggTheoraJava"),
    vtkIOOMF("vtkIOOMFJava"),
    vtkIOODBC("vtkIOODBCJava"),
    vtkIOOCCT("vtkIOOCCTJava"),
    vtkIONetCDF("vtkIONetCDFJava"),
    vtkIOMySQL("vtkIOMySQLJava"),
    vtkIOMotionFX("vtkIOMotionFXJava"),
    vtkIOMPIParallel("vtkIOMPIParallelJava"),
    vtkIOParallel("vtkIOParallelJava"),
    vtkIOMPIImage("vtkIOMPIImageJava"),
    vtkIOMINC("vtkIOMINCJava"),
    vtkIOLSDyna("vtkIOLSDynaJava"),
    vtkIOLAS("vtkIOLASJava"),
    vtkIOImport("vtkIOImportJava"),
    vtkIOIOSS("vtkIOIOSSJava"),
    vtkIOHDF("vtkIOHDFJava"),
    vtkIOH5part("vtkIOH5partJava"),
    vtkIOH5Rage("vtkIOH5RageJava"),
    vtkIOGeoJSON("vtkIOGeoJSONJava"),
    vtkIOFLUENTCFF("vtkIOFLUENTCFFJava"),
    vtkIOFFMPEG("vtkIOFFMPEGJava"),
    vtkIOVideo("vtkIOVideoJava"),
    vtkIOMovie("vtkIOMovieJava"),
    vtkIOFDS("vtkIOFDSJava"),
    vtkIOInfovis("vtkIOInfovisJava"),
    vtkIOExportPDF("vtkIOExportPDFJava"),
    vtkIOExportGL2PS("vtkIOExportGL2PSJava"),
    vtkRenderingGL2PSOpenGL2("vtkRenderingGL2PSOpenGL2Java"),
    vtkIOExodus("vtkIOExodusJava"),
    vtkIOEngys("vtkIOEngysJava"),
    vtkIOEnSight("vtkIOEnSightJava"),
    vtkIOERF("vtkIOERFJava"),
    vtkIOCityGML("vtkIOCityGMLJava"),
    vtkIOChemistry("vtkIOChemistryJava"),
    vtkIOCesium3DTiles("vtkIOCesium3DTilesJava"),
    vtkIOCONVERGECFD("vtkIOCONVERGECFDJava"),
    vtkIOCGNSReader("vtkIOCGNSReaderJava"),
    vtkIOAsynchronous("vtkIOAsynchronousJava"),
    vtkIOAlembic("vtkIOAlembicJava"),
    vtkIOExport("vtkIOExportJava"),
    vtkIOGeometry("vtkIOGeometryJava"),
    vtkRenderingVtkJS("vtkRenderingVtkJSJava"),
    vtkRenderingSceneGraph("vtkRenderingSceneGraphJava"),
    vtkIOAMR("vtkIOAMRJava"),
    vtkInteractionImage("vtkInteractionImageJava"),
    vtkInfovisLayout("vtkInfovisLayoutJava"),
    vtkInfovisBoostGraphAlgorithms("vtkInfovisBoostGraphAlgorithmsJava"),
    vtkImagingStencil("vtkImagingStencilJava"),
    vtkImagingStatistics("vtkImagingStatisticsJava"),
    vtkImagingOpenGL2("vtkImagingOpenGL2Java"),
    vtkImagingMorphological("vtkImagingMorphologicalJava"),
    vtkImagingMath("vtkImagingMathJava"),
    vtkImagingFourier("vtkImagingFourierJava"),
    vtkIOSQL("vtkIOSQLJava"),
    vtkInteractionWidgets("vtkInteractionWidgetsJava"),
    vtkRenderingVolume("vtkRenderingVolumeJava"),
    vtkRenderingAnnotation("vtkRenderingAnnotationJava"),
    vtkInteractionStyle("vtkInteractionStyleJava"),
    vtkImagingHybrid("vtkImagingHybridJava"),
    vtkImagingColor("vtkImagingColorJava"),
    vtkGeovisGDAL("vtkGeovisGDALJava"),
    vtkIOGDAL("vtkIOGDALJava"),
    vtkGeovisCore("vtkGeovisCoreJava"),
    vtkFiltersTopology("vtkFiltersTopologyJava"),
    vtkFiltersTensor("vtkFiltersTensorJava"),
    vtkFiltersSelection("vtkFiltersSelectionJava"),
    vtkFiltersSMP("vtkFiltersSMPJava"),
    vtkFiltersReebGraph("vtkFiltersReebGraphJava"),
    vtkFiltersPython("vtkFiltersPythonJava"),
    vtkFiltersProgrammable("vtkFiltersProgrammableJava"),
    vtkFiltersPoints("vtkFiltersPointsJava"),
    vtkFiltersParallelVerdict("vtkFiltersParallelVerdictJava"),
    vtkFiltersParallelStatistics("vtkFiltersParallelStatisticsJava"),
    vtkFiltersParallelImaging("vtkFiltersParallelImagingJava"),
    vtkFiltersParallelGeometry("vtkFiltersParallelGeometryJava"),
    vtkFiltersParallelFlowPaths("vtkFiltersParallelFlowPathsJava"),
    vtkFiltersParallelDIY2("vtkFiltersParallelDIY2Java"),
    vtkFiltersTemporal("vtkFiltersTemporalJava"),
    vtkFiltersImaging("vtkFiltersImagingJava"),
    vtkImagingGeneral("vtkImagingGeneralJava"),
    vtkFiltersGeometryPreview("vtkFiltersGeometryPreviewJava"),
    vtkFiltersGeneric("vtkFiltersGenericJava"),
    vtkFiltersFlowPaths("vtkFiltersFlowPathsJava"),
    vtkFiltersAMR("vtkFiltersAMRJava"),
    vtkDomainsParallelChemistry("vtkDomainsParallelChemistryJava"),
    vtkFiltersParallelMPI("vtkFiltersParallelMPIJava"),
    vtkFiltersParallel("vtkFiltersParallelJava"),
    vtkFiltersTexture("vtkFiltersTextureJava"),
    vtkFiltersModeling("vtkFiltersModelingJava"),
    vtkParallelMPI("vtkParallelMPIJava"),
    vtkDomainsChemistryOpenGL2("vtkDomainsChemistryOpenGL2Java"),
    vtkRenderingOpenGL2("vtkRenderingOpenGL2Java"),
    vtkRenderingUI("vtkRenderingUIJava"),
    vtkRenderingHyperTreeGrid("vtkRenderingHyperTreeGridJava"),
    vtkFiltersHybrid("vtkFiltersHybridJava"),
    vtkDomainsChemistry("vtkDomainsChemistryJava"),
    vtkCommonPython("vtkCommonPythonJava"),
    vtkCommonArchive("vtkCommonArchiveJava"),
    vtkChartsCore("vtkChartsCoreJava"),
    vtkInfovisCore("vtkInfovisCoreJava"),
    vtkFiltersExtraction("vtkFiltersExtractionJava"),
    vtkIOXML("vtkIOXMLJava"),
    vtkIOXMLParser("vtkIOXMLParserJava"),
    vtkParallelCore("vtkParallelCoreJava"),
    vtkIOLegacy("vtkIOLegacyJava"),
    vtkIOCellGrid("vtkIOCellGridJava"),
    vtkFiltersCellGrid("vtkFiltersCellGridJava"),
    vtkIOCore("vtkIOCoreJava"),
    vtkFiltersStatistics("vtkFiltersStatisticsJava"),
    vtkFiltersHyperTree("vtkFiltersHyperTreeJava"),
    vtkImagingSources("vtkImagingSourcesJava"),
    vtkIOImage("vtkIOImageJava"),
    vtkRenderingContext2D("vtkRenderingContext2DJava"),
    vtkRenderingFreeType("vtkRenderingFreeTypeJava"),
    vtkRenderingCore("vtkRenderingCoreJava"),
    vtkFiltersSources("vtkFiltersSourcesJava"),
    vtkCommonColor("vtkCommonColorJava"),
    vtkAcceleratorsVTKmFilters("vtkAcceleratorsVTKmFiltersJava"),
    vtkImagingCore("vtkImagingCoreJava"),
    vtkFiltersGeneral("vtkFiltersGeneralJava"),
    vtkFiltersVerdict("vtkFiltersVerdictJava"),
    vtkFiltersGeometry("vtkFiltersGeometryJava"),
    vtkCommonComputationalGeometry("vtkCommonComputationalGeometryJava"),
    vtkFiltersCore("vtkFiltersCoreJava"),
    vtkFiltersReduction("vtkFiltersReductionJava"),
    vtkCommonExecutionModel("vtkCommonExecutionModelJava"),
    vtkAcceleratorsVTKmDataModel("vtkAcceleratorsVTKmDataModelJava"),
    vtkCommonDataModel("vtkCommonDataModelJava"),
    vtkCommonSystem("vtkCommonSystemJava"),
    vtkCommonMisc("vtkCommonMiscJava"),
    vtkCommonTransforms("vtkCommonTransformsJava"),
    vtkCommonMath("vtkCommonMathJava"),
    vtkAcceleratorsVTKmCore("vtkAcceleratorsVTKmCoreJava"),
    vtkCommonCore("vtkCommonCoreJava");

    private String nativeLibraryName;
    private boolean loaded;

    public static boolean LoadAllNativeLibraries() {
        boolean bl = true;
        for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibrary.values()) {
            try {
                vtkNativeLibrary2.LoadLibrary();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bl = false;
                unsatisfiedLinkError.printStackTrace();
            }
        }
        return bl;
    }

    public static void LoadNativeLibraries(vtkNativeLibrary ... vtkNativeLibraryArray) {
        for (vtkNativeLibrary vtkNativeLibrary2 : vtkNativeLibraryArray) {
            vtkNativeLibrary2.LoadLibrary();
        }
    }

    public static void DisableOutputWindow(File file) {
        if (file == null) {
            file = new File("vtkError.txt");
        }
        vtkFileOutputWindow vtkFileOutputWindow2 = new vtkFileOutputWindow();
        vtkFileOutputWindow2.SetFileName(file.getAbsolutePath());
        vtkFileOutputWindow2.SetInstance(vtkFileOutputWindow2);
    }

    private vtkNativeLibrary(String string2) {
        this.nativeLibraryName = string2;
        this.loaded = false;
    }

    public void LoadLibrary() throws UnsatisfiedLinkError {
        if (!this.loaded) {
            if (System.getProperty("vtk.lib.dir") != null) {
                File file = new File(System.getProperty("vtk.lib.dir"));
                vtkNativeLibrary.patchJavaLibraryPath(file.getAbsolutePath());
                File file2 = new File(file, System.mapLibraryName(this.nativeLibraryName));
                if (file2.exists()) {
                    try {
                        Runtime.getRuntime().load(file2.getAbsolutePath());
                        this.loaded = true;
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        unsatisfiedLinkError.printStackTrace();
                    }
                }
            }
            System.loadLibrary(this.nativeLibraryName);
        }
        this.loaded = true;
    }

    public boolean IsLoaded() {
        return this.loaded;
    }

    public String GetLibraryName() {
        return this.nativeLibraryName;
    }

    private static void patchJavaLibraryPath(String string) {
        if (string != null) {
            String string2 = System.getProperty("path.separator");
            String string3 = System.getProperty("java.library.path");
            if (!string3.contains(string)) {
                string3 = string3 + string2 + string;
                System.setProperty("java.library.path", string3);
            }
        }
    }
}

