# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_hq_global_optspecs
	string join \n server-dir= colors= output-mode= debug h/help V/version
end

function __fish_hq_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_hq_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_hq_using_subcommand
	set -l cmd (__fish_hq_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c hq -n "__fish_hq_needs_command" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_needs_command" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_needs_command" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_needs_command" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_needs_command" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_needs_command" -s V -l version -d 'Print version'
complete -c hq -n "__fish_hq_needs_command" -f -a "server" -d 'Commands for controlling the HyperQueue server'
complete -c hq -n "__fish_hq_needs_command" -f -a "job" -d 'Commands for controlling HyperQueue jobs'
complete -c hq -n "__fish_hq_needs_command" -f -a "task" -d 'Commands for displaying task(s)'
complete -c hq -n "__fish_hq_needs_command" -f -a "submit" -d 'Submit a job to HyperQueue'
complete -c hq -n "__fish_hq_needs_command" -f -a "worker" -d 'Commands for controlling HyperQueue workers'
complete -c hq -n "__fish_hq_needs_command" -f -a "output-log" -d 'Operations with log'
complete -c hq -n "__fish_hq_needs_command" -f -a "alloc" -d 'Automatic allocation management'
complete -c hq -n "__fish_hq_needs_command" -f -a "journal" -d 'Event and journal management'
complete -c hq -n "__fish_hq_needs_command" -f -a "dashboard" -d 'Start the HyperQueue CLI dashboard'
complete -c hq -n "__fish_hq_needs_command" -f -a "doc" -d 'Display a link to or open HyperQueue documentation'
complete -c hq -n "__fish_hq_needs_command" -f -a "generate-completion" -d 'Generate shell completion script'
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -f -a "start" -d 'Start the HyperQueue server'
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -f -a "stop" -d 'Stop the HyperQueue server, if it is running'
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -f -a "info" -d 'Show info of running HyperQueue server'
complete -c hq -n "__fish_hq_using_subcommand server; and not __fish_seen_subcommand_from start stop info generate-access" -f -a "generate-access" -d 'Generate access file without starting server'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l host -d 'Hostname/IP of the machine under which is visible to others, default: hostname' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l idle-timeout -d 'Duration after which will an idle worker automatically stop.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l client-port -d 'Port for client connections (used e.g. for `hq submit`)' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l worker-port -d 'Port for worker connections' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l journal -d 'Path to a journal file where events is stored. If the file already exists, the file is used to restore the server state' -r -F
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l journal-flush-period -d 'Configure how often should be the journal written.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l access-file -d 'Path to access file that is used for configuration of secret keys and ports' -r -F
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l disable-client-authentication-and-encryption -d 'If set, client connection will NOT be AUTHENTICATED and ENCRYPTED. ANYONE CAN CONNECT TO THE SERVER AS CLIENT! USE AT YOUR OWN RISK'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l disable-worker-authentication-and-encryption -d 'If set, worker connection will NOT be AUTHENTICATED and ENCRYPTED. ANYONE CAN CONNECT TO THE SERVER AS WORKER! USE AT YOUR OWN RISK'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from start" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from stop" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from stop" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from stop" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from stop" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from stop" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from info" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from info" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from info" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from info" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l client-file -d 'Target filename of the access file for client that will be generated' -r -F
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l worker-file -d 'Target filename of the access file for worker that will be generated' -r -F
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l host -d 'Override target host name, otherwise local hostname is used' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l client-host -d 'Override target host name for clients' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l worker-host -d 'Override target host name for workers' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l client-port -d 'Port for connecting client' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l worker-port -d 'Port for connecting workers' -r
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand server; and __fish_seen_subcommand_from generate-access" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "list" -d 'Display information about jobs. By default, only queued or running jobs will be displayed'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "summary" -d 'Display a summary with the amount of jobs per each job state'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "info" -d 'Display detailed information of the selected job'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "cancel" -d 'Cancel a specific job. This will cancel all tasks, stopping them from being computation'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "forget" -d 'Forget a specific job. This will remove the job from the server\'s memory, forgetting it completely and reducing the server\'s memory usage'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "cat" -d 'Shows task(s) streams(stdout, stderr) of a specific job'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "submit" -d 'Submit a job to HyperQueue'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "submit-file" -d 'Submit a job through a job definition file'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "wait" -d 'Waits until a job is finished'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "progress" -d 'Interactively observe the execution of a job'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "task-ids" -d 'Print task Ids for given job'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "open" -d 'Open new job (without attaching any tasks yet)'
complete -c hq -n "__fish_hq_using_subcommand job; and not __fish_seen_subcommand_from list summary info cancel forget cat submit submit-file wait progress task-ids open close" -f -a "close" -d 'Close an open job'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from list" -l filter -d 'Display only jobs with the given states. You can use multiple states separated by a comma' -r -f -a "waiting\t''
running\t''
finished\t''
failed\t''
canceled\t''
opened\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from list" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from list" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from list" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from list" -l all -d 'Display all jobs'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from list" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from summary" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from summary" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from summary" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from summary" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from summary" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from info" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from info" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from info" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from info" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cancel" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cancel" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cancel" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cancel" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cancel" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from forget" -l filter -d 'Forget only jobs with the given states. You can use multiple states separated by a comma. You can only filter by states that mark a completed job' -r -f -a "finished\t''
failed\t''
canceled\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from forget" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from forget" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from forget" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from forget" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from forget" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -l tasks -d 'Filter task(s) by ID' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -l task-status -d 'Filter task(s) by status. You can use multiple states separated by a comma' -r -f -a "waiting\t''
running\t''
finished\t''
failed\t''
canceled\t''
opened\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -l print-task-header -d 'Prepend the output of each task with a header line that identifies the task which produced that output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from cat" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l name -d 'Name of the job' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l max-fails -d 'Maximum number of permitted task failures. If this limit is reached, the job will fail immediately' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l nodes -d 'Number of nodes; 0' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l cpus -d 'Number and placement of CPUs for each job' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l resource -d 'Generic resource request in the form <NAME>=<AMOUNT>' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l time-request -d 'Minimal lifetime of the worker needed to start the job  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l pin -d 'Pin the job to the cores specified in `--cpus`' -r -f -a "taskset\t''
omp\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l cwd -d 'Working directory for the submitted job. The path must be accessible from worker nodes [default: %{SUBMIT_DIR}]' -r -F
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l stdout -d 'Path where the standard output of the job will be stored. The path must be accessible from worker nodes' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l stderr -d 'Path where the standard error of the job will be stored. The path must be accessible from worker nodes' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l env -d 'Specify additional environment variable for the job. You can pass this flag multiple times to pass multiple variables' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l each-line -d 'Create a task array where a task will be created for each line of the given file. The corresponding line will be passed to the task in environment variable `HQ_ENTRY`' -r -F
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l from-json -d 'Create a task array where a task will be created for each item of a JSON array stored in the given file. The corresponding item from the array will be passed as a JSON string to the task in environment variable `HQ_ENTRY`' -r -F
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l array -d 'Create a task array where a task will be created for each number in the specified number range. Each task will be passed an environment variable `HQ_TASK_ID`' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l priority -d 'Priority of each task' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l time-limit -d 'Time limit per task. E.g. --time-limit=10min  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l stream -d 'Stream the output of tasks into this log file' -r -F
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l crash-limit -d 'Limits how many times may task be in a running state while worker is lost. If the limit is reached, the task is marked as failed. If the limit is zero, the limit is disabled' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l job -d 'Attach a submission to an open job' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l directives -d 'Select directives parsing mode' -r -f -a "auto\t''
file\t''
stdin\t''
off\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l task-dir -d 'Create a temporary directory for task, path is provided in HQ_TASK_DIR The directory is automatically deleted when task is finished'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l wait -d 'Wait for the job to finish'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l progress -d 'Interactively observe the progress of the submitted job'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l stdin -d 'Capture stdin and start the task with the given stdin; the job will be submitted when the stdin is closed'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit-file" -l job -d 'Attach a submission to an open job' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit-file" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit-file" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit-file" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit-file" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from submit-file" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from wait" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from wait" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from wait" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from wait" -l without-close -d 'Wait until all tasks are completed, even if the job is still open'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from wait" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from wait" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from progress" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from progress" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from progress" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from progress" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from progress" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from task-ids" -l filter -d 'Select only tasks with given state(s) You can use multiple states separated by a comma' -r -f -a "waiting\t''
running\t''
finished\t''
failed\t''
canceled\t''
opened\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from task-ids" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from task-ids" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from task-ids" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from task-ids" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from task-ids" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from open" -l name -d 'Name of the job' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from open" -l max-fails -d 'Maximum number of permitted task failures. If this limit is reached, the job will fail immediately' -r
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from open" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from open" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from open" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from open" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from open" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from close" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from close" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from close" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from close" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand job; and __fish_seen_subcommand_from close" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand task; and not __fish_seen_subcommand_from list info" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand task; and not __fish_seen_subcommand_from list info" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand task; and not __fish_seen_subcommand_from list info" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand task; and not __fish_seen_subcommand_from list info" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand task; and not __fish_seen_subcommand_from list info" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand task; and not __fish_seen_subcommand_from list info" -f -a "list" -d 'Displays task(s) associated with selected job(s)'
complete -c hq -n "__fish_hq_using_subcommand task; and not __fish_seen_subcommand_from list info" -f -a "info" -d 'Displays detailed task info'
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -l tasks -d 'Filter task(s) by ID' -r
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -l task-status -d 'Filter task(s) by status. You can use multiple states separated by a comma' -r -f -a "waiting\t''
running\t''
finished\t''
failed\t''
canceled\t''
opened\t''"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -s v -d 'Use this flag to enable verbose output'
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from info" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from info" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from info" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from info" -s v -d 'Use this flag to enable verbose output'
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from info" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand task; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand submit" -l name -d 'Name of the job' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l max-fails -d 'Maximum number of permitted task failures. If this limit is reached, the job will fail immediately' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l nodes -d 'Number of nodes; 0' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l cpus -d 'Number and placement of CPUs for each job' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l resource -d 'Generic resource request in the form <NAME>=<AMOUNT>' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l time-request -d 'Minimal lifetime of the worker needed to start the job  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l pin -d 'Pin the job to the cores specified in `--cpus`' -r -f -a "taskset\t''
omp\t''"
complete -c hq -n "__fish_hq_using_subcommand submit" -l cwd -d 'Working directory for the submitted job. The path must be accessible from worker nodes [default: %{SUBMIT_DIR}]' -r -F
complete -c hq -n "__fish_hq_using_subcommand submit" -l stdout -d 'Path where the standard output of the job will be stored. The path must be accessible from worker nodes' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l stderr -d 'Path where the standard error of the job will be stored. The path must be accessible from worker nodes' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l env -d 'Specify additional environment variable for the job. You can pass this flag multiple times to pass multiple variables' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l each-line -d 'Create a task array where a task will be created for each line of the given file. The corresponding line will be passed to the task in environment variable `HQ_ENTRY`' -r -F
complete -c hq -n "__fish_hq_using_subcommand submit" -l from-json -d 'Create a task array where a task will be created for each item of a JSON array stored in the given file. The corresponding item from the array will be passed as a JSON string to the task in environment variable `HQ_ENTRY`' -r -F
complete -c hq -n "__fish_hq_using_subcommand submit" -l array -d 'Create a task array where a task will be created for each number in the specified number range. Each task will be passed an environment variable `HQ_TASK_ID`' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l priority -d 'Priority of each task' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l time-limit -d 'Time limit per task. E.g. --time-limit=10min  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l stream -d 'Stream the output of tasks into this log file' -r -F
complete -c hq -n "__fish_hq_using_subcommand submit" -l crash-limit -d 'Limits how many times may task be in a running state while worker is lost. If the limit is reached, the task is marked as failed. If the limit is zero, the limit is disabled' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l job -d 'Attach a submission to an open job' -r
complete -c hq -n "__fish_hq_using_subcommand submit" -l directives -d 'Select directives parsing mode' -r -f -a "auto\t''
file\t''
stdin\t''
off\t''"
complete -c hq -n "__fish_hq_using_subcommand submit" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand submit" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand submit" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand submit" -l task-dir -d 'Create a temporary directory for task, path is provided in HQ_TASK_DIR The directory is automatically deleted when task is finished'
complete -c hq -n "__fish_hq_using_subcommand submit" -l wait -d 'Wait for the job to finish'
complete -c hq -n "__fish_hq_using_subcommand submit" -l progress -d 'Interactively observe the progress of the submitted job'
complete -c hq -n "__fish_hq_using_subcommand submit" -l stdin -d 'Capture stdin and start the task with the given stdin; the job will be submitted when the stdin is closed'
complete -c hq -n "__fish_hq_using_subcommand submit" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand submit" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "start" -d 'Start worker'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "stop" -d 'Stop worker'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "list" -d 'Display information about workers. By default, only running workers will be displayed'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "hwdetect" -d 'Hwdetect'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "info" -d 'Display information about a specific worker'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "address" -d 'Display worker\'s hostname'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "wait" -d 'Waits on the connection of worker(s)'
complete -c hq -n "__fish_hq_using_subcommand worker; and not __fish_seen_subcommand_from start stop list hwdetect info address wait deploy-ssh" -f -a "deploy-ssh" -d 'Deploy a set of workers using SSH'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l cpus -d 'How many cores should be allocated for the worker' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l resource -d 'Resources provided by the worker' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l group -d 'Manual configuration of worker\'s group Workers from the same group are used for multi-node tasks' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l idle-timeout -d 'Duration after which will an idle worker automatically stop.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l overview-interval -d 'How often should the worker send its overview status (e.g. HW usage, task status) to the server for monitoring. Set to "0s" to disable overview updates' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l heartbeat -d 'How often should the worker announce its existence to the server.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l time-limit -d 'Worker time limit. Worker exits after given time.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l manager -d 'What HPC job manager should be used by the worker' -r -f -a "detect\t''
none\t''
pbs\t''
slurm\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l hostname -d 'Overwrite worker hostname' -r
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l on-server-lost -d 'Behavior when a connection to a server is lost' -r -f -a "stop\t''
finish-running\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l work-dir -d 'Working directory of a worker. Temp directory by default. It should *NOT* be placed on a network filesystem' -r -F
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l no-detect-resources -d 'Disable auto-detection of resources'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l no-hyper-threading -d 'Ignore hyper-threading while detecting CPU cores'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from start" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from stop" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from stop" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from stop" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from stop" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from stop" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from list" -l filter -d 'Select only workers with the given state' -r -f -a "running\t''
offline\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from list" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from list" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from list" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from list" -l all -d 'Display all workers'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from list" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from hwdetect" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from hwdetect" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from hwdetect" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from hwdetect" -l no-hyper-threading -d 'Detect only physical cores'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from hwdetect" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from hwdetect" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from info" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from info" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from info" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from info" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from address" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from address" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from address" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from address" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from address" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from wait" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from wait" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from wait" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from wait" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from wait" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from deploy-ssh" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from deploy-ssh" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from deploy-ssh" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from deploy-ssh" -l show-output -d 'Show log output of the spawned worker(s)'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from deploy-ssh" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand worker; and __fish_seen_subcommand_from deploy-ssh" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -l server-uid -d 'Filter files for given server instance' -r
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -a "summary" -d 'Prints summary of log file'
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -a "jobs" -d 'Prints jobs ids in stream'
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -a "show" -d 'Prints content of stream ordered by time'
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -a "cat" -d 'Prints a raw content of one channel'
complete -c hq -n "__fish_hq_using_subcommand output-log; and not __fish_seen_subcommand_from summary jobs show cat export" -a "export" -d 'Export stream into JSON'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from summary" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from summary" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from summary" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from summary" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from summary" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from jobs" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from jobs" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from jobs" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from jobs" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from jobs" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from show" -l job -d 'JobId' -r
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from show" -l channel -d 'Filter only specific channel' -r -f -a "stdout\t''
stderr\t''"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from show" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from show" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from show" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from show" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from show" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from cat" -l task -d 'Print only the specified task(s) output. You can use the array syntax to specify multiple tasks' -r
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from cat" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from cat" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from cat" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from cat" -l allow-unfinished -d 'Allow unfinished channel'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from cat" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from cat" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from export" -l task -d 'Export only the specified task(s) output. You can use the array syntax to specify multiple tasks' -r
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from export" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from export" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from export" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from export" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand output-log; and __fish_seen_subcommand_from export" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -f -a "list" -d 'Displays allocation queues'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -f -a "info" -d 'Display allocations of the specified allocation queue'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -f -a "add" -d 'Add new allocation queue'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -f -a "pause" -d 'Pause an existing allocation queue. Paused queues do not submit new allocations'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -f -a "resume" -d 'Resume a previously paused allocation queue'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -f -a "dry-run" -d 'Try to submit an allocation to test allocation parameters'
complete -c hq -n "__fish_hq_using_subcommand alloc; and not __fish_seen_subcommand_from list info add pause resume dry-run remove" -f -a "remove" -d 'Removes an allocation queue with the given ID'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from list" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from list" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from list" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from list" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from info" -l filter -d 'Display only allocations with the given state' -r -f -a "queued\t''
running\t''
finished\t''
failed\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from info" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from info" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from info" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from info" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from info" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from add" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from add" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from add" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from add" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from add" -f -a "pbs" -d 'Create a PBS allocation queue'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from add" -f -a "slurm" -d 'Create a SLURM allocation queue'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from pause" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from pause" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from pause" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from pause" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from pause" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from resume" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from resume" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from resume" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from resume" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from resume" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from dry-run" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from dry-run" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from dry-run" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from dry-run" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from dry-run" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from dry-run" -f -a "pbs" -d 'Try to create a PBS allocation'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from dry-run" -f -a "slurm" -d 'Try to create a SLURM allocation'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from remove" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from remove" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from remove" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from remove" -l force -d 'Remove the queue even if there are currently running jobs. The running jobs will be canceled'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from remove" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand alloc; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -f -a "export" -d 'Export events from a journal to NDJSON (line-delimited JSON). Events will be exported to `stdout`, you can redirect it e.g. to a file'
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -f -a "stream" -d 'Stream events from a running server, it first replays old events then it waits for new live events'
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -f -a "replay" -d 'Stream events from a running server, it replays old events after that it terminates the connection'
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -f -a "prune" -d 'Connect to a server and remove completed tasks and non-active workers from journal'
complete -c hq -n "__fish_hq_using_subcommand journal; and not __fish_seen_subcommand_from export stream replay prune flush" -f -a "flush" -d 'Connect to a server and forces to flush a journal'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from export" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from export" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from export" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from export" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from export" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from stream" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from stream" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from stream" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from stream" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from stream" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from replay" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from replay" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from replay" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from replay" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from replay" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from prune" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from prune" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from prune" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from prune" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from prune" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from flush" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from flush" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from flush" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from flush" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand journal; and __fish_seen_subcommand_from flush" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and not __fish_seen_subcommand_from stream replay" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and not __fish_seen_subcommand_from stream replay" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and not __fish_seen_subcommand_from stream replay" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and not __fish_seen_subcommand_from stream replay" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and not __fish_seen_subcommand_from stream replay" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and not __fish_seen_subcommand_from stream replay" -f -a "stream" -d 'Stream events from a server. Note that this will replay all events from the currently active journal file before new events will be streamed'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and not __fish_seen_subcommand_from stream replay" -f -a "replay" -d 'Replay events from a recorded journal file'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from stream" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from stream" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from stream" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from stream" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from stream" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from replay" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from replay" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from replay" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from replay" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand dashboard; and __fish_seen_subcommand_from replay" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "job" -d 'Submitting and examining tasks and jobs'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "jobs" -d 'Submitting and examining tasks and jobs'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "tasks" -d 'Submitting and examining tasks and jobs'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "taskarray" -d 'Jobs containing large amounts of similar tasks'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "resources" -d 'CPU and generic resources of tasks'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "worker" -d 'Deployment of workers'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "workers" -d 'Deployment of workers'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "autoalloc" -d 'Automatic allocator subsystem'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "pbs" -d 'Automatic allocator subsystem'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "slurm" -d 'Automatic allocator subsystem'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "python-api" -d 'Python API'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "python" -d 'Python API'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "cheatsheet" -d 'Cheatsheet with the most common HyperQueue commands'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "changelog" -d 'Changelog'
complete -c hq -n "__fish_hq_using_subcommand doc; and not __fish_seen_subcommand_from job jobs tasks taskarray resources worker workers autoalloc pbs slurm python-api python cheatsheet changelog faq" -f -a "faq" -d 'Frequently asked questions about HyperQueue'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from job" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from job" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from job" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from job" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from job" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from job" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from jobs" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from jobs" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from jobs" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from jobs" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from jobs" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from jobs" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from tasks" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from tasks" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from tasks" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from tasks" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from tasks" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from tasks" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from taskarray" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from taskarray" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from taskarray" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from taskarray" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from taskarray" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from taskarray" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from resources" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from resources" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from resources" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from resources" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from resources" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from resources" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from worker" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from worker" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from worker" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from worker" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from worker" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from worker" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from workers" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from workers" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from workers" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from workers" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from workers" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from workers" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from autoalloc" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from autoalloc" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from autoalloc" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from autoalloc" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from autoalloc" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from autoalloc" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from pbs" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from pbs" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from pbs" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from pbs" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from pbs" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from pbs" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from slurm" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from slurm" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from slurm" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from slurm" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from slurm" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from slurm" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python-api" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python-api" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python-api" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python-api" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python-api" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python-api" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from python" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from cheatsheet" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from cheatsheet" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from cheatsheet" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from cheatsheet" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from cheatsheet" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from cheatsheet" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from changelog" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from changelog" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from changelog" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from changelog" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from changelog" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from changelog" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from faq" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from faq" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from faq" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from faq" -l open -d 'Open the documentation in the default browser'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from faq" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand doc; and __fish_seen_subcommand_from faq" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c hq -n "__fish_hq_using_subcommand generate-completion" -l server-dir -d 'Path to a directory that stores HyperQueue access files' -r -f -a "(__fish_complete_directories)"
complete -c hq -n "__fish_hq_using_subcommand generate-completion" -l colors -d 'Console color policy' -r -f -a "auto\t'Use colors if the stdout is detected to be a terminal'
always\t'Always use colors'
never\t'Never use colors'"
complete -c hq -n "__fish_hq_using_subcommand generate-completion" -l output-mode -d 'How should the output of the command be formatted' -r -f -a "cli\t''
json\t''
quiet\t''"
complete -c hq -n "__fish_hq_using_subcommand generate-completion" -l debug -d 'Turn on a more detailed log output'
complete -c hq -n "__fish_hq_using_subcommand generate-completion" -s h -l help -d 'Print help (see more with \'--help\')'
