/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDesktopPaneUI;

public class MotifDesktopPaneUI
extends BasicDesktopPaneUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifDesktopPaneUI();
    }

    @Override
    protected void installDesktopManager() {
        this.desktopManager = this.desktop.getDesktopManager();
        if (this.desktopManager == null) {
            this.desktopManager = new MotifDesktopManager();
            this.desktop.setDesktopManager(this.desktopManager);
            ((MotifDesktopManager)this.desktopManager).adjustIcons(this.desktop);
        }
    }

    public Insets getInsets(JComponent jComponent) {
        return new Insets(0, 0, 0, 0);
    }

    private class MotifDesktopManager
    extends DefaultDesktopManager
    implements Serializable,
    UIResource {
        JComponent dragPane;
        boolean usingDragPane = false;
        private transient JLayeredPane layeredPaneForDragPane;
        int iconWidth;
        int iconHeight;

        private MotifDesktopManager() {
        }

        @Override
        public void setBoundsForFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
            if (!this.usingDragPane) {
                boolean bl = jComponent.getWidth() != n3 || jComponent.getHeight() != n4;
                Rectangle rectangle = jComponent.getBounds();
                jComponent.setBounds(n, n2, n3, n4);
                SwingUtilities.computeUnion(n, n2, n3, n4, rectangle);
                jComponent.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (bl) {
                    jComponent.validate();
                }
            } else {
                Rectangle rectangle = this.dragPane.getBounds();
                this.dragPane.setBounds(n, n2, n3, n4);
                SwingUtilities.computeUnion(n, n2, n3, n4, rectangle);
                this.dragPane.getParent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        @Override
        public void beginDraggingFrame(JComponent jComponent) {
            this.usingDragPane = false;
            if (jComponent.getParent() instanceof JLayeredPane) {
                if (this.dragPane == null) {
                    this.dragPane = new DragPane();
                }
                this.layeredPaneForDragPane = (JLayeredPane)jComponent.getParent();
                this.layeredPaneForDragPane.setLayer(this.dragPane, Integer.MAX_VALUE);
                this.dragPane.setBounds(jComponent.getX(), jComponent.getY(), jComponent.getWidth(), jComponent.getHeight());
                this.layeredPaneForDragPane.add(this.dragPane);
                this.usingDragPane = true;
            }
        }

        @Override
        public void dragFrame(JComponent jComponent, int n, int n2) {
            this.setBoundsForFrame(jComponent, n, n2, jComponent.getWidth(), jComponent.getHeight());
        }

        @Override
        public void endDraggingFrame(JComponent jComponent) {
            if (this.usingDragPane) {
                this.layeredPaneForDragPane.remove(this.dragPane);
                this.usingDragPane = false;
                if (jComponent instanceof JInternalFrame) {
                    this.setBoundsForFrame(jComponent, this.dragPane.getX(), this.dragPane.getY(), this.dragPane.getWidth(), this.dragPane.getHeight());
                } else if (jComponent instanceof JInternalFrame.JDesktopIcon) {
                    this.adjustBoundsForIcon((JInternalFrame.JDesktopIcon)jComponent, this.dragPane.getX(), this.dragPane.getY());
                }
            }
        }

        @Override
        public void beginResizingFrame(JComponent jComponent, int n) {
            this.usingDragPane = false;
            if (jComponent.getParent() instanceof JLayeredPane) {
                if (this.dragPane == null) {
                    this.dragPane = new DragPane();
                }
                JLayeredPane jLayeredPane = (JLayeredPane)jComponent.getParent();
                jLayeredPane.setLayer(this.dragPane, Integer.MAX_VALUE);
                this.dragPane.setBounds(jComponent.getX(), jComponent.getY(), jComponent.getWidth(), jComponent.getHeight());
                jLayeredPane.add(this.dragPane);
                this.usingDragPane = true;
            }
        }

        @Override
        public void resizeFrame(JComponent jComponent, int n, int n2, int n3, int n4) {
            this.setBoundsForFrame(jComponent, n, n2, n3, n4);
        }

        @Override
        public void endResizingFrame(JComponent jComponent) {
            if (this.usingDragPane) {
                JLayeredPane jLayeredPane = (JLayeredPane)jComponent.getParent();
                jLayeredPane.remove(this.dragPane);
                this.usingDragPane = false;
                this.setBoundsForFrame(jComponent, this.dragPane.getX(), this.dragPane.getY(), this.dragPane.getWidth(), this.dragPane.getHeight());
            }
        }

        @Override
        public void iconifyFrame(JInternalFrame jInternalFrame) {
            JInternalFrame.JDesktopIcon jDesktopIcon = jInternalFrame.getDesktopIcon();
            Point point = jDesktopIcon.getLocation();
            this.adjustBoundsForIcon(jDesktopIcon, point.x, point.y);
            super.iconifyFrame(jInternalFrame);
        }

        protected void adjustIcons(JDesktopPane jDesktopPane) {
            JInternalFrame.JDesktopIcon jDesktopIcon = new JInternalFrame.JDesktopIcon(new JInternalFrame());
            Dimension dimension = jDesktopIcon.getPreferredSize();
            this.iconWidth = dimension.width;
            this.iconHeight = dimension.height;
            JInternalFrame[] jInternalFrameArray = jDesktopPane.getAllFrames();
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                jDesktopIcon = jInternalFrameArray[i].getDesktopIcon();
                Point point = jDesktopIcon.getLocation();
                this.adjustBoundsForIcon(jDesktopIcon, point.x, point.y);
            }
        }

        protected void adjustBoundsForIcon(JInternalFrame.JDesktopIcon jDesktopIcon, int n, int n2) {
            JDesktopPane jDesktopPane = jDesktopIcon.getDesktopPane();
            int n3 = jDesktopPane.getHeight();
            int n4 = this.iconWidth;
            int n5 = this.iconHeight;
            jDesktopPane.repaint(n, n2, n4, n5);
            n = n < 0 ? 0 : n;
            n2 = n2 < 0 ? 0 : n2;
            n2 = n2 >= n3 ? n3 - 1 : n2;
            int n6 = n / n4 * n4;
            int n7 = n3 % n5;
            int n8 = (n2 - n7) / n5 * n5 + n7;
            int n9 = n - n6;
            int n10 = n2 - n8;
            int n11 = n = n9 < n4 / 2 ? n6 : n6 + n4;
            int n12 = n10 < n5 / 2 ? n8 : (n2 = n8 + n5 < n3 ? n8 + n5 : n8);
            while (this.getIconAt(jDesktopPane, jDesktopIcon, n, n2) != null) {
                n += n4;
            }
            if (n > jDesktopPane.getWidth()) {
                return;
            }
            if (jDesktopIcon.getParent() != null) {
                this.setBoundsForFrame(jDesktopIcon, n, n2, n4, n5);
            } else {
                jDesktopIcon.setLocation(n, n2);
            }
        }

        protected JInternalFrame.JDesktopIcon getIconAt(JDesktopPane jDesktopPane, JInternalFrame.JDesktopIcon jDesktopIcon, int n, int n2) {
            Object var5_5 = null;
            Component[] componentArray = jDesktopPane.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component = componentArray[i];
                if (!(component instanceof JInternalFrame.JDesktopIcon) || component == jDesktopIcon) continue;
                Point point = component.getLocation();
                if (point.x != n || point.y != n2) continue;
                return (JInternalFrame.JDesktopIcon)component;
            }
            return null;
        }
    }

    private class DragPane
    extends JComponent {
        private DragPane() {
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor(Color.darkGray);
            graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }
    }
}

