/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.translate;

import ai.djl.Application;
import ai.djl.Model;
import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.NoopServingTranslatorFactory;
import ai.djl.translate.ServingTranslator;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.ClassLoaderUtils;
import ai.djl.util.Pair;
import ai.djl.util.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServingTranslatorFactory
implements TranslatorFactory {
    private static final Logger logger = LoggerFactory.getLogger(ServingTranslatorFactory.class);

    @Override
    public Set<Pair<Type, Type>> getSupportedTypes() {
        return Collections.singleton(new Pair<Class<Input>, Class<Output>>(Input.class, Output.class));
    }

    @Override
    public <I, O> Translator<I, O> newInstance(Class<I> input, Class<O> output, Model model, Map<String, ?> arguments) throws TranslateException {
        if (!this.isSupported(input, output)) {
            throw new IllegalArgumentException("Unsupported input/output types.");
        }
        Path modelDir = model.getModelPath();
        String factoryClass = ArgumentsUtil.stringValue(arguments, "translatorFactory");
        if (factoryClass != null) {
            Translator<Input, Output> translator = this.getServingTranslator(factoryClass, model, arguments);
            if (translator != null) {
                return translator;
            }
            throw new TranslateException("Failed to load translatorFactory: " + factoryClass);
        }
        String className = (String)arguments.get("translator");
        Path libPath = modelDir.resolve("libs");
        if (!Files.isDirectory(libPath, new LinkOption[0]) && !Files.isDirectory(libPath = modelDir.resolve("lib"), new LinkOption[0]) && className == null) {
            return this.loadDefaultTranslator(model, arguments);
        }
        ServingTranslator servingTranslator = this.findTranslator(libPath, className);
        if (servingTranslator != null) {
            servingTranslator.setArguments(arguments);
            logger.info("Using translator: {}", (Object)servingTranslator.getClass().getName());
            return servingTranslator;
        }
        if (className != null) {
            throw new TranslateException("Failed to load translator: " + className);
        }
        return this.loadDefaultTranslator(model, arguments);
    }

    private ServingTranslator findTranslator(Path path, String className) {
        Path classesDir = path.resolve("classes");
        ClassLoaderUtils.compileJavaClass(classesDir);
        return ClassLoaderUtils.findImplementation(path, ServingTranslator.class, className);
    }

    private TranslatorFactory loadTranslatorFactory(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            Class<TranslatorFactory> subclass = clazz.asSubclass(TranslatorFactory.class);
            Constructor<TranslatorFactory> constructor = subclass.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            logger.trace("Not able to load TranslatorFactory: " + className, e);
            return null;
        }
    }

    private Translator<Input, Output> loadDefaultTranslator(Model model, Map<String, ?> arguments) throws TranslateException {
        String factoryClass = this.detectTranslatorFactory(arguments);
        Translator<Input, Output> translator = this.getServingTranslator(factoryClass, model, arguments);
        if (translator != null) {
            return translator;
        }
        NoopServingTranslatorFactory factory = new NoopServingTranslatorFactory();
        return factory.newInstance(Input.class, Output.class, null, arguments);
    }

    private String detectTranslatorFactory(Map<String, ?> arguments) {
        Application application;
        String app = ArgumentsUtil.stringValue(arguments, "application");
        if (app != null) {
            application = Application.of(app);
        } else {
            String task = Utils.getEnvOrSystemProperty("HF_TASK");
            if ((task = ArgumentsUtil.stringValue(arguments, "task", task)) != null) {
                task = task.replace("-", "_").toLowerCase(Locale.ROOT);
                application = Application.of(task);
            } else {
                application = Application.UNDEFINED;
            }
        }
        if (application == Application.CV.IMAGE_CLASSIFICATION) {
            return "ai.djl.modality.cv.translator.ImageClassificationTranslatorFactory";
        }
        if (application == Application.NLP.FILL_MASK) {
            return "ai.djl.huggingface.translator.FillMaskTranslatorFactory";
        }
        if (application == Application.NLP.QUESTION_ANSWER) {
            return "ai.djl.huggingface.translator.QuestionAnsweringTranslatorFactory";
        }
        if (application == Application.NLP.TEXT_CLASSIFICATION) {
            return "ai.djl.huggingface.translator.TextClassificationTranslatorFactory";
        }
        if (application == Application.NLP.TEXT_EMBEDDING) {
            return "ai.djl.huggingface.translator.TextEmbeddingTranslatorFactory";
        }
        if (application == Application.NLP.TOKEN_CLASSIFICATION) {
            return "ai.djl.huggingface.translator.TokenClassificationTranslatorFactory";
        }
        return null;
    }

    private Translator<Input, Output> getServingTranslator(String factoryClass, Model model, Map<String, ?> arguments) throws TranslateException {
        TranslatorFactory factory = this.loadTranslatorFactory(factoryClass);
        if (factory != null && factory.isSupported(Input.class, Output.class)) {
            logger.info("Using TranslatorFactory: {}", (Object)factoryClass);
            return factory.newInstance(Input.class, Output.class, model, arguments);
        }
        return null;
    }
}

