/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.text.impl;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.tribuo.Feature;
import org.tribuo.data.text.FeatureTransformer;
import org.tribuo.util.MurmurHash3;

public class FeatureHasher
implements FeatureTransformer {
    private static final Logger logger = Logger.getLogger(FeatureHasher.class.getName());
    @Config(mandatory=true, description="Dimension to map the hash into.")
    private int dimension;

    public FeatureHasher(int dimension) {
        this.dimension = dimension;
    }

    private FeatureHasher() {
    }

    @Override
    public List<Feature> map(String tag, List<Feature> features) {
        ArrayList<Feature> hashedFeatures = new ArrayList<Feature>();
        for (Feature feature : features) {
            int hash = MurmurHash3.murmurhash3_x86_32((CharSequence)feature.getName(), (int)0, (int)feature.getName().length(), (int)38495);
            int bit = MurmurHash3.murmurhash3_x86_32((CharSequence)feature.getName(), (int)0, (int)feature.getName().length(), (int)77777) & 1;
            int code = (hash >>>= 1) % this.dimension;
            int change = bit == 1 ? 1 : -1;
            Feature newFeature = new Feature(tag + "-hash=" + code, (double)change);
            hashedFeatures.add(newFeature);
        }
        return hashedFeatures;
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "FeatureTransformer");
    }
}

