/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.deciders.collator;

import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.opensearch.performanceanalyzer.decisionmaker.actions.Action;
import org.opensearch.performanceanalyzer.decisionmaker.actions.ImpactVector;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.Decider;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.Decision;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.collator.ImpactAssessment;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.collator.ImpactAssessor;
import org.opensearch.performanceanalyzer.rca.store.rca.cluster.NodeKey;

public class Collator
extends Decider {
    public static final String NAME = "collator";
    private static final int collatorFrequency = 1;
    private static final int evalIntervalSeconds = 5;
    private final ImpactAssessor impactAssessor;
    private final List<Decider> deciders;
    private final Comparator<Action> actionComparator;

    public Collator(Decider ... deciders) {
        super(5L, 1);
        this.deciders = Arrays.asList(deciders);
        this.actionComparator = new ImpactBasedActionComparator();
        this.impactAssessor = new ImpactAssessor();
    }

    @VisibleForTesting
    public Collator(ImpactAssessor impactAssessor, Comparator<Action> actionComparator, Decider ... deciders) {
        super(5L, 1);
        this.deciders = Arrays.asList(deciders);
        this.actionComparator = actionComparator;
        this.impactAssessor = impactAssessor;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public Decision operate() {
        Decision finalDecision = new Decision(System.currentTimeMillis(), NAME);
        ArrayList<Action> allowedActions = new ArrayList<Action>();
        List<Action> allActions = this.getProposedActions();
        Map<NodeKey, ImpactAssessment> overallImpactAssessment = this.impactAssessor.assessOverallImpact(allActions);
        allActions.sort(this.actionComparator);
        allActions.forEach(action -> {
            if (this.impactAssessor.isImpactAligned((Action)action, overallImpactAssessment)) {
                allowedActions.add((Action)action);
            } else {
                this.impactAssessor.undoActionImpactOnOverallAssessment((Action)action, overallImpactAssessment);
            }
        });
        finalDecision.addAllActions(allowedActions);
        return finalDecision;
    }

    private @NonNull List<Action> getProposedActions() {
        ArrayList<Action> proposedActions = new ArrayList<Action>();
        if (this.deciders != null) {
            for (Decider decider : this.deciders) {
                List<Decision> decisions = decider.getFlowUnits();
                decisions.forEach(decision -> {
                    if (!decision.getActions().isEmpty()) {
                        proposedActions.addAll(decision.getActions());
                    }
                });
            }
        }
        return proposedActions;
    }

    @VisibleForTesting
    static final class ImpactBasedActionComparator
    implements Comparator<Action>,
    Serializable {
        ImpactBasedActionComparator() {
        }

        @Override
        public int compare(Action action1, Action action2) {
            int numberOfPressureIncreases2;
            int numberOfPressureReductions2;
            int numberOfPressureReductions1 = this.getImpactedDimensionCount(action1, ImpactVector.Impact.DECREASES_PRESSURE);
            if (numberOfPressureReductions1 != (numberOfPressureReductions2 = this.getImpactedDimensionCount(action2, ImpactVector.Impact.DECREASES_PRESSURE))) {
                return numberOfPressureReductions1 - numberOfPressureReductions2;
            }
            int numberOfPressureIncreases1 = this.getImpactedDimensionCount(action1, ImpactVector.Impact.INCREASES_PRESSURE);
            if (numberOfPressureIncreases1 != (numberOfPressureIncreases2 = this.getImpactedDimensionCount(action2, ImpactVector.Impact.INCREASES_PRESSURE))) {
                return numberOfPressureIncreases2 - numberOfPressureIncreases1;
            }
            return 0;
        }

        private int getImpactedDimensionCount(Action action, ImpactVector.Impact requiredImpact) {
            int count = 0;
            for (ImpactVector impactVector : action.impact().values()) {
                for (ImpactVector.Impact impact : impactVector.getImpact().values()) {
                    if (!impact.equals((Object)requiredImpact)) continue;
                    ++count;
                }
            }
            return count;
        }
    }
}

