# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_rqbit_global_optspecs
	string join \n v= log-file= log-file-rust-log= i/tracker-refresh-interval= http-api-listen-addr= s/single-thread-runtime disable-dht disable-dht-persistence peer-connect-timeout= peer-read-write-timeout= t/worker-threads= disable-tcp-listen tcp-min-port= tcp-max-port= disable-upnp-port-forward enable-upnp-server upnp-server-friendly-name= max-blocking-threads= defer-writes-up-to= experimental-mmap-storage socks-url= concurrent-init-limit= umask= ratelimit-download= ratelimit-upload= h/help V/version
end

function __fish_rqbit_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_rqbit_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_rqbit_using_subcommand
	set -l cmd (__fish_rqbit_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c rqbit -n "__fish_rqbit_needs_command" -s v -d 'The console loglevel' -r -f -a "{trace\t'',debug\t'',info\t'',warn\t'',error\t''}"
complete -c rqbit -n "__fish_rqbit_needs_command" -l log-file -d 'The log filename to also write to in addition to the console' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -l log-file-rust-log -d 'The value for RUST_LOG in the log file' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -s i -l tracker-refresh-interval -d 'The interval to poll trackers, e.g. 30s. Trackers send the refresh interval when we connect to them. Often this is pretty big, e.g. 30 minutes. This can force a certain value' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -l http-api-listen-addr -d 'The listen address for HTTP API' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -l peer-connect-timeout -d 'The connect timeout, e.g. 1s, 1.5s, 100ms etc' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -l peer-read-write-timeout -d 'The connect timeout, e.g. 1s, 1.5s, 100ms etc' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -s t -l worker-threads -d 'How many threads to spawn for the executor' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -l tcp-min-port -d 'The minimal port to listen for incoming connections' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -l tcp-max-port -d 'The maximal port to listen for incoming connections' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -l upnp-server-friendly-name -d 'UPNP server name that would be displayed on devices in your network' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -l max-blocking-threads -d 'How many maximum blocking tokio threads to spawn to process disk reads/writes. This will indicate how many parallel reads/writes can happen at a moment in time. The higher the number, the more the memory usage' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -l defer-writes-up-to -r
complete -c rqbit -n "__fish_rqbit_needs_command" -l socks-url -d 'Provide a socks5 URL. The format is socks5://[username:password]@host:port' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -l concurrent-init-limit -d 'How many torrents can be initializing (rehashing) at the same time' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -l umask -d 'Set the process umask to this value' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -l ratelimit-download -d 'Limit download to bytes-per-second' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -l ratelimit-upload -d 'Limit upload to bytes-per-second' -r
complete -c rqbit -n "__fish_rqbit_needs_command" -s s -l single-thread-runtime -d 'Set this flag if you want to use tokio\'s single threaded runtime. It MAY perform better, but the main purpose is easier debugging, as time profilers work better with this one'
complete -c rqbit -n "__fish_rqbit_needs_command" -l disable-dht
complete -c rqbit -n "__fish_rqbit_needs_command" -l disable-dht-persistence -d 'Set this to disable DHT reading and storing it\'s state. For now this is a useful workaround if you want to launch multiple rqbit instances, otherwise DHT port will conflict'
complete -c rqbit -n "__fish_rqbit_needs_command" -l disable-tcp-listen
complete -c rqbit -n "__fish_rqbit_needs_command" -l disable-upnp-port-forward -d 'If set, will try to publish the chosen port through upnp on your router'
complete -c rqbit -n "__fish_rqbit_needs_command" -l enable-upnp-server -d 'If set, will run a UPNP Media server and stream all the torrents through it. Should be set to your hostname/IP as seen by your LAN neighbors'
complete -c rqbit -n "__fish_rqbit_needs_command" -l experimental-mmap-storage -d 'Use mmap (file-backed) for storage. Any advantages are questionable and unproven. If you use it, you know what you are doing'
complete -c rqbit -n "__fish_rqbit_needs_command" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c rqbit -n "__fish_rqbit_needs_command" -s V -l version -d 'Print version'
complete -c rqbit -n "__fish_rqbit_needs_command" -f -a "server"
complete -c rqbit -n "__fish_rqbit_needs_command" -f -a "download"
complete -c rqbit -n "__fish_rqbit_needs_command" -f -a "completions"
complete -c rqbit -n "__fish_rqbit_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rqbit -n "__fish_rqbit_using_subcommand server; and not __fish_seen_subcommand_from start help" -s h -l help -d 'Print help'
complete -c rqbit -n "__fish_rqbit_using_subcommand server; and not __fish_seen_subcommand_from start help" -f -a "start"
complete -c rqbit -n "__fish_rqbit_using_subcommand server; and not __fish_seen_subcommand_from start help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rqbit -n "__fish_rqbit_using_subcommand server; and __fish_seen_subcommand_from start" -l persistence-location -d 'The folder to store session data in. By default uses OS specific folder. If starts with postgres://, will use postgres as the backend instead of JSON file' -r
complete -c rqbit -n "__fish_rqbit_using_subcommand server; and __fish_seen_subcommand_from start" -l watch-folder -d 'The folder to watch for added .torrent files. All files in this folder will be automatically added to the session' -r
complete -c rqbit -n "__fish_rqbit_using_subcommand server; and __fish_seen_subcommand_from start" -l disable-persistence -d 'Disable server persistence. It will not read or write its state to disk.'
complete -c rqbit -n "__fish_rqbit_using_subcommand server; and __fish_seen_subcommand_from start" -l fastresume -d '[Experimental] if set, will try to resume quickly after restart and skip checksumming'
complete -c rqbit -n "__fish_rqbit_using_subcommand server; and __fish_seen_subcommand_from start" -s h -l help -d 'Print help'
complete -c rqbit -n "__fish_rqbit_using_subcommand server; and __fish_seen_subcommand_from help" -f -a "start"
complete -c rqbit -n "__fish_rqbit_using_subcommand server; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rqbit -n "__fish_rqbit_using_subcommand download" -s o -l output-folder -d 'The output folder to write to. If not exists, it will be created. If not specified, would use the server\'s output folder. If there\'s no server running, this is required' -r
complete -c rqbit -n "__fish_rqbit_using_subcommand download" -s s -l sub-folder -d 'The sub folder within output folder to write to. Useful when you have a server running with output_folder configured, and don\'t want to specify the full path every time' -r
complete -c rqbit -n "__fish_rqbit_using_subcommand download" -s r -l filename-re -d 'If set, only the file whose filename matching this regex will be downloaded' -r
complete -c rqbit -n "__fish_rqbit_using_subcommand download" -l initial-peers -r
complete -c rqbit -n "__fish_rqbit_using_subcommand download" -l server-url -r
complete -c rqbit -n "__fish_rqbit_using_subcommand download" -s l -l list -d 'Only list the torrent metadata contents, don\'t do anything else'
complete -c rqbit -n "__fish_rqbit_using_subcommand download" -l overwrite -d 'Set if you are ok to write on top of existing files'
complete -c rqbit -n "__fish_rqbit_using_subcommand download" -s e -l exit-on-finish -d 'Exit the program once the torrents complete download'
complete -c rqbit -n "__fish_rqbit_using_subcommand download" -l disable-trackers
complete -c rqbit -n "__fish_rqbit_using_subcommand download" -s h -l help -d 'Print help'
complete -c rqbit -n "__fish_rqbit_using_subcommand completions" -s h -l help -d 'Print help'
complete -c rqbit -n "__fish_rqbit_using_subcommand help; and not __fish_seen_subcommand_from server download completions help" -f -a "server"
complete -c rqbit -n "__fish_rqbit_using_subcommand help; and not __fish_seen_subcommand_from server download completions help" -f -a "download"
complete -c rqbit -n "__fish_rqbit_using_subcommand help; and not __fish_seen_subcommand_from server download completions help" -f -a "completions"
complete -c rqbit -n "__fish_rqbit_using_subcommand help; and not __fish_seen_subcommand_from server download completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c rqbit -n "__fish_rqbit_using_subcommand help; and __fish_seen_subcommand_from server" -f -a "start"
