/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.cursor;

import com.google.common.base.Strings;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opensearch.sql.legacy.cursor.Cursor;
import org.opensearch.sql.legacy.cursor.CursorType;
import org.opensearch.sql.legacy.executor.format.Schema;

public class DefaultCursor
implements Cursor {
    private static final String FETCH_SIZE = "f";
    private static final String ROWS_LEFT = "l";
    private static final String INDEX_PATTERN = "i";
    private static final String SCROLL_ID = "s";
    private static final String SCHEMA_COLUMNS = "c";
    private static final String FIELD_ALIAS_MAP = "a";
    @NonNull
    private String indexPattern;
    @NonNull
    private List<Schema.Column> columns;
    private final CursorType type = CursorType.DEFAULT;
    private long rowsLeft;
    @NonNull
    private Map<String, String> fieldAliasMap;
    private String scrollId;
    @NonNull
    private Integer fetchSize;
    private Integer limit;

    @Override
    public CursorType getType() {
        return this.type;
    }

    @Override
    public String generateCursorId() {
        if (this.rowsLeft <= 0L || Strings.isNullOrEmpty((String)this.scrollId)) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put(FETCH_SIZE, (Object)this.fetchSize);
        json.put(ROWS_LEFT, this.rowsLeft);
        json.put(INDEX_PATTERN, (Object)this.indexPattern);
        json.put(SCROLL_ID, (Object)this.scrollId);
        json.put(SCHEMA_COLUMNS, (Object)this.getSchemaAsJson());
        json.put(FIELD_ALIAS_MAP, this.fieldAliasMap);
        return String.format("%s:%s", this.type.getId(), DefaultCursor.encodeCursor(json));
    }

    public static DefaultCursor from(String cursorId) {
        JSONObject json = DefaultCursor.decodeCursor(cursorId);
        DefaultCursor cursor = new DefaultCursor();
        cursor.setFetchSize(json.getInt(FETCH_SIZE));
        cursor.setRowsLeft(json.getLong(ROWS_LEFT));
        cursor.setIndexPattern(json.getString(INDEX_PATTERN));
        cursor.setScrollId(json.getString(SCROLL_ID));
        cursor.setColumns(DefaultCursor.getColumnsFromSchema(json.getJSONArray(SCHEMA_COLUMNS)));
        cursor.setFieldAliasMap(DefaultCursor.fieldAliasMap(json.getJSONObject(FIELD_ALIAS_MAP)));
        return cursor;
    }

    private JSONArray getSchemaAsJson() {
        JSONArray schemaJson = new JSONArray();
        for (Schema.Column column : this.columns) {
            schemaJson.put((Object)this.schemaEntry(column.getName(), column.getAlias(), column.getType()));
        }
        return schemaJson;
    }

    private JSONObject schemaEntry(String name, String alias, String type) {
        JSONObject entry = new JSONObject();
        entry.put("name", (Object)name);
        if (alias != null) {
            entry.put("alias", (Object)alias);
        }
        entry.put("type", (Object)type);
        return entry;
    }

    private static String encodeCursor(JSONObject cursorJson) {
        return Base64.getEncoder().encodeToString(cursorJson.toString().getBytes());
    }

    private static JSONObject decodeCursor(String cursorId) {
        return new JSONObject(new String(Base64.getDecoder().decode(cursorId)));
    }

    private static Map<String, String> fieldAliasMap(JSONObject json) {
        HashMap<String, String> fieldToAliasMap = new HashMap<String, String>();
        json.keySet().forEach(key -> fieldToAliasMap.put((String)key, json.get(key).toString()));
        return fieldToAliasMap;
    }

    private static List<Schema.Column> getColumnsFromSchema(JSONArray schema) {
        List<Schema.Column> columns = IntStream.range(0, schema.length()).mapToObj(i -> {
            JSONObject jsonColumn = schema.getJSONObject(i);
            return new Schema.Column(jsonColumn.getString("name"), jsonColumn.optString("alias", null), Schema.Type.valueOf(jsonColumn.getString("type").toUpperCase()));
        }).collect(Collectors.toList());
        return columns;
    }

    @NonNull
    public String getIndexPattern() {
        return this.indexPattern;
    }

    @NonNull
    public List<Schema.Column> getColumns() {
        return this.columns;
    }

    public long getRowsLeft() {
        return this.rowsLeft;
    }

    @NonNull
    public Map<String, String> getFieldAliasMap() {
        return this.fieldAliasMap;
    }

    public String getScrollId() {
        return this.scrollId;
    }

    @NonNull
    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setIndexPattern(@NonNull String indexPattern) {
        if (indexPattern == null) {
            throw new NullPointerException("indexPattern is marked non-null but is null");
        }
        this.indexPattern = indexPattern;
    }

    public void setColumns(@NonNull List<Schema.Column> columns) {
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        this.columns = columns;
    }

    public void setRowsLeft(long rowsLeft) {
        this.rowsLeft = rowsLeft;
    }

    public void setFieldAliasMap(@NonNull Map<String, String> fieldAliasMap) {
        if (fieldAliasMap == null) {
            throw new NullPointerException("fieldAliasMap is marked non-null but is null");
        }
        this.fieldAliasMap = fieldAliasMap;
    }

    public void setScrollId(String scrollId) {
        this.scrollId = scrollId;
    }

    public void setFetchSize(@NonNull Integer fetchSize) {
        if (fetchSize == null) {
            throw new NullPointerException("fetchSize is marked non-null but is null");
        }
        this.fetchSize = fetchSize;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}

