# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_vmexec_global_optspecs
	string join \n log-level= h/help V/version
end

function __fish_vmexec_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_vmexec_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_vmexec_using_subcommand
	set -l cmd (__fish_vmexec_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c vmexec -n "__fish_vmexec_needs_command" -l log-level -d 'Log messages above specified level (error, warn, info, debug, trace)' -r
complete -c vmexec -n "__fish_vmexec_needs_command" -s h -l help -d 'Print help'
complete -c vmexec -n "__fish_vmexec_needs_command" -s V -l version -d 'Print version'
complete -c vmexec -n "__fish_vmexec_needs_command" -f -a "run" -d 'Run a command in a new virtual machine'
complete -c vmexec -n "__fish_vmexec_needs_command" -f -a "ksm" -d 'Check and change KSM status'
complete -c vmexec -n "__fish_vmexec_needs_command" -f -a "completions" -d 'Generate completion file for a shell'
complete -c vmexec -n "__fish_vmexec_needs_command" -f -a "manpage" -d 'Print man page'
complete -c vmexec -n "__fish_vmexec_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c vmexec -n "__fish_vmexec_using_subcommand run" -s e -l env -d 'Set environment variables for the process inside the virtual machine' -r
complete -c vmexec -n "__fish_vmexec_using_subcommand run" -s v -l volume -d 'Bind mount a volume into the virtual machine' -r
complete -c vmexec -n "__fish_vmexec_using_subcommand run" -l pmem -d 'Mount a virtio-pmem device file into the virtual machine' -r
complete -c vmexec -n "__fish_vmexec_using_subcommand run" -s p -l publish -d 'Publish a port on the virtual machine to the host' -r
complete -c vmexec -n "__fish_vmexec_using_subcommand run" -s s -l ssh-timeout -d 'SSH connection timeout' -r
complete -c vmexec -n "__fish_vmexec_using_subcommand run" -s i -l interactive -d 'Make STDIN available to the virtual machine\'s process' -r -f -a "always\t''
never\t''
auto\t''"
complete -c vmexec -n "__fish_vmexec_using_subcommand run" -s t -l tty -d 'Allocate a pseudo-TTY for the virtual machine' -r -f -a "always\t''
never\t''
auto\t''"
complete -c vmexec -n "__fish_vmexec_using_subcommand run" -l pull -d 'When to pull a new image' -r -f -a "missing\t''
never\t''
newer\t''"
complete -c vmexec -n "__fish_vmexec_using_subcommand run" -l show-vm-window -d 'Show a window with the virtual machine running in it'
complete -c vmexec -n "__fish_vmexec_using_subcommand run" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c vmexec -n "__fish_vmexec_using_subcommand ksm" -s e -l enable -d 'Persistently enable KSM by writing settings to /etc/tmpfiles.d/ksm.conf'
complete -c vmexec -n "__fish_vmexec_using_subcommand ksm" -s d -l disable -d 'Persistently disable KSM by deleting /etc/tmpfiles.d/ksm.conf'
complete -c vmexec -n "__fish_vmexec_using_subcommand ksm" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c vmexec -n "__fish_vmexec_using_subcommand completions" -s h -l help -d 'Print help'
complete -c vmexec -n "__fish_vmexec_using_subcommand manpage" -s h -l help -d 'Print help'
complete -c vmexec -n "__fish_vmexec_using_subcommand help; and not __fish_seen_subcommand_from run ksm completions manpage help" -f -a "run" -d 'Run a command in a new virtual machine'
complete -c vmexec -n "__fish_vmexec_using_subcommand help; and not __fish_seen_subcommand_from run ksm completions manpage help" -f -a "ksm" -d 'Check and change KSM status'
complete -c vmexec -n "__fish_vmexec_using_subcommand help; and not __fish_seen_subcommand_from run ksm completions manpage help" -f -a "completions" -d 'Generate completion file for a shell'
complete -c vmexec -n "__fish_vmexec_using_subcommand help; and not __fish_seen_subcommand_from run ksm completions manpage help" -f -a "manpage" -d 'Print man page'
complete -c vmexec -n "__fish_vmexec_using_subcommand help; and not __fish_seen_subcommand_from run ksm completions manpage help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
