/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Objects;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.ParseResult;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyRuntimeAdapter;
import org.jruby.RubyString;
import org.jruby.ast.executable.Script;
import org.jruby.embed.AttributeName;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.EmbedRubyRuntimeAdapter;
import org.jruby.embed.ParseFailedException;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.internal.EmbedEvalUnitImpl;
import org.jruby.embed.io.ReaderInputStream;
import org.jruby.embed.util.SystemPropertyCatcher;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.parser.ParserType;
import org.jruby.parser.StaticScope;
import org.jruby.parser.StaticScopeFactory;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.LoadService;
import org.jruby.runtime.scope.ManyVarsDynamicScope;

public class EmbedRubyRuntimeAdapterImpl
implements EmbedRubyRuntimeAdapter {
    private final RubyRuntimeAdapter adapter = JavaEmbedUtils.newRuntimeAdapter();
    private final ScriptingContainer container;
    private final boolean wrapExceptions;

    public EmbedRubyRuntimeAdapterImpl(ScriptingContainer container) {
        this(container, false);
    }

    public EmbedRubyRuntimeAdapterImpl(ScriptingContainer container, boolean wrapExceptions) {
        this.container = container;
        this.wrapExceptions = wrapExceptions;
    }

    @Override
    public EmbedEvalUnit parse(String script, int ... lines2) {
        if (script == null) {
            return null;
        }
        boolean unicode_escape = false;
        Object obj = this.container.getAttribute((Object)AttributeName.UNICODE_ESCAPE);
        if (obj instanceof Boolean) {
            unicode_escape = (Boolean)obj;
        }
        if (unicode_escape) {
            ReaderInputStream istream = new ReaderInputStream(new StringReader(script));
            return this.runParser(istream, null, lines2);
        }
        return this.runParser(script, null, lines2);
    }

    @Override
    public EmbedEvalUnit parse(Reader reader, String filename2, int ... lines2) {
        Objects.requireNonNull(reader, "reader");
        ReaderInputStream istream = new ReaderInputStream(reader);
        return this.runParser(istream, filename2, lines2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EmbedEvalUnit parse(PathType type2, String filename2, int ... lines2) {
        Objects.requireNonNull(filename2, "filename");
        if (type2 == null) {
            type2 = PathType.ABSOLUTE;
        }
        InputStream istream = null;
        try {
            Object basedir;
            switch (type2) {
                case ABSOLUTE: {
                    istream = new FileInputStream(filename2);
                    break;
                }
                case RELATIVE: {
                    basedir = (String)this.container.getAttribute((Object)AttributeName.BASE_DIR);
                    if (basedir == null) {
                        basedir = SystemPropertyCatcher.getBaseDir();
                    }
                    String absolutePath = (String)basedir + File.separator + filename2;
                    istream = new FileInputStream(absolutePath);
                    break;
                }
                case CLASSPATH: {
                    URL loc = this.container.getProvider().getRuntime().getJRubyClassLoader().getResource(filename2);
                    if (loc == null) break;
                    filename2 = LoadService.classpathFilenameFromURL(filename2, loc, true);
                    try {
                        istream = loc.openStream();
                        break;
                    }
                    catch (IOException ioe) {
                        istream = null;
                    }
                }
            }
            basedir = this.parse(istream, filename2, lines2);
            return basedir;
        }
        catch (FileNotFoundException e) {
            if (this.wrapExceptions) {
                throw new ParseFailedException(e);
            }
            Helpers.throwException(e);
            EmbedEvalUnit embedEvalUnit = null;
            return embedEvalUnit;
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public EmbedEvalUnit parse(InputStream istream, String filename2, int ... lines2) {
        if (istream != null) {
            return this.runParser(istream, filename2, lines2);
        }
        return null;
    }

    private EmbedEvalUnit runParser(Object input, String filename2, int ... lines2) {
        if (filename2 == null || filename2.length() == 0) {
            filename2 = this.container.getScriptFilename();
        }
        Ruby runtime2 = this.container.getProvider().getRuntime();
        ValueAccessor $0 = new ValueAccessor(RubyString.newString(runtime2, filename2));
        runtime2.getGlobalVariables().define("$PROGRAM_NAME", $0, GlobalVariable.Scope.GLOBAL);
        runtime2.getGlobalVariables().define("$0", $0, GlobalVariable.Scope.GLOBAL);
        int line = 0;
        if (lines2 != null && lines2.length > 0) {
            line = lines2[0];
        }
        DynamicScope scope = null;
        if (EmbedEvalUnitImpl.isSharingVariables(this.container)) {
            scope = EmbedRubyRuntimeAdapterImpl.createLocalVarScope(runtime2, this.container.getVarMap().getLocalVarNames());
        }
        try {
            ParseResult node = input instanceof String ? runtime2.getParserManager().parseEval(filename2, line, (String)input, scope) : runtime2.getParserManager().parseMainFile(filename2, line, (InputStream)input, runtime2.setupSourceEncoding(UTF8Encoding.INSTANCE), scope, ParserType.EVAL);
            RubyInstanceConfig.CompileMode compileMode = runtime2.getInstanceConfig().getCompileMode();
            if (compileMode == RubyInstanceConfig.CompileMode.FORCE) {
                Script script = runtime2.tryCompile(node);
                return new EmbedEvalUnitImpl(this.container, node, scope, script, this.wrapExceptions);
            }
            return new EmbedEvalUnitImpl(this.container, node, scope, null, this.wrapExceptions);
        }
        catch (RaiseException e) {
            if (this.wrapExceptions) {
                throw new ParseFailedException(e.getMessage(), e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (this.wrapExceptions) {
                throw new ParseFailedException(e);
            }
            throw e;
        }
    }

    @Override
    public IRubyObject eval(Ruby runtime2, String script) {
        return this.adapter.eval(runtime2, script);
    }

    @Override
    public JavaEmbedUtils.EvalUnit parse(Ruby runtime2, String script, String filename2, int lineNumber) {
        return this.adapter.parse(runtime2, script, filename2, lineNumber);
    }

    @Override
    public JavaEmbedUtils.EvalUnit parse(Ruby runtime2, InputStream istream, String filename2, int lineNumber) {
        return this.adapter.parse(runtime2, istream, filename2, lineNumber);
    }

    static DynamicScope createLocalVarScope(Ruby runtime2, String[] varNames) {
        StaticScopeFactory scopeFactory = runtime2.getStaticScopeFactory();
        StaticScope topStaticScope = scopeFactory.newLocalScope(null);
        topStaticScope.setModule(runtime2.getObject());
        ManyVarsDynamicScope currentScope = new ManyVarsDynamicScope(topStaticScope, null);
        StaticScope evalScope = scopeFactory.newEvalScope(currentScope.getStaticScope(), varNames);
        ManyVarsDynamicScope scope = new ManyVarsDynamicScope(evalScope, currentScope);
        scope.getStaticScope().determineModule();
        return scope;
    }
}

