/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.CaseChangeable;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;

public class Letter
extends CharObject
implements CaseChangeable {
    public Letter(int n) {
        super(n);
    }

    @Override
    public TeXObject toLowerCase(TeXParser teXParser) {
        int n = Character.toLowerCase(this.charCode);
        if (n == this.getCharCode()) {
            String string = this.toString(teXParser).toLowerCase();
            n = string.codePointAt(0);
            if (string.length() == Character.charCount(n)) {
                return teXParser.getListener().getLetter(n);
            }
            return teXParser.getListener().createString(string);
        }
        return teXParser.getListener().getLetter(n);
    }

    @Override
    public TeXObject toUpperCase(TeXParser teXParser) {
        int n = Character.toUpperCase(this.charCode);
        if (n == this.getCharCode()) {
            String string = this.toString(teXParser).toUpperCase();
            n = string.codePointAt(0);
            if (string.length() == Character.charCount(n)) {
                return teXParser.getListener().getLetter(n);
            }
            return teXParser.getListener().createString(string);
        }
        return teXParser.getListener().getLetter(n);
    }

    @Override
    public Object clone() {
        return new Letter(this.getCharCode());
    }

    @Override
    public int getCatCode() {
        return 11;
    }
}

