"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decorateNavigateToItems = decorateNavigateToItems;
const utils_1 = require("../utils");
function decorateNavigateToItems(ls, snapshotManager) {
    const getNavigateToItems = ls.getNavigateToItems;
    ls.getNavigateToItems = (...args) => {
        const navigationToItems = getNavigateToItems(...args);
        return navigationToItems
            .map((item) => {
            if (!(0, utils_1.isSvelteFilePath)(item.fileName)) {
                return item;
            }
            if (item.name.startsWith('__sveltets_') ||
                (item.name === 'render' && !item.containerName)) {
                return;
            }
            let textSpan = snapshotManager
                .get(item.fileName)
                ?.getOriginalTextSpan(item.textSpan);
            if (!textSpan) {
                if ((0, utils_1.isGeneratedSvelteComponentName)(item.name)) {
                    textSpan = { start: 0, length: 1 };
                }
                else {
                    return;
                }
            }
            return {
                ...item,
                textSpan
            };
        })
            .filter(utils_1.isNotNullOrUndefined);
    };
}
//# sourceMappingURL=navigate-to-items.js.map