/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.rest.handler;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.histogram.Histogram;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.ValidationAspect;
import org.opensearch.timeseries.model.ValidationIssueType;

public class AggregationPrep {
    protected static final Logger logger = LogManager.getLogger(AggregationPrep.class);
    private SearchFeatureDao dateRangeHelper;
    private Config config;
    TimeValue requestTimeout;
    public static final String AGGREGATION = "agg";

    public AggregationPrep(SearchFeatureDao dateRangeHelper, TimeValue requestTimeout, Config config) {
        this.dateRangeHelper = dateRangeHelper;
        this.requestTimeout = requestTimeout;
        this.config = config;
    }

    public LongBounds getTimeRangeBounds(IntervalTimeConfiguration interval, long endMillis) {
        long intervalInMillis = IntervalTimeConfiguration.getIntervalInMinute(interval) * 60000L;
        Long startMillis = endMillis - (long)this.getNumberOfSamples() * intervalInMillis;
        return new LongBounds(startMillis, Long.valueOf(endMillis));
    }

    public int getNumberOfSamples() {
        return this.config.getHistoryIntervals();
    }

    public double getBucketHitRate(SearchResponse response, IntervalTimeConfiguration currentInterval, long endMillis) {
        if (this.config.getEnabledFeatureIds() != null && this.config.getEnabledFeatureIds().size() > 0) {
            List<Optional<double[]>> features = this.dateRangeHelper.parseColdStartSampleResp(response, false, this.config);
            return features.stream().filter(Optional::isPresent).count() / (long)this.getNumberOfSamples();
        }
        return this.getHistorgramBucketHitRate(response);
    }

    public double getHistorgramBucketHitRate(SearchResponse response) {
        int numberOfSamples = this.getNumberOfSamples();
        if (numberOfSamples == 0) {
            return 0.0;
        }
        Histogram histogram = this.validateAndRetrieveHistogramAggregation(response);
        if (histogram == null || histogram.getBuckets() == null) {
            logger.warn("Empty histogram buckets");
            return 0.0;
        }
        int bucketCount = histogram.getBuckets().size();
        return bucketCount / numberOfSamples;
    }

    public List<Long> getTimestamps(SearchResponse response) {
        if (this.config.getEnabledFeatureIds() != null && this.config.getEnabledFeatureIds().size() > 0) {
            return this.dateRangeHelper.parseColdStartSampleTimestamp(response, false, this.config);
        }
        Histogram aggregate = this.validateAndRetrieveHistogramAggregation(response);
        return aggregate.getBuckets().stream().map(entry -> AggregationPrep.convertKeyToEpochMillis(entry.getKey())).collect(Collectors.toList());
    }

    public SearchRequest createSearchRequest(IntervalTimeConfiguration currentInterval, LongBounds currentTimeStampBounds, Map<String, Object> topEntity) {
        if (this.config.getEnabledFeatureIds() != null && this.config.getEnabledFeatureIds().size() > 0) {
            List<Map.Entry<Long, Long>> ranges = this.dateRangeHelper.getTrainSampleRanges(currentInterval, currentTimeStampBounds.getMin(), currentTimeStampBounds.getMax(), this.getNumberOfSamples());
            return this.dateRangeHelper.createColdStartFeatureSearchRequest(this.config, ranges, topEntity.size() == 0 ? Optional.empty() : Optional.of(Entity.createEntityByReordering(topEntity)));
        }
        return this.composeHistogramQuery(topEntity, (int)IntervalTimeConfiguration.getIntervalInMinute(currentInterval), currentTimeStampBounds);
    }

    public SearchRequest createSearchRequestForFeature(IntervalTimeConfiguration currentInterval, LongBounds currentTimeStampBounds, Map<String, Object> topEntity, int featureIndex) {
        if (this.config.getEnabledFeatureIds() != null && this.config.getEnabledFeatureIds().size() > 0) {
            List<Map.Entry<Long, Long>> ranges = this.dateRangeHelper.getTrainSampleRanges(currentInterval, currentTimeStampBounds.getMin(), currentTimeStampBounds.getMax(), this.getNumberOfSamples());
            return this.dateRangeHelper.createColdStartFeatureSearchRequestForSingleFeature(this.config, ranges, topEntity.size() == 0 ? Optional.empty() : Optional.of(Entity.createEntityByReordering(topEntity)), featureIndex);
        }
        throw new IllegalArgumentException("empty feature");
    }

    public static long convertKeyToEpochMillis(Object key) {
        return key instanceof ZonedDateTime ? ((ZonedDateTime)key).toInstant().toEpochMilli() : (key instanceof Double ? ((Double)key).longValue() : (key instanceof Long ? (Long)key : -1L));
    }

    public SearchRequest composeHistogramQuery(Map<String, Object> topEntity, int intervalInMinutes, LongBounds timeStampBounds) {
        AggregationBuilder aggregation = this.getHistogramAggregation(intervalInMinutes, timeStampBounds);
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter(this.config.getFilterQuery());
        if (this.config.isHighCardinality()) {
            if (topEntity.isEmpty()) {
                throw new ValidationException(CommonMessages.CATEGORY_FIELD_TOO_SPARSE, ValidationIssueType.CATEGORY, ValidationAspect.MODEL);
            }
            for (Map.Entry<String, Object> entry : topEntity.entrySet()) {
                query.filter((QueryBuilder)QueryBuilders.termQuery((String)entry.getKey(), (Object)entry.getValue()));
            }
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)query).aggregation(aggregation).size(0).timeout(this.requestTimeout);
        return new SearchRequest(this.config.getIndices().toArray(new String[0])).source(searchSourceBuilder);
    }

    public Histogram validateAndRetrieveHistogramAggregation(SearchResponse response) {
        Aggregations aggs = response.getAggregations();
        if (aggs == null) {
            logger.warn("Unexpected null aggregation.");
            throw new ValidationException(CommonMessages.MODEL_VALIDATION_FAILED_UNEXPECTEDLY, ValidationIssueType.AGGREGATION, ValidationAspect.MODEL);
        }
        Histogram aggregate = (Histogram)aggs.get(AGGREGATION);
        if (aggregate == null) {
            throw new IllegalArgumentException("Failed to find valid aggregation result");
        }
        return aggregate;
    }

    public AggregationBuilder getHistogramAggregation(int intervalInMinutes, LongBounds timeStampBound) {
        return ((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)AGGREGATION).field(this.config.getTimeField())).minDocCount(1L).hardBounds(timeStampBound).fixedInterval(DateHistogramInterval.minutes((int)intervalInMinutes));
    }

    public SearchSourceBuilder getSearchSourceBuilder(QueryBuilder query, AggregationBuilder aggregation) {
        return new SearchSourceBuilder().query(query).aggregation(aggregation).size(0).timeout(this.requestTimeout);
    }
}

