# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/jsonschema/scripts/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the TestCase message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    #
    # //// TestCases
    #
    # *
    #  A `TestCase` contains a sequence of `TestStep`s.
    ##
    class TestCase < Message
      attr_reader :id

      ##
      # The ID of the `Pickle` this `TestCase` is derived from.
      ##
      attr_reader :pickle_id

      attr_reader :test_steps

      def initialize(
        id: '',
        pickle_id: '',
        test_steps: []
      )
        @id = id
        @pickle_id = pickle_id
        @test_steps = test_steps
        super()
      end

      ##
      # Returns a new TestCase from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::TestCase.from_h(some_hash) # => #<Cucumber::Messages::TestCase:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          id: hash[:id],
          pickle_id: hash[:pickleId],
          test_steps: hash[:testSteps]&.map { |item| TestStep.from_h(item) }
        )
      end
    end
  end
end
