"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getElementAttrs = getElementAttrs;
const vue = require("@vue/language-core");
function getElementAttrs(fileName, tagName) {
    const { typescript: ts, language, languageService, getFileId } = this;
    const volarFile = language.scripts.get(getFileId(fileName));
    if (!(volarFile?.generated?.root instanceof vue.VueVirtualCode)) {
        return;
    }
    const program = languageService.getProgram();
    let tsSourceFile;
    if (tsSourceFile = program.getSourceFile(fileName)) {
        const checker = program.getTypeChecker();
        const typeNode = tsSourceFile.statements
            .filter(ts.isTypeAliasDeclaration)
            .find(node => node.name.getText() === '__VLS_IntrinsicElementsCompletion');
        if (checker && typeNode) {
            const type = checker.getTypeFromTypeNode(typeNode.type);
            const el = type.getProperty(tagName);
            if (el) {
                const attrs = checker.getTypeOfSymbolAtLocation(el, typeNode).getProperties();
                return attrs.map(c => c.name);
            }
        }
    }
    return [];
}
//# sourceMappingURL=getElementAttrs.js.map