# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AppServiceCertificate(_serialization.Model):
    """Key Vault container for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar key_vault_id: Key Vault resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2015_08_01.models.KeyVaultSecretStatus
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "key_vault_id": {"key": "keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "keyVaultSecretName", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self, *, key_vault_id: Optional[str] = None, key_vault_secret_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword key_vault_id: Key Vault resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        """
        super().__init__(**kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceCertificateCollection(_serialization.Model):
    """Collection of certificate order certificates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateResource]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServiceCertificateResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AppServiceCertificateResource"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Resource(_serialization.Model):
    """Azure resource. This resource is tracked in Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self, *, location: str, kind: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.location = location
        self.type = None
        self.tags = tags


class AppServiceCertificateOrder(Resource):  # pylint: disable=too-many-instance-attributes
    """SSL certificate purchase order.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar certificates: State of the Key Vault secret.
    :vartype certificates: dict[str, ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificate]
    :ivar distinguished_name: Certificate distinguished name.
    :vartype distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :ivar validity_in_years: Duration in years (must be between 1 and 3).
    :vartype validity_in_years: int
    :ivar key_size: Certificate key size.
    :vartype key_size: int
    :ivar product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
     and "StandardDomainValidatedWildCardSsl".
    :vartype product_type: str or ~azure.mgmt.web.v2015_08_01.models.CertificateProductType
    :ivar auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Known values are: "Succeeded", "Failed",
     "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2015_08_01.models.ProvisioningState
    :ivar status: Current order status. Known values are: "Pendingissuance", "Issued", "Revoked",
     "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired", and
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.web.v2015_08_01.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :ivar csr: Last CSR that was created for this order.
    :vartype csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2015_08_01.models.ResourceNotRenewableReason]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "domain_verification_token": {"readonly": True},
        "validity_in_years": {"maximum": 3, "minimum": 1},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "signed_certificate": {"readonly": True},
        "intermediate": {"readonly": True},
        "root": {"readonly": True},
        "serial_number": {"readonly": True},
        "last_certificate_issuance_time": {"readonly": True},
        "expiration_time": {"readonly": True},
        "is_private_key_external": {"readonly": True},
        "app_service_certificate_not_renewable_reasons": {"readonly": True},
        "next_auto_renewal_time_stamp": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "certificates": {"key": "properties.certificates", "type": "{AppServiceCertificate}"},
        "distinguished_name": {"key": "properties.distinguishedName", "type": "str"},
        "domain_verification_token": {"key": "properties.domainVerificationToken", "type": "str"},
        "validity_in_years": {"key": "properties.validityInYears", "type": "int"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "product_type": {"key": "properties.productType", "type": "str"},
        "auto_renew": {"key": "properties.autoRenew", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "signed_certificate": {"key": "properties.signedCertificate", "type": "CertificateDetails"},
        "csr": {"key": "properties.csr", "type": "str"},
        "intermediate": {"key": "properties.intermediate", "type": "CertificateDetails"},
        "root": {"key": "properties.root", "type": "CertificateDetails"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "last_certificate_issuance_time": {"key": "properties.lastCertificateIssuanceTime", "type": "iso-8601"},
        "expiration_time": {"key": "properties.expirationTime", "type": "iso-8601"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
        "app_service_certificate_not_renewable_reasons": {
            "key": "properties.appServiceCertificateNotRenewableReasons",
            "type": "[str]",
        },
        "next_auto_renewal_time_stamp": {"key": "properties.nextAutoRenewalTimeStamp", "type": "iso-8601"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        certificates: Optional[Dict[str, "_models.AppServiceCertificate"]] = None,
        distinguished_name: Optional[str] = None,
        validity_in_years: int = 1,
        key_size: int = 2048,
        product_type: Optional[Union[str, "_models.CertificateProductType"]] = None,
        auto_renew: bool = True,
        csr: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword certificates: State of the Key Vault secret.
        :paramtype certificates: dict[str, ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificate]
        :keyword distinguished_name: Certificate distinguished name.
        :paramtype distinguished_name: str
        :keyword validity_in_years: Duration in years (must be between 1 and 3).
        :paramtype validity_in_years: int
        :keyword key_size: Certificate key size.
        :paramtype key_size: int
        :keyword product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
         and "StandardDomainValidatedWildCardSsl".
        :paramtype product_type: str or ~azure.mgmt.web.v2015_08_01.models.CertificateProductType
        :keyword auto_renew: :code:`<code>true</code>` if the certificate should be automatically
         renewed when it expires; otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword csr: Last CSR that was created for this order.
        :paramtype csr: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = csr
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None


class AppServiceCertificateOrderCollection(_serialization.Model):
    """Collection of certificate orders.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AppServiceCertificateOrder]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.AppServiceCertificateOrder"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2015_08_01.models.AppServiceCertificateOrder]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ProxyOnlyResource(_serialization.Model):
    """Azure proxy only resource. This resource is not tracked by Azure Resource Manager.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.kind = kind
        self.type = None


class AppServiceCertificateOrderPatchResource(ProxyOnlyResource):  # pylint: disable=too-many-instance-attributes
    """ARM resource for a certificate order that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar certificates: State of the Key Vault secret.
    :vartype certificates: dict[str, ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificate]
    :ivar distinguished_name: Certificate distinguished name.
    :vartype distinguished_name: str
    :ivar domain_verification_token: Domain verification token.
    :vartype domain_verification_token: str
    :ivar validity_in_years: Duration in years (must be between 1 and 3).
    :vartype validity_in_years: int
    :ivar key_size: Certificate key size.
    :vartype key_size: int
    :ivar product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
     and "StandardDomainValidatedWildCardSsl".
    :vartype product_type: str or ~azure.mgmt.web.v2015_08_01.models.CertificateProductType
    :ivar auto_renew: :code:`<code>true</code>` if the certificate should be automatically renewed
     when it expires; otherwise, :code:`<code>false</code>`.
    :vartype auto_renew: bool
    :ivar provisioning_state: Status of certificate order. Known values are: "Succeeded", "Failed",
     "Canceled", "InProgress", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2015_08_01.models.ProvisioningState
    :ivar status: Current order status. Known values are: "Pendingissuance", "Issued", "Revoked",
     "Canceled", "Denied", "Pendingrevocation", "PendingRekey", "Unused", "Expired", and
     "NotSubmitted".
    :vartype status: str or ~azure.mgmt.web.v2015_08_01.models.CertificateOrderStatus
    :ivar signed_certificate: Signed certificate.
    :vartype signed_certificate: ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :ivar csr: Last CSR that was created for this order.
    :vartype csr: str
    :ivar intermediate: Intermediate certificate.
    :vartype intermediate: ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :ivar root: Root certificate.
    :vartype root: ~azure.mgmt.web.v2015_08_01.models.CertificateDetails
    :ivar serial_number: Current serial number of the certificate.
    :vartype serial_number: str
    :ivar last_certificate_issuance_time: Certificate last issuance time.
    :vartype last_certificate_issuance_time: ~datetime.datetime
    :ivar expiration_time: Certificate expiration time.
    :vartype expiration_time: ~datetime.datetime
    :ivar is_private_key_external: :code:`<code>true</code>` if private key is external; otherwise,
     :code:`<code>false</code>`.
    :vartype is_private_key_external: bool
    :ivar app_service_certificate_not_renewable_reasons: Reasons why App Service Certificate is not
     renewable at the current moment.
    :vartype app_service_certificate_not_renewable_reasons: list[str or
     ~azure.mgmt.web.v2015_08_01.models.ResourceNotRenewableReason]
    :ivar next_auto_renewal_time_stamp: Time stamp when the certificate would be auto renewed next.
    :vartype next_auto_renewal_time_stamp: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "domain_verification_token": {"readonly": True},
        "validity_in_years": {"maximum": 3, "minimum": 1},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "signed_certificate": {"readonly": True},
        "intermediate": {"readonly": True},
        "root": {"readonly": True},
        "serial_number": {"readonly": True},
        "last_certificate_issuance_time": {"readonly": True},
        "expiration_time": {"readonly": True},
        "is_private_key_external": {"readonly": True},
        "app_service_certificate_not_renewable_reasons": {"readonly": True},
        "next_auto_renewal_time_stamp": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "certificates": {"key": "properties.certificates", "type": "{AppServiceCertificate}"},
        "distinguished_name": {"key": "properties.distinguishedName", "type": "str"},
        "domain_verification_token": {"key": "properties.domainVerificationToken", "type": "str"},
        "validity_in_years": {"key": "properties.validityInYears", "type": "int"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "product_type": {"key": "properties.productType", "type": "str"},
        "auto_renew": {"key": "properties.autoRenew", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "signed_certificate": {"key": "properties.signedCertificate", "type": "CertificateDetails"},
        "csr": {"key": "properties.csr", "type": "str"},
        "intermediate": {"key": "properties.intermediate", "type": "CertificateDetails"},
        "root": {"key": "properties.root", "type": "CertificateDetails"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "last_certificate_issuance_time": {"key": "properties.lastCertificateIssuanceTime", "type": "iso-8601"},
        "expiration_time": {"key": "properties.expirationTime", "type": "iso-8601"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
        "app_service_certificate_not_renewable_reasons": {
            "key": "properties.appServiceCertificateNotRenewableReasons",
            "type": "[str]",
        },
        "next_auto_renewal_time_stamp": {"key": "properties.nextAutoRenewalTimeStamp", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        certificates: Optional[Dict[str, "_models.AppServiceCertificate"]] = None,
        distinguished_name: Optional[str] = None,
        validity_in_years: int = 1,
        key_size: int = 2048,
        product_type: Optional[Union[str, "_models.CertificateProductType"]] = None,
        auto_renew: bool = True,
        csr: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword certificates: State of the Key Vault secret.
        :paramtype certificates: dict[str, ~azure.mgmt.web.v2015_08_01.models.AppServiceCertificate]
        :keyword distinguished_name: Certificate distinguished name.
        :paramtype distinguished_name: str
        :keyword validity_in_years: Duration in years (must be between 1 and 3).
        :paramtype validity_in_years: int
        :keyword key_size: Certificate key size.
        :paramtype key_size: int
        :keyword product_type: Certificate product type. Known values are: "StandardDomainValidatedSsl"
         and "StandardDomainValidatedWildCardSsl".
        :paramtype product_type: str or ~azure.mgmt.web.v2015_08_01.models.CertificateProductType
        :keyword auto_renew: :code:`<code>true</code>` if the certificate should be automatically
         renewed when it expires; otherwise, :code:`<code>false</code>`.
        :paramtype auto_renew: bool
        :keyword csr: Last CSR that was created for this order.
        :paramtype csr: str
        """
        super().__init__(kind=kind, **kwargs)
        self.certificates = certificates
        self.distinguished_name = distinguished_name
        self.domain_verification_token = None
        self.validity_in_years = validity_in_years
        self.key_size = key_size
        self.product_type = product_type
        self.auto_renew = auto_renew
        self.provisioning_state = None
        self.status = None
        self.signed_certificate = None
        self.csr = csr
        self.intermediate = None
        self.root = None
        self.serial_number = None
        self.last_certificate_issuance_time = None
        self.expiration_time = None
        self.is_private_key_external = None
        self.app_service_certificate_not_renewable_reasons = None
        self.next_auto_renewal_time_stamp = None


class AppServiceCertificatePatchResource(ProxyOnlyResource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key_vault_id: Key Vault resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2015_08_01.models.KeyVaultSecretStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key_vault_id: Key Vault resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        """
        super().__init__(kind=kind, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class AppServiceCertificateResource(Resource):
    """Key Vault container ARM resource for a certificate that is purchased through Azure.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar location: Resource Location. Required.
    :vartype location: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar key_vault_id: Key Vault resource Id.
    :vartype key_vault_id: str
    :ivar key_vault_secret_name: Key Vault secret name.
    :vartype key_vault_secret_name: str
    :ivar provisioning_state: Status of the Key Vault secret. Known values are: "Initialized",
     "WaitingOnCertificateOrder", "Succeeded", "CertificateOrderFailed",
     "OperationNotPermittedOnKeyVault", "AzureServiceUnauthorizedToAccessKeyVault",
     "KeyVaultDoesNotExist", "KeyVaultSecretDoesNotExist", "UnknownError", "ExternalPrivateKey", and
     "Unknown".
    :vartype provisioning_state: str or ~azure.mgmt.web.v2015_08_01.models.KeyVaultSecretStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "location": {"required": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "key_vault_id": {"key": "properties.keyVaultId", "type": "str"},
        "key_vault_secret_name": {"key": "properties.keyVaultSecretName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        kind: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        key_vault_id: Optional[str] = None,
        key_vault_secret_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword location: Resource Location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword key_vault_id: Key Vault resource Id.
        :paramtype key_vault_id: str
        :keyword key_vault_secret_name: Key Vault secret name.
        :paramtype key_vault_secret_name: str
        """
        super().__init__(kind=kind, location=location, tags=tags, **kwargs)
        self.key_vault_id = key_vault_id
        self.key_vault_secret_name = key_vault_secret_name
        self.provisioning_state = None


class CertificateDetails(_serialization.Model):
    """SSL certificate details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: Certificate Version.
    :vartype version: int
    :ivar serial_number: Certificate Serial Number.
    :vartype serial_number: str
    :ivar thumbprint: Certificate Thumbprint.
    :vartype thumbprint: str
    :ivar subject: Certificate Subject.
    :vartype subject: str
    :ivar not_before: Date Certificate is valid from.
    :vartype not_before: ~datetime.datetime
    :ivar not_after: Date Certificate is valid to.
    :vartype not_after: ~datetime.datetime
    :ivar signature_algorithm: Certificate Signature algorithm.
    :vartype signature_algorithm: str
    :ivar issuer: Certificate Issuer.
    :vartype issuer: str
    :ivar raw_data: Raw certificate data.
    :vartype raw_data: str
    """

    _validation = {
        "version": {"readonly": True},
        "serial_number": {"readonly": True},
        "thumbprint": {"readonly": True},
        "subject": {"readonly": True},
        "not_before": {"readonly": True},
        "not_after": {"readonly": True},
        "signature_algorithm": {"readonly": True},
        "issuer": {"readonly": True},
        "raw_data": {"readonly": True},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "int"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "subject": {"key": "subject", "type": "str"},
        "not_before": {"key": "notBefore", "type": "iso-8601"},
        "not_after": {"key": "notAfter", "type": "iso-8601"},
        "signature_algorithm": {"key": "signatureAlgorithm", "type": "str"},
        "issuer": {"key": "issuer", "type": "str"},
        "raw_data": {"key": "rawData", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.version = None
        self.serial_number = None
        self.thumbprint = None
        self.subject = None
        self.not_before = None
        self.not_after = None
        self.signature_algorithm = None
        self.issuer = None
        self.raw_data = None


class CertificateEmail(ProxyOnlyResource):
    """SSL certificate email.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar email_id: Email id.
    :vartype email_id: str
    :ivar time_stamp: Time stamp.
    :vartype time_stamp: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "email_id": {"key": "properties.emailId", "type": "str"},
        "time_stamp": {"key": "properties.timeStamp", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        email_id: Optional[str] = None,
        time_stamp: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword email_id: Email id.
        :paramtype email_id: str
        :keyword time_stamp: Time stamp.
        :paramtype time_stamp: ~datetime.datetime
        """
        super().__init__(kind=kind, **kwargs)
        self.email_id = email_id
        self.time_stamp = time_stamp


class CertificateOrderAction(ProxyOnlyResource):
    """Certificate order action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar type_properties_type: Action type. Known values are: "CertificateIssued",
     "CertificateOrderCanceled", "CertificateOrderCreated", "CertificateRevoked",
     "DomainValidationComplete", "FraudDetected", "OrgNameChange", "OrgValidationComplete",
     "SanDrop", "FraudCleared", "CertificateExpired", "CertificateExpirationWarning",
     "FraudDocumentationRequired", and "Unknown".
    :vartype type_properties_type: str or
     ~azure.mgmt.web.v2015_08_01.models.CertificateOrderActionType
    :ivar created_at: Time at which the certificate action was performed.
    :vartype created_at: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        type_properties_type: Optional[Union[str, "_models.CertificateOrderActionType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword type_properties_type: Action type. Known values are: "CertificateIssued",
         "CertificateOrderCanceled", "CertificateOrderCreated", "CertificateRevoked",
         "DomainValidationComplete", "FraudDetected", "OrgNameChange", "OrgValidationComplete",
         "SanDrop", "FraudCleared", "CertificateExpired", "CertificateExpirationWarning",
         "FraudDocumentationRequired", and "Unknown".
        :paramtype type_properties_type: str or
         ~azure.mgmt.web.v2015_08_01.models.CertificateOrderActionType
        :keyword created_at: Time at which the certificate action was performed.
        :paramtype created_at: ~datetime.datetime
        """
        super().__init__(kind=kind, **kwargs)
        self.type_properties_type = type_properties_type
        self.created_at = created_at


class CsmOperationCollection(_serialization.Model):
    """Collection of Azure resource manager operation metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: Collection of resources. Required.
    :vartype value: list[~azure.mgmt.web.v2015_08_01.models.CsmOperationDescription]
    :ivar next_link: Link to next page of resources.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CsmOperationDescription]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.CsmOperationDescription"], **kwargs: Any) -> None:
        """
        :keyword value: Collection of resources. Required.
        :paramtype value: list[~azure.mgmt.web.v2015_08_01.models.CsmOperationDescription]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class CsmOperationDescription(_serialization.Model):
    """Description of an operation available for Microsoft.Web resource provider.

    :ivar name:
    :vartype name: str
    :ivar display: Meta data about operation used for display in portal.
    :vartype display: ~azure.mgmt.web.v2015_08_01.models.CsmOperationDisplay
    :ivar origin:
    :vartype origin: str
    :ivar properties: Properties available for a Microsoft.Web resource provider operation.
    :vartype properties: ~azure.mgmt.web.v2015_08_01.models.CsmOperationDescriptionProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "CsmOperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "CsmOperationDescriptionProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.CsmOperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.CsmOperationDescriptionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display: Meta data about operation used for display in portal.
        :paramtype display: ~azure.mgmt.web.v2015_08_01.models.CsmOperationDisplay
        :keyword origin:
        :paramtype origin: str
        :keyword properties: Properties available for a Microsoft.Web resource provider operation.
        :paramtype properties: ~azure.mgmt.web.v2015_08_01.models.CsmOperationDescriptionProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class CsmOperationDescriptionProperties(_serialization.Model):
    """Properties available for a Microsoft.Web resource provider operation.

    :ivar service_specification: Resource metrics service provided by Microsoft.Insights resource
     provider.
    :vartype service_specification: ~azure.mgmt.web.v2015_08_01.models.ServiceSpecification
    """

    _attribute_map = {
        "service_specification": {"key": "serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self, *, service_specification: Optional["_models.ServiceSpecification"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword service_specification: Resource metrics service provided by Microsoft.Insights
         resource provider.
        :paramtype service_specification: ~azure.mgmt.web.v2015_08_01.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.service_specification = service_specification


class CsmOperationDisplay(_serialization.Model):
    """Meta data about operation used for display in portal.

    :ivar provider:
    :vartype provider: str
    :ivar resource:
    :vartype resource: str
    :ivar operation:
    :vartype operation: str
    :ivar description:
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider:
        :paramtype provider: str
        :keyword resource:
        :paramtype resource: str
        :keyword operation:
        :paramtype operation: str
        :keyword description:
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class Dimension(_serialization.Model):
    """Dimension of a resource metric. For e.g. instance specific HTTP requests for a web app,
    where instance name is dimension of the metric HTTP request.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar internal_name:
    :vartype internal_name: str
    :ivar to_be_exported_for_shoebox:
    :vartype to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "internal_name": {"key": "internalName", "type": "str"},
        "to_be_exported_for_shoebox": {"key": "toBeExportedForShoebox", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword internal_name:
        :paramtype internal_name: str
        :keyword to_be_exported_for_shoebox:
        :paramtype to_be_exported_for_shoebox: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class MetricAvailability(_serialization.Model):
    """Retention policy of a resource metric.

    :ivar time_grain:
    :vartype time_grain: str
    :ivar blob_duration:
    :vartype blob_duration: str
    """

    _attribute_map = {
        "time_grain": {"key": "timeGrain", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(self, *, time_grain: Optional[str] = None, blob_duration: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword time_grain:
        :paramtype time_grain: str
        :keyword blob_duration:
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.time_grain = time_grain
        self.blob_duration = blob_duration


class MetricSpecification(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Definition of a single resource metric.

    :ivar name:
    :vartype name: str
    :ivar display_name:
    :vartype display_name: str
    :ivar display_description:
    :vartype display_description: str
    :ivar unit:
    :vartype unit: str
    :ivar aggregation_type:
    :vartype aggregation_type: str
    :ivar supports_instance_level_aggregation:
    :vartype supports_instance_level_aggregation: bool
    :ivar enable_regional_mdm_account:
    :vartype enable_regional_mdm_account: bool
    :ivar source_mdm_account:
    :vartype source_mdm_account: str
    :ivar source_mdm_namespace:
    :vartype source_mdm_namespace: str
    :ivar metric_filter_pattern:
    :vartype metric_filter_pattern: str
    :ivar fill_gap_with_zero:
    :vartype fill_gap_with_zero: bool
    :ivar is_internal:
    :vartype is_internal: bool
    :ivar dimensions:
    :vartype dimensions: list[~azure.mgmt.web.v2015_08_01.models.Dimension]
    :ivar category:
    :vartype category: str
    :ivar availabilities:
    :vartype availabilities: list[~azure.mgmt.web.v2015_08_01.models.MetricAvailability]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "supports_instance_level_aggregation": {"key": "supportsInstanceLevelAggregation", "type": "bool"},
        "enable_regional_mdm_account": {"key": "enableRegionalMdmAccount", "type": "bool"},
        "source_mdm_account": {"key": "sourceMdmAccount", "type": "str"},
        "source_mdm_namespace": {"key": "sourceMdmNamespace", "type": "str"},
        "metric_filter_pattern": {"key": "metricFilterPattern", "type": "str"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "is_internal": {"key": "isInternal", "type": "bool"},
        "dimensions": {"key": "dimensions", "type": "[Dimension]"},
        "category": {"key": "category", "type": "str"},
        "availabilities": {"key": "availabilities", "type": "[MetricAvailability]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supports_instance_level_aggregation: Optional[bool] = None,
        enable_regional_mdm_account: Optional[bool] = None,
        source_mdm_account: Optional[str] = None,
        source_mdm_namespace: Optional[str] = None,
        metric_filter_pattern: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        is_internal: Optional[bool] = None,
        dimensions: Optional[List["_models.Dimension"]] = None,
        category: Optional[str] = None,
        availabilities: Optional[List["_models.MetricAvailability"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword display_name:
        :paramtype display_name: str
        :keyword display_description:
        :paramtype display_description: str
        :keyword unit:
        :paramtype unit: str
        :keyword aggregation_type:
        :paramtype aggregation_type: str
        :keyword supports_instance_level_aggregation:
        :paramtype supports_instance_level_aggregation: bool
        :keyword enable_regional_mdm_account:
        :paramtype enable_regional_mdm_account: bool
        :keyword source_mdm_account:
        :paramtype source_mdm_account: str
        :keyword source_mdm_namespace:
        :paramtype source_mdm_namespace: str
        :keyword metric_filter_pattern:
        :paramtype metric_filter_pattern: str
        :keyword fill_gap_with_zero:
        :paramtype fill_gap_with_zero: bool
        :keyword is_internal:
        :paramtype is_internal: bool
        :keyword dimensions:
        :paramtype dimensions: list[~azure.mgmt.web.v2015_08_01.models.Dimension]
        :keyword category:
        :paramtype category: str
        :keyword availabilities:
        :paramtype availabilities: list[~azure.mgmt.web.v2015_08_01.models.MetricAvailability]
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.supports_instance_level_aggregation = supports_instance_level_aggregation
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.source_mdm_account = source_mdm_account
        self.source_mdm_namespace = source_mdm_namespace
        self.metric_filter_pattern = metric_filter_pattern
        self.fill_gap_with_zero = fill_gap_with_zero
        self.is_internal = is_internal
        self.dimensions = dimensions
        self.category = category
        self.availabilities = availabilities


class NameIdentifier(_serialization.Model):
    """Identifies an object.

    :ivar name: Name of the object.
    :vartype name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the object.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class ReissueCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate reissue request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key_size: Certificate Key Size.
    :vartype key_size: int
    :ivar delay_existing_revoke_in_hours: Delay in hours to revoke existing certificate after the
     new certificate is issued.
    :vartype delay_existing_revoke_in_hours: int
    :ivar csr: Csr to be used for re-key operation.
    :vartype csr: str
    :ivar is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :vartype is_private_key_external: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "delay_existing_revoke_in_hours": {"key": "properties.delayExistingRevokeInHours", "type": "int"},
        "csr": {"key": "properties.csr", "type": "str"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_size: Optional[int] = None,
        delay_existing_revoke_in_hours: Optional[int] = None,
        csr: Optional[str] = None,
        is_private_key_external: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key_size: Certificate Key Size.
        :paramtype key_size: int
        :keyword delay_existing_revoke_in_hours: Delay in hours to revoke existing certificate after
         the new certificate is issued.
        :paramtype delay_existing_revoke_in_hours: int
        :keyword csr: Csr to be used for re-key operation.
        :paramtype csr: str
        :keyword is_private_key_external: Should we change the ASC type (from managed private key to
         external private key and vice versa).
        :paramtype is_private_key_external: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.delay_existing_revoke_in_hours = delay_existing_revoke_in_hours
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class RenewCertificateOrderRequest(ProxyOnlyResource):
    """Class representing certificate renew request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar kind: Kind of resource.
    :vartype kind: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar key_size: Certificate Key Size.
    :vartype key_size: int
    :ivar csr: Csr to be used for re-key operation.
    :vartype csr: str
    :ivar is_private_key_external: Should we change the ASC type (from managed private key to
     external private key and vice versa).
    :vartype is_private_key_external: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "key_size": {"key": "properties.keySize", "type": "int"},
        "csr": {"key": "properties.csr", "type": "str"},
        "is_private_key_external": {"key": "properties.isPrivateKeyExternal", "type": "bool"},
    }

    def __init__(
        self,
        *,
        kind: Optional[str] = None,
        key_size: Optional[int] = None,
        csr: Optional[str] = None,
        is_private_key_external: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of resource.
        :paramtype kind: str
        :keyword key_size: Certificate Key Size.
        :paramtype key_size: int
        :keyword csr: Csr to be used for re-key operation.
        :paramtype csr: str
        :keyword is_private_key_external: Should we change the ASC type (from managed private key to
         external private key and vice versa).
        :paramtype is_private_key_external: bool
        """
        super().__init__(kind=kind, **kwargs)
        self.key_size = key_size
        self.csr = csr
        self.is_private_key_external = is_private_key_external


class ServiceSpecification(_serialization.Model):
    """Resource metrics service provided by Microsoft.Insights resource provider.

    :ivar metric_specifications:
    :vartype metric_specifications: list[~azure.mgmt.web.v2015_08_01.models.MetricSpecification]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
    }

    def __init__(
        self, *, metric_specifications: Optional[List["_models.MetricSpecification"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword metric_specifications:
        :paramtype metric_specifications: list[~azure.mgmt.web.v2015_08_01.models.MetricSpecification]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications


class SiteSeal(_serialization.Model):
    """Site seal.

    All required parameters must be populated in order to send to server.

    :ivar html: HTML snippet. Required.
    :vartype html: str
    """

    _validation = {
        "html": {"required": True},
    }

    _attribute_map = {
        "html": {"key": "html", "type": "str"},
    }

    def __init__(self, *, html: str, **kwargs: Any) -> None:
        """
        :keyword html: HTML snippet. Required.
        :paramtype html: str
        """
        super().__init__(**kwargs)
        self.html = html


class SiteSealRequest(_serialization.Model):
    """Site seal request.

    :ivar light_theme: If :code:`<code>true</code>` use the light color theme for site seal;
     otherwise, use the default color theme.
    :vartype light_theme: bool
    :ivar locale: Locale of site seal.
    :vartype locale: str
    """

    _attribute_map = {
        "light_theme": {"key": "lightTheme", "type": "bool"},
        "locale": {"key": "locale", "type": "str"},
    }

    def __init__(self, *, light_theme: Optional[bool] = None, locale: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword light_theme: If :code:`<code>true</code>` use the light color theme for site seal;
         otherwise, use the default color theme.
        :paramtype light_theme: bool
        :keyword locale: Locale of site seal.
        :paramtype locale: str
        """
        super().__init__(**kwargs)
        self.light_theme = light_theme
        self.locale = locale
