/* Clapper Playback Library
 * Copyright (C) 2024 Rafał Dzięgiel <rafostar.github@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#pragma once

#if !defined(__CLAPPER_INSIDE__) && !defined(CLAPPER_COMPILATION)
#error "Only <clapper/clapper.h> can be included directly."
#endif

/**
 * CLAPPER_MAJOR_VERSION:
 *
 * Clapper major version component
 */
#define CLAPPER_MAJOR_VERSION            (0)

/**
 * CLAPPER_MINOR_VERSION:
 *
 * Clapper minor version component
 */
#define CLAPPER_MINOR_VERSION            (8)

/**
 * CLAPPER_MICRO_VERSION:
 *
 * Clapper micro version component
 */
#define CLAPPER_MICRO_VERSION            (0)

/**
 * CLAPPER_VERSION:
 *
 * Clapper version
 */
#define CLAPPER_VERSION                  (0.8.0)

/**
 * CLAPPER_VERSION_S:
 *
 * Clapper version, encoded as a string
 */
#define CLAPPER_VERSION_S                "0.8.0"

#define CLAPPER_ENCODE_VERSION(major,minor,micro) \
    ((major) << 24 | (minor) << 16 | (micro) << 8)

/**
 * CLAPPER_VERSION_HEX:
 *
 * Clapper version, encoded as an hexadecimal number, useful for integer comparisons.
 */
#define CLAPPER_VERSION_HEX \
    (CLAPPER_ENCODE_VERSION (CLAPPER_MAJOR_VERSION, CLAPPER_MINOR_VERSION, CLAPPER_MICRO_VERSION))

#define CLAPPER_CHECK_VERSION(major, minor, micro)                           \
    (CLAPPER_MAJOR_VERSION > (major) ||                                      \
    (CLAPPER_MAJOR_VERSION == (major) && CLAPPER_MINOR_VERSION > (minor)) || \
    (CLAPPER_MAJOR_VERSION == (major) && CLAPPER_MINOR_VERSION == (minor) && \
    CLAPPER_MICRO_VERSION >= (micro)))
