/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.memory;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.util.NativeMemoryCacheKeyHelper;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.index.memory.NativeMemoryAllocation;
import org.opensearch.knn.index.memory.NativeMemoryLoadStrategy;
import org.opensearch.knn.index.store.IndexInputWithBuffer;

public abstract class NativeMemoryEntryContext<T extends NativeMemoryAllocation>
implements AutoCloseable {
    protected final String key;

    public NativeMemoryEntryContext(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public abstract Integer calculateSizeInKB();

    public void openVectorIndex() {
    }

    @Override
    public void close() {
    }

    public abstract T load() throws IOException;

    public static class AnonymousEntryContext
    extends NativeMemoryEntryContext<NativeMemoryAllocation.AnonymousAllocation> {
        private final int size;
        private final NativeMemoryLoadStrategy.AnonymousLoadStrategy loadStrategy;

        public AnonymousEntryContext(int size, NativeMemoryLoadStrategy.AnonymousLoadStrategy loadStrategy) {
            super(UUID.randomUUID().toString());
            this.size = size;
            this.loadStrategy = loadStrategy;
        }

        @Override
        public Integer calculateSizeInKB() {
            return this.size;
        }

        @Override
        public NativeMemoryAllocation.AnonymousAllocation load() throws IOException {
            return this.loadStrategy.load(this);
        }
    }

    public static class TrainingDataEntryContext
    extends NativeMemoryEntryContext<NativeMemoryAllocation.TrainingDataAllocation> {
        private static final String KEY_PREFIX = "tdata#";
        private static final String DELIMETER = ":";
        private final int size;
        private final NativeMemoryLoadStrategy.TrainingLoadStrategy trainingLoadStrategy;
        private final ClusterService clusterService;
        private final String trainIndexName;
        private final String trainFieldName;
        private final int maxVectorCount;
        private final int searchSize;
        private final VectorDataType vectorDataType;
        private final QuantizationConfig quantizationConfig;

        public TrainingDataEntryContext(int size, String trainIndexName, String trainFieldName, NativeMemoryLoadStrategy.TrainingLoadStrategy trainingLoadStrategy, ClusterService clusterService, int maxVectorCount, int searchSize, VectorDataType vectorDataType, QuantizationConfig quantizationConfig) {
            super(TrainingDataEntryContext.generateKey(trainIndexName, trainFieldName));
            this.size = size;
            this.trainingLoadStrategy = trainingLoadStrategy;
            this.trainIndexName = trainIndexName;
            this.trainFieldName = trainFieldName;
            this.clusterService = clusterService;
            this.maxVectorCount = maxVectorCount;
            this.searchSize = searchSize;
            this.vectorDataType = vectorDataType;
            this.quantizationConfig = quantizationConfig;
        }

        @Override
        public Integer calculateSizeInKB() {
            return this.size;
        }

        @Override
        public NativeMemoryAllocation.TrainingDataAllocation load() {
            return this.trainingLoadStrategy.load(this);
        }

        public String getTrainIndexName() {
            return this.trainIndexName;
        }

        public String getTrainFieldName() {
            return this.trainFieldName;
        }

        public int getMaxVectorCount() {
            return this.maxVectorCount;
        }

        public int getSearchSize() {
            return this.searchSize;
        }

        public ClusterService getClusterService() {
            return this.clusterService;
        }

        public VectorDataType getVectorDataType() {
            return this.vectorDataType;
        }

        private static String generateKey(String trainIndexName, String trainFieldName) {
            return KEY_PREFIX + trainIndexName + DELIMETER + trainFieldName;
        }

        @Generated
        public QuantizationConfig getQuantizationConfig() {
            return this.quantizationConfig;
        }
    }

    public static class IndexEntryContext
    extends NativeMemoryEntryContext<NativeMemoryAllocation.IndexAllocation> {
        @Generated
        private static final Logger log = LogManager.getLogger(IndexEntryContext.class);
        private final Directory directory;
        private final NativeMemoryLoadStrategy.IndexLoadStrategy indexLoadStrategy;
        private final String openSearchIndexName;
        private final Map<String, Object> parameters;
        @Nullable
        private final String modelId;
        private boolean indexGraphFileOpened = false;
        private int indexSizeKb;
        private IndexInput readStream;
        IndexInputWithBuffer indexInputWithBuffer;

        public IndexEntryContext(Directory directory, String vectorIndexCacheKey, NativeMemoryLoadStrategy.IndexLoadStrategy indexLoadStrategy, Map<String, Object> parameters, String openSearchIndexName) {
            this(directory, vectorIndexCacheKey, indexLoadStrategy, parameters, openSearchIndexName, null);
        }

        public IndexEntryContext(Directory directory, String vectorIndexCacheKey, NativeMemoryLoadStrategy.IndexLoadStrategy indexLoadStrategy, Map<String, Object> parameters, String openSearchIndexName, String modelId) {
            super(vectorIndexCacheKey);
            this.directory = directory;
            this.indexLoadStrategy = indexLoadStrategy;
            this.openSearchIndexName = openSearchIndexName;
            this.parameters = parameters;
            this.modelId = modelId;
        }

        @Override
        public Integer calculateSizeInKB() {
            String indexFileName = NativeMemoryCacheKeyHelper.extractVectorIndexFileName(this.key);
            try {
                long fileLength = this.directory.fileLength(indexFileName);
                return (int)(fileLength / 1024L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void openVectorIndex() {
            if (this.isIndexGraphFileOpened()) {
                return;
            }
            String cacheKey = this.getKey();
            String vectorFileName = NativeMemoryCacheKeyHelper.extractVectorIndexFileName(cacheKey);
            if (vectorFileName == null) {
                throw new IllegalStateException("Invalid cache key was given. The key [" + cacheKey + "] does not contain the corresponding vector file name.");
            }
            Directory directory = this.getDirectory();
            try {
                this.indexSizeKb = Math.toIntExact(directory.fileLength(vectorFileName) / 1024L);
                this.readStream = directory.openInput(vectorFileName, IOContext.READONCE);
                this.readStream.seek(0L);
                this.indexInputWithBuffer = new IndexInputWithBuffer(this.readStream);
                this.indexGraphFileOpened = true;
                log.debug("[KNN] NativeMemoryCacheManager openVectorIndex successful");
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to openVectorIndex the index " + this.openSearchIndexName);
            }
        }

        @Override
        public NativeMemoryAllocation.IndexAllocation load() throws IOException {
            if (!this.isIndexGraphFileOpened()) {
                throw new IllegalStateException("Index graph file is not open");
            }
            return this.indexLoadStrategy.load(this);
        }

        @Override
        public void close() {
            if (this.readStream != null) {
                try {
                    this.readStream.close();
                    this.indexGraphFileOpened = false;
                }
                catch (IOException e) {
                    throw new RuntimeException("Exception while closing the indexInput index [" + this.openSearchIndexName + "] for loading the graph file.", e);
                }
            }
        }

        @Generated
        public Directory getDirectory() {
            return this.directory;
        }

        @Generated
        public String getOpenSearchIndexName() {
            return this.openSearchIndexName;
        }

        @Generated
        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        @Generated
        public String getModelId() {
            return this.modelId;
        }

        @Generated
        public boolean isIndexGraphFileOpened() {
            return this.indexGraphFileOpened;
        }

        @Generated
        public int getIndexSizeKb() {
            return this.indexSizeKb;
        }

        @Generated
        public IndexInput getReadStream() {
            return this.readStream;
        }

        @Generated
        public IndexInputWithBuffer getIndexInputWithBuffer() {
            return this.indexInputWithBuffer;
        }
    }
}

