"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getComponentNames = getComponentNames;
exports._getComponentNames = _getComponentNames;
const language_core_1 = require("@vue/language-core");
const utils_1 = require("./utils");
function getComponentNames(fileName) {
    const { typescript: ts, language, languageService, getFileId } = this;
    const volarFile = language.scripts.get(getFileId(fileName));
    if (!(volarFile?.generated?.root instanceof language_core_1.VueVirtualCode)) {
        return;
    }
    const vueCode = volarFile.generated.root;
    return _getComponentNames(ts, languageService, vueCode);
}
function _getComponentNames(ts, tsLs, vueCode) {
    const names = (0, utils_1.getVariableType)(ts, tsLs, vueCode, '__VLS_components')
        ?.type
        ?.getProperties()
        .map(c => c.name)
        .filter(entry => !entry.includes('$') && !entry.startsWith('_'))
        ?? [];
    names.push((0, utils_1.getSelfComponentName)(vueCode.fileName));
    return names;
}
//# sourceMappingURL=getComponentNames.js.map