<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: opentelemetry/proto/trace/v1/trace.proto

namespace Opentelemetry\Proto\Trace\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Span represents a single operation performed by a single component of the system.
 * The next available field id is 17.
 *
 * Generated from protobuf message <code>opentelemetry.proto.trace.v1.Span</code>
 */
class Span extends \Google\Protobuf\Internal\Message
{
    /**
     * A unique identifier for a trace. All spans from the same trace share
     * the same `trace_id`. The ID is a 16-byte array. An ID with all zeroes OR
     * of length other than 16 bytes is considered invalid (empty string in OTLP/JSON
     * is zero-length and thus is also invalid).
     * This field is required.
     *
     * Generated from protobuf field <code>bytes trace_id = 1;</code>
     */
    protected $trace_id = '';
    /**
     * A unique identifier for a span within a trace, assigned when the span
     * is created. The ID is an 8-byte array. An ID with all zeroes OR of length
     * other than 8 bytes is considered invalid (empty string in OTLP/JSON
     * is zero-length and thus is also invalid).
     * This field is required.
     *
     * Generated from protobuf field <code>bytes span_id = 2;</code>
     */
    protected $span_id = '';
    /**
     * trace_state conveys information about request position in multiple distributed tracing graphs.
     * It is a trace_state in w3c-trace-context format: https://www.w3.org/TR/trace-context/#tracestate-header
     * See also https://github.com/w3c/distributed-tracing for more details about this field.
     *
     * Generated from protobuf field <code>string trace_state = 3;</code>
     */
    protected $trace_state = '';
    /**
     * The `span_id` of this span's parent span. If this is a root span, then this
     * field must be empty. The ID is an 8-byte array.
     *
     * Generated from protobuf field <code>bytes parent_span_id = 4;</code>
     */
    protected $parent_span_id = '';
    /**
     * A description of the span's operation.
     * For example, the name can be a qualified method name or a file name
     * and a line number where the operation is called. A best practice is to use
     * the same display name at the same call point in an application.
     * This makes it easier to correlate spans in different traces.
     * This field is semantically required to be set to non-empty string.
     * Empty value is equivalent to an unknown span name.
     * This field is required.
     *
     * Generated from protobuf field <code>string name = 5;</code>
     */
    protected $name = '';
    /**
     * Distinguishes between spans generated in a particular context. For example,
     * two spans with the same name may be distinguished using `CLIENT` (caller)
     * and `SERVER` (callee) to identify queueing latency associated with the span.
     *
     * Generated from protobuf field <code>.opentelemetry.proto.trace.v1.Span.SpanKind kind = 6;</code>
     */
    protected $kind = 0;
    /**
     * start_time_unix_nano is the start time of the span. On the client side, this is the time
     * kept by the local machine where the span execution starts. On the server side, this
     * is the time when the server's application handler starts running.
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
     * This field is semantically required and it is expected that end_time >= start_time.
     *
     * Generated from protobuf field <code>fixed64 start_time_unix_nano = 7;</code>
     */
    protected $start_time_unix_nano = 0;
    /**
     * end_time_unix_nano is the end time of the span. On the client side, this is the time
     * kept by the local machine where the span execution ends. On the server side, this
     * is the time when the server application handler stops running.
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
     * This field is semantically required and it is expected that end_time >= start_time.
     *
     * Generated from protobuf field <code>fixed64 end_time_unix_nano = 8;</code>
     */
    protected $end_time_unix_nano = 0;
    /**
     * attributes is a collection of key/value pairs. Note, global attributes
     * like server name can be set using the resource API. Examples of attributes:
     *     "/http/user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36"
     *     "/http/server_latency": 300
     *     "example.com/myattribute": true
     *     "example.com/score": 10.239
     * The OpenTelemetry API specification further restricts the allowed value types:
     * https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/common/README.md#attribute
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     *
     * Generated from protobuf field <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     */
    private $attributes;
    /**
     * dropped_attributes_count is the number of attributes that were discarded. Attributes
     * can be discarded because their keys are too long or because there are too many
     * attributes. If this value is 0, then no attributes were dropped.
     *
     * Generated from protobuf field <code>uint32 dropped_attributes_count = 10;</code>
     */
    protected $dropped_attributes_count = 0;
    /**
     * events is a collection of Event items.
     *
     * Generated from protobuf field <code>repeated .opentelemetry.proto.trace.v1.Span.Event events = 11;</code>
     */
    private $events;
    /**
     * dropped_events_count is the number of dropped events. If the value is 0, then no
     * events were dropped.
     *
     * Generated from protobuf field <code>uint32 dropped_events_count = 12;</code>
     */
    protected $dropped_events_count = 0;
    /**
     * links is a collection of Links, which are references from this span to a span
     * in the same or different trace.
     *
     * Generated from protobuf field <code>repeated .opentelemetry.proto.trace.v1.Span.Link links = 13;</code>
     */
    private $links;
    /**
     * dropped_links_count is the number of dropped links after the maximum size was
     * enforced. If this value is 0, then no links were dropped.
     *
     * Generated from protobuf field <code>uint32 dropped_links_count = 14;</code>
     */
    protected $dropped_links_count = 0;
    /**
     * An optional final status for this span. Semantically when Status isn't set, it means
     * span's status code is unset, i.e. assume STATUS_CODE_UNSET (code = 0).
     *
     * Generated from protobuf field <code>.opentelemetry.proto.trace.v1.Status status = 15;</code>
     */
    protected $status = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $trace_id
     *           A unique identifier for a trace. All spans from the same trace share
     *           the same `trace_id`. The ID is a 16-byte array. An ID with all zeroes OR
     *           of length other than 16 bytes is considered invalid (empty string in OTLP/JSON
     *           is zero-length and thus is also invalid).
     *           This field is required.
     *     @type string $span_id
     *           A unique identifier for a span within a trace, assigned when the span
     *           is created. The ID is an 8-byte array. An ID with all zeroes OR of length
     *           other than 8 bytes is considered invalid (empty string in OTLP/JSON
     *           is zero-length and thus is also invalid).
     *           This field is required.
     *     @type string $trace_state
     *           trace_state conveys information about request position in multiple distributed tracing graphs.
     *           It is a trace_state in w3c-trace-context format: https://www.w3.org/TR/trace-context/#tracestate-header
     *           See also https://github.com/w3c/distributed-tracing for more details about this field.
     *     @type string $parent_span_id
     *           The `span_id` of this span's parent span. If this is a root span, then this
     *           field must be empty. The ID is an 8-byte array.
     *     @type string $name
     *           A description of the span's operation.
     *           For example, the name can be a qualified method name or a file name
     *           and a line number where the operation is called. A best practice is to use
     *           the same display name at the same call point in an application.
     *           This makes it easier to correlate spans in different traces.
     *           This field is semantically required to be set to non-empty string.
     *           Empty value is equivalent to an unknown span name.
     *           This field is required.
     *     @type int $kind
     *           Distinguishes between spans generated in a particular context. For example,
     *           two spans with the same name may be distinguished using `CLIENT` (caller)
     *           and `SERVER` (callee) to identify queueing latency associated with the span.
     *     @type int|string $start_time_unix_nano
     *           start_time_unix_nano is the start time of the span. On the client side, this is the time
     *           kept by the local machine where the span execution starts. On the server side, this
     *           is the time when the server's application handler starts running.
     *           Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
     *           This field is semantically required and it is expected that end_time >= start_time.
     *     @type int|string $end_time_unix_nano
     *           end_time_unix_nano is the end time of the span. On the client side, this is the time
     *           kept by the local machine where the span execution ends. On the server side, this
     *           is the time when the server application handler stops running.
     *           Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
     *           This field is semantically required and it is expected that end_time >= start_time.
     *     @type \Opentelemetry\Proto\Common\V1\KeyValue[]|\Google\Protobuf\Internal\RepeatedField $attributes
     *           attributes is a collection of key/value pairs. Note, global attributes
     *           like server name can be set using the resource API. Examples of attributes:
     *               "/http/user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36"
     *               "/http/server_latency": 300
     *               "example.com/myattribute": true
     *               "example.com/score": 10.239
     *           The OpenTelemetry API specification further restricts the allowed value types:
     *           https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/common/README.md#attribute
     *           Attribute keys MUST be unique (it is not allowed to have more than one
     *           attribute with the same key).
     *     @type int $dropped_attributes_count
     *           dropped_attributes_count is the number of attributes that were discarded. Attributes
     *           can be discarded because their keys are too long or because there are too many
     *           attributes. If this value is 0, then no attributes were dropped.
     *     @type \Opentelemetry\Proto\Trace\V1\Span\Event[]|\Google\Protobuf\Internal\RepeatedField $events
     *           events is a collection of Event items.
     *     @type int $dropped_events_count
     *           dropped_events_count is the number of dropped events. If the value is 0, then no
     *           events were dropped.
     *     @type \Opentelemetry\Proto\Trace\V1\Span\Link[]|\Google\Protobuf\Internal\RepeatedField $links
     *           links is a collection of Links, which are references from this span to a span
     *           in the same or different trace.
     *     @type int $dropped_links_count
     *           dropped_links_count is the number of dropped links after the maximum size was
     *           enforced. If this value is 0, then no links were dropped.
     *     @type \Opentelemetry\Proto\Trace\V1\Status $status
     *           An optional final status for this span. Semantically when Status isn't set, it means
     *           span's status code is unset, i.e. assume STATUS_CODE_UNSET (code = 0).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Opentelemetry\Proto\Trace\V1\Trace::initOnce();
        parent::__construct($data);
    }

    /**
     * A unique identifier for a trace. All spans from the same trace share
     * the same `trace_id`. The ID is a 16-byte array. An ID with all zeroes OR
     * of length other than 16 bytes is considered invalid (empty string in OTLP/JSON
     * is zero-length and thus is also invalid).
     * This field is required.
     *
     * Generated from protobuf field <code>bytes trace_id = 1;</code>
     * @return string
     */
    public function getTraceId()
    {
        return $this->trace_id;
    }

    /**
     * A unique identifier for a trace. All spans from the same trace share
     * the same `trace_id`. The ID is a 16-byte array. An ID with all zeroes OR
     * of length other than 16 bytes is considered invalid (empty string in OTLP/JSON
     * is zero-length and thus is also invalid).
     * This field is required.
     *
     * Generated from protobuf field <code>bytes trace_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setTraceId($var)
    {
        GPBUtil::checkString($var, False);
        $this->trace_id = $var;

        return $this;
    }

    /**
     * A unique identifier for a span within a trace, assigned when the span
     * is created. The ID is an 8-byte array. An ID with all zeroes OR of length
     * other than 8 bytes is considered invalid (empty string in OTLP/JSON
     * is zero-length and thus is also invalid).
     * This field is required.
     *
     * Generated from protobuf field <code>bytes span_id = 2;</code>
     * @return string
     */
    public function getSpanId()
    {
        return $this->span_id;
    }

    /**
     * A unique identifier for a span within a trace, assigned when the span
     * is created. The ID is an 8-byte array. An ID with all zeroes OR of length
     * other than 8 bytes is considered invalid (empty string in OTLP/JSON
     * is zero-length and thus is also invalid).
     * This field is required.
     *
     * Generated from protobuf field <code>bytes span_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setSpanId($var)
    {
        GPBUtil::checkString($var, False);
        $this->span_id = $var;

        return $this;
    }

    /**
     * trace_state conveys information about request position in multiple distributed tracing graphs.
     * It is a trace_state in w3c-trace-context format: https://www.w3.org/TR/trace-context/#tracestate-header
     * See also https://github.com/w3c/distributed-tracing for more details about this field.
     *
     * Generated from protobuf field <code>string trace_state = 3;</code>
     * @return string
     */
    public function getTraceState()
    {
        return $this->trace_state;
    }

    /**
     * trace_state conveys information about request position in multiple distributed tracing graphs.
     * It is a trace_state in w3c-trace-context format: https://www.w3.org/TR/trace-context/#tracestate-header
     * See also https://github.com/w3c/distributed-tracing for more details about this field.
     *
     * Generated from protobuf field <code>string trace_state = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setTraceState($var)
    {
        GPBUtil::checkString($var, True);
        $this->trace_state = $var;

        return $this;
    }

    /**
     * The `span_id` of this span's parent span. If this is a root span, then this
     * field must be empty. The ID is an 8-byte array.
     *
     * Generated from protobuf field <code>bytes parent_span_id = 4;</code>
     * @return string
     */
    public function getParentSpanId()
    {
        return $this->parent_span_id;
    }

    /**
     * The `span_id` of this span's parent span. If this is a root span, then this
     * field must be empty. The ID is an 8-byte array.
     *
     * Generated from protobuf field <code>bytes parent_span_id = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setParentSpanId($var)
    {
        GPBUtil::checkString($var, False);
        $this->parent_span_id = $var;

        return $this;
    }

    /**
     * A description of the span's operation.
     * For example, the name can be a qualified method name or a file name
     * and a line number where the operation is called. A best practice is to use
     * the same display name at the same call point in an application.
     * This makes it easier to correlate spans in different traces.
     * This field is semantically required to be set to non-empty string.
     * Empty value is equivalent to an unknown span name.
     * This field is required.
     *
     * Generated from protobuf field <code>string name = 5;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * A description of the span's operation.
     * For example, the name can be a qualified method name or a file name
     * and a line number where the operation is called. A best practice is to use
     * the same display name at the same call point in an application.
     * This makes it easier to correlate spans in different traces.
     * This field is semantically required to be set to non-empty string.
     * Empty value is equivalent to an unknown span name.
     * This field is required.
     *
     * Generated from protobuf field <code>string name = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Distinguishes between spans generated in a particular context. For example,
     * two spans with the same name may be distinguished using `CLIENT` (caller)
     * and `SERVER` (callee) to identify queueing latency associated with the span.
     *
     * Generated from protobuf field <code>.opentelemetry.proto.trace.v1.Span.SpanKind kind = 6;</code>
     * @return int
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * Distinguishes between spans generated in a particular context. For example,
     * two spans with the same name may be distinguished using `CLIENT` (caller)
     * and `SERVER` (callee) to identify queueing latency associated with the span.
     *
     * Generated from protobuf field <code>.opentelemetry.proto.trace.v1.Span.SpanKind kind = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkEnum($var, \Opentelemetry\Proto\Trace\V1\Span\SpanKind::class);
        $this->kind = $var;

        return $this;
    }

    /**
     * start_time_unix_nano is the start time of the span. On the client side, this is the time
     * kept by the local machine where the span execution starts. On the server side, this
     * is the time when the server's application handler starts running.
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
     * This field is semantically required and it is expected that end_time >= start_time.
     *
     * Generated from protobuf field <code>fixed64 start_time_unix_nano = 7;</code>
     * @return int|string
     */
    public function getStartTimeUnixNano()
    {
        return $this->start_time_unix_nano;
    }

    /**
     * start_time_unix_nano is the start time of the span. On the client side, this is the time
     * kept by the local machine where the span execution starts. On the server side, this
     * is the time when the server's application handler starts running.
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
     * This field is semantically required and it is expected that end_time >= start_time.
     *
     * Generated from protobuf field <code>fixed64 start_time_unix_nano = 7;</code>
     * @param int|string $var
     * @return $this
     */
    public function setStartTimeUnixNano($var)
    {
        GPBUtil::checkUint64($var);
        $this->start_time_unix_nano = $var;

        return $this;
    }

    /**
     * end_time_unix_nano is the end time of the span. On the client side, this is the time
     * kept by the local machine where the span execution ends. On the server side, this
     * is the time when the server application handler stops running.
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
     * This field is semantically required and it is expected that end_time >= start_time.
     *
     * Generated from protobuf field <code>fixed64 end_time_unix_nano = 8;</code>
     * @return int|string
     */
    public function getEndTimeUnixNano()
    {
        return $this->end_time_unix_nano;
    }

    /**
     * end_time_unix_nano is the end time of the span. On the client side, this is the time
     * kept by the local machine where the span execution ends. On the server side, this
     * is the time when the server application handler stops running.
     * Value is UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
     * This field is semantically required and it is expected that end_time >= start_time.
     *
     * Generated from protobuf field <code>fixed64 end_time_unix_nano = 8;</code>
     * @param int|string $var
     * @return $this
     */
    public function setEndTimeUnixNano($var)
    {
        GPBUtil::checkUint64($var);
        $this->end_time_unix_nano = $var;

        return $this;
    }

    /**
     * attributes is a collection of key/value pairs. Note, global attributes
     * like server name can be set using the resource API. Examples of attributes:
     *     "/http/user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36"
     *     "/http/server_latency": 300
     *     "example.com/myattribute": true
     *     "example.com/score": 10.239
     * The OpenTelemetry API specification further restricts the allowed value types:
     * https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/common/README.md#attribute
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     *
     * Generated from protobuf field <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * attributes is a collection of key/value pairs. Note, global attributes
     * like server name can be set using the resource API. Examples of attributes:
     *     "/http/user_agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Safari/537.36"
     *     "/http/server_latency": 300
     *     "example.com/myattribute": true
     *     "example.com/score": 10.239
     * The OpenTelemetry API specification further restricts the allowed value types:
     * https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/common/README.md#attribute
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     *
     * Generated from protobuf field <code>repeated .opentelemetry.proto.common.v1.KeyValue attributes = 9;</code>
     * @param \Opentelemetry\Proto\Common\V1\KeyValue[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAttributes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Opentelemetry\Proto\Common\V1\KeyValue::class);
        $this->attributes = $arr;

        return $this;
    }

    /**
     * dropped_attributes_count is the number of attributes that were discarded. Attributes
     * can be discarded because their keys are too long or because there are too many
     * attributes. If this value is 0, then no attributes were dropped.
     *
     * Generated from protobuf field <code>uint32 dropped_attributes_count = 10;</code>
     * @return int
     */
    public function getDroppedAttributesCount()
    {
        return $this->dropped_attributes_count;
    }

    /**
     * dropped_attributes_count is the number of attributes that were discarded. Attributes
     * can be discarded because their keys are too long or because there are too many
     * attributes. If this value is 0, then no attributes were dropped.
     *
     * Generated from protobuf field <code>uint32 dropped_attributes_count = 10;</code>
     * @param int $var
     * @return $this
     */
    public function setDroppedAttributesCount($var)
    {
        GPBUtil::checkUint32($var);
        $this->dropped_attributes_count = $var;

        return $this;
    }

    /**
     * events is a collection of Event items.
     *
     * Generated from protobuf field <code>repeated .opentelemetry.proto.trace.v1.Span.Event events = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEvents()
    {
        return $this->events;
    }

    /**
     * events is a collection of Event items.
     *
     * Generated from protobuf field <code>repeated .opentelemetry.proto.trace.v1.Span.Event events = 11;</code>
     * @param \Opentelemetry\Proto\Trace\V1\Span\Event[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEvents($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Opentelemetry\Proto\Trace\V1\Span\Event::class);
        $this->events = $arr;

        return $this;
    }

    /**
     * dropped_events_count is the number of dropped events. If the value is 0, then no
     * events were dropped.
     *
     * Generated from protobuf field <code>uint32 dropped_events_count = 12;</code>
     * @return int
     */
    public function getDroppedEventsCount()
    {
        return $this->dropped_events_count;
    }

    /**
     * dropped_events_count is the number of dropped events. If the value is 0, then no
     * events were dropped.
     *
     * Generated from protobuf field <code>uint32 dropped_events_count = 12;</code>
     * @param int $var
     * @return $this
     */
    public function setDroppedEventsCount($var)
    {
        GPBUtil::checkUint32($var);
        $this->dropped_events_count = $var;

        return $this;
    }

    /**
     * links is a collection of Links, which are references from this span to a span
     * in the same or different trace.
     *
     * Generated from protobuf field <code>repeated .opentelemetry.proto.trace.v1.Span.Link links = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLinks()
    {
        return $this->links;
    }

    /**
     * links is a collection of Links, which are references from this span to a span
     * in the same or different trace.
     *
     * Generated from protobuf field <code>repeated .opentelemetry.proto.trace.v1.Span.Link links = 13;</code>
     * @param \Opentelemetry\Proto\Trace\V1\Span\Link[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLinks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Opentelemetry\Proto\Trace\V1\Span\Link::class);
        $this->links = $arr;

        return $this;
    }

    /**
     * dropped_links_count is the number of dropped links after the maximum size was
     * enforced. If this value is 0, then no links were dropped.
     *
     * Generated from protobuf field <code>uint32 dropped_links_count = 14;</code>
     * @return int
     */
    public function getDroppedLinksCount()
    {
        return $this->dropped_links_count;
    }

    /**
     * dropped_links_count is the number of dropped links after the maximum size was
     * enforced. If this value is 0, then no links were dropped.
     *
     * Generated from protobuf field <code>uint32 dropped_links_count = 14;</code>
     * @param int $var
     * @return $this
     */
    public function setDroppedLinksCount($var)
    {
        GPBUtil::checkUint32($var);
        $this->dropped_links_count = $var;

        return $this;
    }

    /**
     * An optional final status for this span. Semantically when Status isn't set, it means
     * span's status code is unset, i.e. assume STATUS_CODE_UNSET (code = 0).
     *
     * Generated from protobuf field <code>.opentelemetry.proto.trace.v1.Status status = 15;</code>
     * @return \Opentelemetry\Proto\Trace\V1\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }

    public function hasStatus()
    {
        return isset($this->status);
    }

    public function clearStatus()
    {
        unset($this->status);
    }

    /**
     * An optional final status for this span. Semantically when Status isn't set, it means
     * span's status code is unset, i.e. assume STATUS_CODE_UNSET (code = 0).
     *
     * Generated from protobuf field <code>.opentelemetry.proto.trace.v1.Status status = 15;</code>
     * @param \Opentelemetry\Proto\Trace\V1\Status $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkMessage($var, \Opentelemetry\Proto\Trace\V1\Status::class);
        $this->status = $var;

        return $this;
    }

}

