"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.provideAutoInsertSelfClosingTags = provideAutoInsertSelfClosingTags;
const html = require("vscode-html-languageservice");
const vue_template_1 = require("../vue-template");
async function provideAutoInsertSelfClosingTags(context, service, document, position, change) {
    if (document.languageId !== 'html') {
        return;
    }
    const enabled = await context.env.getConfiguration?.('vue.autoInsert.selfClosing') ?? true;
    if (!enabled) {
        return;
    }
    if (change.text !== '/') {
        return;
    }
    const scanner = (0, vue_template_1.getScanner)(service, document, 'html');
    if (!scanner) {
        return;
    }
    const offset = document.offsetAt(position);
    let token;
    let inStartTag = false;
    while ((token = scanner.scan()) !== html.TokenType.EOS) {
        if (token === html.TokenType.StartTagOpen) {
            inStartTag = true;
        }
        else if (token === html.TokenType.StartTagClose || token === html.TokenType.StartTagSelfClose) {
            inStartTag = false;
        }
        else if (scanner.getTokenOffset() + 1 === offset) {
            if (token === html.TokenType.Unknown) {
                return '>';
            }
            return;
        }
    }
}
//# sourceMappingURL=autoinsert-self-closing-tags.js.map