"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getComponentInfo = getComponentInfo;
const shared_1 = require("@vue/shared");
const getComponentEvents_1 = require("./getComponentEvents");
const getComponentProps_1 = require("./getComponentProps");
const globalProperties = [
    'key',
    'ref',
    'ref_for',
    'ref_key',
    'class',
    'style'
];
function getComponentInfo(fileName, tag) {
    const props = getComponentProps_1.getComponentProps.call(this, fileName, tag, true)?.filter(({ name }) => !globalProperties.includes(name) && !(0, shared_1.hyphenate)(name).startsWith('on-vnode-'));
    const events = getComponentEvents_1.getComponentEvents.call(this, fileName, tag);
    return {
        props,
        events,
    };
}
//# sourceMappingURL=getComponentInfo.js.map