/*
 * Decompiled with CFR 0.152.
 */
package jiconfont.javafx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import jiconfont.DefaultIconCode;
import jiconfont.IconCode;
import jiconfont.javafx.IconCodeConverter;

public class IconNode
extends Text {
    private StyleableObjectProperty<IconCode> iconCode;
    private StyleableObjectProperty<Number> iconSize;
    private static CssMetaData<IconNode, IconCode> ICON_CODE_META_DATA = new CssMetaData<IconNode, IconCode>("-fx-icon-code", IconCodeConverter.getInstance()){

        @Override
        public boolean isSettable(IconNode styleable) {
            return true;
        }

        @Override
        public StyleableProperty<IconCode> getStyleableProperty(IconNode styleable) {
            return styleable.iconCodeProperty();
        }
    };
    private static final CssMetaData<IconNode, Number> ICON_SIZE_META_DATA = new CssMetaData<IconNode, Number>("-fx-icon-size", StyleConverter.getSizeConverter(), (Number)16.0){

        @Override
        public boolean isSettable(IconNode icon) {
            return true;
        }

        @Override
        public StyleableProperty<Number> getStyleableProperty(IconNode icon) {
            return (StyleableProperty)((Object)icon.iconSizeProperty());
        }
    };
    private static final List<CssMetaData<? extends Styleable, ?>> cssMetaDataList;

    public IconNode() {
        this((IconCode)null);
    }

    public IconNode(IconCode iconCode) {
        this.iconCodeProperty().addListener(new ChangeListener<IconCode>(){

            @Override
            public void changed(ObservableValue<? extends IconCode> observable2, IconCode oldValue, IconCode newValue) {
                IconNode.this.updateIconCode();
            }
        });
        this.iconSizeProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observable2, Number oldValue, Number newValue) {
                IconNode.this.updateIconSize();
            }
        });
        if (iconCode != null) {
            this.setIconCode(iconCode);
        }
    }

    public StyleableObjectProperty<IconCode> iconCodeProperty() {
        if (this.iconCode == null) {
            this.iconCode = new StyleableObjectProperty<IconCode>(){

                @Override
                public Object getBean() {
                    return IconNode.this;
                }

                @Override
                public String getName() {
                    return "iconCode";
                }

                @Override
                public CssMetaData<? extends Styleable, IconCode> getCssMetaData() {
                    return ICON_CODE_META_DATA;
                }
            };
        }
        return this.iconCode;
    }

    public void setIconCode(String fontFamily, char unicode) {
        this.iconCode.set(new DefaultIconCode(fontFamily, unicode));
    }

    public void setIconCode(IconCode iconCode) {
        this.iconCode.set(iconCode);
    }

    public IconCode getIconCode() {
        return (IconCode)this.iconCode.get();
    }

    public ObjectProperty<Number> iconSizeProperty() {
        if (this.iconSize == null) {
            this.iconSize = new StyleableObjectProperty<Number>((Number)18){

                @Override
                public Object getBean() {
                    return IconNode.this;
                }

                @Override
                public String getName() {
                    return "iconSize";
                }

                @Override
                public CssMetaData<? extends Styleable, Number> getCssMetaData() {
                    return ICON_SIZE_META_DATA;
                }
            };
        }
        return this.iconSize;
    }

    public Number getIconSize() {
        return (Number)this.iconSize.get();
    }

    public void setIconSize(Number iconSize) {
        this.iconSize.set(iconSize);
    }

    private void updateIconSize() {
        if (this.getIconCode() != null) {
            this.setFont(new Font(this.getIconCode().getFontFamily(), this.getIconSize().doubleValue()));
        }
    }

    private void updateIconCode() {
        if (this.getIconCode() != null) {
            this.setFont(new Font(this.getIconCode().getFontFamily(), this.getIconSize().doubleValue()));
            this.setText(Character.toString(this.getIconCode().getUnicode()));
        } else {
            this.setFont(null);
            this.setText("");
        }
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return cssMetaDataList;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return IconNode.getClassCssMetaData();
    }

    static {
        ArrayList temp = new ArrayList(Text.getClassCssMetaData());
        temp.add(ICON_CODE_META_DATA);
        temp.add(ICON_SIZE_META_DATA);
        cssMetaDataList = Collections.unmodifiableList(temp);
    }
}

