/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.ad.model.Operator;
import org.opensearch.ad.model.ThresholdType;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

public class Condition
implements Writeable,
ToXContentObject {
    private static final String FEATURE_NAME_FIELD = "feature_name";
    private static final String THRESHOLD_TYPE_FIELD = "threshold_type";
    private static final String OPERATOR_FIELD = "operator";
    private static final String VALUE_FIELD = "value";
    private String featureName;
    private ThresholdType thresholdType;
    private Operator operator;
    private Double value;

    public Condition(String featureName, ThresholdType thresholdType, Operator operator, Double value) {
        this.featureName = featureName;
        this.thresholdType = thresholdType;
        this.operator = operator;
        this.value = value;
    }

    public Condition(StreamInput input) throws IOException {
        this.featureName = input.readString();
        this.thresholdType = (ThresholdType)input.readEnum(ThresholdType.class);
        this.operator = (Operator)input.readEnum(Operator.class);
        this.value = input.readBoolean() ? Double.valueOf(input.readDouble()) : null;
    }

    public static Condition parse(XContentParser parser) throws IOException {
        String featureName = null;
        ThresholdType thresholdType = null;
        Operator operator = null;
        Double value = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "feature_name": {
                    featureName = parser.text();
                    break;
                }
                case "threshold_type": {
                    thresholdType = ThresholdType.valueOf(parser.text().toUpperCase(Locale.ROOT));
                    break;
                }
                case "operator": {
                    if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                        operator = null;
                        break;
                    }
                    operator = Operator.valueOf(parser.text().toUpperCase(Locale.ROOT));
                    break;
                }
                case "value": {
                    if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                        value = null;
                        break;
                    }
                    value = parser.doubleValue();
                    break;
                }
            }
        }
        return new Condition(featureName, thresholdType, operator, value);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject().field(FEATURE_NAME_FIELD, this.featureName).field(THRESHOLD_TYPE_FIELD, (Object)this.thresholdType).field(OPERATOR_FIELD, (Object)this.operator);
        if (this.value != null) {
            builder.field(VALUE_FIELD, this.value);
        }
        return xContentBuilder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.featureName);
        out.writeEnum((Enum)this.thresholdType);
        out.writeEnum((Enum)this.operator);
        out.writeBoolean(this.value != null);
        if (this.value != null) {
            out.writeDouble(this.value.doubleValue());
        }
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public ThresholdType getThresholdType() {
        return this.thresholdType;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Condition that = (Condition)o;
        return Objects.equal((Object)this.featureName, (Object)that.featureName) && Objects.equal((Object)((Object)this.thresholdType), (Object)((Object)that.thresholdType)) && Objects.equal((Object)((Object)this.operator), (Object)((Object)that.operator)) && Objects.equal((Object)this.value, (Object)that.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode((Object[])new Object[]{this.featureName, this.thresholdType, this.operator, this.value});
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("featureName", (Object)this.featureName).append("thresholdType", (Object)this.thresholdType).append(OPERATOR_FIELD, (Object)this.operator).append(VALUE_FIELD, (Object)this.value).toString();
    }
}

