/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.settings.ForecastEnabledSetting;
import org.opensearch.forecast.transport.GetForecasterAction;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.timeseries.transport.GetConfigRequest;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.owasp.encoder.Encode;

public class RestGetForecasterAction
extends BaseRestHandler {
    private static final String GET_FORECASTER_ACTION = "get_forecaster";

    public String getName() {
        return GET_FORECASTER_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ForecastEnabledSetting.isForecastEnabled()) {
            throw new IllegalStateException("Forecast functionality is disabled. To enable update plugins.forecast.enabled to true");
        }
        try {
            String forecasterId = request.param("forecasterID");
            String typesStr = request.param("type");
            String rawPath = request.rawPath();
            boolean returnJob = request.paramAsBoolean("job", false);
            boolean returnTask = request.paramAsBoolean("task", false);
            boolean all = request.paramAsBoolean("_all", false);
            GetConfigRequest getForecasterRequest = new GetConfigRequest(forecasterId, RestActions.parseVersion((RestRequest)request), returnJob, returnTask, typesStr, rawPath, all, RestHandlerUtils.buildEntity(request, forecasterId));
            return channel -> client.execute((ActionType)GetForecasterAction.INSTANCE, (ActionRequest)getForecasterRequest, (ActionListener)new RestToXContentListener(channel));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Encode.forHtml((String)e.getMessage()));
        }
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_forecast/forecasters", "forecasterID", "_profile")), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s/{%s}", "/_plugins/_forecast/forecasters", "forecasterID", "_profile", "type")), (Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_forecast/forecasters", "forecasterID", "_profile")), (Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}/%s/{%s}", "/_plugins/_forecast/forecasters", "forecasterID", "_profile", "type")), (Object)new RestHandler.Route(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}", "/_plugins/_forecast/forecasters", "forecasterID")));
    }
}

