/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.logical.node;

import java.util.Map;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.legacy.esdomain.LocalClusterState;
import org.opensearch.sql.legacy.query.join.TableInJoinRequestBuilder;
import org.opensearch.sql.legacy.query.planner.core.PlanNode;
import org.opensearch.sql.legacy.query.planner.logical.LogicalOperator;
import org.opensearch.sql.legacy.query.planner.physical.PhysicalOperator;
import org.opensearch.sql.legacy.query.planner.physical.node.pointInTime.PointInTime;
import org.opensearch.sql.legacy.query.planner.physical.node.scroll.Scroll;

public class TableScan
implements LogicalOperator {
    private final TableInJoinRequestBuilder request;
    private final int pageSize;

    public TableScan(TableInJoinRequestBuilder request, int pageSize) {
        this.request = request;
        this.pageSize = pageSize;
    }

    @Override
    public PlanNode[] children() {
        return new PlanNode[0];
    }

    @Override
    public <T> PhysicalOperator[] toPhysical(Map<LogicalOperator, PhysicalOperator<T>> optimalOps) {
        if (((Boolean)LocalClusterState.state().getSettingValue(Settings.Key.SQL_PAGINATION_API_SEARCH_AFTER)).booleanValue()) {
            return new PhysicalOperator[]{new PointInTime(this.request, this.pageSize)};
        }
        return new PhysicalOperator[]{new Scroll(this.request, this.pageSize)};
    }

    public String toString() {
        return "TableScan";
    }

    public String getTableAlias() {
        return this.request.getAlias();
    }

    public String getTableName() {
        return this.request.getOriginalSelect().getFrom().get(0).getIndex();
    }
}

