/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.physical.estimation;

import java.util.Arrays;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Map;
import org.opensearch.sql.legacy.query.planner.core.PlanNode;
import org.opensearch.sql.legacy.query.planner.logical.LogicalOperator;
import org.opensearch.sql.legacy.query.planner.logical.LogicalPlanVisitor;
import org.opensearch.sql.legacy.query.planner.logical.node.Group;
import org.opensearch.sql.legacy.query.planner.physical.PhysicalOperator;

public class Estimation<T>
implements LogicalPlanVisitor {
    private Map<LogicalOperator, PhysicalOperator<T>> optimalOps = new IdentityHashMap<LogicalOperator, PhysicalOperator<T>>();
    private PhysicalOperator<T> root;

    @Override
    public boolean visit(Group group) {
        return false;
    }

    @Override
    public void endVisit(PlanNode node) {
        LogicalOperator op = (LogicalOperator)node;
        PhysicalOperator optimal = Arrays.stream(op.toPhysical(this.optimalOps)).min(Comparator.comparing(PhysicalOperator::estimate)).orElseThrow(() -> new IllegalStateException("No optimal operator found: " + String.valueOf(op)));
        this.optimalOps.put(op, optimal);
        this.root = optimal;
    }

    public PhysicalOperator<T> optimalPlan() {
        return this.root;
    }
}

