/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.nio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.ssl.SslHandler;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import org.opensearch.ExceptionsHelper;
import org.opensearch.common.Nullable;
import org.opensearch.http.nio.NettyListener;
import org.opensearch.http.nio.PagedByteBuf;
import org.opensearch.nio.FlushOperation;
import org.opensearch.nio.Page;
import org.opensearch.nio.WriteOperation;

class NettyAdaptor {
    private final EmbeddedChannel nettyChannel;
    private final LinkedList<FlushOperation> flushOperations = new LinkedList();

    NettyAdaptor(ChannelHandler ... handlers) {
        this((SslHandler)null, handlers);
    }

    NettyAdaptor(@Nullable SslHandler sslHandler, ChannelHandler ... handlers) {
        this.nettyChannel = new EmbeddedChannel();
        this.nettyChannel.pipeline().addLast("write_captor", (ChannelHandler)new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                try {
                    ByteBuf message = (ByteBuf)msg;
                    promise.addListener(f -> message.release());
                    NettyListener listener = NettyListener.fromChannelPromise(promise);
                    NettyAdaptor.this.flushOperations.add(new FlushOperation(message.nioBuffers(), (BiConsumer)listener));
                }
                catch (Exception e) {
                    promise.setFailure((Throwable)e);
                }
            }
        });
        if (sslHandler != null) {
            this.nettyChannel.pipeline().addAfter("write_captor", "ssl_handler", (ChannelHandler)sslHandler);
        }
        this.nettyChannel.pipeline().addLast(handlers);
    }

    public void close() throws Exception {
        assert (this.flushOperations.isEmpty()) : "Should close outbound operations before calling close";
        SslHandler sslHandler = (SslHandler)this.nettyChannel.pipeline().get("ssl_handler");
        if (sslHandler != null) {
            this.nettyChannel.pipeline().remove((ChannelHandler)sslHandler);
        }
        ChannelFuture closeFuture = this.nettyChannel.close();
        closeFuture.await();
        if (!closeFuture.isSuccess()) {
            Throwable cause = closeFuture.cause();
            ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            throw (Exception)cause;
        }
    }

    public void addCloseListener(BiConsumer<Void, Exception> listener) {
        this.nettyChannel.closeFuture().addListener(f -> {
            if (f.isSuccess()) {
                listener.accept(null, null);
            } else {
                Throwable cause = f.cause();
                ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
                assert (cause instanceof Exception);
                listener.accept(null, (Exception)cause);
            }
        });
    }

    public int read(ByteBuffer[] buffers) {
        ByteBuf byteBuf = Unpooled.wrappedBuffer((ByteBuffer[])buffers);
        int initialReaderIndex = byteBuf.readerIndex();
        this.nettyChannel.writeInbound(new Object[]{byteBuf});
        return byteBuf.readerIndex() - initialReaderIndex;
    }

    public int read(Page[] pages) {
        ByteBuf byteBuf = PagedByteBuf.byteBufFromPages(pages);
        int readableBytes = byteBuf.readableBytes();
        this.nettyChannel.writeInbound(new Object[]{byteBuf});
        return readableBytes;
    }

    public Object pollInboundMessage() {
        return this.nettyChannel.readInbound();
    }

    public void write(WriteOperation writeOperation) {
        this.nettyChannel.writeAndFlush(writeOperation.getObject(), (ChannelPromise)NettyListener.fromBiConsumer(writeOperation.getListener(), (Channel)this.nettyChannel));
    }

    public FlushOperation pollOutboundOperation() {
        return this.flushOperations.pollFirst();
    }

    public int getOutboundCount() {
        return this.flushOperations.size();
    }
}

