// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from esp32s2.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Espressif

//go:build esp && esp32s2

/*
// 32-bit MCU & 2.4 GHz Wi-Fi
*/
//     Copyright 2023 Espressif Systems (Shanghai) PTE LTD Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
package esp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ESP32-S2"
	CPU          = "Xtensa LX7"
	FPUPresent   = false
	NVICPrioBits = 0
)

// Interrupt numbers.
const (
	// Interrupt Controller (Core 0)
	IRQ_WIFI_MAC = 0

	// Interrupt Controller (Core 0)
	IRQ_WIFI_NMI = 1

	// Interrupt Controller (Core 0)
	IRQ_WIFI_PWR = 2

	// Interrupt Controller (Core 0)
	IRQ_WIFI_BB = 3

	// Interrupt Controller (Core 0)
	IRQ_BT_MAC = 4

	// Interrupt Controller (Core 0)
	IRQ_BT_BB = 5

	// Interrupt Controller (Core 0)
	IRQ_BT_BB_NMI = 6

	// Interrupt Controller (Core 0)
	IRQ_RWBT = 7

	// Interrupt Controller (Core 0)
	IRQ_RWBLE = 8

	// Interrupt Controller (Core 0)
	IRQ_RWBT_NMI = 9

	// Interrupt Controller (Core 0)
	IRQ_RWBLE_NMI = 10

	// Interrupt Controller (Core 0)
	IRQ_SLC0 = 11

	// Interrupt Controller (Core 0)
	IRQ_SLC1 = 12

	// Universal Host Controller Interface 0
	IRQ_UHCI0 = 13

	// Universal Host Controller Interface 0
	IRQ_UHCI1 = 14

	// Timer Group 0
	IRQ_TG0_T0_LEVEL = 15

	// Timer Group 0
	IRQ_TG0_T1_LEVEL = 16

	// Timer Group 0
	IRQ_TG0_WDT_LEVEL = 17

	// Timer Group 0
	IRQ_TG0_LACT_LEVEL = 18

	// Timer Group 1
	IRQ_TG1_T0_LEVEL = 19

	// Timer Group 1
	IRQ_TG1_T1_LEVEL = 20

	// Timer Group 1
	IRQ_TG1_WDT_LEVEL = 21

	// Timer Group 1
	IRQ_TG1_LACT_LEVEL = 22

	// General Purpose Input/Output
	IRQ_GPIO = 23

	// General Purpose Input/Output
	IRQ_GPIO_NMI = 24

	// General Purpose Input/Output
	IRQ_GPIO_INTR_2 = 25

	// General Purpose Input/Output
	IRQ_GPIO_NMI_2 = 26

	// DEDICATED_GPIO Peripheral
	IRQ_DEDICATED_GPIO = 27

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR0 = 28

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR1 = 29

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR2 = 30

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR3 = 31

	// SPI (Serial Peripheral Interface) Controller 1
	IRQ_SPI1 = 32

	// SPI (Serial Peripheral Interface) Controller 2
	IRQ_SPI2 = 33

	// SPI (Serial Peripheral Interface) Controller 3
	IRQ_SPI3 = 34

	// I2S (Inter-IC Sound) Controller 0
	IRQ_I2S0 = 35

	// I2S (Inter-IC Sound) Controller 0
	IRQ_I2S1 = 36

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 0
	IRQ_UART0 = 37

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 1
	IRQ_UART1 = 38

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 1
	IRQ_UART2 = 39

	// Interrupt Controller (Core 0)
	IRQ_SDIO_HOST = 40

	// LED Control PWM (Pulse Width Modulation)
	IRQ_LEDC = 45

	// eFuse Controller
	IRQ_EFUSE = 46

	// Two-Wire Automotive Interface
	IRQ_TWAI0 = 47

	// USB OTG (On-The-Go)
	IRQ_USB = 48

	// Real-Time Clock Control
	IRQ_RTC_CORE = 49

	// Remote Control
	IRQ_RMT = 50

	// Pulse Count Controller
	IRQ_PCNT = 51

	// I2C (Inter-Integrated Circuit) Controller 0
	IRQ_I2C_EXT0 = 52

	// I2C (Inter-Integrated Circuit) Controller 1
	IRQ_I2C_EXT1 = 53

	// RSA (Rivest Shamir Adleman) Accelerator
	IRQ_RSA = 54

	// SHA (Secure Hash Algorithm) Accelerator
	IRQ_SHA = 55

	// AES (Advanced Encryption Standard) Accelerator
	IRQ_AES = 56

	// SPI (Serial Peripheral Interface) Controller 2
	IRQ_SPI2_DMA = 57

	// SPI (Serial Peripheral Interface) Controller 3
	IRQ_SPI3_DMA = 58

	// Interrupt Controller (Core 0)
	IRQ_WDT = 59

	// LED Control PWM (Pulse Width Modulation)
	IRQ_TIMER1 = 60

	// LED Control PWM (Pulse Width Modulation)
	IRQ_TIMER2 = 61

	// Timer Group 0
	IRQ_TG0_T0_EDGE = 62

	// Timer Group 0
	IRQ_TG0_T1_EDGE = 63

	// Timer Group 0
	IRQ_TG0_WDT_EDGE = 64

	// Timer Group 0
	IRQ_TG0_LACT_EDGE = 65

	// Timer Group 1
	IRQ_TG1_T0_EDGE = 66

	// Timer Group 1
	IRQ_TG1_T1_EDGE = 67

	// Timer Group 1
	IRQ_TG1_WDT_EDGE = 68

	// Timer Group 1
	IRQ_TG1_LACT_EDGE = 69

	// Interrupt Controller (Core 0)
	IRQ_CACHE_IA = 70

	// System Timer
	IRQ_SYSTIMER_TARGET0 = 71

	// System Timer
	IRQ_SYSTIMER_TARGET1 = 72

	// System Timer
	IRQ_SYSTIMER_TARGET2 = 73

	// Permissions Controller
	IRQ_PMS_PRO_IRAM0_ILG = 75

	// Permissions Controller
	IRQ_PMS_PRO_DRAM0_ILG = 76

	// Permissions Controller
	IRQ_PMS_PRO_DPORT_ILG = 77

	// Permissions Controller
	IRQ_PMS_PRO_AHB_ILG = 78

	// Permissions Controller
	IRQ_PMS_PRO_CACHE_ILG = 79

	// Permissions Controller
	IRQ_PMS_DMA_APB_I_ILG = 80

	// Permissions Controller
	IRQ_PMS_DMA_RX_I_ILG = 81

	// Permissions Controller
	IRQ_PMS_DMA_TX_I_ILG = 82

	// SPI (Serial Peripheral Interface) Controller 0
	IRQ_SPI0_REJECT_CACHE = 83

	// SPI (Serial Peripheral Interface) Controller 4
	IRQ_SPI4_DMA = 85

	// SPI (Serial Peripheral Interface) Controller 4
	IRQ_SPI4 = 86

	// Interrupt Controller (Core 0)
	IRQ_ICACHE_PRELOAD = 87

	// Interrupt Controller (Core 0)
	IRQ_DCACHE_PRELOAD = 88

	// SAR (Successive Approximation Register) Analog-to-Digital Converter
	IRQ_APB_ADC = 89

	// Interrupt Controller (Core 0)
	IRQ_CPU_PERI_ERR = 91

	// Interrupt Controller (Core 0)
	IRQ_APB_PERI_ERR = 92

	// Interrupt Controller (Core 0)
	IRQ_DCACHE_SYNC = 93

	// Interrupt Controller (Core 0)
	IRQ_ICACHE_SYNC = 94

	// Highest interrupt number on this device.
	IRQ_max = 94
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)
func HandleInterrupt(num int) {
	switch num {
	case IRQ_WIFI_MAC:
		callHandlers(IRQ_WIFI_MAC)
	case IRQ_WIFI_NMI:
		callHandlers(IRQ_WIFI_NMI)
	case IRQ_WIFI_PWR:
		callHandlers(IRQ_WIFI_PWR)
	case IRQ_WIFI_BB:
		callHandlers(IRQ_WIFI_BB)
	case IRQ_BT_MAC:
		callHandlers(IRQ_BT_MAC)
	case IRQ_BT_BB:
		callHandlers(IRQ_BT_BB)
	case IRQ_BT_BB_NMI:
		callHandlers(IRQ_BT_BB_NMI)
	case IRQ_RWBT:
		callHandlers(IRQ_RWBT)
	case IRQ_RWBLE:
		callHandlers(IRQ_RWBLE)
	case IRQ_RWBT_NMI:
		callHandlers(IRQ_RWBT_NMI)
	case IRQ_RWBLE_NMI:
		callHandlers(IRQ_RWBLE_NMI)
	case IRQ_SLC0:
		callHandlers(IRQ_SLC0)
	case IRQ_SLC1:
		callHandlers(IRQ_SLC1)
	case IRQ_UHCI0:
		callHandlers(IRQ_UHCI0)
	case IRQ_UHCI1:
		callHandlers(IRQ_UHCI1)
	case IRQ_TG0_T0_LEVEL:
		callHandlers(IRQ_TG0_T0_LEVEL)
	case IRQ_TG0_T1_LEVEL:
		callHandlers(IRQ_TG0_T1_LEVEL)
	case IRQ_TG0_WDT_LEVEL:
		callHandlers(IRQ_TG0_WDT_LEVEL)
	case IRQ_TG0_LACT_LEVEL:
		callHandlers(IRQ_TG0_LACT_LEVEL)
	case IRQ_TG1_T0_LEVEL:
		callHandlers(IRQ_TG1_T0_LEVEL)
	case IRQ_TG1_T1_LEVEL:
		callHandlers(IRQ_TG1_T1_LEVEL)
	case IRQ_TG1_WDT_LEVEL:
		callHandlers(IRQ_TG1_WDT_LEVEL)
	case IRQ_TG1_LACT_LEVEL:
		callHandlers(IRQ_TG1_LACT_LEVEL)
	case IRQ_GPIO:
		callHandlers(IRQ_GPIO)
	case IRQ_GPIO_NMI:
		callHandlers(IRQ_GPIO_NMI)
	case IRQ_GPIO_INTR_2:
		callHandlers(IRQ_GPIO_INTR_2)
	case IRQ_GPIO_NMI_2:
		callHandlers(IRQ_GPIO_NMI_2)
	case IRQ_DEDICATED_GPIO:
		callHandlers(IRQ_DEDICATED_GPIO)
	case IRQ_FROM_CPU_INTR0:
		callHandlers(IRQ_FROM_CPU_INTR0)
	case IRQ_FROM_CPU_INTR1:
		callHandlers(IRQ_FROM_CPU_INTR1)
	case IRQ_FROM_CPU_INTR2:
		callHandlers(IRQ_FROM_CPU_INTR2)
	case IRQ_FROM_CPU_INTR3:
		callHandlers(IRQ_FROM_CPU_INTR3)
	case IRQ_SPI1:
		callHandlers(IRQ_SPI1)
	case IRQ_SPI2:
		callHandlers(IRQ_SPI2)
	case IRQ_SPI3:
		callHandlers(IRQ_SPI3)
	case IRQ_I2S0:
		callHandlers(IRQ_I2S0)
	case IRQ_I2S1:
		callHandlers(IRQ_I2S1)
	case IRQ_UART0:
		callHandlers(IRQ_UART0)
	case IRQ_UART1:
		callHandlers(IRQ_UART1)
	case IRQ_UART2:
		callHandlers(IRQ_UART2)
	case IRQ_SDIO_HOST:
		callHandlers(IRQ_SDIO_HOST)
	case IRQ_LEDC:
		callHandlers(IRQ_LEDC)
	case IRQ_EFUSE:
		callHandlers(IRQ_EFUSE)
	case IRQ_TWAI0:
		callHandlers(IRQ_TWAI0)
	case IRQ_USB:
		callHandlers(IRQ_USB)
	case IRQ_RTC_CORE:
		callHandlers(IRQ_RTC_CORE)
	case IRQ_RMT:
		callHandlers(IRQ_RMT)
	case IRQ_PCNT:
		callHandlers(IRQ_PCNT)
	case IRQ_I2C_EXT0:
		callHandlers(IRQ_I2C_EXT0)
	case IRQ_I2C_EXT1:
		callHandlers(IRQ_I2C_EXT1)
	case IRQ_RSA:
		callHandlers(IRQ_RSA)
	case IRQ_SHA:
		callHandlers(IRQ_SHA)
	case IRQ_AES:
		callHandlers(IRQ_AES)
	case IRQ_SPI2_DMA:
		callHandlers(IRQ_SPI2_DMA)
	case IRQ_SPI3_DMA:
		callHandlers(IRQ_SPI3_DMA)
	case IRQ_WDT:
		callHandlers(IRQ_WDT)
	case IRQ_TIMER1:
		callHandlers(IRQ_TIMER1)
	case IRQ_TIMER2:
		callHandlers(IRQ_TIMER2)
	case IRQ_TG0_T0_EDGE:
		callHandlers(IRQ_TG0_T0_EDGE)
	case IRQ_TG0_T1_EDGE:
		callHandlers(IRQ_TG0_T1_EDGE)
	case IRQ_TG0_WDT_EDGE:
		callHandlers(IRQ_TG0_WDT_EDGE)
	case IRQ_TG0_LACT_EDGE:
		callHandlers(IRQ_TG0_LACT_EDGE)
	case IRQ_TG1_T0_EDGE:
		callHandlers(IRQ_TG1_T0_EDGE)
	case IRQ_TG1_T1_EDGE:
		callHandlers(IRQ_TG1_T1_EDGE)
	case IRQ_TG1_WDT_EDGE:
		callHandlers(IRQ_TG1_WDT_EDGE)
	case IRQ_TG1_LACT_EDGE:
		callHandlers(IRQ_TG1_LACT_EDGE)
	case IRQ_CACHE_IA:
		callHandlers(IRQ_CACHE_IA)
	case IRQ_SYSTIMER_TARGET0:
		callHandlers(IRQ_SYSTIMER_TARGET0)
	case IRQ_SYSTIMER_TARGET1:
		callHandlers(IRQ_SYSTIMER_TARGET1)
	case IRQ_SYSTIMER_TARGET2:
		callHandlers(IRQ_SYSTIMER_TARGET2)
	case IRQ_PMS_PRO_IRAM0_ILG:
		callHandlers(IRQ_PMS_PRO_IRAM0_ILG)
	case IRQ_PMS_PRO_DRAM0_ILG:
		callHandlers(IRQ_PMS_PRO_DRAM0_ILG)
	case IRQ_PMS_PRO_DPORT_ILG:
		callHandlers(IRQ_PMS_PRO_DPORT_ILG)
	case IRQ_PMS_PRO_AHB_ILG:
		callHandlers(IRQ_PMS_PRO_AHB_ILG)
	case IRQ_PMS_PRO_CACHE_ILG:
		callHandlers(IRQ_PMS_PRO_CACHE_ILG)
	case IRQ_PMS_DMA_APB_I_ILG:
		callHandlers(IRQ_PMS_DMA_APB_I_ILG)
	case IRQ_PMS_DMA_RX_I_ILG:
		callHandlers(IRQ_PMS_DMA_RX_I_ILG)
	case IRQ_PMS_DMA_TX_I_ILG:
		callHandlers(IRQ_PMS_DMA_TX_I_ILG)
	case IRQ_SPI0_REJECT_CACHE:
		callHandlers(IRQ_SPI0_REJECT_CACHE)
	case IRQ_SPI4_DMA:
		callHandlers(IRQ_SPI4_DMA)
	case IRQ_SPI4:
		callHandlers(IRQ_SPI4)
	case IRQ_ICACHE_PRELOAD:
		callHandlers(IRQ_ICACHE_PRELOAD)
	case IRQ_DCACHE_PRELOAD:
		callHandlers(IRQ_DCACHE_PRELOAD)
	case IRQ_APB_ADC:
		callHandlers(IRQ_APB_ADC)
	case IRQ_CPU_PERI_ERR:
		callHandlers(IRQ_CPU_PERI_ERR)
	case IRQ_APB_PERI_ERR:
		callHandlers(IRQ_APB_PERI_ERR)
	case IRQ_DCACHE_SYNC:
		callHandlers(IRQ_DCACHE_SYNC)
	case IRQ_ICACHE_SYNC:
		callHandlers(IRQ_ICACHE_SYNC)
	}
}

// Peripherals.
var (
	// AES (Advanced Encryption Standard) Accelerator
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x6003a000)))

	// SAR (Successive Approximation Register) Analog-to-Digital Converter
	APB_SARADC = (*APB_SARADC_Type)(unsafe.Pointer(uintptr(0x3f440000)))

	// BB Peripheral
	BB = (*BB_Type)(unsafe.Pointer(uintptr(0x3f41d000)))

	// DEDICATED_GPIO Peripheral
	DEDICATED_GPIO = (*DEDIC_GPIO_Type)(unsafe.Pointer(uintptr(0x3f4cf000)))

	// Digital Signature
	DS = (*DS_Type)(unsafe.Pointer(uintptr(0x6003d000)))

	// eFuse Controller
	EFUSE = (*EFUSE_Type)(unsafe.Pointer(uintptr(0x3f41a000)))

	// External Memory
	EXTMEM = (*EXTMEM_Type)(unsafe.Pointer(uintptr(0x61800000)))

	// General Purpose Input/Output
	GPIO = (*GPIO_Type)(unsafe.Pointer(uintptr(0x3f404000)))

	// Sigma-Delta Modulation
	GPIO_SD = (*GPIOSD_Type)(unsafe.Pointer(uintptr(0x3f404f00)))

	// HMAC (Hash-based Message Authentication Code) Accelerator
	HMAC = (*HMAC_Type)(unsafe.Pointer(uintptr(0x6003e000)))

	// I2C (Inter-Integrated Circuit) Controller 0
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x3f413000)))

	// I2S (Inter-IC Sound) Controller 0
	I2S0 = (*I2S_Type)(unsafe.Pointer(uintptr(0x3f40f000)))

	// Interrupt Controller (Core 0)
	INTERRUPT_CORE0 = (*INTERRUPT_CORE0_Type)(unsafe.Pointer(uintptr(0x3f4c2000)))

	// Input/Output Multiplexer
	IO_MUX = (*IO_MUX_Type)(unsafe.Pointer(uintptr(0x3f409000)))

	// LED Control PWM (Pulse Width Modulation)
	LEDC = (*LEDC_Type)(unsafe.Pointer(uintptr(0x3f419000)))

	// Pulse Count Controller
	PCNT = (*PCNT_Type)(unsafe.Pointer(uintptr(0x3f417000)))

	// Permissions Controller
	PMS = (*PMS_Type)(unsafe.Pointer(uintptr(0x3f4c1000)))

	// Remote Control
	RMT = (*RMT_Type)(unsafe.Pointer(uintptr(0x3f416000)))

	// Hardware Random Number Generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x60035000)))

	// RSA (Rivest Shamir Adleman) Accelerator
	RSA = (*RSA_Type)(unsafe.Pointer(uintptr(0x6003c000)))

	// Low-power Input/Output
	RTC_IO = (*RTCIO_Type)(unsafe.Pointer(uintptr(0x3f408400)))

	// Real-Time Clock Control
	RTC_CNTL = (*RTC_CNTL_Type)(unsafe.Pointer(uintptr(0x3f408000)))

	// Low-power I2C (Inter-Integrated Circuit) Controller
	RTC_I2C = (*RTC_I2C_Type)(unsafe.Pointer(uintptr(0x3f408c00)))

	// SENS Peripheral
	SENS = (*SENS_Type)(unsafe.Pointer(uintptr(0x3f408800)))

	// SHA (Secure Hash Algorithm) Accelerator
	SHA = (*SHA_Type)(unsafe.Pointer(uintptr(0x6003b000)))

	// SPI (Serial Peripheral Interface) Controller 0
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x3f403000)))

	// SYSCON Peripheral
	SYSCON = (*SYSCON_Type)(unsafe.Pointer(uintptr(0x3f426000)))

	// System Configuration Registers
	SYSTEM = (*SYSTEM_Type)(unsafe.Pointer(uintptr(0x3f4c0000)))

	// System Timer
	SYSTIMER = (*SYSTIMER_Type)(unsafe.Pointer(uintptr(0x3f423000)))

	// Timer Group 0
	TIMG0 = (*TIMG_Type)(unsafe.Pointer(uintptr(0x3f41f000)))

	// Two-Wire Automotive Interface
	TWAI0 = (*TWAI_Type)(unsafe.Pointer(uintptr(0x3f42b000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 0
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x3f400000)))

	// Universal Host Controller Interface 0
	UHCI0 = (*UHCI_Type)(unsafe.Pointer(uintptr(0x3f414000)))

	// USB OTG (On-The-Go)
	USB0 = (*USB_Type)(unsafe.Pointer(uintptr(0x60080000)))

	// USB_WRAP Peripheral
	USB_WRAP = (*USB_WRAP_Type)(unsafe.Pointer(uintptr(0x3f439000)))

	// XTS-AES-128 Flash Encryption
	XTS_AES = (*XTS_AES_Type)(unsafe.Pointer(uintptr(0x6003a100)))

	// I2C (Inter-Integrated Circuit) Controller 1
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x3f427000)))

	// SPI (Serial Peripheral Interface) Controller 1
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x3f402000)))

	// SPI (Serial Peripheral Interface) Controller 2
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x3f424000)))

	// SPI (Serial Peripheral Interface) Controller 3
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x3f425000)))

	// SPI (Serial Peripheral Interface) Controller 4
	SPI4 = (*SPI_Type)(unsafe.Pointer(uintptr(0x3f437000)))

	// Timer Group 1
	TIMG1 = (*TIMG_Type)(unsafe.Pointer(uintptr(0x3f420000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x3f410000)))
)

// AES (Advanced Encryption Standard) Accelerator
type AES_Type struct {
	KEY_0             volatile.Register32 // 0x0
	KEY_1             volatile.Register32 // 0x4
	KEY_2             volatile.Register32 // 0x8
	KEY_3             volatile.Register32 // 0xC
	KEY_4             volatile.Register32 // 0x10
	KEY_5             volatile.Register32 // 0x14
	KEY_6             volatile.Register32 // 0x18
	KEY_7             volatile.Register32 // 0x1C
	TEXT_IN_0         volatile.Register32 // 0x20
	TEXT_IN_1         volatile.Register32 // 0x24
	TEXT_IN_2         volatile.Register32 // 0x28
	TEXT_IN_3         volatile.Register32 // 0x2C
	TEXT_OUT_0        volatile.Register32 // 0x30
	TEXT_OUT_1        volatile.Register32 // 0x34
	TEXT_OUT_2        volatile.Register32 // 0x38
	TEXT_OUT_3        volatile.Register32 // 0x3C
	MODE              volatile.Register32 // 0x40
	ENDIAN            volatile.Register32 // 0x44
	TRIGGER           volatile.Register32 // 0x48
	STATE             volatile.Register32 // 0x4C
	IV_0              volatile.Register32 // 0x50
	IV_1              volatile.Register32 // 0x54
	IV_2              volatile.Register32 // 0x58
	IV_3              volatile.Register32 // 0x5C
	H_0               volatile.Register32 // 0x60
	H_1               volatile.Register32 // 0x64
	H_2               volatile.Register32 // 0x68
	H_3               volatile.Register32 // 0x6C
	J0_0              volatile.Register32 // 0x70
	J0_1              volatile.Register32 // 0x74
	J0_2              volatile.Register32 // 0x78
	J0_3              volatile.Register32 // 0x7C
	T0_0              volatile.Register32 // 0x80
	T0_1              volatile.Register32 // 0x84
	T0_2              volatile.Register32 // 0x88
	T0_3              volatile.Register32 // 0x8C
	DMA_ENABLE        volatile.Register32 // 0x90
	BLOCK_MODE        volatile.Register32 // 0x94
	BLOCK_NUM         volatile.Register32 // 0x98
	INC_SEL           volatile.Register32 // 0x9C
	AAD_BLOCK_NUM     volatile.Register32 // 0xA0
	REMAINDER_BIT_NUM volatile.Register32 // 0xA4
	CONTINUE_OP       volatile.Register32 // 0xA8
	INT_CLR           volatile.Register32 // 0xAC
	INT_ENA           volatile.Register32 // 0xB0
	DATE              volatile.Register32 // 0xB4
	DMA_EXIT          volatile.Register32 // 0xB8
}

// AES.KEY_0: AES key register %s
func (o *AES_Type) SetKEY_0(value uint32) {
	volatile.StoreUint32(&o.KEY_0.Reg, value)
}
func (o *AES_Type) GetKEY_0() uint32 {
	return volatile.LoadUint32(&o.KEY_0.Reg)
}

// AES.KEY_1: AES key register %s
func (o *AES_Type) SetKEY_1(value uint32) {
	volatile.StoreUint32(&o.KEY_1.Reg, value)
}
func (o *AES_Type) GetKEY_1() uint32 {
	return volatile.LoadUint32(&o.KEY_1.Reg)
}

// AES.KEY_2: AES key register %s
func (o *AES_Type) SetKEY_2(value uint32) {
	volatile.StoreUint32(&o.KEY_2.Reg, value)
}
func (o *AES_Type) GetKEY_2() uint32 {
	return volatile.LoadUint32(&o.KEY_2.Reg)
}

// AES.KEY_3: AES key register %s
func (o *AES_Type) SetKEY_3(value uint32) {
	volatile.StoreUint32(&o.KEY_3.Reg, value)
}
func (o *AES_Type) GetKEY_3() uint32 {
	return volatile.LoadUint32(&o.KEY_3.Reg)
}

// AES.KEY_4: AES key register %s
func (o *AES_Type) SetKEY_4(value uint32) {
	volatile.StoreUint32(&o.KEY_4.Reg, value)
}
func (o *AES_Type) GetKEY_4() uint32 {
	return volatile.LoadUint32(&o.KEY_4.Reg)
}

// AES.KEY_5: AES key register %s
func (o *AES_Type) SetKEY_5(value uint32) {
	volatile.StoreUint32(&o.KEY_5.Reg, value)
}
func (o *AES_Type) GetKEY_5() uint32 {
	return volatile.LoadUint32(&o.KEY_5.Reg)
}

// AES.KEY_6: AES key register %s
func (o *AES_Type) SetKEY_6(value uint32) {
	volatile.StoreUint32(&o.KEY_6.Reg, value)
}
func (o *AES_Type) GetKEY_6() uint32 {
	return volatile.LoadUint32(&o.KEY_6.Reg)
}

// AES.KEY_7: AES key register %s
func (o *AES_Type) SetKEY_7(value uint32) {
	volatile.StoreUint32(&o.KEY_7.Reg, value)
}
func (o *AES_Type) GetKEY_7() uint32 {
	return volatile.LoadUint32(&o.KEY_7.Reg)
}

// AES.TEXT_IN_0: Source data register %s
func (o *AES_Type) SetTEXT_IN_0(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_0.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_0() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_0.Reg)
}

// AES.TEXT_IN_1: Source data register %s
func (o *AES_Type) SetTEXT_IN_1(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_1.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_1() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_1.Reg)
}

// AES.TEXT_IN_2: Source data register %s
func (o *AES_Type) SetTEXT_IN_2(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_2.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_2() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_2.Reg)
}

// AES.TEXT_IN_3: Source data register %s
func (o *AES_Type) SetTEXT_IN_3(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_3.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_3() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_3.Reg)
}

// AES.TEXT_OUT_0: Result data register %s
func (o *AES_Type) SetTEXT_OUT_0(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_0.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_0() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_0.Reg)
}

// AES.TEXT_OUT_1: Result data register %s
func (o *AES_Type) SetTEXT_OUT_1(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_1.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_1() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_1.Reg)
}

// AES.TEXT_OUT_2: Result data register %s
func (o *AES_Type) SetTEXT_OUT_2(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_2.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_2() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_2.Reg)
}

// AES.TEXT_OUT_3: Result data register %s
func (o *AES_Type) SetTEXT_OUT_3(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_3.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_3() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_3.Reg)
}

// AES.MODE: AES working mode configuration register
func (o *AES_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x7)|value)
}
func (o *AES_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x7
}

// AES.ENDIAN: Endian configuration register
func (o *AES_Type) SetENDIAN(value uint32) {
	volatile.StoreUint32(&o.ENDIAN.Reg, volatile.LoadUint32(&o.ENDIAN.Reg)&^(0x3f)|value)
}
func (o *AES_Type) GetENDIAN() uint32 {
	return volatile.LoadUint32(&o.ENDIAN.Reg) & 0x3f
}

// AES.TRIGGER: Operation start controlling register
func (o *AES_Type) SetTRIGGER(value uint32) {
	volatile.StoreUint32(&o.TRIGGER.Reg, volatile.LoadUint32(&o.TRIGGER.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetTRIGGER() uint32 {
	return volatile.LoadUint32(&o.TRIGGER.Reg) & 0x1
}

// AES.STATE: Operation status register
func (o *AES_Type) SetSTATE(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x3)|value)
}
func (o *AES_Type) GetSTATE() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0x3
}

// AES.IV_0: initialization vector
func (o *AES_Type) SetIV_0(value uint32) {
	volatile.StoreUint32(&o.IV_0.Reg, value)
}
func (o *AES_Type) GetIV_0() uint32 {
	return volatile.LoadUint32(&o.IV_0.Reg)
}

// AES.IV_1: initialization vector
func (o *AES_Type) SetIV_1(value uint32) {
	volatile.StoreUint32(&o.IV_1.Reg, value)
}
func (o *AES_Type) GetIV_1() uint32 {
	return volatile.LoadUint32(&o.IV_1.Reg)
}

// AES.IV_2: initialization vector
func (o *AES_Type) SetIV_2(value uint32) {
	volatile.StoreUint32(&o.IV_2.Reg, value)
}
func (o *AES_Type) GetIV_2() uint32 {
	return volatile.LoadUint32(&o.IV_2.Reg)
}

// AES.IV_3: initialization vector
func (o *AES_Type) SetIV_3(value uint32) {
	volatile.StoreUint32(&o.IV_3.Reg, value)
}
func (o *AES_Type) GetIV_3() uint32 {
	return volatile.LoadUint32(&o.IV_3.Reg)
}

// AES.H_0: GCM hash subkey
func (o *AES_Type) SetH_0(value uint32) {
	volatile.StoreUint32(&o.H_0.Reg, value)
}
func (o *AES_Type) GetH_0() uint32 {
	return volatile.LoadUint32(&o.H_0.Reg)
}

// AES.H_1: GCM hash subkey
func (o *AES_Type) SetH_1(value uint32) {
	volatile.StoreUint32(&o.H_1.Reg, value)
}
func (o *AES_Type) GetH_1() uint32 {
	return volatile.LoadUint32(&o.H_1.Reg)
}

// AES.H_2: GCM hash subkey
func (o *AES_Type) SetH_2(value uint32) {
	volatile.StoreUint32(&o.H_2.Reg, value)
}
func (o *AES_Type) GetH_2() uint32 {
	return volatile.LoadUint32(&o.H_2.Reg)
}

// AES.H_3: GCM hash subkey
func (o *AES_Type) SetH_3(value uint32) {
	volatile.StoreUint32(&o.H_3.Reg, value)
}
func (o *AES_Type) GetH_3() uint32 {
	return volatile.LoadUint32(&o.H_3.Reg)
}

// AES.J0_0: J0
func (o *AES_Type) SetJ0_0(value uint32) {
	volatile.StoreUint32(&o.J0_0.Reg, value)
}
func (o *AES_Type) GetJ0_0() uint32 {
	return volatile.LoadUint32(&o.J0_0.Reg)
}

// AES.J0_1: J0
func (o *AES_Type) SetJ0_1(value uint32) {
	volatile.StoreUint32(&o.J0_1.Reg, value)
}
func (o *AES_Type) GetJ0_1() uint32 {
	return volatile.LoadUint32(&o.J0_1.Reg)
}

// AES.J0_2: J0
func (o *AES_Type) SetJ0_2(value uint32) {
	volatile.StoreUint32(&o.J0_2.Reg, value)
}
func (o *AES_Type) GetJ0_2() uint32 {
	return volatile.LoadUint32(&o.J0_2.Reg)
}

// AES.J0_3: J0
func (o *AES_Type) SetJ0_3(value uint32) {
	volatile.StoreUint32(&o.J0_3.Reg, value)
}
func (o *AES_Type) GetJ0_3() uint32 {
	return volatile.LoadUint32(&o.J0_3.Reg)
}

// AES.T0_0: T0
func (o *AES_Type) SetT0_0(value uint32) {
	volatile.StoreUint32(&o.T0_0.Reg, value)
}
func (o *AES_Type) GetT0_0() uint32 {
	return volatile.LoadUint32(&o.T0_0.Reg)
}

// AES.T0_1: T0
func (o *AES_Type) SetT0_1(value uint32) {
	volatile.StoreUint32(&o.T0_1.Reg, value)
}
func (o *AES_Type) GetT0_1() uint32 {
	return volatile.LoadUint32(&o.T0_1.Reg)
}

// AES.T0_2: T0
func (o *AES_Type) SetT0_2(value uint32) {
	volatile.StoreUint32(&o.T0_2.Reg, value)
}
func (o *AES_Type) GetT0_2() uint32 {
	return volatile.LoadUint32(&o.T0_2.Reg)
}

// AES.T0_3: T0
func (o *AES_Type) SetT0_3(value uint32) {
	volatile.StoreUint32(&o.T0_3.Reg, value)
}
func (o *AES_Type) GetT0_3() uint32 {
	return volatile.LoadUint32(&o.T0_3.Reg)
}

// AES.DMA_ENABLE: DMA enable register
func (o *AES_Type) SetDMA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DMA_ENABLE.Reg, volatile.LoadUint32(&o.DMA_ENABLE.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetDMA_ENABLE() uint32 {
	return volatile.LoadUint32(&o.DMA_ENABLE.Reg) & 0x1
}

// AES.BLOCK_MODE: Block operation type register
func (o *AES_Type) SetBLOCK_MODE(value uint32) {
	volatile.StoreUint32(&o.BLOCK_MODE.Reg, volatile.LoadUint32(&o.BLOCK_MODE.Reg)&^(0x7)|value)
}
func (o *AES_Type) GetBLOCK_MODE() uint32 {
	return volatile.LoadUint32(&o.BLOCK_MODE.Reg) & 0x7
}

// AES.BLOCK_NUM: Block number configuration register
func (o *AES_Type) SetBLOCK_NUM(value uint32) {
	volatile.StoreUint32(&o.BLOCK_NUM.Reg, value)
}
func (o *AES_Type) GetBLOCK_NUM() uint32 {
	return volatile.LoadUint32(&o.BLOCK_NUM.Reg)
}

// AES.INC_SEL: Standard incrementing function register
func (o *AES_Type) SetINC_SEL(value uint32) {
	volatile.StoreUint32(&o.INC_SEL.Reg, volatile.LoadUint32(&o.INC_SEL.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINC_SEL() uint32 {
	return volatile.LoadUint32(&o.INC_SEL.Reg) & 0x1
}

// AES.AAD_BLOCK_NUM: AAD block number configuration register
func (o *AES_Type) SetAAD_BLOCK_NUM(value uint32) {
	volatile.StoreUint32(&o.AAD_BLOCK_NUM.Reg, value)
}
func (o *AES_Type) GetAAD_BLOCK_NUM() uint32 {
	return volatile.LoadUint32(&o.AAD_BLOCK_NUM.Reg)
}

// AES.REMAINDER_BIT_NUM: Remainder bit number of plaintext/ciphertext
func (o *AES_Type) SetREMAINDER_BIT_NUM(value uint32) {
	volatile.StoreUint32(&o.REMAINDER_BIT_NUM.Reg, volatile.LoadUint32(&o.REMAINDER_BIT_NUM.Reg)&^(0x7f)|value)
}
func (o *AES_Type) GetREMAINDER_BIT_NUM() uint32 {
	return volatile.LoadUint32(&o.REMAINDER_BIT_NUM.Reg) & 0x7f
}

// AES.CONTINUE_OP: Operation continue controlling register
func (o *AES_Type) SetCONTINUE_OP(value uint32) {
	volatile.StoreUint32(&o.CONTINUE_OP.Reg, volatile.LoadUint32(&o.CONTINUE_OP.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCONTINUE_OP() uint32 {
	return volatile.LoadUint32(&o.CONTINUE_OP.Reg) & 0x1
}

// AES.INT_CLR: DMA-AES interrupt clear register
func (o *AES_Type) SetINT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}

// AES.INT_ENA: DMA-AES interrupt enable register
func (o *AES_Type) SetINT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}

// AES.DATE: Version control register
func (o *AES_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x3fffffff)|value)
}
func (o *AES_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x3fffffff
}

// AES.DMA_EXIT: Operation exit controlling register
func (o *AES_Type) SetDMA_EXIT(value uint32) {
	volatile.StoreUint32(&o.DMA_EXIT.Reg, volatile.LoadUint32(&o.DMA_EXIT.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetDMA_EXIT() uint32 {
	return volatile.LoadUint32(&o.DMA_EXIT.Reg) & 0x1
}

// SAR (Successive Approximation Register) Analog-to-Digital Converter
type APB_SARADC_Type struct {
	CTRL           volatile.Register32 // 0x0
	CTRL2          volatile.Register32 // 0x4
	FSM            volatile.Register32 // 0x8
	FSM_WAIT       volatile.Register32 // 0xC
	SAR1_STATUS    volatile.Register32 // 0x10
	SAR2_STATUS    volatile.Register32 // 0x14
	SAR1_PATT_TAB1 volatile.Register32 // 0x18
	SAR1_PATT_TAB2 volatile.Register32 // 0x1C
	SAR1_PATT_TAB3 volatile.Register32 // 0x20
	SAR1_PATT_TAB4 volatile.Register32 // 0x24
	SAR2_PATT_TAB1 volatile.Register32 // 0x28
	SAR2_PATT_TAB2 volatile.Register32 // 0x2C
	SAR2_PATT_TAB3 volatile.Register32 // 0x30
	SAR2_PATT_TAB4 volatile.Register32 // 0x34
	ARB_CTRL       volatile.Register32 // 0x38
	FILTER_CTRL    volatile.Register32 // 0x3C
	FILTER_STATUS  volatile.Register32 // 0x40
	THRES_CTRL     volatile.Register32 // 0x44
	INT_ENA        volatile.Register32 // 0x48
	INT_RAW        volatile.Register32 // 0x4C
	INT_ST         volatile.Register32 // 0x50
	INT_CLR        volatile.Register32 // 0x54
	DMA_CONF       volatile.Register32 // 0x58
	CLKM_CONF      volatile.Register32 // 0x5C
	APB_DAC_CTRL   volatile.Register32 // 0x60
	_              [920]byte
	APB_CTRL_DATE  volatile.Register32 // 0x3FC
}

// APB_SARADC.CTRL: DIG ADC common configuration
func (o *APB_SARADC_Type) SetCTRL_START_FORCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *APB_SARADC_Type) GetCTRL_START_FORCE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *APB_SARADC_Type) SetCTRL_START(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *APB_SARADC_Type) GetCTRL_START() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *APB_SARADC_Type) SetCTRL_WORK_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x18)|value<<3)
}
func (o *APB_SARADC_Type) GetCTRL_WORK_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x18) >> 3
}
func (o *APB_SARADC_Type) SetCTRL_SAR_SEL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *APB_SARADC_Type) GetCTRL_SAR_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}
func (o *APB_SARADC_Type) SetCTRL_SAR_CLK_GATED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *APB_SARADC_Type) GetCTRL_SAR_CLK_GATED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *APB_SARADC_Type) SetCTRL_SAR_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x7f80)|value<<7)
}
func (o *APB_SARADC_Type) GetCTRL_SAR_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x7f80) >> 7
}
func (o *APB_SARADC_Type) SetCTRL_SAR1_PATT_LEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x78000)|value<<15)
}
func (o *APB_SARADC_Type) GetCTRL_SAR1_PATT_LEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x78000) >> 15
}
func (o *APB_SARADC_Type) SetCTRL_SAR2_PATT_LEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x780000)|value<<19)
}
func (o *APB_SARADC_Type) GetCTRL_SAR2_PATT_LEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x780000) >> 19
}
func (o *APB_SARADC_Type) SetCTRL_SAR1_PATT_P_CLEAR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *APB_SARADC_Type) GetCTRL_SAR1_PATT_P_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800000) >> 23
}
func (o *APB_SARADC_Type) SetCTRL_SAR2_PATT_P_CLEAR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *APB_SARADC_Type) GetCTRL_SAR2_PATT_P_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1000000) >> 24
}
func (o *APB_SARADC_Type) SetCTRL_DATA_SAR_SEL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *APB_SARADC_Type) GetCTRL_DATA_SAR_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2000000) >> 25
}
func (o *APB_SARADC_Type) SetCTRL_DATA_TO_I2S(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetCTRL_DATA_TO_I2S() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetCTRL_XPD_SAR_FORCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x18000000)|value<<27)
}
func (o *APB_SARADC_Type) GetCTRL_XPD_SAR_FORCE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x18000000) >> 27
}
func (o *APB_SARADC_Type) SetCTRL_WAIT_ARB_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc0000000)|value<<30)
}
func (o *APB_SARADC_Type) GetCTRL_WAIT_ARB_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc0000000) >> 30
}

// APB_SARADC.CTRL2: DIG ADC common configuration
func (o *APB_SARADC_Type) SetCTRL2_MEAS_NUM_LIMIT(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1)|value)
}
func (o *APB_SARADC_Type) GetCTRL2_MEAS_NUM_LIMIT() uint32 {
	return volatile.LoadUint32(&o.CTRL2.Reg) & 0x1
}
func (o *APB_SARADC_Type) SetCTRL2_MAX_MEAS_NUM(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1fe)|value<<1)
}
func (o *APB_SARADC_Type) GetCTRL2_MAX_MEAS_NUM() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x1fe) >> 1
}
func (o *APB_SARADC_Type) SetCTRL2_SAR1_INV(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x200)|value<<9)
}
func (o *APB_SARADC_Type) GetCTRL2_SAR1_INV() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x200) >> 9
}
func (o *APB_SARADC_Type) SetCTRL2_SAR2_INV(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x400)|value<<10)
}
func (o *APB_SARADC_Type) GetCTRL2_SAR2_INV() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x400) >> 10
}
func (o *APB_SARADC_Type) SetCTRL2_TIMER_SEL(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x800)|value<<11)
}
func (o *APB_SARADC_Type) GetCTRL2_TIMER_SEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x800) >> 11
}
func (o *APB_SARADC_Type) SetCTRL2_TIMER_TARGET(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0xfff000)|value<<12)
}
func (o *APB_SARADC_Type) GetCTRL2_TIMER_TARGET() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0xfff000) >> 12
}
func (o *APB_SARADC_Type) SetCTRL2_TIMER_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1000000)|value<<24)
}
func (o *APB_SARADC_Type) GetCTRL2_TIMER_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x1000000) >> 24
}

// APB_SARADC.FSM: digital adc control register
func (o *APB_SARADC_Type) SetFSM_SAMPLE_NUM(value uint32) {
	volatile.StoreUint32(&o.FSM.Reg, volatile.LoadUint32(&o.FSM.Reg)&^(0xff0000)|value<<16)
}
func (o *APB_SARADC_Type) GetFSM_SAMPLE_NUM() uint32 {
	return (volatile.LoadUint32(&o.FSM.Reg) & 0xff0000) >> 16
}
func (o *APB_SARADC_Type) SetFSM_SAMPLE_CYCLE(value uint32) {
	volatile.StoreUint32(&o.FSM.Reg, volatile.LoadUint32(&o.FSM.Reg)&^(0xff000000)|value<<24)
}
func (o *APB_SARADC_Type) GetFSM_SAMPLE_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.FSM.Reg) & 0xff000000) >> 24
}

// APB_SARADC.FSM_WAIT: configure saradc fsm internal parameter base on test
func (o *APB_SARADC_Type) SetFSM_WAIT_XPD_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff)|value)
}
func (o *APB_SARADC_Type) GetFSM_WAIT_XPD_WAIT() uint32 {
	return volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff
}
func (o *APB_SARADC_Type) SetFSM_WAIT_RSTB_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff00)|value<<8)
}
func (o *APB_SARADC_Type) GetFSM_WAIT_RSTB_WAIT() uint32 {
	return (volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff00) >> 8
}
func (o *APB_SARADC_Type) SetFSM_WAIT_STANDBY_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff0000)|value<<16)
}
func (o *APB_SARADC_Type) GetFSM_WAIT_STANDBY_WAIT() uint32 {
	return (volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff0000) >> 16
}

// APB_SARADC.SAR1_STATUS: digital adc1 status
func (o *APB_SARADC_Type) SetSAR1_STATUS(value uint32) {
	volatile.StoreUint32(&o.SAR1_STATUS.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR1_STATUS() uint32 {
	return volatile.LoadUint32(&o.SAR1_STATUS.Reg)
}

// APB_SARADC.SAR2_STATUS: digital adc2 status
func (o *APB_SARADC_Type) SetSAR2_STATUS(value uint32) {
	volatile.StoreUint32(&o.SAR2_STATUS.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR2_STATUS() uint32 {
	return volatile.LoadUint32(&o.SAR2_STATUS.Reg)
}

// APB_SARADC.SAR1_PATT_TAB1: item 0 ~ 3 for pattern table 1 (each item one byte)
func (o *APB_SARADC_Type) SetSAR1_PATT_TAB1(value uint32) {
	volatile.StoreUint32(&o.SAR1_PATT_TAB1.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR1_PATT_TAB1() uint32 {
	return volatile.LoadUint32(&o.SAR1_PATT_TAB1.Reg)
}

// APB_SARADC.SAR1_PATT_TAB2: Item 4 ~ 7 for pattern table 1 (each item one byte)
func (o *APB_SARADC_Type) SetSAR1_PATT_TAB2(value uint32) {
	volatile.StoreUint32(&o.SAR1_PATT_TAB2.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR1_PATT_TAB2() uint32 {
	return volatile.LoadUint32(&o.SAR1_PATT_TAB2.Reg)
}

// APB_SARADC.SAR1_PATT_TAB3: Item 8 ~ 11 for pattern table 1 (each item one byte)
func (o *APB_SARADC_Type) SetSAR1_PATT_TAB3(value uint32) {
	volatile.StoreUint32(&o.SAR1_PATT_TAB3.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR1_PATT_TAB3() uint32 {
	return volatile.LoadUint32(&o.SAR1_PATT_TAB3.Reg)
}

// APB_SARADC.SAR1_PATT_TAB4: Item 12 ~ 15 for pattern table 1 (each item one byte)
func (o *APB_SARADC_Type) SetSAR1_PATT_TAB4(value uint32) {
	volatile.StoreUint32(&o.SAR1_PATT_TAB4.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR1_PATT_TAB4() uint32 {
	return volatile.LoadUint32(&o.SAR1_PATT_TAB4.Reg)
}

// APB_SARADC.SAR2_PATT_TAB1: item 0 ~ 3 for pattern table 2 (each item one byte)
func (o *APB_SARADC_Type) SetSAR2_PATT_TAB1(value uint32) {
	volatile.StoreUint32(&o.SAR2_PATT_TAB1.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR2_PATT_TAB1() uint32 {
	return volatile.LoadUint32(&o.SAR2_PATT_TAB1.Reg)
}

// APB_SARADC.SAR2_PATT_TAB2: Item 4 ~ 7 for pattern table 2 (each item one byte)
func (o *APB_SARADC_Type) SetSAR2_PATT_TAB2(value uint32) {
	volatile.StoreUint32(&o.SAR2_PATT_TAB2.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR2_PATT_TAB2() uint32 {
	return volatile.LoadUint32(&o.SAR2_PATT_TAB2.Reg)
}

// APB_SARADC.SAR2_PATT_TAB3: Item 8 ~ 11 for pattern table 2 (each item one byte)
func (o *APB_SARADC_Type) SetSAR2_PATT_TAB3(value uint32) {
	volatile.StoreUint32(&o.SAR2_PATT_TAB3.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR2_PATT_TAB3() uint32 {
	return volatile.LoadUint32(&o.SAR2_PATT_TAB3.Reg)
}

// APB_SARADC.SAR2_PATT_TAB4: Item 12 ~ 15 for pattern table 2 (each item one byte)
func (o *APB_SARADC_Type) SetSAR2_PATT_TAB4(value uint32) {
	volatile.StoreUint32(&o.SAR2_PATT_TAB4.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR2_PATT_TAB4() uint32 {
	return volatile.LoadUint32(&o.SAR2_PATT_TAB4.Reg)
}

// APB_SARADC.ARB_CTRL: Configure the settings of DIG ADC2 arbiter
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_APB_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_APB_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x4) >> 2
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_RTC_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_RTC_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x8) >> 3
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_WIFI_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_WIFI_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x10) >> 4
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_GRANT_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_GRANT_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x20) >> 5
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_APB_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0xc0)|value<<6)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_APB_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0xc0) >> 6
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_RTC_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_RTC_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x300) >> 8
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_WIFI_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_WIFI_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0xc00) >> 10
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_FIX_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_FIX_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x1000) >> 12
}

// APB_SARADC.FILTER_CTRL: Configure the settings of DIG ADC2 filter
func (o *APB_SARADC_Type) SetFILTER_CTRL_ADC2_FILTER_RESET(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL.Reg, volatile.LoadUint32(&o.FILTER_CTRL.Reg)&^(0x1)|value)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL_ADC2_FILTER_RESET() uint32 {
	return volatile.LoadUint32(&o.FILTER_CTRL.Reg) & 0x1
}
func (o *APB_SARADC_Type) SetFILTER_CTRL_ADC1_FILTER_RESET(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL.Reg, volatile.LoadUint32(&o.FILTER_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL_ADC1_FILTER_RESET() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL.Reg) & 0x2) >> 1
}
func (o *APB_SARADC_Type) SetFILTER_CTRL_ADC2_FILTER_FACTOR(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL.Reg, volatile.LoadUint32(&o.FILTER_CTRL.Reg)&^(0x7f0000)|value<<16)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL_ADC2_FILTER_FACTOR() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL.Reg) & 0x7f0000) >> 16
}
func (o *APB_SARADC_Type) SetFILTER_CTRL_ADC1_FILTER_FACTOR(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL.Reg, volatile.LoadUint32(&o.FILTER_CTRL.Reg)&^(0x3f800000)|value<<23)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL_ADC1_FILTER_FACTOR() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL.Reg) & 0x3f800000) >> 23
}
func (o *APB_SARADC_Type) SetFILTER_CTRL_ADC2_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL.Reg, volatile.LoadUint32(&o.FILTER_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL_ADC2_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetFILTER_CTRL_ADC1_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL.Reg, volatile.LoadUint32(&o.FILTER_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL_ADC1_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL.Reg) & 0x80000000) >> 31
}

// APB_SARADC.FILTER_STATUS: Data status of DIG ADC2 filter
func (o *APB_SARADC_Type) SetFILTER_STATUS_ADC2_FILTER_DATA(value uint32) {
	volatile.StoreUint32(&o.FILTER_STATUS.Reg, volatile.LoadUint32(&o.FILTER_STATUS.Reg)&^(0xffff)|value)
}
func (o *APB_SARADC_Type) GetFILTER_STATUS_ADC2_FILTER_DATA() uint32 {
	return volatile.LoadUint32(&o.FILTER_STATUS.Reg) & 0xffff
}
func (o *APB_SARADC_Type) SetFILTER_STATUS_ADC1_FILTER_DATA(value uint32) {
	volatile.StoreUint32(&o.FILTER_STATUS.Reg, volatile.LoadUint32(&o.FILTER_STATUS.Reg)&^(0xffff0000)|value<<16)
}
func (o *APB_SARADC_Type) GetFILTER_STATUS_ADC1_FILTER_DATA() uint32 {
	return (volatile.LoadUint32(&o.FILTER_STATUS.Reg) & 0xffff0000) >> 16
}

// APB_SARADC.THRES_CTRL: Configure monitor threshold for DIG ADC2
func (o *APB_SARADC_Type) SetTHRES_CTRL_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x1)|value)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x1
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_ADC2_THRES_MODE(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_ADC2_THRES_MODE() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x4) >> 2
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_ADC1_THRES_MODE(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_ADC1_THRES_MODE() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x8) >> 3
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_ADC2_THRES(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x1fff0)|value<<4)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_ADC2_THRES() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x1fff0) >> 4
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_ADC1_THRES(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x3ffe0000)|value<<17)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_ADC1_THRES() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x3ffe0000) >> 17
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_ADC2_THRES_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_ADC2_THRES_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_ADC1_THRES_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_ADC1_THRES_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_ENA: Enable DIG ADC interrupts
func (o *APB_SARADC_Type) SetINT_ENA_ADC2_THRES_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_ENA_ADC2_THRES_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_ENA_ADC1_THRES_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_ENA_ADC1_THRES_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_ENA_ADC2_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_ENA_ADC2_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_ENA_ADC1_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_ENA_ADC1_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_RAW: DIG ADC interrupt raw bits
func (o *APB_SARADC_Type) SetINT_RAW_ADC2_THRES_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_RAW_ADC2_THRES_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_RAW_ADC1_THRES_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_RAW_ADC1_THRES_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_RAW_ADC2_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_RAW_ADC2_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_RAW_ADC1_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_RAW_ADC1_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_ST: DIG ADC interrupt status
func (o *APB_SARADC_Type) SetINT_ST_ADC2_THRES_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_ST_ADC2_THRES_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_ST_ADC1_THRES_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_ST_ADC1_THRES_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_ST_ADC2_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_ST_ADC2_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_ST_ADC1_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_ST_ADC1_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_CLR: Clear DIG ADC interrupts
func (o *APB_SARADC_Type) SetINT_CLR_ADC2_THRES_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_CLR_ADC2_THRES_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_CLR_ADC1_THRES_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_CLR_ADC1_THRES_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_CLR_ADC2_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_CLR_ADC2_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_CLR_ADC1_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_CLR_ADC1_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80000000) >> 31
}

// APB_SARADC.DMA_CONF: Configure digital ADC DMA path
func (o *APB_SARADC_Type) SetDMA_CONF_APB_ADC_EOF_NUM(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0xffff)|value)
}
func (o *APB_SARADC_Type) GetDMA_CONF_APB_ADC_EOF_NUM() uint32 {
	return volatile.LoadUint32(&o.DMA_CONF.Reg) & 0xffff
}
func (o *APB_SARADC_Type) SetDMA_CONF_APB_ADC_RESET_FSM(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetDMA_CONF_APB_ADC_RESET_FSM() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetDMA_CONF_APB_ADC_TRANS(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetDMA_CONF_APB_ADC_TRANS() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x80000000) >> 31
}

// APB_SARADC.CLKM_CONF: Configure DIG ADC clock
func (o *APB_SARADC_Type) SetCLKM_CONF_CLKM_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0xff)|value)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLKM_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0xff
}
func (o *APB_SARADC_Type) SetCLKM_CONF_CLKM_DIV_B(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x3f00)|value<<8)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLKM_DIV_B() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x3f00) >> 8
}
func (o *APB_SARADC_Type) SetCLKM_CONF_CLKM_DIV_A(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0xfc000)|value<<14)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLKM_DIV_A() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0xfc000) >> 14
}
func (o *APB_SARADC_Type) SetCLKM_CONF_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x600000)|value<<21)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x600000) >> 21
}

// APB_SARADC.APB_DAC_CTRL: Configure DAC settings
func (o *APB_SARADC_Type) SetAPB_DAC_CTRL_DAC_TIMER_TARGET(value uint32) {
	volatile.StoreUint32(&o.APB_DAC_CTRL.Reg, volatile.LoadUint32(&o.APB_DAC_CTRL.Reg)&^(0xfff)|value)
}
func (o *APB_SARADC_Type) GetAPB_DAC_CTRL_DAC_TIMER_TARGET() uint32 {
	return volatile.LoadUint32(&o.APB_DAC_CTRL.Reg) & 0xfff
}
func (o *APB_SARADC_Type) SetAPB_DAC_CTRL_DAC_TIMER_EN(value uint32) {
	volatile.StoreUint32(&o.APB_DAC_CTRL.Reg, volatile.LoadUint32(&o.APB_DAC_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *APB_SARADC_Type) GetAPB_DAC_CTRL_DAC_TIMER_EN() uint32 {
	return (volatile.LoadUint32(&o.APB_DAC_CTRL.Reg) & 0x1000) >> 12
}
func (o *APB_SARADC_Type) SetAPB_DAC_CTRL_APB_DAC_ALTER_MODE(value uint32) {
	volatile.StoreUint32(&o.APB_DAC_CTRL.Reg, volatile.LoadUint32(&o.APB_DAC_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *APB_SARADC_Type) GetAPB_DAC_CTRL_APB_DAC_ALTER_MODE() uint32 {
	return (volatile.LoadUint32(&o.APB_DAC_CTRL.Reg) & 0x2000) >> 13
}
func (o *APB_SARADC_Type) SetAPB_DAC_CTRL_APB_DAC_TRANS(value uint32) {
	volatile.StoreUint32(&o.APB_DAC_CTRL.Reg, volatile.LoadUint32(&o.APB_DAC_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *APB_SARADC_Type) GetAPB_DAC_CTRL_APB_DAC_TRANS() uint32 {
	return (volatile.LoadUint32(&o.APB_DAC_CTRL.Reg) & 0x4000) >> 14
}
func (o *APB_SARADC_Type) SetAPB_DAC_CTRL_DAC_RESET_FIFO(value uint32) {
	volatile.StoreUint32(&o.APB_DAC_CTRL.Reg, volatile.LoadUint32(&o.APB_DAC_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *APB_SARADC_Type) GetAPB_DAC_CTRL_DAC_RESET_FIFO() uint32 {
	return (volatile.LoadUint32(&o.APB_DAC_CTRL.Reg) & 0x8000) >> 15
}
func (o *APB_SARADC_Type) SetAPB_DAC_CTRL_APB_DAC_RST(value uint32) {
	volatile.StoreUint32(&o.APB_DAC_CTRL.Reg, volatile.LoadUint32(&o.APB_DAC_CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *APB_SARADC_Type) GetAPB_DAC_CTRL_APB_DAC_RST() uint32 {
	return (volatile.LoadUint32(&o.APB_DAC_CTRL.Reg) & 0x10000) >> 16
}

// APB_SARADC.APB_CTRL_DATE: Version control register
func (o *APB_SARADC_Type) SetAPB_CTRL_DATE(value uint32) {
	volatile.StoreUint32(&o.APB_CTRL_DATE.Reg, value)
}
func (o *APB_SARADC_Type) GetAPB_CTRL_DATE() uint32 {
	return volatile.LoadUint32(&o.APB_CTRL_DATE.Reg)
}

// BB Peripheral
type BB_Type struct {
	_         [84]byte
	BBPD_CTRL volatile.Register32 // 0x54
}

// BB.BBPD_CTRL: Baseband control register
func (o *BB_Type) SetBBPD_CTRL_DC_EST_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x1)|value)
}
func (o *BB_Type) GetBBPD_CTRL_DC_EST_FORCE_PD() uint32 {
	return volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x1
}
func (o *BB_Type) SetBBPD_CTRL_DC_EST_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *BB_Type) GetBBPD_CTRL_DC_EST_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x2) >> 1
}
func (o *BB_Type) SetBBPD_CTRL_FFT_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *BB_Type) GetBBPD_CTRL_FFT_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x4) >> 2
}
func (o *BB_Type) SetBBPD_CTRL_FFT_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.BBPD_CTRL.Reg, volatile.LoadUint32(&o.BBPD_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *BB_Type) GetBBPD_CTRL_FFT_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.BBPD_CTRL.Reg) & 0x8) >> 3
}

// DEDICATED_GPIO Peripheral
type DEDIC_GPIO_Type struct {
	OUT_DRT   volatile.Register32 // 0x0
	OUT_MSK   volatile.Register32 // 0x4
	OUT_IDV   volatile.Register32 // 0x8
	OUT_SCAN  volatile.Register32 // 0xC
	OUT_CPU   volatile.Register32 // 0x10
	IN_DLY    volatile.Register32 // 0x14
	IN_SCAN   volatile.Register32 // 0x18
	INTR_RCGN volatile.Register32 // 0x1C
	INTR_RAW  volatile.Register32 // 0x20
	INTR_RLS  volatile.Register32 // 0x24
	INTR_ST   volatile.Register32 // 0x28
	INTR_CLR  volatile.Register32 // 0x2C
}

// DEDIC_GPIO.OUT_DRT: Dedicated GPIO directive output register
func (o *DEDIC_GPIO_Type) SetOUT_DRT_VLAUE(value uint32) {
	volatile.StoreUint32(&o.OUT_DRT.Reg, volatile.LoadUint32(&o.OUT_DRT.Reg)&^(0xff)|value)
}
func (o *DEDIC_GPIO_Type) GetOUT_DRT_VLAUE() uint32 {
	return volatile.LoadUint32(&o.OUT_DRT.Reg) & 0xff
}

// DEDIC_GPIO.OUT_MSK: Dedicated GPIO mask output register
func (o *DEDIC_GPIO_Type) SetOUT_MSK_OUT_VALUE(value uint32) {
	volatile.StoreUint32(&o.OUT_MSK.Reg, volatile.LoadUint32(&o.OUT_MSK.Reg)&^(0xff)|value)
}
func (o *DEDIC_GPIO_Type) GetOUT_MSK_OUT_VALUE() uint32 {
	return volatile.LoadUint32(&o.OUT_MSK.Reg) & 0xff
}
func (o *DEDIC_GPIO_Type) SetOUT_MSK(value uint32) {
	volatile.StoreUint32(&o.OUT_MSK.Reg, volatile.LoadUint32(&o.OUT_MSK.Reg)&^(0xff00)|value<<8)
}
func (o *DEDIC_GPIO_Type) GetOUT_MSK() uint32 {
	return (volatile.LoadUint32(&o.OUT_MSK.Reg) & 0xff00) >> 8
}

// DEDIC_GPIO.OUT_IDV: Dedicated GPIO individual output register
func (o *DEDIC_GPIO_Type) SetOUT_IDV_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_IDV.Reg, volatile.LoadUint32(&o.OUT_IDV.Reg)&^(0x3)|value)
}
func (o *DEDIC_GPIO_Type) GetOUT_IDV_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_IDV.Reg) & 0x3
}
func (o *DEDIC_GPIO_Type) SetOUT_IDV_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_IDV.Reg, volatile.LoadUint32(&o.OUT_IDV.Reg)&^(0xc)|value<<2)
}
func (o *DEDIC_GPIO_Type) GetOUT_IDV_CH1() uint32 {
	return (volatile.LoadUint32(&o.OUT_IDV.Reg) & 0xc) >> 2
}
func (o *DEDIC_GPIO_Type) SetOUT_IDV_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_IDV.Reg, volatile.LoadUint32(&o.OUT_IDV.Reg)&^(0x30)|value<<4)
}
func (o *DEDIC_GPIO_Type) GetOUT_IDV_CH2() uint32 {
	return (volatile.LoadUint32(&o.OUT_IDV.Reg) & 0x30) >> 4
}
func (o *DEDIC_GPIO_Type) SetOUT_IDV_CH3(value uint32) {
	volatile.StoreUint32(&o.OUT_IDV.Reg, volatile.LoadUint32(&o.OUT_IDV.Reg)&^(0xc0)|value<<6)
}
func (o *DEDIC_GPIO_Type) GetOUT_IDV_CH3() uint32 {
	return (volatile.LoadUint32(&o.OUT_IDV.Reg) & 0xc0) >> 6
}
func (o *DEDIC_GPIO_Type) SetOUT_IDV_CH4(value uint32) {
	volatile.StoreUint32(&o.OUT_IDV.Reg, volatile.LoadUint32(&o.OUT_IDV.Reg)&^(0x300)|value<<8)
}
func (o *DEDIC_GPIO_Type) GetOUT_IDV_CH4() uint32 {
	return (volatile.LoadUint32(&o.OUT_IDV.Reg) & 0x300) >> 8
}
func (o *DEDIC_GPIO_Type) SetOUT_IDV_CH5(value uint32) {
	volatile.StoreUint32(&o.OUT_IDV.Reg, volatile.LoadUint32(&o.OUT_IDV.Reg)&^(0xc00)|value<<10)
}
func (o *DEDIC_GPIO_Type) GetOUT_IDV_CH5() uint32 {
	return (volatile.LoadUint32(&o.OUT_IDV.Reg) & 0xc00) >> 10
}
func (o *DEDIC_GPIO_Type) SetOUT_IDV_CH6(value uint32) {
	volatile.StoreUint32(&o.OUT_IDV.Reg, volatile.LoadUint32(&o.OUT_IDV.Reg)&^(0x3000)|value<<12)
}
func (o *DEDIC_GPIO_Type) GetOUT_IDV_CH6() uint32 {
	return (volatile.LoadUint32(&o.OUT_IDV.Reg) & 0x3000) >> 12
}
func (o *DEDIC_GPIO_Type) SetOUT_IDV_CH7(value uint32) {
	volatile.StoreUint32(&o.OUT_IDV.Reg, volatile.LoadUint32(&o.OUT_IDV.Reg)&^(0xc000)|value<<14)
}
func (o *DEDIC_GPIO_Type) GetOUT_IDV_CH7() uint32 {
	return (volatile.LoadUint32(&o.OUT_IDV.Reg) & 0xc000) >> 14
}

// DEDIC_GPIO.OUT_SCAN: Dedicated GPIO output status register
func (o *DEDIC_GPIO_Type) SetOUT_SCAN_OUT_STATUS(value uint32) {
	volatile.StoreUint32(&o.OUT_SCAN.Reg, volatile.LoadUint32(&o.OUT_SCAN.Reg)&^(0xff)|value)
}
func (o *DEDIC_GPIO_Type) GetOUT_SCAN_OUT_STATUS() uint32 {
	return volatile.LoadUint32(&o.OUT_SCAN.Reg) & 0xff
}

// DEDIC_GPIO.OUT_CPU: Dedicated GPIO output mode selection register
func (o *DEDIC_GPIO_Type) SetOUT_CPU_SEL0(value uint32) {
	volatile.StoreUint32(&o.OUT_CPU.Reg, volatile.LoadUint32(&o.OUT_CPU.Reg)&^(0x1)|value)
}
func (o *DEDIC_GPIO_Type) GetOUT_CPU_SEL0() uint32 {
	return volatile.LoadUint32(&o.OUT_CPU.Reg) & 0x1
}
func (o *DEDIC_GPIO_Type) SetOUT_CPU_SEL1(value uint32) {
	volatile.StoreUint32(&o.OUT_CPU.Reg, volatile.LoadUint32(&o.OUT_CPU.Reg)&^(0x2)|value<<1)
}
func (o *DEDIC_GPIO_Type) GetOUT_CPU_SEL1() uint32 {
	return (volatile.LoadUint32(&o.OUT_CPU.Reg) & 0x2) >> 1
}
func (o *DEDIC_GPIO_Type) SetOUT_CPU_SEL2(value uint32) {
	volatile.StoreUint32(&o.OUT_CPU.Reg, volatile.LoadUint32(&o.OUT_CPU.Reg)&^(0x4)|value<<2)
}
func (o *DEDIC_GPIO_Type) GetOUT_CPU_SEL2() uint32 {
	return (volatile.LoadUint32(&o.OUT_CPU.Reg) & 0x4) >> 2
}
func (o *DEDIC_GPIO_Type) SetOUT_CPU_SEL3(value uint32) {
	volatile.StoreUint32(&o.OUT_CPU.Reg, volatile.LoadUint32(&o.OUT_CPU.Reg)&^(0x8)|value<<3)
}
func (o *DEDIC_GPIO_Type) GetOUT_CPU_SEL3() uint32 {
	return (volatile.LoadUint32(&o.OUT_CPU.Reg) & 0x8) >> 3
}
func (o *DEDIC_GPIO_Type) SetOUT_CPU_SEL4(value uint32) {
	volatile.StoreUint32(&o.OUT_CPU.Reg, volatile.LoadUint32(&o.OUT_CPU.Reg)&^(0x10)|value<<4)
}
func (o *DEDIC_GPIO_Type) GetOUT_CPU_SEL4() uint32 {
	return (volatile.LoadUint32(&o.OUT_CPU.Reg) & 0x10) >> 4
}
func (o *DEDIC_GPIO_Type) SetOUT_CPU_SEL5(value uint32) {
	volatile.StoreUint32(&o.OUT_CPU.Reg, volatile.LoadUint32(&o.OUT_CPU.Reg)&^(0x20)|value<<5)
}
func (o *DEDIC_GPIO_Type) GetOUT_CPU_SEL5() uint32 {
	return (volatile.LoadUint32(&o.OUT_CPU.Reg) & 0x20) >> 5
}
func (o *DEDIC_GPIO_Type) SetOUT_CPU_SEL6(value uint32) {
	volatile.StoreUint32(&o.OUT_CPU.Reg, volatile.LoadUint32(&o.OUT_CPU.Reg)&^(0x40)|value<<6)
}
func (o *DEDIC_GPIO_Type) GetOUT_CPU_SEL6() uint32 {
	return (volatile.LoadUint32(&o.OUT_CPU.Reg) & 0x40) >> 6
}
func (o *DEDIC_GPIO_Type) SetOUT_CPU_SEL7(value uint32) {
	volatile.StoreUint32(&o.OUT_CPU.Reg, volatile.LoadUint32(&o.OUT_CPU.Reg)&^(0x80)|value<<7)
}
func (o *DEDIC_GPIO_Type) GetOUT_CPU_SEL7() uint32 {
	return (volatile.LoadUint32(&o.OUT_CPU.Reg) & 0x80) >> 7
}

// DEDIC_GPIO.IN_DLY: Dedicated GPIO input delay configuration register
func (o *DEDIC_GPIO_Type) SetIN_DLY_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DLY.Reg, volatile.LoadUint32(&o.IN_DLY.Reg)&^(0x3)|value)
}
func (o *DEDIC_GPIO_Type) GetIN_DLY_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DLY.Reg) & 0x3
}
func (o *DEDIC_GPIO_Type) SetIN_DLY_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DLY.Reg, volatile.LoadUint32(&o.IN_DLY.Reg)&^(0xc)|value<<2)
}
func (o *DEDIC_GPIO_Type) GetIN_DLY_CH1() uint32 {
	return (volatile.LoadUint32(&o.IN_DLY.Reg) & 0xc) >> 2
}
func (o *DEDIC_GPIO_Type) SetIN_DLY_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DLY.Reg, volatile.LoadUint32(&o.IN_DLY.Reg)&^(0x30)|value<<4)
}
func (o *DEDIC_GPIO_Type) GetIN_DLY_CH2() uint32 {
	return (volatile.LoadUint32(&o.IN_DLY.Reg) & 0x30) >> 4
}
func (o *DEDIC_GPIO_Type) SetIN_DLY_CH3(value uint32) {
	volatile.StoreUint32(&o.IN_DLY.Reg, volatile.LoadUint32(&o.IN_DLY.Reg)&^(0xc0)|value<<6)
}
func (o *DEDIC_GPIO_Type) GetIN_DLY_CH3() uint32 {
	return (volatile.LoadUint32(&o.IN_DLY.Reg) & 0xc0) >> 6
}
func (o *DEDIC_GPIO_Type) SetIN_DLY_CH4(value uint32) {
	volatile.StoreUint32(&o.IN_DLY.Reg, volatile.LoadUint32(&o.IN_DLY.Reg)&^(0x300)|value<<8)
}
func (o *DEDIC_GPIO_Type) GetIN_DLY_CH4() uint32 {
	return (volatile.LoadUint32(&o.IN_DLY.Reg) & 0x300) >> 8
}
func (o *DEDIC_GPIO_Type) SetIN_DLY_CH5(value uint32) {
	volatile.StoreUint32(&o.IN_DLY.Reg, volatile.LoadUint32(&o.IN_DLY.Reg)&^(0xc00)|value<<10)
}
func (o *DEDIC_GPIO_Type) GetIN_DLY_CH5() uint32 {
	return (volatile.LoadUint32(&o.IN_DLY.Reg) & 0xc00) >> 10
}
func (o *DEDIC_GPIO_Type) SetIN_DLY_CH6(value uint32) {
	volatile.StoreUint32(&o.IN_DLY.Reg, volatile.LoadUint32(&o.IN_DLY.Reg)&^(0x3000)|value<<12)
}
func (o *DEDIC_GPIO_Type) GetIN_DLY_CH6() uint32 {
	return (volatile.LoadUint32(&o.IN_DLY.Reg) & 0x3000) >> 12
}
func (o *DEDIC_GPIO_Type) SetIN_DLY_CH7(value uint32) {
	volatile.StoreUint32(&o.IN_DLY.Reg, volatile.LoadUint32(&o.IN_DLY.Reg)&^(0xc000)|value<<14)
}
func (o *DEDIC_GPIO_Type) GetIN_DLY_CH7() uint32 {
	return (volatile.LoadUint32(&o.IN_DLY.Reg) & 0xc000) >> 14
}

// DEDIC_GPIO.IN_SCAN: Dedicated GPIO input status register
func (o *DEDIC_GPIO_Type) SetIN_SCAN_IN_STATUS(value uint32) {
	volatile.StoreUint32(&o.IN_SCAN.Reg, volatile.LoadUint32(&o.IN_SCAN.Reg)&^(0xff)|value)
}
func (o *DEDIC_GPIO_Type) GetIN_SCAN_IN_STATUS() uint32 {
	return volatile.LoadUint32(&o.IN_SCAN.Reg) & 0xff
}

// DEDIC_GPIO.INTR_RCGN: Dedicated GPIO interrupts generation mode register
func (o *DEDIC_GPIO_Type) SetINTR_RCGN_INTR_MODE_CH0(value uint32) {
	volatile.StoreUint32(&o.INTR_RCGN.Reg, volatile.LoadUint32(&o.INTR_RCGN.Reg)&^(0x7)|value)
}
func (o *DEDIC_GPIO_Type) GetINTR_RCGN_INTR_MODE_CH0() uint32 {
	return volatile.LoadUint32(&o.INTR_RCGN.Reg) & 0x7
}
func (o *DEDIC_GPIO_Type) SetINTR_RCGN_INTR_MODE_CH1(value uint32) {
	volatile.StoreUint32(&o.INTR_RCGN.Reg, volatile.LoadUint32(&o.INTR_RCGN.Reg)&^(0x38)|value<<3)
}
func (o *DEDIC_GPIO_Type) GetINTR_RCGN_INTR_MODE_CH1() uint32 {
	return (volatile.LoadUint32(&o.INTR_RCGN.Reg) & 0x38) >> 3
}
func (o *DEDIC_GPIO_Type) SetINTR_RCGN_INTR_MODE_CH2(value uint32) {
	volatile.StoreUint32(&o.INTR_RCGN.Reg, volatile.LoadUint32(&o.INTR_RCGN.Reg)&^(0x1c0)|value<<6)
}
func (o *DEDIC_GPIO_Type) GetINTR_RCGN_INTR_MODE_CH2() uint32 {
	return (volatile.LoadUint32(&o.INTR_RCGN.Reg) & 0x1c0) >> 6
}
func (o *DEDIC_GPIO_Type) SetINTR_RCGN_INTR_MODE_CH3(value uint32) {
	volatile.StoreUint32(&o.INTR_RCGN.Reg, volatile.LoadUint32(&o.INTR_RCGN.Reg)&^(0xe00)|value<<9)
}
func (o *DEDIC_GPIO_Type) GetINTR_RCGN_INTR_MODE_CH3() uint32 {
	return (volatile.LoadUint32(&o.INTR_RCGN.Reg) & 0xe00) >> 9
}
func (o *DEDIC_GPIO_Type) SetINTR_RCGN_INTR_MODE_CH4(value uint32) {
	volatile.StoreUint32(&o.INTR_RCGN.Reg, volatile.LoadUint32(&o.INTR_RCGN.Reg)&^(0x7000)|value<<12)
}
func (o *DEDIC_GPIO_Type) GetINTR_RCGN_INTR_MODE_CH4() uint32 {
	return (volatile.LoadUint32(&o.INTR_RCGN.Reg) & 0x7000) >> 12
}
func (o *DEDIC_GPIO_Type) SetINTR_RCGN_INTR_MODE_CH5(value uint32) {
	volatile.StoreUint32(&o.INTR_RCGN.Reg, volatile.LoadUint32(&o.INTR_RCGN.Reg)&^(0x38000)|value<<15)
}
func (o *DEDIC_GPIO_Type) GetINTR_RCGN_INTR_MODE_CH5() uint32 {
	return (volatile.LoadUint32(&o.INTR_RCGN.Reg) & 0x38000) >> 15
}
func (o *DEDIC_GPIO_Type) SetINTR_RCGN_INTR_MODE_CH6(value uint32) {
	volatile.StoreUint32(&o.INTR_RCGN.Reg, volatile.LoadUint32(&o.INTR_RCGN.Reg)&^(0x1c0000)|value<<18)
}
func (o *DEDIC_GPIO_Type) GetINTR_RCGN_INTR_MODE_CH6() uint32 {
	return (volatile.LoadUint32(&o.INTR_RCGN.Reg) & 0x1c0000) >> 18
}
func (o *DEDIC_GPIO_Type) SetINTR_RCGN_INTR_MODE_CH7(value uint32) {
	volatile.StoreUint32(&o.INTR_RCGN.Reg, volatile.LoadUint32(&o.INTR_RCGN.Reg)&^(0xe00000)|value<<21)
}
func (o *DEDIC_GPIO_Type) GetINTR_RCGN_INTR_MODE_CH7() uint32 {
	return (volatile.LoadUint32(&o.INTR_RCGN.Reg) & 0xe00000) >> 21
}

// DEDIC_GPIO.INTR_RAW: Raw interrupt status
func (o *DEDIC_GPIO_Type) SetINTR_RAW_GPIO0(value uint32) {
	volatile.StoreUint32(&o.INTR_RAW.Reg, volatile.LoadUint32(&o.INTR_RAW.Reg)&^(0x1)|value)
}
func (o *DEDIC_GPIO_Type) GetINTR_RAW_GPIO0() uint32 {
	return volatile.LoadUint32(&o.INTR_RAW.Reg) & 0x1
}
func (o *DEDIC_GPIO_Type) SetINTR_RAW_GPIO1(value uint32) {
	volatile.StoreUint32(&o.INTR_RAW.Reg, volatile.LoadUint32(&o.INTR_RAW.Reg)&^(0x2)|value<<1)
}
func (o *DEDIC_GPIO_Type) GetINTR_RAW_GPIO1() uint32 {
	return (volatile.LoadUint32(&o.INTR_RAW.Reg) & 0x2) >> 1
}
func (o *DEDIC_GPIO_Type) SetINTR_RAW_GPIO2(value uint32) {
	volatile.StoreUint32(&o.INTR_RAW.Reg, volatile.LoadUint32(&o.INTR_RAW.Reg)&^(0x4)|value<<2)
}
func (o *DEDIC_GPIO_Type) GetINTR_RAW_GPIO2() uint32 {
	return (volatile.LoadUint32(&o.INTR_RAW.Reg) & 0x4) >> 2
}
func (o *DEDIC_GPIO_Type) SetINTR_RAW_GPIO3(value uint32) {
	volatile.StoreUint32(&o.INTR_RAW.Reg, volatile.LoadUint32(&o.INTR_RAW.Reg)&^(0x8)|value<<3)
}
func (o *DEDIC_GPIO_Type) GetINTR_RAW_GPIO3() uint32 {
	return (volatile.LoadUint32(&o.INTR_RAW.Reg) & 0x8) >> 3
}
func (o *DEDIC_GPIO_Type) SetINTR_RAW_GPIO4(value uint32) {
	volatile.StoreUint32(&o.INTR_RAW.Reg, volatile.LoadUint32(&o.INTR_RAW.Reg)&^(0x10)|value<<4)
}
func (o *DEDIC_GPIO_Type) GetINTR_RAW_GPIO4() uint32 {
	return (volatile.LoadUint32(&o.INTR_RAW.Reg) & 0x10) >> 4
}
func (o *DEDIC_GPIO_Type) SetINTR_RAW_GPIO5(value uint32) {
	volatile.StoreUint32(&o.INTR_RAW.Reg, volatile.LoadUint32(&o.INTR_RAW.Reg)&^(0x20)|value<<5)
}
func (o *DEDIC_GPIO_Type) GetINTR_RAW_GPIO5() uint32 {
	return (volatile.LoadUint32(&o.INTR_RAW.Reg) & 0x20) >> 5
}
func (o *DEDIC_GPIO_Type) SetINTR_RAW_GPIO6(value uint32) {
	volatile.StoreUint32(&o.INTR_RAW.Reg, volatile.LoadUint32(&o.INTR_RAW.Reg)&^(0x40)|value<<6)
}
func (o *DEDIC_GPIO_Type) GetINTR_RAW_GPIO6() uint32 {
	return (volatile.LoadUint32(&o.INTR_RAW.Reg) & 0x40) >> 6
}
func (o *DEDIC_GPIO_Type) SetINTR_RAW_GPIO7(value uint32) {
	volatile.StoreUint32(&o.INTR_RAW.Reg, volatile.LoadUint32(&o.INTR_RAW.Reg)&^(0x80)|value<<7)
}
func (o *DEDIC_GPIO_Type) GetINTR_RAW_GPIO7() uint32 {
	return (volatile.LoadUint32(&o.INTR_RAW.Reg) & 0x80) >> 7
}

// DEDIC_GPIO.INTR_RLS: Interrupt enable bits
func (o *DEDIC_GPIO_Type) SetINTR_RLS_GPIO0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INTR_RLS.Reg, volatile.LoadUint32(&o.INTR_RLS.Reg)&^(0x1)|value)
}
func (o *DEDIC_GPIO_Type) GetINTR_RLS_GPIO0_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INTR_RLS.Reg) & 0x1
}
func (o *DEDIC_GPIO_Type) SetINTR_RLS_GPIO1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INTR_RLS.Reg, volatile.LoadUint32(&o.INTR_RLS.Reg)&^(0x2)|value<<1)
}
func (o *DEDIC_GPIO_Type) GetINTR_RLS_GPIO1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INTR_RLS.Reg) & 0x2) >> 1
}
func (o *DEDIC_GPIO_Type) SetINTR_RLS_GPIO2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INTR_RLS.Reg, volatile.LoadUint32(&o.INTR_RLS.Reg)&^(0x4)|value<<2)
}
func (o *DEDIC_GPIO_Type) GetINTR_RLS_GPIO2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INTR_RLS.Reg) & 0x4) >> 2
}
func (o *DEDIC_GPIO_Type) SetINTR_RLS_GPIO3_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INTR_RLS.Reg, volatile.LoadUint32(&o.INTR_RLS.Reg)&^(0x8)|value<<3)
}
func (o *DEDIC_GPIO_Type) GetINTR_RLS_GPIO3_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INTR_RLS.Reg) & 0x8) >> 3
}
func (o *DEDIC_GPIO_Type) SetINTR_RLS_GPIO4_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INTR_RLS.Reg, volatile.LoadUint32(&o.INTR_RLS.Reg)&^(0x10)|value<<4)
}
func (o *DEDIC_GPIO_Type) GetINTR_RLS_GPIO4_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INTR_RLS.Reg) & 0x10) >> 4
}
func (o *DEDIC_GPIO_Type) SetINTR_RLS_GPIO5_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INTR_RLS.Reg, volatile.LoadUint32(&o.INTR_RLS.Reg)&^(0x20)|value<<5)
}
func (o *DEDIC_GPIO_Type) GetINTR_RLS_GPIO5_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INTR_RLS.Reg) & 0x20) >> 5
}
func (o *DEDIC_GPIO_Type) SetINTR_RLS_GPIO6_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INTR_RLS.Reg, volatile.LoadUint32(&o.INTR_RLS.Reg)&^(0x40)|value<<6)
}
func (o *DEDIC_GPIO_Type) GetINTR_RLS_GPIO6_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INTR_RLS.Reg) & 0x40) >> 6
}
func (o *DEDIC_GPIO_Type) SetINTR_RLS_GPIO7_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INTR_RLS.Reg, volatile.LoadUint32(&o.INTR_RLS.Reg)&^(0x80)|value<<7)
}
func (o *DEDIC_GPIO_Type) GetINTR_RLS_GPIO7_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INTR_RLS.Reg) & 0x80) >> 7
}

// DEDIC_GPIO.INTR_ST: Masked interrupt status
func (o *DEDIC_GPIO_Type) SetINTR_ST_GPIO0_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INTR_ST.Reg, volatile.LoadUint32(&o.INTR_ST.Reg)&^(0x1)|value)
}
func (o *DEDIC_GPIO_Type) GetINTR_ST_GPIO0_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INTR_ST.Reg) & 0x1
}
func (o *DEDIC_GPIO_Type) SetINTR_ST_GPIO1_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INTR_ST.Reg, volatile.LoadUint32(&o.INTR_ST.Reg)&^(0x2)|value<<1)
}
func (o *DEDIC_GPIO_Type) GetINTR_ST_GPIO1_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INTR_ST.Reg) & 0x2) >> 1
}
func (o *DEDIC_GPIO_Type) SetINTR_ST_GPIO2_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INTR_ST.Reg, volatile.LoadUint32(&o.INTR_ST.Reg)&^(0x4)|value<<2)
}
func (o *DEDIC_GPIO_Type) GetINTR_ST_GPIO2_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INTR_ST.Reg) & 0x4) >> 2
}
func (o *DEDIC_GPIO_Type) SetINTR_ST_GPIO3_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INTR_ST.Reg, volatile.LoadUint32(&o.INTR_ST.Reg)&^(0x8)|value<<3)
}
func (o *DEDIC_GPIO_Type) GetINTR_ST_GPIO3_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INTR_ST.Reg) & 0x8) >> 3
}
func (o *DEDIC_GPIO_Type) SetINTR_ST_GPIO4_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INTR_ST.Reg, volatile.LoadUint32(&o.INTR_ST.Reg)&^(0x10)|value<<4)
}
func (o *DEDIC_GPIO_Type) GetINTR_ST_GPIO4_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INTR_ST.Reg) & 0x10) >> 4
}
func (o *DEDIC_GPIO_Type) SetINTR_ST_GPIO5_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INTR_ST.Reg, volatile.LoadUint32(&o.INTR_ST.Reg)&^(0x20)|value<<5)
}
func (o *DEDIC_GPIO_Type) GetINTR_ST_GPIO5_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INTR_ST.Reg) & 0x20) >> 5
}
func (o *DEDIC_GPIO_Type) SetINTR_ST_GPIO6_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INTR_ST.Reg, volatile.LoadUint32(&o.INTR_ST.Reg)&^(0x40)|value<<6)
}
func (o *DEDIC_GPIO_Type) GetINTR_ST_GPIO6_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INTR_ST.Reg) & 0x40) >> 6
}
func (o *DEDIC_GPIO_Type) SetINTR_ST_GPIO7_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INTR_ST.Reg, volatile.LoadUint32(&o.INTR_ST.Reg)&^(0x80)|value<<7)
}
func (o *DEDIC_GPIO_Type) GetINTR_ST_GPIO7_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INTR_ST.Reg) & 0x80) >> 7
}

// DEDIC_GPIO.INTR_CLR: Interrupt clear bits
func (o *DEDIC_GPIO_Type) SetINTR_CLR_GPIO0_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INTR_CLR.Reg, volatile.LoadUint32(&o.INTR_CLR.Reg)&^(0x1)|value)
}
func (o *DEDIC_GPIO_Type) GetINTR_CLR_GPIO0_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INTR_CLR.Reg) & 0x1
}
func (o *DEDIC_GPIO_Type) SetINTR_CLR_GPIO1_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INTR_CLR.Reg, volatile.LoadUint32(&o.INTR_CLR.Reg)&^(0x2)|value<<1)
}
func (o *DEDIC_GPIO_Type) GetINTR_CLR_GPIO1_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTR_CLR.Reg) & 0x2) >> 1
}
func (o *DEDIC_GPIO_Type) SetINTR_CLR_GPIO2_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INTR_CLR.Reg, volatile.LoadUint32(&o.INTR_CLR.Reg)&^(0x4)|value<<2)
}
func (o *DEDIC_GPIO_Type) GetINTR_CLR_GPIO2_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTR_CLR.Reg) & 0x4) >> 2
}
func (o *DEDIC_GPIO_Type) SetINTR_CLR_GPIO3_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INTR_CLR.Reg, volatile.LoadUint32(&o.INTR_CLR.Reg)&^(0x8)|value<<3)
}
func (o *DEDIC_GPIO_Type) GetINTR_CLR_GPIO3_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTR_CLR.Reg) & 0x8) >> 3
}
func (o *DEDIC_GPIO_Type) SetINTR_CLR_GPIO4_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INTR_CLR.Reg, volatile.LoadUint32(&o.INTR_CLR.Reg)&^(0x10)|value<<4)
}
func (o *DEDIC_GPIO_Type) GetINTR_CLR_GPIO4_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTR_CLR.Reg) & 0x10) >> 4
}
func (o *DEDIC_GPIO_Type) SetINTR_CLR_GPIO5_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INTR_CLR.Reg, volatile.LoadUint32(&o.INTR_CLR.Reg)&^(0x20)|value<<5)
}
func (o *DEDIC_GPIO_Type) GetINTR_CLR_GPIO5_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTR_CLR.Reg) & 0x20) >> 5
}
func (o *DEDIC_GPIO_Type) SetINTR_CLR_GPIO6_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INTR_CLR.Reg, volatile.LoadUint32(&o.INTR_CLR.Reg)&^(0x40)|value<<6)
}
func (o *DEDIC_GPIO_Type) GetINTR_CLR_GPIO6_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTR_CLR.Reg) & 0x40) >> 6
}
func (o *DEDIC_GPIO_Type) SetINTR_CLR_GPIO7_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INTR_CLR.Reg, volatile.LoadUint32(&o.INTR_CLR.Reg)&^(0x80)|value<<7)
}
func (o *DEDIC_GPIO_Type) GetINTR_CLR_GPIO7_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTR_CLR.Reg) & 0x80) >> 7
}

// Digital Signature
type DS_Type struct {
	C_MEM           [1584]volatile.Register8 // 0x0
	IV_0            volatile.Register32      // 0x630
	IV_1            volatile.Register32      // 0x634
	IV_2            volatile.Register32      // 0x638
	IV_3            volatile.Register32      // 0x63C
	_               [448]byte
	X_MEM           [512]volatile.Register8 // 0x800
	Z_MEM           [512]volatile.Register8 // 0xA00
	_               [512]byte
	SET_START       volatile.Register32 // 0xE00
	SET_ME          volatile.Register32 // 0xE04
	SET_FINISH      volatile.Register32 // 0xE08
	QUERY_BUSY      volatile.Register32 // 0xE0C
	QUERY_KEY_WRONG volatile.Register32 // 0xE10
	QUERY_CHECK     volatile.Register32 // 0xE14
	_               [8]byte
	DATE            volatile.Register32 // 0xE20
}

// DS.IV_0: IV block data.
func (o *DS_Type) SetIV_0(value uint32) {
	volatile.StoreUint32(&o.IV_0.Reg, value)
}
func (o *DS_Type) GetIV_0() uint32 {
	return volatile.LoadUint32(&o.IV_0.Reg)
}

// DS.IV_1: IV block data.
func (o *DS_Type) SetIV_1(value uint32) {
	volatile.StoreUint32(&o.IV_1.Reg, value)
}
func (o *DS_Type) GetIV_1() uint32 {
	return volatile.LoadUint32(&o.IV_1.Reg)
}

// DS.IV_2: IV block data.
func (o *DS_Type) SetIV_2(value uint32) {
	volatile.StoreUint32(&o.IV_2.Reg, value)
}
func (o *DS_Type) GetIV_2() uint32 {
	return volatile.LoadUint32(&o.IV_2.Reg)
}

// DS.IV_3: IV block data.
func (o *DS_Type) SetIV_3(value uint32) {
	volatile.StoreUint32(&o.IV_3.Reg, value)
}
func (o *DS_Type) GetIV_3() uint32 {
	return volatile.LoadUint32(&o.IV_3.Reg)
}

// DS.SET_START: Activates the DS peripheral
func (o *DS_Type) SetSET_START(value uint32) {
	volatile.StoreUint32(&o.SET_START.Reg, volatile.LoadUint32(&o.SET_START.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetSET_START() uint32 {
	return volatile.LoadUint32(&o.SET_START.Reg) & 0x1
}

// DS.SET_ME: Starts DS operation
func (o *DS_Type) SetSET_ME(value uint32) {
	volatile.StoreUint32(&o.SET_ME.Reg, volatile.LoadUint32(&o.SET_ME.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetSET_ME() uint32 {
	return volatile.LoadUint32(&o.SET_ME.Reg) & 0x1
}

// DS.SET_FINISH: Ends DS operation
func (o *DS_Type) SetSET_FINISH(value uint32) {
	volatile.StoreUint32(&o.SET_FINISH.Reg, volatile.LoadUint32(&o.SET_FINISH.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetSET_FINISH() uint32 {
	return volatile.LoadUint32(&o.SET_FINISH.Reg) & 0x1
}

// DS.QUERY_BUSY: Status of the DS
func (o *DS_Type) SetQUERY_BUSY(value uint32) {
	volatile.StoreUint32(&o.QUERY_BUSY.Reg, volatile.LoadUint32(&o.QUERY_BUSY.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetQUERY_BUSY() uint32 {
	return volatile.LoadUint32(&o.QUERY_BUSY.Reg) & 0x1
}

// DS.QUERY_KEY_WRONG: Checks the reason why DS_KEY is not ready.
func (o *DS_Type) SetQUERY_KEY_WRONG(value uint32) {
	volatile.StoreUint32(&o.QUERY_KEY_WRONG.Reg, volatile.LoadUint32(&o.QUERY_KEY_WRONG.Reg)&^(0xf)|value)
}
func (o *DS_Type) GetQUERY_KEY_WRONG() uint32 {
	return volatile.LoadUint32(&o.QUERY_KEY_WRONG.Reg) & 0xf
}

// DS.QUERY_CHECK: Queries DS check result
func (o *DS_Type) SetQUERY_CHECK_MD_ERROR(value uint32) {
	volatile.StoreUint32(&o.QUERY_CHECK.Reg, volatile.LoadUint32(&o.QUERY_CHECK.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetQUERY_CHECK_MD_ERROR() uint32 {
	return volatile.LoadUint32(&o.QUERY_CHECK.Reg) & 0x1
}
func (o *DS_Type) SetQUERY_CHECK_PADDING_BAD(value uint32) {
	volatile.StoreUint32(&o.QUERY_CHECK.Reg, volatile.LoadUint32(&o.QUERY_CHECK.Reg)&^(0x2)|value<<1)
}
func (o *DS_Type) GetQUERY_CHECK_PADDING_BAD() uint32 {
	return (volatile.LoadUint32(&o.QUERY_CHECK.Reg) & 0x2) >> 1
}

// DS.DATE: Version control register
func (o *DS_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x3fffffff)|value)
}
func (o *DS_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x3fffffff
}

// eFuse Controller
type EFUSE_Type struct {
	PGM_DATA0           volatile.Register32 // 0x0
	PGM_DATA1           volatile.Register32 // 0x4
	PGM_DATA2           volatile.Register32 // 0x8
	PGM_DATA3           volatile.Register32 // 0xC
	PGM_DATA4           volatile.Register32 // 0x10
	PGM_DATA5           volatile.Register32 // 0x14
	PGM_DATA6           volatile.Register32 // 0x18
	PGM_DATA7           volatile.Register32 // 0x1C
	PGM_CHECK_VALUE0    volatile.Register32 // 0x20
	PGM_CHECK_VALUE1    volatile.Register32 // 0x24
	PGM_CHECK_VALUE2    volatile.Register32 // 0x28
	RD_WR_DIS           volatile.Register32 // 0x2C
	RD_REPEAT_DATA0     volatile.Register32 // 0x30
	RD_REPEAT_DATA1     volatile.Register32 // 0x34
	RD_REPEAT_DATA2     volatile.Register32 // 0x38
	RD_REPEAT_DATA3     volatile.Register32 // 0x3C
	RD_REPEAT_DATA4     volatile.Register32 // 0x40
	RD_MAC_SPI_SYS_0    volatile.Register32 // 0x44
	RD_MAC_SPI_SYS_1    volatile.Register32 // 0x48
	RD_MAC_SPI_SYS_2    volatile.Register32 // 0x4C
	RD_MAC_SPI_SYS_3    volatile.Register32 // 0x50
	RD_MAC_SPI_SYS_4    volatile.Register32 // 0x54
	RD_MAC_SPI_SYS_5    volatile.Register32 // 0x58
	RD_SYS_DATA_PART1_0 volatile.Register32 // 0x5C
	RD_SYS_DATA_PART1_1 volatile.Register32 // 0x60
	RD_SYS_DATA_PART1_2 volatile.Register32 // 0x64
	RD_SYS_DATA_PART1_3 volatile.Register32 // 0x68
	RD_SYS_DATA_PART1_4 volatile.Register32 // 0x6C
	RD_SYS_DATA_PART1_5 volatile.Register32 // 0x70
	RD_SYS_DATA_PART1_6 volatile.Register32 // 0x74
	RD_SYS_DATA_PART1_7 volatile.Register32 // 0x78
	RD_USR_DATA0        volatile.Register32 // 0x7C
	RD_USR_DATA1        volatile.Register32 // 0x80
	RD_USR_DATA2        volatile.Register32 // 0x84
	RD_USR_DATA3        volatile.Register32 // 0x88
	RD_USR_DATA4        volatile.Register32 // 0x8C
	RD_USR_DATA5        volatile.Register32 // 0x90
	RD_USR_DATA6        volatile.Register32 // 0x94
	RD_USR_DATA7        volatile.Register32 // 0x98
	RD_KEY0_DATA0       volatile.Register32 // 0x9C
	RD_KEY0_DATA1       volatile.Register32 // 0xA0
	RD_KEY0_DATA2       volatile.Register32 // 0xA4
	RD_KEY0_DATA3       volatile.Register32 // 0xA8
	RD_KEY0_DATA4       volatile.Register32 // 0xAC
	RD_KEY0_DATA5       volatile.Register32 // 0xB0
	RD_KEY0_DATA6       volatile.Register32 // 0xB4
	RD_KEY0_DATA7       volatile.Register32 // 0xB8
	RD_KEY1_DATA0       volatile.Register32 // 0xBC
	RD_KEY1_DATA1       volatile.Register32 // 0xC0
	RD_KEY1_DATA2       volatile.Register32 // 0xC4
	RD_KEY1_DATA3       volatile.Register32 // 0xC8
	RD_KEY1_DATA4       volatile.Register32 // 0xCC
	RD_KEY1_DATA5       volatile.Register32 // 0xD0
	RD_KEY1_DATA6       volatile.Register32 // 0xD4
	RD_KEY1_DATA7       volatile.Register32 // 0xD8
	RD_KEY2_DATA0       volatile.Register32 // 0xDC
	RD_KEY2_DATA1       volatile.Register32 // 0xE0
	RD_KEY2_DATA2       volatile.Register32 // 0xE4
	RD_KEY2_DATA3       volatile.Register32 // 0xE8
	RD_KEY2_DATA4       volatile.Register32 // 0xEC
	RD_KEY2_DATA5       volatile.Register32 // 0xF0
	RD_KEY2_DATA6       volatile.Register32 // 0xF4
	RD_KEY2_DATA7       volatile.Register32 // 0xF8
	RD_KEY3_DATA0       volatile.Register32 // 0xFC
	RD_KEY3_DATA1       volatile.Register32 // 0x100
	RD_KEY3_DATA2       volatile.Register32 // 0x104
	RD_KEY3_DATA3       volatile.Register32 // 0x108
	RD_KEY3_DATA4       volatile.Register32 // 0x10C
	RD_KEY3_DATA5       volatile.Register32 // 0x110
	RD_KEY3_DATA6       volatile.Register32 // 0x114
	RD_KEY3_DATA7       volatile.Register32 // 0x118
	RD_KEY4_DATA0       volatile.Register32 // 0x11C
	RD_KEY4_DATA1       volatile.Register32 // 0x120
	RD_KEY4_DATA2       volatile.Register32 // 0x124
	RD_KEY4_DATA3       volatile.Register32 // 0x128
	RD_KEY4_DATA4       volatile.Register32 // 0x12C
	RD_KEY4_DATA5       volatile.Register32 // 0x130
	RD_KEY4_DATA6       volatile.Register32 // 0x134
	RD_KEY4_DATA7       volatile.Register32 // 0x138
	RD_KEY5_DATA0       volatile.Register32 // 0x13C
	RD_KEY5_DATA1       volatile.Register32 // 0x140
	RD_KEY5_DATA2       volatile.Register32 // 0x144
	RD_KEY5_DATA3       volatile.Register32 // 0x148
	RD_KEY5_DATA4       volatile.Register32 // 0x14C
	RD_KEY5_DATA5       volatile.Register32 // 0x150
	RD_KEY5_DATA6       volatile.Register32 // 0x154
	RD_KEY5_DATA7       volatile.Register32 // 0x158
	RD_SYS_DATA_PART2_0 volatile.Register32 // 0x15C
	RD_SYS_DATA_PART2_1 volatile.Register32 // 0x160
	RD_SYS_DATA_PART2_2 volatile.Register32 // 0x164
	RD_SYS_DATA_PART2_3 volatile.Register32 // 0x168
	RD_SYS_DATA_PART2_4 volatile.Register32 // 0x16C
	RD_SYS_DATA_PART2_5 volatile.Register32 // 0x170
	RD_SYS_DATA_PART2_6 volatile.Register32 // 0x174
	RD_SYS_DATA_PART2_7 volatile.Register32 // 0x178
	RD_REPEAT_ERR0      volatile.Register32 // 0x17C
	RD_REPEAT_ERR1      volatile.Register32 // 0x180
	RD_REPEAT_ERR2      volatile.Register32 // 0x184
	RD_REPEAT_ERR3      volatile.Register32 // 0x188
	_                   [4]byte
	RD_REPEAT_ERR4      volatile.Register32 // 0x190
	_                   [44]byte
	RD_RS_ERR0          volatile.Register32 // 0x1C0
	RD_RS_ERR1          volatile.Register32 // 0x1C4
	CLK                 volatile.Register32 // 0x1C8
	CONF                volatile.Register32 // 0x1CC
	STATUS              volatile.Register32 // 0x1D0
	CMD                 volatile.Register32 // 0x1D4
	INT_RAW             volatile.Register32 // 0x1D8
	INT_ST              volatile.Register32 // 0x1DC
	INT_ENA             volatile.Register32 // 0x1E0
	INT_CLR             volatile.Register32 // 0x1E4
	DAC_CONF            volatile.Register32 // 0x1E8
	RD_TIM_CONF         volatile.Register32 // 0x1EC
	WR_TIM_CONF0        volatile.Register32 // 0x1F0
	WR_TIM_CONF1        volatile.Register32 // 0x1F4
	WR_TIM_CONF2        volatile.Register32 // 0x1F8
	DATE                volatile.Register32 // 0x1FC
}

// EFUSE.PGM_DATA0: Register %s that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA0(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA0() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA0.Reg)
}

// EFUSE.PGM_DATA1: Register %s that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA1(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA1() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA1.Reg)
}

// EFUSE.PGM_DATA2: Register %s that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA2(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA2() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA2.Reg)
}

// EFUSE.PGM_DATA3: Register %s that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA3(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA3() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA3.Reg)
}

// EFUSE.PGM_DATA4: Register %s that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA4(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA4() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA4.Reg)
}

// EFUSE.PGM_DATA5: Register %s that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA5(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA5() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA5.Reg)
}

// EFUSE.PGM_DATA6: Register %s that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA6(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA6() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA6.Reg)
}

// EFUSE.PGM_DATA7: Register %s that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA7(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA7() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA7.Reg)
}

// EFUSE.PGM_CHECK_VALUE0: Register %s that stores the RS code to be programmed.
func (o *EFUSE_Type) SetPGM_CHECK_VALUE0(value uint32) {
	volatile.StoreUint32(&o.PGM_CHECK_VALUE0.Reg, value)
}
func (o *EFUSE_Type) GetPGM_CHECK_VALUE0() uint32 {
	return volatile.LoadUint32(&o.PGM_CHECK_VALUE0.Reg)
}

// EFUSE.PGM_CHECK_VALUE1: Register %s that stores the RS code to be programmed.
func (o *EFUSE_Type) SetPGM_CHECK_VALUE1(value uint32) {
	volatile.StoreUint32(&o.PGM_CHECK_VALUE1.Reg, value)
}
func (o *EFUSE_Type) GetPGM_CHECK_VALUE1() uint32 {
	return volatile.LoadUint32(&o.PGM_CHECK_VALUE1.Reg)
}

// EFUSE.PGM_CHECK_VALUE2: Register %s that stores the RS code to be programmed.
func (o *EFUSE_Type) SetPGM_CHECK_VALUE2(value uint32) {
	volatile.StoreUint32(&o.PGM_CHECK_VALUE2.Reg, value)
}
func (o *EFUSE_Type) GetPGM_CHECK_VALUE2() uint32 {
	return volatile.LoadUint32(&o.PGM_CHECK_VALUE2.Reg)
}

// EFUSE.RD_WR_DIS: Register 0 of BLOCK0.
func (o *EFUSE_Type) SetRD_WR_DIS(value uint32) {
	volatile.StoreUint32(&o.RD_WR_DIS.Reg, value)
}
func (o *EFUSE_Type) GetRD_WR_DIS() uint32 {
	return volatile.LoadUint32(&o.RD_WR_DIS.Reg)
}

// EFUSE.RD_REPEAT_DATA0: Register 1 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_RD_DIS(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x7f)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_RD_DIS() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x7f
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_RTC_RAM_BOOT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_RTC_RAM_BOOT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_ICACHE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_ICACHE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DCACHE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DCACHE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DOWNLOAD_ICACHE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x400)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DOWNLOAD_ICACHE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x400) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DOWNLOAD_DCACHE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x800)|value<<11)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DOWNLOAD_DCACHE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x800) >> 11
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_FORCE_DOWNLOAD(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_FORCE_DOWNLOAD() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_USB(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_USB() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_CAN(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x4000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_CAN() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x4000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_BOOT_REMAP(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_BOOT_REMAP() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_RPT4_RESERVED5(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x10000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_RPT4_RESERVED5() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x10000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_SOFT_DIS_JTAG(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x20000)|value<<17)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_SOFT_DIS_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x20000) >> 17
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_HARD_DIS_JTAG(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x40000)|value<<18)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_HARD_DIS_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x40000) >> 18
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DOWNLOAD_MANUAL_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x80000)|value<<19)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DOWNLOAD_MANUAL_ENCRYPT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x80000) >> 19
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_USB_DREFH(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x300000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_USB_DREFH() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x300000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_USB_DREFL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0xc00000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_USB_DREFL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0xc00000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_USB_EXCHG_PINS(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x1000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_USB_EXCHG_PINS() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x1000000) >> 24
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_EXT_PHY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x2000000)|value<<25)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_EXT_PHY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x2000000) >> 25
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_USB_FORCE_NOPERSIST(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x4000000)|value<<26)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_USB_FORCE_NOPERSIST() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x4000000) >> 26
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_RPT4_RESERVED0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x18000000)|value<<27)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_RPT4_RESERVED0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x18000000) >> 27
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_VDD_SPI_MODECURLIM(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x20000000)|value<<29)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_VDD_SPI_MODECURLIM() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x20000000) >> 29
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_VDD_SPI_DREFH(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0xc0000000)|value<<30)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_VDD_SPI_DREFH() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0xc0000000) >> 30
}

// EFUSE.RD_REPEAT_DATA1: Register 2 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_DREFM(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x3)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_DREFM() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x3
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_DREFL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xc)|value<<2)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_DREFL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xc) >> 2
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_XPD(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_XPD() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_TIEH(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_TIEH() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_FORCE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x40)|value<<6)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_FORCE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x40) >> 6
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_EN_INIT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_EN_INIT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_ENCURLIM(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_ENCURLIM() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_DCURLIM(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xe00)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_DCURLIM() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xe00) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_INIT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x3000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_INIT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x3000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_VDD_SPI_DCAP(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xc000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_VDD_SPI_DCAP() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xc000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_WDT_DELAY_SEL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x30000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_WDT_DELAY_SEL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x30000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SPI_BOOT_CRYPT_CNT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x1c0000)|value<<18)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SPI_BOOT_CRYPT_CNT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x1c0000) >> 18
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x400000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x400000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE2(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE2() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_KEY_PURPOSE_0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xf000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_KEY_PURPOSE_0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xf000000) >> 24
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_KEY_PURPOSE_1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_KEY_PURPOSE_1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_DATA2: Register 3 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_2(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_2() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_3(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf0)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_3() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf0) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_4(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf00)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_4() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf00) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_5(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_5() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_6(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf0000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_6() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf0000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_SECURE_BOOT_EN(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_SECURE_BOOT_EN() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_SECURE_BOOT_AGGRESSIVE_REVOKE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_SECURE_BOOT_AGGRESSIVE_REVOKE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_RPT4_RESERVED1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xfc00000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_RPT4_RESERVED1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xfc00000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_FLASH_TPUW(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_FLASH_TPUW() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_DATA3: Register 4 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_DIS_DOWNLOAD_MODE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_DIS_DOWNLOAD_MODE() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x1
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_DIS_LEGACY_SPI_BOOT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_DIS_LEGACY_SPI_BOOT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_UART_PRINT_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_UART_PRINT_CHANNEL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_RPT4_RESERVED3(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_RPT4_RESERVED3() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_DIS_USB_DOWNLOAD_MODE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_DIS_USB_DOWNLOAD_MODE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_ENABLE_SECURITY_DOWNLOAD(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_ENABLE_SECURITY_DOWNLOAD() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_UART_PRINT_CONTROL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0xc0)|value<<6)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_UART_PRINT_CONTROL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0xc0) >> 6
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_PIN_POWER_SELECTION(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_PIN_POWER_SELECTION() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_FLASH_TYPE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_FLASH_TYPE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_FORCE_SEND_RESUME(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x400)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_FORCE_SEND_RESUME() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x400) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_SECURE_VERSION(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x7fff800)|value<<11)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_SECURE_VERSION() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x7fff800) >> 11
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_RPT4_RESERVED2(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0xf8000000)|value<<27)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_RPT4_RESERVED2() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0xf8000000) >> 27
}

// EFUSE.RD_REPEAT_DATA4: Register 5 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_DATA4_RPT4_RESERVED4(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA4.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA4.Reg)&^(0xffffff)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA4_RPT4_RESERVED4() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA4.Reg) & 0xffffff
}

// EFUSE.RD_MAC_SPI_SYS_0: Register 0 of BLOCK1.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_0(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_0.Reg, value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_0() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_0.Reg)
}

// EFUSE.RD_MAC_SPI_SYS_1: Register 1 of BLOCK1.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_1_MAC_1(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_1.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_1_MAC_1() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg) & 0xffff
}
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_1_SPI_PAD_CONF_0(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_1.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg)&^(0xffff0000)|value<<16)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_1_SPI_PAD_CONF_0() uint32 {
	return (volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg) & 0xffff0000) >> 16
}

// EFUSE.RD_MAC_SPI_SYS_2: Register 2 of BLOCK1.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_2(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_2.Reg, value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_2() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_2.Reg)
}

// EFUSE.RD_MAC_SPI_SYS_3: Register 3 of BLOCK1.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_3_SPI_PAD_CONF_2(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_3.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg)&^(0x3ffff)|value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_3_SPI_PAD_CONF_2() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg) & 0x3ffff
}
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_3_SYS_DATA_PART0_0(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_3.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg)&^(0xfffc0000)|value<<18)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_3_SYS_DATA_PART0_0() uint32 {
	return (volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg) & 0xfffc0000) >> 18
}

// EFUSE.RD_MAC_SPI_SYS_4: Register 4 of BLOCK1.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_4(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_4.Reg, value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_4() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_4.Reg)
}

// EFUSE.RD_MAC_SPI_SYS_5: Register 5 of BLOCK1.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_5(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_5.Reg, value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_5() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_5.Reg)
}

// EFUSE.RD_SYS_DATA_PART1_0: Register %s of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART1_0(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART1_0.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART1_0() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART1_0.Reg)
}

// EFUSE.RD_SYS_DATA_PART1_1: Register %s of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART1_1(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART1_1.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART1_1() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART1_1.Reg)
}

// EFUSE.RD_SYS_DATA_PART1_2: Register %s of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART1_2(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART1_2.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART1_2() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART1_2.Reg)
}

// EFUSE.RD_SYS_DATA_PART1_3: Register %s of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART1_3(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART1_3.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART1_3() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART1_3.Reg)
}

// EFUSE.RD_SYS_DATA_PART1_4: Register %s of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART1_4(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART1_4.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART1_4() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART1_4.Reg)
}

// EFUSE.RD_SYS_DATA_PART1_5: Register %s of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART1_5(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART1_5.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART1_5() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART1_5.Reg)
}

// EFUSE.RD_SYS_DATA_PART1_6: Register %s of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART1_6(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART1_6.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART1_6() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART1_6.Reg)
}

// EFUSE.RD_SYS_DATA_PART1_7: Register %s of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART1_7(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART1_7.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART1_7() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART1_7.Reg)
}

// EFUSE.RD_USR_DATA0: Register %s of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA0.Reg)
}

// EFUSE.RD_USR_DATA1: Register %s of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA1.Reg)
}

// EFUSE.RD_USR_DATA2: Register %s of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA2.Reg)
}

// EFUSE.RD_USR_DATA3: Register %s of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA3.Reg)
}

// EFUSE.RD_USR_DATA4: Register %s of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA4.Reg)
}

// EFUSE.RD_USR_DATA5: Register %s of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA5.Reg)
}

// EFUSE.RD_USR_DATA6: Register %s of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA6.Reg)
}

// EFUSE.RD_USR_DATA7: Register %s of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA7.Reg)
}

// EFUSE.RD_KEY0_DATA0: Register %s of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA0.Reg)
}

// EFUSE.RD_KEY0_DATA1: Register %s of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA1.Reg)
}

// EFUSE.RD_KEY0_DATA2: Register %s of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA2.Reg)
}

// EFUSE.RD_KEY0_DATA3: Register %s of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA3.Reg)
}

// EFUSE.RD_KEY0_DATA4: Register %s of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA4.Reg)
}

// EFUSE.RD_KEY0_DATA5: Register %s of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA5.Reg)
}

// EFUSE.RD_KEY0_DATA6: Register %s of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA6.Reg)
}

// EFUSE.RD_KEY0_DATA7: Register %s of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA7.Reg)
}

// EFUSE.RD_KEY1_DATA0: Register %s of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA0.Reg)
}

// EFUSE.RD_KEY1_DATA1: Register %s of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA1.Reg)
}

// EFUSE.RD_KEY1_DATA2: Register %s of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA2.Reg)
}

// EFUSE.RD_KEY1_DATA3: Register %s of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA3.Reg)
}

// EFUSE.RD_KEY1_DATA4: Register %s of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA4.Reg)
}

// EFUSE.RD_KEY1_DATA5: Register %s of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA5.Reg)
}

// EFUSE.RD_KEY1_DATA6: Register %s of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA6.Reg)
}

// EFUSE.RD_KEY1_DATA7: Register %s of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA7.Reg)
}

// EFUSE.RD_KEY2_DATA0: Register %s of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA0.Reg)
}

// EFUSE.RD_KEY2_DATA1: Register %s of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA1.Reg)
}

// EFUSE.RD_KEY2_DATA2: Register %s of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA2.Reg)
}

// EFUSE.RD_KEY2_DATA3: Register %s of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA3.Reg)
}

// EFUSE.RD_KEY2_DATA4: Register %s of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA4.Reg)
}

// EFUSE.RD_KEY2_DATA5: Register %s of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA5.Reg)
}

// EFUSE.RD_KEY2_DATA6: Register %s of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA6.Reg)
}

// EFUSE.RD_KEY2_DATA7: Register %s of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA7.Reg)
}

// EFUSE.RD_KEY3_DATA0: Register %s of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA0.Reg)
}

// EFUSE.RD_KEY3_DATA1: Register %s of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA1.Reg)
}

// EFUSE.RD_KEY3_DATA2: Register %s of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA2.Reg)
}

// EFUSE.RD_KEY3_DATA3: Register %s of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA3.Reg)
}

// EFUSE.RD_KEY3_DATA4: Register %s of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA4.Reg)
}

// EFUSE.RD_KEY3_DATA5: Register %s of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA5.Reg)
}

// EFUSE.RD_KEY3_DATA6: Register %s of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA6.Reg)
}

// EFUSE.RD_KEY3_DATA7: Register %s of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA7.Reg)
}

// EFUSE.RD_KEY4_DATA0: Register %s of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA0.Reg)
}

// EFUSE.RD_KEY4_DATA1: Register %s of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA1.Reg)
}

// EFUSE.RD_KEY4_DATA2: Register %s of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA2.Reg)
}

// EFUSE.RD_KEY4_DATA3: Register %s of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA3.Reg)
}

// EFUSE.RD_KEY4_DATA4: Register %s of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA4.Reg)
}

// EFUSE.RD_KEY4_DATA5: Register %s of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA5.Reg)
}

// EFUSE.RD_KEY4_DATA6: Register %s of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA6.Reg)
}

// EFUSE.RD_KEY4_DATA7: Register %s of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA7.Reg)
}

// EFUSE.RD_KEY5_DATA0: Register %s of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA0.Reg)
}

// EFUSE.RD_KEY5_DATA1: Register %s of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA1.Reg)
}

// EFUSE.RD_KEY5_DATA2: Register %s of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA2.Reg)
}

// EFUSE.RD_KEY5_DATA3: Register %s of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA3.Reg)
}

// EFUSE.RD_KEY5_DATA4: Register %s of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA4.Reg)
}

// EFUSE.RD_KEY5_DATA5: Register %s of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA5.Reg)
}

// EFUSE.RD_KEY5_DATA6: Register %s of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA6.Reg)
}

// EFUSE.RD_KEY5_DATA7: Register %s of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA7.Reg)
}

// EFUSE.RD_SYS_DATA_PART2_0: Register %s of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART2_0(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART2_0.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART2_0() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART2_0.Reg)
}

// EFUSE.RD_SYS_DATA_PART2_1: Register %s of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART2_1(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART2_1.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART2_1() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART2_1.Reg)
}

// EFUSE.RD_SYS_DATA_PART2_2: Register %s of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART2_2(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART2_2.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART2_2() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART2_2.Reg)
}

// EFUSE.RD_SYS_DATA_PART2_3: Register %s of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART2_3(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART2_3.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART2_3() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART2_3.Reg)
}

// EFUSE.RD_SYS_DATA_PART2_4: Register %s of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART2_4(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART2_4.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART2_4() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART2_4.Reg)
}

// EFUSE.RD_SYS_DATA_PART2_5: Register %s of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART2_5(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART2_5.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART2_5() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART2_5.Reg)
}

// EFUSE.RD_SYS_DATA_PART2_6: Register %s of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART2_6(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART2_6.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART2_6() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART2_6.Reg)
}

// EFUSE.RD_SYS_DATA_PART2_7: Register %s of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_DATA_PART2_7(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_DATA_PART2_7.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_DATA_PART2_7() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_DATA_PART2_7.Reg)
}

// EFUSE.RD_REPEAT_ERR0: Programming error record register 0 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_RD_DIS_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x7f)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_RD_DIS_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x7f
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_RTC_RAM_BOOT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_RTC_RAM_BOOT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_ICACHE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_ICACHE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_DCACHE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_DCACHE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_DOWNLOAD_ICACHE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x400)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_DOWNLOAD_ICACHE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x400) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_DOWNLOAD_DCACHE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x800)|value<<11)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_DOWNLOAD_DCACHE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x800) >> 11
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_FORCE_DOWNLOAD_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_FORCE_DOWNLOAD_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_USB_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_USB_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_CAN_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x4000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_CAN_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x4000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_BOOT_REMAP_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_BOOT_REMAP_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_RPT4_RESERVED5_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x10000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_RPT4_RESERVED5_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x10000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_SOFT_DIS_JTAG_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x20000)|value<<17)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_SOFT_DIS_JTAG_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x20000) >> 17
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_HARD_DIS_JTAG_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x40000)|value<<18)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_HARD_DIS_JTAG_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x40000) >> 18
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_DOWNLOAD_MANUAL_ENCRYPT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x80000)|value<<19)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_DOWNLOAD_MANUAL_ENCRYPT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x80000) >> 19
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_USB_DREFH_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x300000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_USB_DREFH_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x300000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_USB_DREFL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0xc00000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_USB_DREFL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0xc00000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_USB_EXCHG_PINS_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x1000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_USB_EXCHG_PINS_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x1000000) >> 24
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_EXT_PHY_ENABLE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x2000000)|value<<25)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_EXT_PHY_ENABLE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x2000000) >> 25
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_USB_FORCE_NOPERSIST_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x4000000)|value<<26)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_USB_FORCE_NOPERSIST_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x4000000) >> 26
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_RPT4_RESERVED0_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x18000000)|value<<27)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_RPT4_RESERVED0_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x18000000) >> 27
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_VDD_SPI_MODECURLIM_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x20000000)|value<<29)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_VDD_SPI_MODECURLIM_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x20000000) >> 29
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_VDD_SPI_DREFH_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0xc0000000)|value<<30)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_VDD_SPI_DREFH_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0xc0000000) >> 30
}

// EFUSE.RD_REPEAT_ERR1: Programming error record register 1 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_DREFM_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x3)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_DREFM_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x3
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_DREFL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xc)|value<<2)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_DREFL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xc) >> 2
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_XPD_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_XPD_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_TIEH_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_TIEH_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_FORCE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x40)|value<<6)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_FORCE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x40) >> 6
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_EN_INIT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_EN_INIT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_ENCURLIM_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_ENCURLIM_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_DCURLIM_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xe00)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_DCURLIM_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xe00) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_INIT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x3000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_INIT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x3000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_VDD_SPI_DCAP_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xc000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_VDD_SPI_DCAP_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xc000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_WDT_DELAY_SEL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x30000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_WDT_DELAY_SEL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x30000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SPI_BOOT_CRYPT_CNT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x1c0000)|value<<18)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SPI_BOOT_CRYPT_CNT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x1c0000) >> 18
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE0_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE0_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE1_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x400000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE1_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x400000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE2_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE2_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_KEY_PURPOSE_0_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xf000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_KEY_PURPOSE_0_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xf000000) >> 24
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_KEY_PURPOSE_1_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_KEY_PURPOSE_1_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_ERR2: Programming error record register 2 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_2_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_2_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_3_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf0)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_3_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf0) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_4_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf00)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_4_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf00) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_5_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_5_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_6_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf0000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_6_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf0000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_SECURE_BOOT_EN_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_SECURE_BOOT_EN_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_SECURE_BOOT_AGGRESSIVE_REVOKE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_SECURE_BOOT_AGGRESSIVE_REVOKE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_RPT4_RESERVED1_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xfc00000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_RPT4_RESERVED1_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xfc00000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_FLASH_TPUW_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_FLASH_TPUW_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_ERR3: Programming error record register 3 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_DIS_DOWNLOAD_MODE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_DIS_DOWNLOAD_MODE_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x1
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_DIS_LEGACY_SPI_BOOT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_DIS_LEGACY_SPI_BOOT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_UART_PRINT_CHANNEL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_UART_PRINT_CHANNEL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_RPT4_RESERVED3_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_RPT4_RESERVED3_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_DIS_USB_DOWNLOAD_MODE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_DIS_USB_DOWNLOAD_MODE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_ENABLE_SECURITY_DOWNLOAD_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_ENABLE_SECURITY_DOWNLOAD_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_UART_PRINT_CONTROL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0xc0)|value<<6)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_UART_PRINT_CONTROL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0xc0) >> 6
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_PIN_POWER_SELECTION_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_PIN_POWER_SELECTION_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_FLASH_TYPE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_FLASH_TYPE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_FORCE_SEND_RESUME_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x400)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_FORCE_SEND_RESUME_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x400) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_SECURE_VERSION_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x7fff800)|value<<11)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_SECURE_VERSION_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x7fff800) >> 11
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_RPT4_RESERVED2_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0xf8000000)|value<<27)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_RPT4_RESERVED2_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0xf8000000) >> 27
}

// EFUSE.RD_REPEAT_ERR4: Programming error record register 4 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR4_RPT4_RESERVED4_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR4.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR4.Reg)&^(0xffffff)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR4_RPT4_RESERVED4_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR4.Reg) & 0xffffff
}

// EFUSE.RD_RS_ERR0: Programming error record register 0 of BLOCK1-10.
func (o *EFUSE_Type) SetRD_RS_ERR0_MAC_SPI_8M_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x7)|value)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_MAC_SPI_8M_ERR_NUM() uint32 {
	return volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x7
}
func (o *EFUSE_Type) SetRD_RS_ERR0_MAC_SPI_8M_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_MAC_SPI_8M_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_RS_ERR0_SYS_PART1_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x70)|value<<4)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_SYS_PART1_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x70) >> 4
}
func (o *EFUSE_Type) SetRD_RS_ERR0_SYS_PART1_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_SYS_PART1_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_RS_ERR0_USR_DATA_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x700)|value<<8)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_USR_DATA_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x700) >> 8
}
func (o *EFUSE_Type) SetRD_RS_ERR0_USR_DATA_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x800)|value<<11)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_USR_DATA_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x800) >> 11
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY0_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x7000)|value<<12)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY0_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x7000) >> 12
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY0_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY0_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY1_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x70000)|value<<16)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY1_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x70000) >> 16
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY1_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x80000)|value<<19)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY1_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x80000) >> 19
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY2_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x700000)|value<<20)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY2_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x700000) >> 20
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY2_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY2_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x800000) >> 23
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY3_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x7000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY3_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x7000000) >> 24
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY3_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x8000000)|value<<27)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY3_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x8000000) >> 27
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY4_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x70000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY4_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x70000000) >> 28
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY4_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x80000000)|value<<31)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY4_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x80000000) >> 31
}

// EFUSE.RD_RS_ERR1: Programming error record register 1 of BLOCK1-10.
func (o *EFUSE_Type) SetRD_RS_ERR1_KEY5_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x7)|value)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_KEY5_ERR_NUM() uint32 {
	return volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x7
}
func (o *EFUSE_Type) SetRD_RS_ERR1_KEY5_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_KEY5_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_RS_ERR1_SYS_PART2_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x70)|value<<4)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_SYS_PART2_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x70) >> 4
}
func (o *EFUSE_Type) SetRD_RS_ERR1_SYS_PART2_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_SYS_PART2_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x80) >> 7
}

// EFUSE.CLK: eFuse clock configuration register.
func (o *EFUSE_Type) SetCLK_EFUSE_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetCLK_EFUSE_MEM_FORCE_PD() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0x1
}
func (o *EFUSE_Type) SetCLK_MEM_CLK_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetCLK_MEM_CLK_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetCLK_EFUSE_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetCLK_EFUSE_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetCLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x10000)|value<<16)
}
func (o *EFUSE_Type) GetCLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x10000) >> 16
}

// EFUSE.CONF: eFuse operation mode configuration register.
func (o *EFUSE_Type) SetCONF_OP_CODE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetCONF_OP_CODE() uint32 {
	return volatile.LoadUint32(&o.CONF.Reg) & 0xffff
}

// EFUSE.STATUS: eFuse status register.
func (o *EFUSE_Type) SetSTATUS_STATE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xf)|value)
}
func (o *EFUSE_Type) GetSTATUS_STATE() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0xf
}
func (o *EFUSE_Type) SetSTATUS_OTP_LOAD_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetSTATUS_OTP_LOAD_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetSTATUS_OTP_VDDQ_C_SYNC2(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetSTATUS_OTP_VDDQ_C_SYNC2() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetSTATUS_OTP_STROBE_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *EFUSE_Type) GetSTATUS_OTP_STROBE_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *EFUSE_Type) SetSTATUS_OTP_CSB_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetSTATUS_OTP_CSB_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetSTATUS_OTP_PGENB_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetSTATUS_OTP_PGENB_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetSTATUS_OTP_VDDQ_IS_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetSTATUS_OTP_VDDQ_IS_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetSTATUS_REPEAT_ERR_CNT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x3fc00)|value<<10)
}
func (o *EFUSE_Type) GetSTATUS_REPEAT_ERR_CNT() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x3fc00) >> 10
}

// EFUSE.CMD: eFuse command register.
func (o *EFUSE_Type) SetCMD_READ_CMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetCMD_READ_CMD() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x1
}
func (o *EFUSE_Type) SetCMD_PGM_CMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetCMD_PGM_CMD() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetCMD_BLK_NUM(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x3c)|value<<2)
}
func (o *EFUSE_Type) GetCMD_BLK_NUM() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x3c) >> 2
}

// EFUSE.INT_RAW: eFuse raw interrupt register.
func (o *EFUSE_Type) SetINT_RAW_READ_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_RAW_READ_DONE_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_RAW_PGM_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_RAW_PGM_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}

// EFUSE.INT_ST: eFuse interrupt status register.
func (o *EFUSE_Type) SetINT_ST_READ_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_ST_READ_DONE_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_ST_PGM_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_ST_PGM_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}

// EFUSE.INT_ENA: eFuse interrupt enable register.
func (o *EFUSE_Type) SetINT_ENA_READ_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_ENA_READ_DONE_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_ENA_PGM_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_ENA_PGM_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}

// EFUSE.INT_CLR: eFuse interrupt clear register.
func (o *EFUSE_Type) SetINT_CLR_READ_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_CLR_READ_DONE_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_CLR_PGM_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_CLR_PGM_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}

// EFUSE.DAC_CONF: Controls the eFuse programming voltage.
func (o *EFUSE_Type) SetDAC_CONF_DAC_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_CLK_DIV() uint32 {
	return volatile.LoadUint32(&o.DAC_CONF.Reg) & 0xff
}
func (o *EFUSE_Type) SetDAC_CONF_DAC_CLK_PAD_SEL(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_CLK_PAD_SEL() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetDAC_CONF_DAC_NUM(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x1fe00)|value<<9)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_NUM() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x1fe00) >> 9
}
func (o *EFUSE_Type) SetDAC_CONF_OE_CLR(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *EFUSE_Type) GetDAC_CONF_OE_CLR() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x20000) >> 17
}

// EFUSE.RD_TIM_CONF: Configures read timing parameters.
func (o *EFUSE_Type) SetRD_TIM_CONF_THR_A(value uint32) {
	volatile.StoreUint32(&o.RD_TIM_CONF.Reg, volatile.LoadUint32(&o.RD_TIM_CONF.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetRD_TIM_CONF_THR_A() uint32 {
	return volatile.LoadUint32(&o.RD_TIM_CONF.Reg) & 0xff
}
func (o *EFUSE_Type) SetRD_TIM_CONF_TRD(value uint32) {
	volatile.StoreUint32(&o.RD_TIM_CONF.Reg, volatile.LoadUint32(&o.RD_TIM_CONF.Reg)&^(0xff00)|value<<8)
}
func (o *EFUSE_Type) GetRD_TIM_CONF_TRD() uint32 {
	return (volatile.LoadUint32(&o.RD_TIM_CONF.Reg) & 0xff00) >> 8
}
func (o *EFUSE_Type) SetRD_TIM_CONF_TSUR_A(value uint32) {
	volatile.StoreUint32(&o.RD_TIM_CONF.Reg, volatile.LoadUint32(&o.RD_TIM_CONF.Reg)&^(0xff0000)|value<<16)
}
func (o *EFUSE_Type) GetRD_TIM_CONF_TSUR_A() uint32 {
	return (volatile.LoadUint32(&o.RD_TIM_CONF.Reg) & 0xff0000) >> 16
}
func (o *EFUSE_Type) SetRD_TIM_CONF_READ_INIT_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_TIM_CONF.Reg, volatile.LoadUint32(&o.RD_TIM_CONF.Reg)&^(0xff000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_TIM_CONF_READ_INIT_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_TIM_CONF.Reg) & 0xff000000) >> 24
}

// EFUSE.WR_TIM_CONF0: Configuration register 0 of eFuse programming timing parameters.
func (o *EFUSE_Type) SetWR_TIM_CONF0_THP_A(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF0.Reg, volatile.LoadUint32(&o.WR_TIM_CONF0.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetWR_TIM_CONF0_THP_A() uint32 {
	return volatile.LoadUint32(&o.WR_TIM_CONF0.Reg) & 0xff
}
func (o *EFUSE_Type) SetWR_TIM_CONF0_TPGM_INACTIVE(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF0.Reg, volatile.LoadUint32(&o.WR_TIM_CONF0.Reg)&^(0xff00)|value<<8)
}
func (o *EFUSE_Type) GetWR_TIM_CONF0_TPGM_INACTIVE() uint32 {
	return (volatile.LoadUint32(&o.WR_TIM_CONF0.Reg) & 0xff00) >> 8
}
func (o *EFUSE_Type) SetWR_TIM_CONF0_TPGM(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF0.Reg, volatile.LoadUint32(&o.WR_TIM_CONF0.Reg)&^(0xffff0000)|value<<16)
}
func (o *EFUSE_Type) GetWR_TIM_CONF0_TPGM() uint32 {
	return (volatile.LoadUint32(&o.WR_TIM_CONF0.Reg) & 0xffff0000) >> 16
}

// EFUSE.WR_TIM_CONF1: Configuration register 1 of eFuse programming timing parameters.
func (o *EFUSE_Type) SetWR_TIM_CONF1_TSUP_A(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF1.Reg, volatile.LoadUint32(&o.WR_TIM_CONF1.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetWR_TIM_CONF1_TSUP_A() uint32 {
	return volatile.LoadUint32(&o.WR_TIM_CONF1.Reg) & 0xff
}
func (o *EFUSE_Type) SetWR_TIM_CONF1_PWR_ON_NUM(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF1.Reg, volatile.LoadUint32(&o.WR_TIM_CONF1.Reg)&^(0xffff00)|value<<8)
}
func (o *EFUSE_Type) GetWR_TIM_CONF1_PWR_ON_NUM() uint32 {
	return (volatile.LoadUint32(&o.WR_TIM_CONF1.Reg) & 0xffff00) >> 8
}

// EFUSE.WR_TIM_CONF2: Configuration register 2 of eFuse programming timing parameters.
func (o *EFUSE_Type) SetWR_TIM_CONF2_PWR_OFF_NUM(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF2.Reg, volatile.LoadUint32(&o.WR_TIM_CONF2.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetWR_TIM_CONF2_PWR_OFF_NUM() uint32 {
	return volatile.LoadUint32(&o.WR_TIM_CONF2.Reg) & 0xffff
}

// EFUSE.DATE: Version control register.
func (o *EFUSE_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *EFUSE_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// External Memory
type EXTMEM_Type struct {
	PRO_DCACHE_CTRL                      volatile.Register32 // 0x0
	PRO_DCACHE_CTRL1                     volatile.Register32 // 0x4
	PRO_DCACHE_TAG_POWER_CTRL            volatile.Register32 // 0x8
	PRO_DCACHE_LOCK0_ADDR                volatile.Register32 // 0xC
	PRO_DCACHE_LOCK0_SIZE                volatile.Register32 // 0x10
	PRO_DCACHE_LOCK1_ADDR                volatile.Register32 // 0x14
	PRO_DCACHE_LOCK1_SIZE                volatile.Register32 // 0x18
	PRO_DCACHE_MEM_SYNC0                 volatile.Register32 // 0x1C
	PRO_DCACHE_MEM_SYNC1                 volatile.Register32 // 0x20
	PRO_DCACHE_PRELOAD_ADDR              volatile.Register32 // 0x24
	PRO_DCACHE_PRELOAD_SIZE              volatile.Register32 // 0x28
	PRO_DCACHE_AUTOLOAD_CFG              volatile.Register32 // 0x2C
	PRO_DCACHE_AUTOLOAD_SECTION0_ADDR    volatile.Register32 // 0x30
	PRO_DCACHE_AUTOLOAD_SECTION0_SIZE    volatile.Register32 // 0x34
	PRO_DCACHE_AUTOLOAD_SECTION1_ADDR    volatile.Register32 // 0x38
	PRO_DCACHE_AUTOLOAD_SECTION1_SIZE    volatile.Register32 // 0x3C
	PRO_ICACHE_CTRL                      volatile.Register32 // 0x40
	PRO_ICACHE_CTRL1                     volatile.Register32 // 0x44
	PRO_ICACHE_TAG_POWER_CTRL            volatile.Register32 // 0x48
	PRO_ICACHE_LOCK0_ADDR                volatile.Register32 // 0x4C
	PRO_ICACHE_LOCK0_SIZE                volatile.Register32 // 0x50
	PRO_ICACHE_LOCK1_ADDR                volatile.Register32 // 0x54
	PRO_ICACHE_LOCK1_SIZE                volatile.Register32 // 0x58
	PRO_ICACHE_MEM_SYNC0                 volatile.Register32 // 0x5C
	PRO_ICACHE_MEM_SYNC1                 volatile.Register32 // 0x60
	PRO_ICACHE_PRELOAD_ADDR              volatile.Register32 // 0x64
	PRO_ICACHE_PRELOAD_SIZE              volatile.Register32 // 0x68
	PRO_ICACHE_AUTOLOAD_CFG              volatile.Register32 // 0x6C
	PRO_ICACHE_AUTOLOAD_SECTION0_ADDR    volatile.Register32 // 0x70
	PRO_ICACHE_AUTOLOAD_SECTION0_SIZE    volatile.Register32 // 0x74
	PRO_ICACHE_AUTOLOAD_SECTION1_ADDR    volatile.Register32 // 0x78
	PRO_ICACHE_AUTOLOAD_SECTION1_SIZE    volatile.Register32 // 0x7C
	IC_PRELOAD_CNT                       volatile.Register32 // 0x80
	IC_PRELOAD_MISS_CNT                  volatile.Register32 // 0x84
	IBUS2_ABANDON_CNT                    volatile.Register32 // 0x88
	IBUS1_ABANDON_CNT                    volatile.Register32 // 0x8C
	IBUS0_ABANDON_CNT                    volatile.Register32 // 0x90
	IBUS2_ACS_MISS_CNT                   volatile.Register32 // 0x94
	IBUS1_ACS_MISS_CNT                   volatile.Register32 // 0x98
	IBUS0_ACS_MISS_CNT                   volatile.Register32 // 0x9C
	IBUS2_ACS_CNT                        volatile.Register32 // 0xA0
	IBUS1_ACS_CNT                        volatile.Register32 // 0xA4
	IBUS0_ACS_CNT                        volatile.Register32 // 0xA8
	DC_PRELOAD_CNT                       volatile.Register32 // 0xAC
	DC_PRELOAD_EVICT_CNT                 volatile.Register32 // 0xB0
	DC_PRELOAD_MISS_CNT                  volatile.Register32 // 0xB4
	DBUS2_ABANDON_CNT                    volatile.Register32 // 0xB8
	DBUS1_ABANDON_CNT                    volatile.Register32 // 0xBC
	DBUS0_ABANDON_CNT                    volatile.Register32 // 0xC0
	DBUS2_ACS_WB_CNT                     volatile.Register32 // 0xC4
	DBUS1_ACS_WB_CNT                     volatile.Register32 // 0xC8
	DBUS0_ACS_WB_CNT                     volatile.Register32 // 0xCC
	DBUS2_ACS_MISS_CNT                   volatile.Register32 // 0xD0
	DBUS1_ACS_MISS_CNT                   volatile.Register32 // 0xD4
	DBUS0_ACS_MISS_CNT                   volatile.Register32 // 0xD8
	DBUS2_ACS_CNT                        volatile.Register32 // 0xDC
	DBUS1_ACS_CNT                        volatile.Register32 // 0xE0
	DBUS0_ACS_CNT                        volatile.Register32 // 0xE4
	CACHE_DBG_INT_ENA                    volatile.Register32 // 0xE8
	CACHE_DBG_INT_CLR                    volatile.Register32 // 0xEC
	CACHE_DBG_STATUS0                    volatile.Register32 // 0xF0
	CACHE_DBG_STATUS1                    volatile.Register32 // 0xF4
	PRO_CACHE_ACS_CNT_CLR                volatile.Register32 // 0xF8
	PRO_DCACHE_REJECT_ST                 volatile.Register32 // 0xFC
	PRO_DCACHE_REJECT_VADDR              volatile.Register32 // 0x100
	PRO_ICACHE_REJECT_ST                 volatile.Register32 // 0x104
	PRO_ICACHE_REJECT_VADDR              volatile.Register32 // 0x108
	PRO_CACHE_MMU_FAULT_CONTENT          volatile.Register32 // 0x10C
	PRO_CACHE_MMU_FAULT_VADDR            volatile.Register32 // 0x110
	PRO_CACHE_WRAP_AROUND_CTRL           volatile.Register32 // 0x114
	PRO_CACHE_MMU_POWER_CTRL             volatile.Register32 // 0x118
	PRO_CACHE_STATE                      volatile.Register32 // 0x11C
	CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE volatile.Register32 // 0x120
	CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON   volatile.Register32 // 0x124
	CACHE_BRIDGE_ARBITER_CTRL            volatile.Register32 // 0x128
	CACHE_PRELOAD_INT_CTRL               volatile.Register32 // 0x12C
	CACHE_SYNC_INT_CTRL                  volatile.Register32 // 0x130
	CACHE_CONF_MISC                      volatile.Register32 // 0x134
	CLOCK_GATE                           volatile.Register32 // 0x138
	_                                    [704]byte
	PRO_EXTMEM_REG_DATE                  volatile.Register32 // 0x3FC
}

// EXTMEM.PRO_DCACHE_CTRL: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_ENABLE() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_SETSIZE_MODE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_SETSIZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_BLOCKSIZE_MODE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_BLOCKSIZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_INVALIDATE_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_INVALIDATE_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_INVALIDATE_DONE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_INVALIDATE_DONE() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_FLUSH_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_FLUSH_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_FLUSH_DONE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_FLUSH_DONE() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_CLEAN_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_CLEAN_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x1000) >> 12
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_CLEAN_DONE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_CLEAN_DONE() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x2000) >> 13
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_LOCK0_EN(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_LOCK0_EN() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x4000) >> 14
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_LOCK1_EN(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_LOCK1_EN() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x8000) >> 15
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_AUTOLOAD_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x40000) >> 18
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x80000) >> 19
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_PRELOAD_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x100000) >> 20
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x200000) >> 21
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_UNLOCK_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_UNLOCK_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x400000) >> 22
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_UNLOCK_DONE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_UNLOCK_DONE() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x800000) >> 23
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_LOCK_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_LOCK_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x1000000) >> 24
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL_PRO_DCACHE_LOCK_DONE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL_PRO_DCACHE_LOCK_DONE() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL.Reg) & 0x2000000) >> 25
}

// EXTMEM.PRO_DCACHE_CTRL1: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL1_PRO_DCACHE_MASK_BUS0(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL1.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL1_PRO_DCACHE_MASK_BUS0() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_CTRL1.Reg) & 0x1
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL1_PRO_DCACHE_MASK_BUS1(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL1.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL1_PRO_DCACHE_MASK_BUS1() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL1.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetPRO_DCACHE_CTRL1_PRO_DCACHE_MASK_BUS2(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_DCACHE_CTRL1.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_CTRL1_PRO_DCACHE_MASK_BUS2() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_CTRL1.Reg) & 0x4) >> 2
}

// EXTMEM.PRO_DCACHE_TAG_POWER_CTRL: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_TAG_POWER_CTRL_PRO_DCACHE_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_TAG_POWER_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_TAG_POWER_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_TAG_POWER_CTRL_PRO_DCACHE_TAG_MEM_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_TAG_POWER_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetPRO_DCACHE_TAG_POWER_CTRL_PRO_DCACHE_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_TAG_POWER_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_TAG_POWER_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_TAG_POWER_CTRL_PRO_DCACHE_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_TAG_POWER_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetPRO_DCACHE_TAG_POWER_CTRL_PRO_DCACHE_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_TAG_POWER_CTRL.Reg, volatile.LoadUint32(&o.PRO_DCACHE_TAG_POWER_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_TAG_POWER_CTRL_PRO_DCACHE_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_TAG_POWER_CTRL.Reg) & 0x4) >> 2
}

// EXTMEM.PRO_DCACHE_LOCK0_ADDR: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_LOCK0_ADDR(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_LOCK0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_LOCK0_ADDR() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_LOCK0_ADDR.Reg)
}

// EXTMEM.PRO_DCACHE_LOCK0_SIZE: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_LOCK0_SIZE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_LOCK0_SIZE.Reg, volatile.LoadUint32(&o.PRO_DCACHE_LOCK0_SIZE.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_LOCK0_SIZE() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_LOCK0_SIZE.Reg) & 0xffff
}

// EXTMEM.PRO_DCACHE_LOCK1_ADDR: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_LOCK1_ADDR(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_LOCK1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_LOCK1_ADDR() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_LOCK1_ADDR.Reg)
}

// EXTMEM.PRO_DCACHE_LOCK1_SIZE: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_LOCK1_SIZE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_LOCK1_SIZE.Reg, volatile.LoadUint32(&o.PRO_DCACHE_LOCK1_SIZE.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_LOCK1_SIZE() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_LOCK1_SIZE.Reg) & 0xffff
}

// EXTMEM.PRO_DCACHE_MEM_SYNC0: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_MEM_SYNC0(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_MEM_SYNC0.Reg, value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_MEM_SYNC0() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_MEM_SYNC0.Reg)
}

// EXTMEM.PRO_DCACHE_MEM_SYNC1: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_MEM_SYNC1_PRO_DCACHE_MEMSYNC_SIZE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_MEM_SYNC1.Reg, volatile.LoadUint32(&o.PRO_DCACHE_MEM_SYNC1.Reg)&^(0x7ffff)|value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_MEM_SYNC1_PRO_DCACHE_MEMSYNC_SIZE() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_MEM_SYNC1.Reg) & 0x7ffff
}

// EXTMEM.PRO_DCACHE_PRELOAD_ADDR: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_PRELOAD_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_PRELOAD_ADDR.Reg)
}

// EXTMEM.PRO_DCACHE_PRELOAD_SIZE: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.PRO_DCACHE_PRELOAD_SIZE.Reg)&^(0x3ff)|value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_PRELOAD_SIZE.Reg) & 0x3ff
}
func (o *EXTMEM_Type) SetPRO_DCACHE_PRELOAD_SIZE_PRO_DCACHE_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.PRO_DCACHE_PRELOAD_SIZE.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_PRELOAD_SIZE_PRO_DCACHE_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_PRELOAD_SIZE.Reg) & 0x400) >> 10
}

// EXTMEM.PRO_DCACHE_AUTOLOAD_CFG: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_AUTOLOAD_CFG_PRO_DCACHE_AUTOLOAD_MODE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg, volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_AUTOLOAD_CFG_PRO_DCACHE_AUTOLOAD_MODE() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg) & 0x1
}
func (o *EXTMEM_Type) SetPRO_DCACHE_AUTOLOAD_CFG_PRO_DCACHE_AUTOLOAD_STEP(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg, volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg)&^(0x6)|value<<1)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_AUTOLOAD_CFG_PRO_DCACHE_AUTOLOAD_STEP() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg) & 0x6) >> 1
}
func (o *EXTMEM_Type) SetPRO_DCACHE_AUTOLOAD_CFG_PRO_DCACHE_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg, volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_AUTOLOAD_CFG_PRO_DCACHE_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetPRO_DCACHE_AUTOLOAD_CFG_PRO_DCACHE_AUTOLOAD_RQST(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg, volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg)&^(0x30)|value<<4)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_AUTOLOAD_CFG_PRO_DCACHE_AUTOLOAD_RQST() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg) & 0x30) >> 4
}
func (o *EXTMEM_Type) SetPRO_DCACHE_AUTOLOAD_CFG_PRO_DCACHE_AUTOLOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg, volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg)&^(0xc0)|value<<6)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_AUTOLOAD_CFG_PRO_DCACHE_AUTOLOAD_SIZE() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg) & 0xc0) >> 6
}
func (o *EXTMEM_Type) SetPRO_DCACHE_AUTOLOAD_CFG_PRO_DCACHE_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg, volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_AUTOLOAD_CFG_PRO_DCACHE_AUTOLOAD_SCT0_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetPRO_DCACHE_AUTOLOAD_CFG_PRO_DCACHE_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg, volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_AUTOLOAD_CFG_PRO_DCACHE_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_CFG.Reg) & 0x200) >> 9
}

// EXTMEM.PRO_DCACHE_AUTOLOAD_SECTION0_ADDR: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_AUTOLOAD_SECTION0_ADDR(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_AUTOLOAD_SECTION0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_AUTOLOAD_SECTION0_ADDR() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_SECTION0_ADDR.Reg)
}

// EXTMEM.PRO_DCACHE_AUTOLOAD_SECTION0_SIZE: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_AUTOLOAD_SECTION0_SIZE_PRO_DCACHE_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_AUTOLOAD_SECTION0_SIZE.Reg, volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_SECTION0_SIZE.Reg)&^(0xffffff)|value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_AUTOLOAD_SECTION0_SIZE_PRO_DCACHE_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_SECTION0_SIZE.Reg) & 0xffffff
}

// EXTMEM.PRO_DCACHE_AUTOLOAD_SECTION1_ADDR: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_AUTOLOAD_SECTION1_ADDR(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_AUTOLOAD_SECTION1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_AUTOLOAD_SECTION1_ADDR() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_SECTION1_ADDR.Reg)
}

// EXTMEM.PRO_DCACHE_AUTOLOAD_SECTION1_SIZE: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_AUTOLOAD_SECTION1_SIZE_PRO_DCACHE_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_AUTOLOAD_SECTION1_SIZE.Reg, volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_SECTION1_SIZE.Reg)&^(0xffffff)|value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_AUTOLOAD_SECTION1_SIZE_PRO_DCACHE_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_AUTOLOAD_SECTION1_SIZE.Reg) & 0xffffff
}

// EXTMEM.PRO_ICACHE_CTRL: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL_PRO_ICACHE_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL_PRO_ICACHE_ENABLE() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL_PRO_ICACHE_SETSIZE_MODE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL_PRO_ICACHE_SETSIZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL_PRO_ICACHE_BLOCKSIZE_MODE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL_PRO_ICACHE_BLOCKSIZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL_PRO_ICACHE_INVALIDATE_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL_PRO_ICACHE_INVALIDATE_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL_PRO_ICACHE_INVALIDATE_DONE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL_PRO_ICACHE_INVALIDATE_DONE() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL_PRO_ICACHE_LOCK0_EN(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL_PRO_ICACHE_LOCK0_EN() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg) & 0x4000) >> 14
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL_PRO_ICACHE_LOCK1_EN(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL_PRO_ICACHE_LOCK1_EN() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg) & 0x8000) >> 15
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL_PRO_ICACHE_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL_PRO_ICACHE_AUTOLOAD_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg) & 0x40000) >> 18
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL_PRO_ICACHE_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL_PRO_ICACHE_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg) & 0x80000) >> 19
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL_PRO_ICACHE_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL_PRO_ICACHE_PRELOAD_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg) & 0x100000) >> 20
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL_PRO_ICACHE_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL_PRO_ICACHE_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg) & 0x200000) >> 21
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL_PRO_ICACHE_UNLOCK_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL_PRO_ICACHE_UNLOCK_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg) & 0x400000) >> 22
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL_PRO_ICACHE_UNLOCK_DONE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL_PRO_ICACHE_UNLOCK_DONE() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg) & 0x800000) >> 23
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL_PRO_ICACHE_LOCK_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL_PRO_ICACHE_LOCK_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg) & 0x1000000) >> 24
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL_PRO_ICACHE_LOCK_DONE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL_PRO_ICACHE_LOCK_DONE() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL.Reg) & 0x2000000) >> 25
}

// EXTMEM.PRO_ICACHE_CTRL1: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL1_PRO_ICACHE_MASK_BUS0(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL1.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL1_PRO_ICACHE_MASK_BUS0() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_CTRL1.Reg) & 0x1
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL1_PRO_ICACHE_MASK_BUS1(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL1.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL1_PRO_ICACHE_MASK_BUS1() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL1.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetPRO_ICACHE_CTRL1_PRO_ICACHE_MASK_BUS2(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_CTRL1.Reg, volatile.LoadUint32(&o.PRO_ICACHE_CTRL1.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_CTRL1_PRO_ICACHE_MASK_BUS2() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_CTRL1.Reg) & 0x4) >> 2
}

// EXTMEM.PRO_ICACHE_TAG_POWER_CTRL: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_TAG_POWER_CTRL_PRO_ICACHE_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_TAG_POWER_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_TAG_POWER_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_TAG_POWER_CTRL_PRO_ICACHE_TAG_MEM_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_TAG_POWER_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetPRO_ICACHE_TAG_POWER_CTRL_PRO_ICACHE_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_TAG_POWER_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_TAG_POWER_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_TAG_POWER_CTRL_PRO_ICACHE_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_TAG_POWER_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetPRO_ICACHE_TAG_POWER_CTRL_PRO_ICACHE_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_TAG_POWER_CTRL.Reg, volatile.LoadUint32(&o.PRO_ICACHE_TAG_POWER_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_TAG_POWER_CTRL_PRO_ICACHE_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_TAG_POWER_CTRL.Reg) & 0x4) >> 2
}

// EXTMEM.PRO_ICACHE_LOCK0_ADDR: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_LOCK0_ADDR(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_LOCK0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_LOCK0_ADDR() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_LOCK0_ADDR.Reg)
}

// EXTMEM.PRO_ICACHE_LOCK0_SIZE: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_LOCK0_SIZE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_LOCK0_SIZE.Reg, volatile.LoadUint32(&o.PRO_ICACHE_LOCK0_SIZE.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_LOCK0_SIZE() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_LOCK0_SIZE.Reg) & 0xffff
}

// EXTMEM.PRO_ICACHE_LOCK1_ADDR: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_LOCK1_ADDR(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_LOCK1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_LOCK1_ADDR() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_LOCK1_ADDR.Reg)
}

// EXTMEM.PRO_ICACHE_LOCK1_SIZE: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_LOCK1_SIZE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_LOCK1_SIZE.Reg, volatile.LoadUint32(&o.PRO_ICACHE_LOCK1_SIZE.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_LOCK1_SIZE() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_LOCK1_SIZE.Reg) & 0xffff
}

// EXTMEM.PRO_ICACHE_MEM_SYNC0: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_MEM_SYNC0(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_MEM_SYNC0.Reg, value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_MEM_SYNC0() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_MEM_SYNC0.Reg)
}

// EXTMEM.PRO_ICACHE_MEM_SYNC1: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_MEM_SYNC1_PRO_ICACHE_MEMSYNC_SIZE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_MEM_SYNC1.Reg, volatile.LoadUint32(&o.PRO_ICACHE_MEM_SYNC1.Reg)&^(0x7ffff)|value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_MEM_SYNC1_PRO_ICACHE_MEMSYNC_SIZE() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_MEM_SYNC1.Reg) & 0x7ffff
}

// EXTMEM.PRO_ICACHE_PRELOAD_ADDR: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_PRELOAD_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_PRELOAD_ADDR.Reg)
}

// EXTMEM.PRO_ICACHE_PRELOAD_SIZE: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.PRO_ICACHE_PRELOAD_SIZE.Reg)&^(0x3ff)|value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_PRELOAD_SIZE.Reg) & 0x3ff
}
func (o *EXTMEM_Type) SetPRO_ICACHE_PRELOAD_SIZE_PRO_ICACHE_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.PRO_ICACHE_PRELOAD_SIZE.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_PRELOAD_SIZE_PRO_ICACHE_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_PRELOAD_SIZE.Reg) & 0x400) >> 10
}

// EXTMEM.PRO_ICACHE_AUTOLOAD_CFG: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_AUTOLOAD_CFG_PRO_ICACHE_AUTOLOAD_MODE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg, volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_AUTOLOAD_CFG_PRO_ICACHE_AUTOLOAD_MODE() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg) & 0x1
}
func (o *EXTMEM_Type) SetPRO_ICACHE_AUTOLOAD_CFG_PRO_ICACHE_AUTOLOAD_STEP(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg, volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg)&^(0x6)|value<<1)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_AUTOLOAD_CFG_PRO_ICACHE_AUTOLOAD_STEP() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg) & 0x6) >> 1
}
func (o *EXTMEM_Type) SetPRO_ICACHE_AUTOLOAD_CFG_PRO_ICACHE_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg, volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_AUTOLOAD_CFG_PRO_ICACHE_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetPRO_ICACHE_AUTOLOAD_CFG_PRO_ICACHE_AUTOLOAD_RQST(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg, volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg)&^(0x30)|value<<4)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_AUTOLOAD_CFG_PRO_ICACHE_AUTOLOAD_RQST() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg) & 0x30) >> 4
}
func (o *EXTMEM_Type) SetPRO_ICACHE_AUTOLOAD_CFG_PRO_ICACHE_AUTOLOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg, volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg)&^(0xc0)|value<<6)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_AUTOLOAD_CFG_PRO_ICACHE_AUTOLOAD_SIZE() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg) & 0xc0) >> 6
}
func (o *EXTMEM_Type) SetPRO_ICACHE_AUTOLOAD_CFG_PRO_ICACHE_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg, volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_AUTOLOAD_CFG_PRO_ICACHE_AUTOLOAD_SCT0_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetPRO_ICACHE_AUTOLOAD_CFG_PRO_ICACHE_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg, volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_AUTOLOAD_CFG_PRO_ICACHE_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_CFG.Reg) & 0x200) >> 9
}

// EXTMEM.PRO_ICACHE_AUTOLOAD_SECTION0_ADDR: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_AUTOLOAD_SECTION0_ADDR(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_AUTOLOAD_SECTION0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_AUTOLOAD_SECTION0_ADDR() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_SECTION0_ADDR.Reg)
}

// EXTMEM.PRO_ICACHE_AUTOLOAD_SECTION0_SIZE: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_AUTOLOAD_SECTION0_SIZE_PRO_ICACHE_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_AUTOLOAD_SECTION0_SIZE.Reg, volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_SECTION0_SIZE.Reg)&^(0xffffff)|value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_AUTOLOAD_SECTION0_SIZE_PRO_ICACHE_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_SECTION0_SIZE.Reg) & 0xffffff
}

// EXTMEM.PRO_ICACHE_AUTOLOAD_SECTION1_ADDR: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_AUTOLOAD_SECTION1_ADDR(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_AUTOLOAD_SECTION1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_AUTOLOAD_SECTION1_ADDR() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_SECTION1_ADDR.Reg)
}

// EXTMEM.PRO_ICACHE_AUTOLOAD_SECTION1_SIZE: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_AUTOLOAD_SECTION1_SIZE_PRO_ICACHE_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_AUTOLOAD_SECTION1_SIZE.Reg, volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_SECTION1_SIZE.Reg)&^(0xffffff)|value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_AUTOLOAD_SECTION1_SIZE_PRO_ICACHE_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_AUTOLOAD_SECTION1_SIZE.Reg) & 0xffffff
}

// EXTMEM.IC_PRELOAD_CNT: register description
func (o *EXTMEM_Type) SetIC_PRELOAD_CNT(value uint32) {
	volatile.StoreUint32(&o.IC_PRELOAD_CNT.Reg, volatile.LoadUint32(&o.IC_PRELOAD_CNT.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetIC_PRELOAD_CNT() uint32 {
	return volatile.LoadUint32(&o.IC_PRELOAD_CNT.Reg) & 0xffff
}

// EXTMEM.IC_PRELOAD_MISS_CNT: register description
func (o *EXTMEM_Type) SetIC_PRELOAD_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.IC_PRELOAD_MISS_CNT.Reg, volatile.LoadUint32(&o.IC_PRELOAD_MISS_CNT.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetIC_PRELOAD_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.IC_PRELOAD_MISS_CNT.Reg) & 0xffff
}

// EXTMEM.IBUS2_ABANDON_CNT: register description
func (o *EXTMEM_Type) SetIBUS2_ABANDON_CNT(value uint32) {
	volatile.StoreUint32(&o.IBUS2_ABANDON_CNT.Reg, volatile.LoadUint32(&o.IBUS2_ABANDON_CNT.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetIBUS2_ABANDON_CNT() uint32 {
	return volatile.LoadUint32(&o.IBUS2_ABANDON_CNT.Reg) & 0xffff
}

// EXTMEM.IBUS1_ABANDON_CNT: register description
func (o *EXTMEM_Type) SetIBUS1_ABANDON_CNT(value uint32) {
	volatile.StoreUint32(&o.IBUS1_ABANDON_CNT.Reg, volatile.LoadUint32(&o.IBUS1_ABANDON_CNT.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetIBUS1_ABANDON_CNT() uint32 {
	return volatile.LoadUint32(&o.IBUS1_ABANDON_CNT.Reg) & 0xffff
}

// EXTMEM.IBUS0_ABANDON_CNT: register description
func (o *EXTMEM_Type) SetIBUS0_ABANDON_CNT(value uint32) {
	volatile.StoreUint32(&o.IBUS0_ABANDON_CNT.Reg, volatile.LoadUint32(&o.IBUS0_ABANDON_CNT.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetIBUS0_ABANDON_CNT() uint32 {
	return volatile.LoadUint32(&o.IBUS0_ABANDON_CNT.Reg) & 0xffff
}

// EXTMEM.IBUS2_ACS_MISS_CNT: register description
func (o *EXTMEM_Type) SetIBUS2_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.IBUS2_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetIBUS2_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.IBUS2_ACS_MISS_CNT.Reg)
}

// EXTMEM.IBUS1_ACS_MISS_CNT: register description
func (o *EXTMEM_Type) SetIBUS1_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.IBUS1_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetIBUS1_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.IBUS1_ACS_MISS_CNT.Reg)
}

// EXTMEM.IBUS0_ACS_MISS_CNT: register description
func (o *EXTMEM_Type) SetIBUS0_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.IBUS0_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetIBUS0_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.IBUS0_ACS_MISS_CNT.Reg)
}

// EXTMEM.IBUS2_ACS_CNT: register description
func (o *EXTMEM_Type) SetIBUS2_ACS_CNT(value uint32) {
	volatile.StoreUint32(&o.IBUS2_ACS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetIBUS2_ACS_CNT() uint32 {
	return volatile.LoadUint32(&o.IBUS2_ACS_CNT.Reg)
}

// EXTMEM.IBUS1_ACS_CNT: register description
func (o *EXTMEM_Type) SetIBUS1_ACS_CNT(value uint32) {
	volatile.StoreUint32(&o.IBUS1_ACS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetIBUS1_ACS_CNT() uint32 {
	return volatile.LoadUint32(&o.IBUS1_ACS_CNT.Reg)
}

// EXTMEM.IBUS0_ACS_CNT: register description
func (o *EXTMEM_Type) SetIBUS0_ACS_CNT(value uint32) {
	volatile.StoreUint32(&o.IBUS0_ACS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetIBUS0_ACS_CNT() uint32 {
	return volatile.LoadUint32(&o.IBUS0_ACS_CNT.Reg)
}

// EXTMEM.DC_PRELOAD_CNT: register description
func (o *EXTMEM_Type) SetDC_PRELOAD_CNT(value uint32) {
	volatile.StoreUint32(&o.DC_PRELOAD_CNT.Reg, volatile.LoadUint32(&o.DC_PRELOAD_CNT.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetDC_PRELOAD_CNT() uint32 {
	return volatile.LoadUint32(&o.DC_PRELOAD_CNT.Reg) & 0xffff
}

// EXTMEM.DC_PRELOAD_EVICT_CNT: register description
func (o *EXTMEM_Type) SetDC_PRELOAD_EVICT_CNT(value uint32) {
	volatile.StoreUint32(&o.DC_PRELOAD_EVICT_CNT.Reg, volatile.LoadUint32(&o.DC_PRELOAD_EVICT_CNT.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetDC_PRELOAD_EVICT_CNT() uint32 {
	return volatile.LoadUint32(&o.DC_PRELOAD_EVICT_CNT.Reg) & 0xffff
}

// EXTMEM.DC_PRELOAD_MISS_CNT: register description
func (o *EXTMEM_Type) SetDC_PRELOAD_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.DC_PRELOAD_MISS_CNT.Reg, volatile.LoadUint32(&o.DC_PRELOAD_MISS_CNT.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetDC_PRELOAD_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.DC_PRELOAD_MISS_CNT.Reg) & 0xffff
}

// EXTMEM.DBUS2_ABANDON_CNT: register description
func (o *EXTMEM_Type) SetDBUS2_ABANDON_CNT(value uint32) {
	volatile.StoreUint32(&o.DBUS2_ABANDON_CNT.Reg, volatile.LoadUint32(&o.DBUS2_ABANDON_CNT.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetDBUS2_ABANDON_CNT() uint32 {
	return volatile.LoadUint32(&o.DBUS2_ABANDON_CNT.Reg) & 0xffff
}

// EXTMEM.DBUS1_ABANDON_CNT: register description
func (o *EXTMEM_Type) SetDBUS1_ABANDON_CNT(value uint32) {
	volatile.StoreUint32(&o.DBUS1_ABANDON_CNT.Reg, volatile.LoadUint32(&o.DBUS1_ABANDON_CNT.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetDBUS1_ABANDON_CNT() uint32 {
	return volatile.LoadUint32(&o.DBUS1_ABANDON_CNT.Reg) & 0xffff
}

// EXTMEM.DBUS0_ABANDON_CNT: register description
func (o *EXTMEM_Type) SetDBUS0_ABANDON_CNT(value uint32) {
	volatile.StoreUint32(&o.DBUS0_ABANDON_CNT.Reg, volatile.LoadUint32(&o.DBUS0_ABANDON_CNT.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetDBUS0_ABANDON_CNT() uint32 {
	return volatile.LoadUint32(&o.DBUS0_ABANDON_CNT.Reg) & 0xffff
}

// EXTMEM.DBUS2_ACS_WB_CNT: register description
func (o *EXTMEM_Type) SetDBUS2_ACS_WB_CNT(value uint32) {
	volatile.StoreUint32(&o.DBUS2_ACS_WB_CNT.Reg, volatile.LoadUint32(&o.DBUS2_ACS_WB_CNT.Reg)&^(0xfffff)|value)
}
func (o *EXTMEM_Type) GetDBUS2_ACS_WB_CNT() uint32 {
	return volatile.LoadUint32(&o.DBUS2_ACS_WB_CNT.Reg) & 0xfffff
}

// EXTMEM.DBUS1_ACS_WB_CNT: register description
func (o *EXTMEM_Type) SetDBUS1_ACS_WB_CNT(value uint32) {
	volatile.StoreUint32(&o.DBUS1_ACS_WB_CNT.Reg, volatile.LoadUint32(&o.DBUS1_ACS_WB_CNT.Reg)&^(0xfffff)|value)
}
func (o *EXTMEM_Type) GetDBUS1_ACS_WB_CNT() uint32 {
	return volatile.LoadUint32(&o.DBUS1_ACS_WB_CNT.Reg) & 0xfffff
}

// EXTMEM.DBUS0_ACS_WB_CNT: register description
func (o *EXTMEM_Type) SetDBUS0_ACS_WB_CNT(value uint32) {
	volatile.StoreUint32(&o.DBUS0_ACS_WB_CNT.Reg, volatile.LoadUint32(&o.DBUS0_ACS_WB_CNT.Reg)&^(0xfffff)|value)
}
func (o *EXTMEM_Type) GetDBUS0_ACS_WB_CNT() uint32 {
	return volatile.LoadUint32(&o.DBUS0_ACS_WB_CNT.Reg) & 0xfffff
}

// EXTMEM.DBUS2_ACS_MISS_CNT: register description
func (o *EXTMEM_Type) SetDBUS2_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.DBUS2_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetDBUS2_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.DBUS2_ACS_MISS_CNT.Reg)
}

// EXTMEM.DBUS1_ACS_MISS_CNT: register description
func (o *EXTMEM_Type) SetDBUS1_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.DBUS1_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetDBUS1_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.DBUS1_ACS_MISS_CNT.Reg)
}

// EXTMEM.DBUS0_ACS_MISS_CNT: register description
func (o *EXTMEM_Type) SetDBUS0_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.DBUS0_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetDBUS0_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.DBUS0_ACS_MISS_CNT.Reg)
}

// EXTMEM.DBUS2_ACS_CNT: register description
func (o *EXTMEM_Type) SetDBUS2_ACS_CNT(value uint32) {
	volatile.StoreUint32(&o.DBUS2_ACS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetDBUS2_ACS_CNT() uint32 {
	return volatile.LoadUint32(&o.DBUS2_ACS_CNT.Reg)
}

// EXTMEM.DBUS1_ACS_CNT: register description
func (o *EXTMEM_Type) SetDBUS1_ACS_CNT(value uint32) {
	volatile.StoreUint32(&o.DBUS1_ACS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetDBUS1_ACS_CNT() uint32 {
	return volatile.LoadUint32(&o.DBUS1_ACS_CNT.Reg)
}

// EXTMEM.DBUS0_ACS_CNT: register description
func (o *EXTMEM_Type) SetDBUS0_ACS_CNT(value uint32) {
	volatile.StoreUint32(&o.DBUS0_ACS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetDBUS0_ACS_CNT() uint32 {
	return volatile.LoadUint32(&o.DBUS0_ACS_CNT.Reg)
}

// EXTMEM.CACHE_DBG_INT_ENA: register description
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_CACHE_DBG_EN(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_CACHE_DBG_EN() uint32 {
	return volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_IBUS_ACS_MSK_IC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_IBUS_ACS_MSK_IC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_IBUS_CNT_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_IBUS_CNT_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_IC_SYNC_SIZE_FAULT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_IC_SYNC_SIZE_FAULT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_IC_PRELOAD_SIZE_FAULT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_IC_PRELOAD_SIZE_FAULT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_ICACHE_REJECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_ICACHE_REJECT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_ICACHE_SET_PRELOAD_ILG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_ICACHE_SET_PRELOAD_ILG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_ICACHE_SET_SYNC_ILG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_ICACHE_SET_SYNC_ILG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_ICACHE_SET_LOCK_ILG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_ICACHE_SET_LOCK_ILG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_DBUS_ACS_MSK_DC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_DBUS_ACS_MSK_DC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_DBUS_CNT_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_DBUS_CNT_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_DC_SYNC_SIZE_FAULT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_DC_SYNC_SIZE_FAULT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x1000) >> 12
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_DC_PRELOAD_SIZE_FAULT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_DC_PRELOAD_SIZE_FAULT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x2000) >> 13
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_DCACHE_WRITE_FLASH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x4000)|value<<14)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_DCACHE_WRITE_FLASH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x4000) >> 14
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_DCACHE_REJECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x8000)|value<<15)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_DCACHE_REJECT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x8000) >> 15
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_DCACHE_SET_PRELOAD_ILG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x10000)|value<<16)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_DCACHE_SET_PRELOAD_ILG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x10000) >> 16
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_DCACHE_SET_SYNC_ILG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x20000)|value<<17)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_DCACHE_SET_SYNC_ILG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x20000) >> 17
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_DCACHE_SET_LOCK_ILG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x40000)|value<<18)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_DCACHE_SET_LOCK_ILG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x40000) >> 18
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_ENA_MMU_ENTRY_FAULT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_ENA.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg)&^(0x80000)|value<<19)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_ENA_MMU_ENTRY_FAULT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_ENA.Reg) & 0x80000) >> 19
}

// EXTMEM.CACHE_DBG_INT_CLR: register description
func (o *EXTMEM_Type) SetCACHE_DBG_INT_CLR_IBUS_ACS_MSK_IC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_CLR_IBUS_ACS_MSK_IC_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_CLR_IBUS_CNT_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_CLR_IBUS_CNT_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_CLR_IC_SYNC_SIZE_FAULT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_CLR_IC_SYNC_SIZE_FAULT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_CLR_IC_PRELOAD_SIZE_FAULT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_CLR_IC_PRELOAD_SIZE_FAULT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_CLR_ICACHE_REJECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_CLR_ICACHE_REJECT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_CLR_ICACHE_SET_ILG_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_CLR_ICACHE_SET_ILG_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_CLR_DBUS_ACS_MSK_DC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_CLR_DBUS_ACS_MSK_DC_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_CLR_DBUS_CNT_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_CLR_DBUS_CNT_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_CLR_DC_SYNC_SIZE_FAULT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_CLR_DC_SYNC_SIZE_FAULT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_CLR_DC_PRELOAD_SIZE_FAULT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_CLR_DC_PRELOAD_SIZE_FAULT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_CLR_DCACHE_WRITE_FLASH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_CLR_DCACHE_WRITE_FLASH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_CLR_DCACHE_REJECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_CLR_DCACHE_REJECT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_CLR_DCACHE_SET_ILG_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_CLR_DCACHE_SET_ILG_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg) & 0x1000) >> 12
}
func (o *EXTMEM_Type) SetCACHE_DBG_INT_CLR_MMU_ENTRY_FAULT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_INT_CLR.Reg, volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetCACHE_DBG_INT_CLR_MMU_ENTRY_FAULT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_INT_CLR.Reg) & 0x2000) >> 13
}

// EXTMEM.CACHE_DBG_STATUS0: register description
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IBUS0_ACS_MSK_ICACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IBUS0_ACS_MSK_ICACHE_ST() uint32 {
	return volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IBUS1_ACS_MSK_ICACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IBUS1_ACS_MSK_ICACHE_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IBUS2_ACS_MSK_ICACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IBUS2_ACS_MSK_ICACHE_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IBUS0_ACS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IBUS0_ACS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IBUS1_ACS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IBUS1_ACS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IBUS2_ACS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IBUS2_ACS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IBUS0_ACS_MISS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IBUS0_ACS_MISS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IBUS1_ACS_MISS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IBUS1_ACS_MISS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IBUS2_ACS_MISS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IBUS2_ACS_MISS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IBUS0_ABANDON_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IBUS0_ABANDON_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x1000) >> 12
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IBUS1_ABANDON_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IBUS1_ABANDON_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x2000) >> 13
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IBUS2_ABANDON_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x4000)|value<<14)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IBUS2_ABANDON_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x4000) >> 14
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IC_PRELOAD_MISS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x10000)|value<<16)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IC_PRELOAD_MISS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x10000) >> 16
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IC_PRELOAD_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x40000)|value<<18)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IC_PRELOAD_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x40000) >> 18
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IC_SYNC_SIZE_FAULT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x80000)|value<<19)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IC_SYNC_SIZE_FAULT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x80000) >> 19
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_IC_PRELOAD_SIZE_FAULT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x100000)|value<<20)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_IC_PRELOAD_SIZE_FAULT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x100000) >> 20
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_ICACHE_REJECT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x200000)|value<<21)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_ICACHE_REJECT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x200000) >> 21
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_ICACHE_SET_PRELOAD_ILG_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x400000)|value<<22)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_ICACHE_SET_PRELOAD_ILG_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x400000) >> 22
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_ICACHE_SET_SYNC_ILG_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x800000)|value<<23)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_ICACHE_SET_SYNC_ILG_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x800000) >> 23
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS0_ICACHE_SET_LOCK_ILG_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS0.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS0_ICACHE_SET_LOCK_ILG_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS0.Reg) & 0x1000000) >> 24
}

// EXTMEM.CACHE_DBG_STATUS1: register description
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DBUS0_ACS_MSK_DCACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DBUS0_ACS_MSK_DCACHE_ST() uint32 {
	return volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DBUS1_ACS_MSK_DCACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DBUS1_ACS_MSK_DCACHE_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DBUS2_ACS_MSK_DCACHE_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DBUS2_ACS_MSK_DCACHE_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DBUS0_ACS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DBUS0_ACS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DBUS1_ACS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DBUS1_ACS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DBUS2_ACS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DBUS2_ACS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DBUS0_ACS_MISS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DBUS0_ACS_MISS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DBUS1_ACS_MISS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DBUS1_ACS_MISS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DBUS2_ACS_MISS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DBUS2_ACS_MISS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DBUS0_ACS_WB_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DBUS0_ACS_WB_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x1000) >> 12
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DBUS1_ACS_WB_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DBUS1_ACS_WB_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x2000) >> 13
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DBUS2_ACS_WB_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DBUS2_ACS_WB_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x4000) >> 14
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DBUS0_ABANDON_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DBUS0_ABANDON_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x10000) >> 16
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DBUS1_ABANDON_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DBUS1_ABANDON_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x20000) >> 17
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DBUS2_ABANDON_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DBUS2_ABANDON_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x40000) >> 18
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DC_PRELOAD_MISS_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DC_PRELOAD_MISS_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x100000) >> 20
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DC_PRELOAD_EVICT_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DC_PRELOAD_EVICT_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x200000) >> 21
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DC_PRELOAD_CNT_OVF_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DC_PRELOAD_CNT_OVF_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x400000) >> 22
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DC_SYNC_SIZE_FAULT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DC_SYNC_SIZE_FAULT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x800000) >> 23
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DC_PRELOAD_SIZE_FAULT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DC_PRELOAD_SIZE_FAULT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x1000000) >> 24
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DCACHE_WRITE_FLASH_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DCACHE_WRITE_FLASH_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x2000000) >> 25
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DCACHE_REJECT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DCACHE_REJECT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x4000000) >> 26
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DCACHE_SET_PRELOAD_ILG_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DCACHE_SET_PRELOAD_ILG_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x8000000) >> 27
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DCACHE_SET_SYNC_ILG_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DCACHE_SET_SYNC_ILG_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x10000000) >> 28
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_DCACHE_SET_LOCK_ILG_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_DCACHE_SET_LOCK_ILG_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x20000000) >> 29
}
func (o *EXTMEM_Type) SetCACHE_DBG_STATUS1_MMU_ENTRY_FAULT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_DBG_STATUS1.Reg, volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTMEM_Type) GetCACHE_DBG_STATUS1_MMU_ENTRY_FAULT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_DBG_STATUS1.Reg) & 0x40000000) >> 30
}

// EXTMEM.PRO_CACHE_ACS_CNT_CLR: register description
func (o *EXTMEM_Type) SetPRO_CACHE_ACS_CNT_CLR_PRO_DCACHE_ACS_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_ACS_CNT_CLR.Reg, volatile.LoadUint32(&o.PRO_CACHE_ACS_CNT_CLR.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetPRO_CACHE_ACS_CNT_CLR_PRO_DCACHE_ACS_CNT_CLR() uint32 {
	return volatile.LoadUint32(&o.PRO_CACHE_ACS_CNT_CLR.Reg) & 0x1
}
func (o *EXTMEM_Type) SetPRO_CACHE_ACS_CNT_CLR_PRO_ICACHE_ACS_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_ACS_CNT_CLR.Reg, volatile.LoadUint32(&o.PRO_CACHE_ACS_CNT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetPRO_CACHE_ACS_CNT_CLR_PRO_ICACHE_ACS_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_ACS_CNT_CLR.Reg) & 0x2) >> 1
}

// EXTMEM.PRO_DCACHE_REJECT_ST: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_REJECT_ST_PRO_DCACHE_TAG_ATTR(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_REJECT_ST.Reg, volatile.LoadUint32(&o.PRO_DCACHE_REJECT_ST.Reg)&^(0x7)|value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_REJECT_ST_PRO_DCACHE_TAG_ATTR() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_REJECT_ST.Reg) & 0x7
}
func (o *EXTMEM_Type) SetPRO_DCACHE_REJECT_ST_PRO_DCACHE_CPU_ATTR(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_REJECT_ST.Reg, volatile.LoadUint32(&o.PRO_DCACHE_REJECT_ST.Reg)&^(0x38)|value<<3)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_REJECT_ST_PRO_DCACHE_CPU_ATTR() uint32 {
	return (volatile.LoadUint32(&o.PRO_DCACHE_REJECT_ST.Reg) & 0x38) >> 3
}

// EXTMEM.PRO_DCACHE_REJECT_VADDR: register description
func (o *EXTMEM_Type) SetPRO_DCACHE_REJECT_VADDR(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_REJECT_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetPRO_DCACHE_REJECT_VADDR() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_REJECT_VADDR.Reg)
}

// EXTMEM.PRO_ICACHE_REJECT_ST: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_REJECT_ST_PRO_ICACHE_TAG_ATTR(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_REJECT_ST.Reg, volatile.LoadUint32(&o.PRO_ICACHE_REJECT_ST.Reg)&^(0x7)|value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_REJECT_ST_PRO_ICACHE_TAG_ATTR() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_REJECT_ST.Reg) & 0x7
}
func (o *EXTMEM_Type) SetPRO_ICACHE_REJECT_ST_PRO_ICACHE_CPU_ATTR(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_REJECT_ST.Reg, volatile.LoadUint32(&o.PRO_ICACHE_REJECT_ST.Reg)&^(0x38)|value<<3)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_REJECT_ST_PRO_ICACHE_CPU_ATTR() uint32 {
	return (volatile.LoadUint32(&o.PRO_ICACHE_REJECT_ST.Reg) & 0x38) >> 3
}

// EXTMEM.PRO_ICACHE_REJECT_VADDR: register description
func (o *EXTMEM_Type) SetPRO_ICACHE_REJECT_VADDR(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_REJECT_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetPRO_ICACHE_REJECT_VADDR() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_REJECT_VADDR.Reg)
}

// EXTMEM.PRO_CACHE_MMU_FAULT_CONTENT: register description
func (o *EXTMEM_Type) SetPRO_CACHE_MMU_FAULT_CONTENT(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_MMU_FAULT_CONTENT.Reg, volatile.LoadUint32(&o.PRO_CACHE_MMU_FAULT_CONTENT.Reg)&^(0x1ffff)|value)
}
func (o *EXTMEM_Type) GetPRO_CACHE_MMU_FAULT_CONTENT() uint32 {
	return volatile.LoadUint32(&o.PRO_CACHE_MMU_FAULT_CONTENT.Reg) & 0x1ffff
}
func (o *EXTMEM_Type) SetPRO_CACHE_MMU_FAULT_CONTENT_PRO_CACHE_MMU_FAULT_CODE(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_MMU_FAULT_CONTENT.Reg, volatile.LoadUint32(&o.PRO_CACHE_MMU_FAULT_CONTENT.Reg)&^(0xe0000)|value<<17)
}
func (o *EXTMEM_Type) GetPRO_CACHE_MMU_FAULT_CONTENT_PRO_CACHE_MMU_FAULT_CODE() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_MMU_FAULT_CONTENT.Reg) & 0xe0000) >> 17
}

// EXTMEM.PRO_CACHE_MMU_FAULT_VADDR: register description
func (o *EXTMEM_Type) SetPRO_CACHE_MMU_FAULT_VADDR(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_MMU_FAULT_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetPRO_CACHE_MMU_FAULT_VADDR() uint32 {
	return volatile.LoadUint32(&o.PRO_CACHE_MMU_FAULT_VADDR.Reg)
}

// EXTMEM.PRO_CACHE_WRAP_AROUND_CTRL: register description
func (o *EXTMEM_Type) SetPRO_CACHE_WRAP_AROUND_CTRL_PRO_CACHE_FLASH_WRAP_AROUND(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_WRAP_AROUND_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetPRO_CACHE_WRAP_AROUND_CTRL_PRO_CACHE_FLASH_WRAP_AROUND() uint32 {
	return volatile.LoadUint32(&o.PRO_CACHE_WRAP_AROUND_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetPRO_CACHE_WRAP_AROUND_CTRL_PRO_CACHE_SRAM_RD_WRAP_AROUND(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_WRAP_AROUND_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetPRO_CACHE_WRAP_AROUND_CTRL_PRO_CACHE_SRAM_RD_WRAP_AROUND() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_WRAP_AROUND_CTRL.Reg) & 0x2) >> 1
}

// EXTMEM.PRO_CACHE_MMU_POWER_CTRL: register description
func (o *EXTMEM_Type) SetPRO_CACHE_MMU_POWER_CTRL_PRO_CACHE_MMU_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_MMU_POWER_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_MMU_POWER_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetPRO_CACHE_MMU_POWER_CTRL_PRO_CACHE_MMU_MEM_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.PRO_CACHE_MMU_POWER_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetPRO_CACHE_MMU_POWER_CTRL_PRO_CACHE_MMU_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_MMU_POWER_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_MMU_POWER_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetPRO_CACHE_MMU_POWER_CTRL_PRO_CACHE_MMU_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_MMU_POWER_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetPRO_CACHE_MMU_POWER_CTRL_PRO_CACHE_MMU_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_MMU_POWER_CTRL.Reg, volatile.LoadUint32(&o.PRO_CACHE_MMU_POWER_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetPRO_CACHE_MMU_POWER_CTRL_PRO_CACHE_MMU_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_MMU_POWER_CTRL.Reg) & 0x4) >> 2
}

// EXTMEM.PRO_CACHE_STATE: register description
func (o *EXTMEM_Type) SetPRO_CACHE_STATE_PRO_ICACHE_STATE(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_STATE.Reg, volatile.LoadUint32(&o.PRO_CACHE_STATE.Reg)&^(0xfff)|value)
}
func (o *EXTMEM_Type) GetPRO_CACHE_STATE_PRO_ICACHE_STATE() uint32 {
	return volatile.LoadUint32(&o.PRO_CACHE_STATE.Reg) & 0xfff
}
func (o *EXTMEM_Type) SetPRO_CACHE_STATE_PRO_DCACHE_STATE(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_STATE.Reg, volatile.LoadUint32(&o.PRO_CACHE_STATE.Reg)&^(0xfff000)|value<<12)
}
func (o *EXTMEM_Type) GetPRO_CACHE_STATE_PRO_DCACHE_STATE() uint32 {
	return (volatile.LoadUint32(&o.PRO_CACHE_STATE.Reg) & 0xfff000) >> 12
}

// EXTMEM.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE: register description
func (o *EXTMEM_Type) SetCACHE_ENCRYPT_DECRYPT_RECORD_DISABLE_RECORD_DISABLE_DB_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg, volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_ENCRYPT_DECRYPT_RECORD_DISABLE_RECORD_DISABLE_DB_ENCRYPT() uint32 {
	return volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_ENCRYPT_DECRYPT_RECORD_DISABLE_RECORD_DISABLE_G0CB_DECRYPT(value uint32) {
	volatile.StoreUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg, volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_ENCRYPT_DECRYPT_RECORD_DISABLE_RECORD_DISABLE_G0CB_DECRYPT() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_RECORD_DISABLE.Reg) & 0x2) >> 1
}

// EXTMEM.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON: register description
func (o *EXTMEM_Type) SetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_DB_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg, volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_DB_ENCRYPT() uint32 {
	return volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_G0CB_DECRYPT(value uint32) {
	volatile.StoreUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg, volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_G0CB_DECRYPT() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_AUTOMATIC_ENCRYPT_DECRYPT(value uint32) {
	volatile.StoreUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg, volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON_CLK_FORCE_ON_AUTOMATIC_ENCRYPT_DECRYPT() uint32 {
	return (volatile.LoadUint32(&o.CACHE_ENCRYPT_DECRYPT_CLK_FORCE_ON.Reg) & 0x4) >> 2
}

// EXTMEM.CACHE_BRIDGE_ARBITER_CTRL: register description
func (o *EXTMEM_Type) SetCACHE_BRIDGE_ARBITER_CTRL_ALLOC_WB_HOLD_ARBITER(value uint32) {
	volatile.StoreUint32(&o.CACHE_BRIDGE_ARBITER_CTRL.Reg, volatile.LoadUint32(&o.CACHE_BRIDGE_ARBITER_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_BRIDGE_ARBITER_CTRL_ALLOC_WB_HOLD_ARBITER() uint32 {
	return volatile.LoadUint32(&o.CACHE_BRIDGE_ARBITER_CTRL.Reg) & 0x1
}

// EXTMEM.CACHE_PRELOAD_INT_CTRL: register description
func (o *EXTMEM_Type) SetCACHE_PRELOAD_INT_CTRL_PRO_ICACHE_PRELOAD_INT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_PRELOAD_INT_CTRL_PRO_ICACHE_PRELOAD_INT_ST() uint32 {
	return volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_PRELOAD_INT_CTRL_PRO_ICACHE_PRELOAD_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_PRELOAD_INT_CTRL_PRO_ICACHE_PRELOAD_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_PRELOAD_INT_CTRL_PRO_ICACHE_PRELOAD_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_PRELOAD_INT_CTRL_PRO_ICACHE_PRELOAD_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCACHE_PRELOAD_INT_CTRL_PRO_DCACHE_PRELOAD_INT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCACHE_PRELOAD_INT_CTRL_PRO_DCACHE_PRELOAD_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCACHE_PRELOAD_INT_CTRL_PRO_DCACHE_PRELOAD_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCACHE_PRELOAD_INT_CTRL_PRO_DCACHE_PRELOAD_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetCACHE_PRELOAD_INT_CTRL_PRO_DCACHE_PRELOAD_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCACHE_PRELOAD_INT_CTRL_PRO_DCACHE_PRELOAD_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_PRELOAD_INT_CTRL.Reg) & 0x20) >> 5
}

// EXTMEM.CACHE_SYNC_INT_CTRL: register description
func (o *EXTMEM_Type) SetCACHE_SYNC_INT_CTRL_PRO_ICACHE_SYNC_INT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_INT_CTRL_PRO_ICACHE_SYNC_INT_ST() uint32 {
	return volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_SYNC_INT_CTRL_PRO_ICACHE_SYNC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_INT_CTRL_PRO_ICACHE_SYNC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_SYNC_INT_CTRL_PRO_ICACHE_SYNC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_INT_CTRL_PRO_ICACHE_SYNC_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCACHE_SYNC_INT_CTRL_PRO_DCACHE_SYNC_INT_ST(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_INT_CTRL_PRO_DCACHE_SYNC_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCACHE_SYNC_INT_CTRL_PRO_DCACHE_SYNC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_INT_CTRL_PRO_DCACHE_SYNC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetCACHE_SYNC_INT_CTRL_PRO_DCACHE_SYNC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_INT_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_INT_CTRL_PRO_DCACHE_SYNC_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_INT_CTRL.Reg) & 0x20) >> 5
}

// EXTMEM.CACHE_CONF_MISC: register description
func (o *EXTMEM_Type) SetCACHE_CONF_MISC_PRO_CACHE_IGNORE_PRELOAD_MMU_ENTRY_FAULT(value uint32) {
	volatile.StoreUint32(&o.CACHE_CONF_MISC.Reg, volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_CONF_MISC_PRO_CACHE_IGNORE_PRELOAD_MMU_ENTRY_FAULT() uint32 {
	return volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_CONF_MISC_PRO_CACHE_IGNORE_SYNC_MMU_ENTRY_FAULT(value uint32) {
	volatile.StoreUint32(&o.CACHE_CONF_MISC.Reg, volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_CONF_MISC_PRO_CACHE_IGNORE_SYNC_MMU_ENTRY_FAULT() uint32 {
	return (volatile.LoadUint32(&o.CACHE_CONF_MISC.Reg) & 0x2) >> 1
}

// EXTMEM.CLOCK_GATE: register description
func (o *EXTMEM_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// EXTMEM.PRO_EXTMEM_REG_DATE: register description
func (o *EXTMEM_Type) SetPRO_EXTMEM_REG_DATE(value uint32) {
	volatile.StoreUint32(&o.PRO_EXTMEM_REG_DATE.Reg, volatile.LoadUint32(&o.PRO_EXTMEM_REG_DATE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetPRO_EXTMEM_REG_DATE() uint32 {
	return volatile.LoadUint32(&o.PRO_EXTMEM_REG_DATE.Reg) & 0xfffffff
}

// General Purpose Input/Output
type GPIO_Type struct {
	BT_SELECT          volatile.Register32 // 0x0
	OUT                volatile.Register32 // 0x4
	OUT_W1TS           volatile.Register32 // 0x8
	OUT_W1TC           volatile.Register32 // 0xC
	OUT1               volatile.Register32 // 0x10
	OUT1_W1TS          volatile.Register32 // 0x14
	OUT1_W1TC          volatile.Register32 // 0x18
	SDIO_SELECT        volatile.Register32 // 0x1C
	ENABLE             volatile.Register32 // 0x20
	ENABLE_W1TS        volatile.Register32 // 0x24
	ENABLE_W1TC        volatile.Register32 // 0x28
	ENABLE1            volatile.Register32 // 0x2C
	ENABLE1_W1TS       volatile.Register32 // 0x30
	ENABLE1_W1TC       volatile.Register32 // 0x34
	STRAP              volatile.Register32 // 0x38
	IN                 volatile.Register32 // 0x3C
	IN1                volatile.Register32 // 0x40
	STATUS             volatile.Register32 // 0x44
	STATUS_W1TS        volatile.Register32 // 0x48
	STATUS_W1TC        volatile.Register32 // 0x4C
	STATUS1            volatile.Register32 // 0x50
	STATUS1_W1TS       volatile.Register32 // 0x54
	STATUS1_W1TC       volatile.Register32 // 0x58
	PCPU_INT           volatile.Register32 // 0x5C
	PCPU_NMI_INT       volatile.Register32 // 0x60
	CPUSDIO_INT        volatile.Register32 // 0x64
	PCPU_INT1          volatile.Register32 // 0x68
	PCPU_NMI_INT1      volatile.Register32 // 0x6C
	CPUSDIO_INT1       volatile.Register32 // 0x70
	PIN0               volatile.Register32 // 0x74
	PIN1               volatile.Register32 // 0x78
	PIN2               volatile.Register32 // 0x7C
	PIN3               volatile.Register32 // 0x80
	PIN4               volatile.Register32 // 0x84
	PIN5               volatile.Register32 // 0x88
	PIN6               volatile.Register32 // 0x8C
	PIN7               volatile.Register32 // 0x90
	PIN8               volatile.Register32 // 0x94
	PIN9               volatile.Register32 // 0x98
	PIN10              volatile.Register32 // 0x9C
	PIN11              volatile.Register32 // 0xA0
	PIN12              volatile.Register32 // 0xA4
	PIN13              volatile.Register32 // 0xA8
	PIN14              volatile.Register32 // 0xAC
	PIN15              volatile.Register32 // 0xB0
	PIN16              volatile.Register32 // 0xB4
	PIN17              volatile.Register32 // 0xB8
	PIN18              volatile.Register32 // 0xBC
	PIN19              volatile.Register32 // 0xC0
	PIN20              volatile.Register32 // 0xC4
	PIN21              volatile.Register32 // 0xC8
	PIN22              volatile.Register32 // 0xCC
	PIN23              volatile.Register32 // 0xD0
	PIN24              volatile.Register32 // 0xD4
	PIN25              volatile.Register32 // 0xD8
	PIN26              volatile.Register32 // 0xDC
	PIN27              volatile.Register32 // 0xE0
	PIN28              volatile.Register32 // 0xE4
	PIN29              volatile.Register32 // 0xE8
	PIN30              volatile.Register32 // 0xEC
	PIN31              volatile.Register32 // 0xF0
	PIN32              volatile.Register32 // 0xF4
	PIN33              volatile.Register32 // 0xF8
	PIN34              volatile.Register32 // 0xFC
	PIN35              volatile.Register32 // 0x100
	PIN36              volatile.Register32 // 0x104
	PIN37              volatile.Register32 // 0x108
	PIN38              volatile.Register32 // 0x10C
	PIN39              volatile.Register32 // 0x110
	PIN40              volatile.Register32 // 0x114
	PIN41              volatile.Register32 // 0x118
	PIN42              volatile.Register32 // 0x11C
	PIN43              volatile.Register32 // 0x120
	PIN44              volatile.Register32 // 0x124
	PIN45              volatile.Register32 // 0x128
	PIN46              volatile.Register32 // 0x12C
	PIN47              volatile.Register32 // 0x130
	PIN48              volatile.Register32 // 0x134
	PIN49              volatile.Register32 // 0x138
	PIN50              volatile.Register32 // 0x13C
	PIN51              volatile.Register32 // 0x140
	PIN52              volatile.Register32 // 0x144
	PIN53              volatile.Register32 // 0x148
	STATUS_NEXT        volatile.Register32 // 0x14C
	STATUS_NEXT1       volatile.Register32 // 0x150
	FUNC0_IN_SEL_CFG   volatile.Register32 // 0x154
	FUNC1_IN_SEL_CFG   volatile.Register32 // 0x158
	FUNC2_IN_SEL_CFG   volatile.Register32 // 0x15C
	FUNC3_IN_SEL_CFG   volatile.Register32 // 0x160
	FUNC4_IN_SEL_CFG   volatile.Register32 // 0x164
	FUNC5_IN_SEL_CFG   volatile.Register32 // 0x168
	FUNC6_IN_SEL_CFG   volatile.Register32 // 0x16C
	FUNC7_IN_SEL_CFG   volatile.Register32 // 0x170
	FUNC8_IN_SEL_CFG   volatile.Register32 // 0x174
	FUNC9_IN_SEL_CFG   volatile.Register32 // 0x178
	FUNC10_IN_SEL_CFG  volatile.Register32 // 0x17C
	FUNC11_IN_SEL_CFG  volatile.Register32 // 0x180
	FUNC12_IN_SEL_CFG  volatile.Register32 // 0x184
	FUNC13_IN_SEL_CFG  volatile.Register32 // 0x188
	FUNC14_IN_SEL_CFG  volatile.Register32 // 0x18C
	FUNC15_IN_SEL_CFG  volatile.Register32 // 0x190
	FUNC16_IN_SEL_CFG  volatile.Register32 // 0x194
	FUNC17_IN_SEL_CFG  volatile.Register32 // 0x198
	FUNC18_IN_SEL_CFG  volatile.Register32 // 0x19C
	FUNC19_IN_SEL_CFG  volatile.Register32 // 0x1A0
	FUNC20_IN_SEL_CFG  volatile.Register32 // 0x1A4
	FUNC21_IN_SEL_CFG  volatile.Register32 // 0x1A8
	FUNC22_IN_SEL_CFG  volatile.Register32 // 0x1AC
	FUNC23_IN_SEL_CFG  volatile.Register32 // 0x1B0
	FUNC24_IN_SEL_CFG  volatile.Register32 // 0x1B4
	FUNC25_IN_SEL_CFG  volatile.Register32 // 0x1B8
	FUNC26_IN_SEL_CFG  volatile.Register32 // 0x1BC
	FUNC27_IN_SEL_CFG  volatile.Register32 // 0x1C0
	FUNC28_IN_SEL_CFG  volatile.Register32 // 0x1C4
	FUNC29_IN_SEL_CFG  volatile.Register32 // 0x1C8
	FUNC30_IN_SEL_CFG  volatile.Register32 // 0x1CC
	FUNC31_IN_SEL_CFG  volatile.Register32 // 0x1D0
	FUNC32_IN_SEL_CFG  volatile.Register32 // 0x1D4
	FUNC33_IN_SEL_CFG  volatile.Register32 // 0x1D8
	FUNC34_IN_SEL_CFG  volatile.Register32 // 0x1DC
	FUNC35_IN_SEL_CFG  volatile.Register32 // 0x1E0
	FUNC36_IN_SEL_CFG  volatile.Register32 // 0x1E4
	FUNC37_IN_SEL_CFG  volatile.Register32 // 0x1E8
	FUNC38_IN_SEL_CFG  volatile.Register32 // 0x1EC
	FUNC39_IN_SEL_CFG  volatile.Register32 // 0x1F0
	FUNC40_IN_SEL_CFG  volatile.Register32 // 0x1F4
	FUNC41_IN_SEL_CFG  volatile.Register32 // 0x1F8
	FUNC42_IN_SEL_CFG  volatile.Register32 // 0x1FC
	FUNC43_IN_SEL_CFG  volatile.Register32 // 0x200
	FUNC44_IN_SEL_CFG  volatile.Register32 // 0x204
	FUNC45_IN_SEL_CFG  volatile.Register32 // 0x208
	FUNC46_IN_SEL_CFG  volatile.Register32 // 0x20C
	FUNC47_IN_SEL_CFG  volatile.Register32 // 0x210
	FUNC48_IN_SEL_CFG  volatile.Register32 // 0x214
	FUNC49_IN_SEL_CFG  volatile.Register32 // 0x218
	FUNC50_IN_SEL_CFG  volatile.Register32 // 0x21C
	FUNC51_IN_SEL_CFG  volatile.Register32 // 0x220
	FUNC52_IN_SEL_CFG  volatile.Register32 // 0x224
	FUNC53_IN_SEL_CFG  volatile.Register32 // 0x228
	FUNC54_IN_SEL_CFG  volatile.Register32 // 0x22C
	FUNC55_IN_SEL_CFG  volatile.Register32 // 0x230
	FUNC56_IN_SEL_CFG  volatile.Register32 // 0x234
	FUNC57_IN_SEL_CFG  volatile.Register32 // 0x238
	FUNC58_IN_SEL_CFG  volatile.Register32 // 0x23C
	FUNC59_IN_SEL_CFG  volatile.Register32 // 0x240
	FUNC60_IN_SEL_CFG  volatile.Register32 // 0x244
	FUNC61_IN_SEL_CFG  volatile.Register32 // 0x248
	FUNC62_IN_SEL_CFG  volatile.Register32 // 0x24C
	FUNC63_IN_SEL_CFG  volatile.Register32 // 0x250
	FUNC64_IN_SEL_CFG  volatile.Register32 // 0x254
	FUNC65_IN_SEL_CFG  volatile.Register32 // 0x258
	FUNC66_IN_SEL_CFG  volatile.Register32 // 0x25C
	FUNC67_IN_SEL_CFG  volatile.Register32 // 0x260
	FUNC68_IN_SEL_CFG  volatile.Register32 // 0x264
	FUNC69_IN_SEL_CFG  volatile.Register32 // 0x268
	FUNC70_IN_SEL_CFG  volatile.Register32 // 0x26C
	FUNC71_IN_SEL_CFG  volatile.Register32 // 0x270
	FUNC72_IN_SEL_CFG  volatile.Register32 // 0x274
	FUNC73_IN_SEL_CFG  volatile.Register32 // 0x278
	FUNC74_IN_SEL_CFG  volatile.Register32 // 0x27C
	FUNC75_IN_SEL_CFG  volatile.Register32 // 0x280
	FUNC76_IN_SEL_CFG  volatile.Register32 // 0x284
	FUNC77_IN_SEL_CFG  volatile.Register32 // 0x288
	FUNC78_IN_SEL_CFG  volatile.Register32 // 0x28C
	FUNC79_IN_SEL_CFG  volatile.Register32 // 0x290
	FUNC80_IN_SEL_CFG  volatile.Register32 // 0x294
	FUNC81_IN_SEL_CFG  volatile.Register32 // 0x298
	FUNC82_IN_SEL_CFG  volatile.Register32 // 0x29C
	FUNC83_IN_SEL_CFG  volatile.Register32 // 0x2A0
	FUNC84_IN_SEL_CFG  volatile.Register32 // 0x2A4
	FUNC85_IN_SEL_CFG  volatile.Register32 // 0x2A8
	FUNC86_IN_SEL_CFG  volatile.Register32 // 0x2AC
	FUNC87_IN_SEL_CFG  volatile.Register32 // 0x2B0
	FUNC88_IN_SEL_CFG  volatile.Register32 // 0x2B4
	FUNC89_IN_SEL_CFG  volatile.Register32 // 0x2B8
	FUNC90_IN_SEL_CFG  volatile.Register32 // 0x2BC
	FUNC91_IN_SEL_CFG  volatile.Register32 // 0x2C0
	FUNC92_IN_SEL_CFG  volatile.Register32 // 0x2C4
	FUNC93_IN_SEL_CFG  volatile.Register32 // 0x2C8
	FUNC94_IN_SEL_CFG  volatile.Register32 // 0x2CC
	FUNC95_IN_SEL_CFG  volatile.Register32 // 0x2D0
	FUNC96_IN_SEL_CFG  volatile.Register32 // 0x2D4
	FUNC97_IN_SEL_CFG  volatile.Register32 // 0x2D8
	FUNC98_IN_SEL_CFG  volatile.Register32 // 0x2DC
	FUNC99_IN_SEL_CFG  volatile.Register32 // 0x2E0
	FUNC100_IN_SEL_CFG volatile.Register32 // 0x2E4
	FUNC101_IN_SEL_CFG volatile.Register32 // 0x2E8
	FUNC102_IN_SEL_CFG volatile.Register32 // 0x2EC
	FUNC103_IN_SEL_CFG volatile.Register32 // 0x2F0
	FUNC104_IN_SEL_CFG volatile.Register32 // 0x2F4
	FUNC105_IN_SEL_CFG volatile.Register32 // 0x2F8
	FUNC106_IN_SEL_CFG volatile.Register32 // 0x2FC
	FUNC107_IN_SEL_CFG volatile.Register32 // 0x300
	FUNC108_IN_SEL_CFG volatile.Register32 // 0x304
	FUNC109_IN_SEL_CFG volatile.Register32 // 0x308
	FUNC110_IN_SEL_CFG volatile.Register32 // 0x30C
	FUNC111_IN_SEL_CFG volatile.Register32 // 0x310
	FUNC112_IN_SEL_CFG volatile.Register32 // 0x314
	FUNC113_IN_SEL_CFG volatile.Register32 // 0x318
	FUNC114_IN_SEL_CFG volatile.Register32 // 0x31C
	FUNC115_IN_SEL_CFG volatile.Register32 // 0x320
	FUNC116_IN_SEL_CFG volatile.Register32 // 0x324
	FUNC117_IN_SEL_CFG volatile.Register32 // 0x328
	FUNC118_IN_SEL_CFG volatile.Register32 // 0x32C
	FUNC119_IN_SEL_CFG volatile.Register32 // 0x330
	FUNC120_IN_SEL_CFG volatile.Register32 // 0x334
	FUNC121_IN_SEL_CFG volatile.Register32 // 0x338
	FUNC122_IN_SEL_CFG volatile.Register32 // 0x33C
	FUNC123_IN_SEL_CFG volatile.Register32 // 0x340
	FUNC124_IN_SEL_CFG volatile.Register32 // 0x344
	FUNC125_IN_SEL_CFG volatile.Register32 // 0x348
	FUNC126_IN_SEL_CFG volatile.Register32 // 0x34C
	FUNC127_IN_SEL_CFG volatile.Register32 // 0x350
	FUNC128_IN_SEL_CFG volatile.Register32 // 0x354
	FUNC129_IN_SEL_CFG volatile.Register32 // 0x358
	FUNC130_IN_SEL_CFG volatile.Register32 // 0x35C
	FUNC131_IN_SEL_CFG volatile.Register32 // 0x360
	FUNC132_IN_SEL_CFG volatile.Register32 // 0x364
	FUNC133_IN_SEL_CFG volatile.Register32 // 0x368
	FUNC134_IN_SEL_CFG volatile.Register32 // 0x36C
	FUNC135_IN_SEL_CFG volatile.Register32 // 0x370
	FUNC136_IN_SEL_CFG volatile.Register32 // 0x374
	FUNC137_IN_SEL_CFG volatile.Register32 // 0x378
	FUNC138_IN_SEL_CFG volatile.Register32 // 0x37C
	FUNC139_IN_SEL_CFG volatile.Register32 // 0x380
	FUNC140_IN_SEL_CFG volatile.Register32 // 0x384
	FUNC141_IN_SEL_CFG volatile.Register32 // 0x388
	FUNC142_IN_SEL_CFG volatile.Register32 // 0x38C
	FUNC143_IN_SEL_CFG volatile.Register32 // 0x390
	FUNC144_IN_SEL_CFG volatile.Register32 // 0x394
	FUNC145_IN_SEL_CFG volatile.Register32 // 0x398
	FUNC146_IN_SEL_CFG volatile.Register32 // 0x39C
	FUNC147_IN_SEL_CFG volatile.Register32 // 0x3A0
	FUNC148_IN_SEL_CFG volatile.Register32 // 0x3A4
	FUNC149_IN_SEL_CFG volatile.Register32 // 0x3A8
	FUNC150_IN_SEL_CFG volatile.Register32 // 0x3AC
	FUNC151_IN_SEL_CFG volatile.Register32 // 0x3B0
	FUNC152_IN_SEL_CFG volatile.Register32 // 0x3B4
	FUNC153_IN_SEL_CFG volatile.Register32 // 0x3B8
	FUNC154_IN_SEL_CFG volatile.Register32 // 0x3BC
	FUNC155_IN_SEL_CFG volatile.Register32 // 0x3C0
	FUNC156_IN_SEL_CFG volatile.Register32 // 0x3C4
	FUNC157_IN_SEL_CFG volatile.Register32 // 0x3C8
	FUNC158_IN_SEL_CFG volatile.Register32 // 0x3CC
	FUNC159_IN_SEL_CFG volatile.Register32 // 0x3D0
	FUNC160_IN_SEL_CFG volatile.Register32 // 0x3D4
	FUNC161_IN_SEL_CFG volatile.Register32 // 0x3D8
	FUNC162_IN_SEL_CFG volatile.Register32 // 0x3DC
	FUNC163_IN_SEL_CFG volatile.Register32 // 0x3E0
	FUNC164_IN_SEL_CFG volatile.Register32 // 0x3E4
	FUNC165_IN_SEL_CFG volatile.Register32 // 0x3E8
	FUNC166_IN_SEL_CFG volatile.Register32 // 0x3EC
	FUNC167_IN_SEL_CFG volatile.Register32 // 0x3F0
	FUNC168_IN_SEL_CFG volatile.Register32 // 0x3F4
	FUNC169_IN_SEL_CFG volatile.Register32 // 0x3F8
	FUNC170_IN_SEL_CFG volatile.Register32 // 0x3FC
	FUNC171_IN_SEL_CFG volatile.Register32 // 0x400
	FUNC172_IN_SEL_CFG volatile.Register32 // 0x404
	FUNC173_IN_SEL_CFG volatile.Register32 // 0x408
	FUNC174_IN_SEL_CFG volatile.Register32 // 0x40C
	FUNC175_IN_SEL_CFG volatile.Register32 // 0x410
	FUNC176_IN_SEL_CFG volatile.Register32 // 0x414
	FUNC177_IN_SEL_CFG volatile.Register32 // 0x418
	FUNC178_IN_SEL_CFG volatile.Register32 // 0x41C
	FUNC179_IN_SEL_CFG volatile.Register32 // 0x420
	FUNC180_IN_SEL_CFG volatile.Register32 // 0x424
	FUNC181_IN_SEL_CFG volatile.Register32 // 0x428
	FUNC182_IN_SEL_CFG volatile.Register32 // 0x42C
	FUNC183_IN_SEL_CFG volatile.Register32 // 0x430
	FUNC184_IN_SEL_CFG volatile.Register32 // 0x434
	FUNC185_IN_SEL_CFG volatile.Register32 // 0x438
	FUNC186_IN_SEL_CFG volatile.Register32 // 0x43C
	FUNC187_IN_SEL_CFG volatile.Register32 // 0x440
	FUNC188_IN_SEL_CFG volatile.Register32 // 0x444
	FUNC189_IN_SEL_CFG volatile.Register32 // 0x448
	FUNC190_IN_SEL_CFG volatile.Register32 // 0x44C
	FUNC191_IN_SEL_CFG volatile.Register32 // 0x450
	FUNC192_IN_SEL_CFG volatile.Register32 // 0x454
	FUNC193_IN_SEL_CFG volatile.Register32 // 0x458
	FUNC194_IN_SEL_CFG volatile.Register32 // 0x45C
	FUNC195_IN_SEL_CFG volatile.Register32 // 0x460
	FUNC196_IN_SEL_CFG volatile.Register32 // 0x464
	FUNC197_IN_SEL_CFG volatile.Register32 // 0x468
	FUNC198_IN_SEL_CFG volatile.Register32 // 0x46C
	FUNC199_IN_SEL_CFG volatile.Register32 // 0x470
	FUNC200_IN_SEL_CFG volatile.Register32 // 0x474
	FUNC201_IN_SEL_CFG volatile.Register32 // 0x478
	FUNC202_IN_SEL_CFG volatile.Register32 // 0x47C
	FUNC203_IN_SEL_CFG volatile.Register32 // 0x480
	FUNC204_IN_SEL_CFG volatile.Register32 // 0x484
	FUNC205_IN_SEL_CFG volatile.Register32 // 0x488
	FUNC206_IN_SEL_CFG volatile.Register32 // 0x48C
	FUNC207_IN_SEL_CFG volatile.Register32 // 0x490
	FUNC208_IN_SEL_CFG volatile.Register32 // 0x494
	FUNC209_IN_SEL_CFG volatile.Register32 // 0x498
	FUNC210_IN_SEL_CFG volatile.Register32 // 0x49C
	FUNC211_IN_SEL_CFG volatile.Register32 // 0x4A0
	FUNC212_IN_SEL_CFG volatile.Register32 // 0x4A4
	FUNC213_IN_SEL_CFG volatile.Register32 // 0x4A8
	FUNC214_IN_SEL_CFG volatile.Register32 // 0x4AC
	FUNC215_IN_SEL_CFG volatile.Register32 // 0x4B0
	FUNC216_IN_SEL_CFG volatile.Register32 // 0x4B4
	FUNC217_IN_SEL_CFG volatile.Register32 // 0x4B8
	FUNC218_IN_SEL_CFG volatile.Register32 // 0x4BC
	FUNC219_IN_SEL_CFG volatile.Register32 // 0x4C0
	FUNC220_IN_SEL_CFG volatile.Register32 // 0x4C4
	FUNC221_IN_SEL_CFG volatile.Register32 // 0x4C8
	FUNC222_IN_SEL_CFG volatile.Register32 // 0x4CC
	FUNC223_IN_SEL_CFG volatile.Register32 // 0x4D0
	FUNC224_IN_SEL_CFG volatile.Register32 // 0x4D4
	FUNC225_IN_SEL_CFG volatile.Register32 // 0x4D8
	FUNC226_IN_SEL_CFG volatile.Register32 // 0x4DC
	FUNC227_IN_SEL_CFG volatile.Register32 // 0x4E0
	FUNC228_IN_SEL_CFG volatile.Register32 // 0x4E4
	FUNC229_IN_SEL_CFG volatile.Register32 // 0x4E8
	FUNC230_IN_SEL_CFG volatile.Register32 // 0x4EC
	FUNC231_IN_SEL_CFG volatile.Register32 // 0x4F0
	FUNC232_IN_SEL_CFG volatile.Register32 // 0x4F4
	FUNC233_IN_SEL_CFG volatile.Register32 // 0x4F8
	FUNC234_IN_SEL_CFG volatile.Register32 // 0x4FC
	FUNC235_IN_SEL_CFG volatile.Register32 // 0x500
	FUNC236_IN_SEL_CFG volatile.Register32 // 0x504
	FUNC237_IN_SEL_CFG volatile.Register32 // 0x508
	FUNC238_IN_SEL_CFG volatile.Register32 // 0x50C
	FUNC239_IN_SEL_CFG volatile.Register32 // 0x510
	FUNC240_IN_SEL_CFG volatile.Register32 // 0x514
	FUNC241_IN_SEL_CFG volatile.Register32 // 0x518
	FUNC242_IN_SEL_CFG volatile.Register32 // 0x51C
	FUNC243_IN_SEL_CFG volatile.Register32 // 0x520
	FUNC244_IN_SEL_CFG volatile.Register32 // 0x524
	FUNC245_IN_SEL_CFG volatile.Register32 // 0x528
	FUNC246_IN_SEL_CFG volatile.Register32 // 0x52C
	FUNC247_IN_SEL_CFG volatile.Register32 // 0x530
	FUNC248_IN_SEL_CFG volatile.Register32 // 0x534
	FUNC249_IN_SEL_CFG volatile.Register32 // 0x538
	FUNC250_IN_SEL_CFG volatile.Register32 // 0x53C
	FUNC251_IN_SEL_CFG volatile.Register32 // 0x540
	FUNC252_IN_SEL_CFG volatile.Register32 // 0x544
	FUNC253_IN_SEL_CFG volatile.Register32 // 0x548
	FUNC254_IN_SEL_CFG volatile.Register32 // 0x54C
	FUNC255_IN_SEL_CFG volatile.Register32 // 0x550
	FUNC0_OUT_SEL_CFG  volatile.Register32 // 0x554
	FUNC1_OUT_SEL_CFG  volatile.Register32 // 0x558
	FUNC2_OUT_SEL_CFG  volatile.Register32 // 0x55C
	FUNC3_OUT_SEL_CFG  volatile.Register32 // 0x560
	FUNC4_OUT_SEL_CFG  volatile.Register32 // 0x564
	FUNC5_OUT_SEL_CFG  volatile.Register32 // 0x568
	FUNC6_OUT_SEL_CFG  volatile.Register32 // 0x56C
	FUNC7_OUT_SEL_CFG  volatile.Register32 // 0x570
	FUNC8_OUT_SEL_CFG  volatile.Register32 // 0x574
	FUNC9_OUT_SEL_CFG  volatile.Register32 // 0x578
	FUNC10_OUT_SEL_CFG volatile.Register32 // 0x57C
	FUNC11_OUT_SEL_CFG volatile.Register32 // 0x580
	FUNC12_OUT_SEL_CFG volatile.Register32 // 0x584
	FUNC13_OUT_SEL_CFG volatile.Register32 // 0x588
	FUNC14_OUT_SEL_CFG volatile.Register32 // 0x58C
	FUNC15_OUT_SEL_CFG volatile.Register32 // 0x590
	FUNC16_OUT_SEL_CFG volatile.Register32 // 0x594
	FUNC17_OUT_SEL_CFG volatile.Register32 // 0x598
	FUNC18_OUT_SEL_CFG volatile.Register32 // 0x59C
	FUNC19_OUT_SEL_CFG volatile.Register32 // 0x5A0
	FUNC20_OUT_SEL_CFG volatile.Register32 // 0x5A4
	FUNC21_OUT_SEL_CFG volatile.Register32 // 0x5A8
	FUNC22_OUT_SEL_CFG volatile.Register32 // 0x5AC
	FUNC23_OUT_SEL_CFG volatile.Register32 // 0x5B0
	FUNC24_OUT_SEL_CFG volatile.Register32 // 0x5B4
	FUNC25_OUT_SEL_CFG volatile.Register32 // 0x5B8
	FUNC26_OUT_SEL_CFG volatile.Register32 // 0x5BC
	FUNC27_OUT_SEL_CFG volatile.Register32 // 0x5C0
	FUNC28_OUT_SEL_CFG volatile.Register32 // 0x5C4
	FUNC29_OUT_SEL_CFG volatile.Register32 // 0x5C8
	FUNC30_OUT_SEL_CFG volatile.Register32 // 0x5CC
	FUNC31_OUT_SEL_CFG volatile.Register32 // 0x5D0
	FUNC32_OUT_SEL_CFG volatile.Register32 // 0x5D4
	FUNC33_OUT_SEL_CFG volatile.Register32 // 0x5D8
	FUNC34_OUT_SEL_CFG volatile.Register32 // 0x5DC
	FUNC35_OUT_SEL_CFG volatile.Register32 // 0x5E0
	FUNC36_OUT_SEL_CFG volatile.Register32 // 0x5E4
	FUNC37_OUT_SEL_CFG volatile.Register32 // 0x5E8
	FUNC38_OUT_SEL_CFG volatile.Register32 // 0x5EC
	FUNC39_OUT_SEL_CFG volatile.Register32 // 0x5F0
	FUNC40_OUT_SEL_CFG volatile.Register32 // 0x5F4
	FUNC41_OUT_SEL_CFG volatile.Register32 // 0x5F8
	FUNC42_OUT_SEL_CFG volatile.Register32 // 0x5FC
	FUNC43_OUT_SEL_CFG volatile.Register32 // 0x600
	FUNC44_OUT_SEL_CFG volatile.Register32 // 0x604
	FUNC45_OUT_SEL_CFG volatile.Register32 // 0x608
	FUNC46_OUT_SEL_CFG volatile.Register32 // 0x60C
	FUNC47_OUT_SEL_CFG volatile.Register32 // 0x610
	FUNC48_OUT_SEL_CFG volatile.Register32 // 0x614
	FUNC49_OUT_SEL_CFG volatile.Register32 // 0x618
	FUNC50_OUT_SEL_CFG volatile.Register32 // 0x61C
	FUNC51_OUT_SEL_CFG volatile.Register32 // 0x620
	FUNC52_OUT_SEL_CFG volatile.Register32 // 0x624
	FUNC53_OUT_SEL_CFG volatile.Register32 // 0x628
	CLOCK_GATE         volatile.Register32 // 0x62C
	_                  [204]byte
	REG_DATE           volatile.Register32 // 0x6FC
}

// GPIO.BT_SELECT: GPIO bit select register
func (o *GPIO_Type) SetBT_SELECT(value uint32) {
	volatile.StoreUint32(&o.BT_SELECT.Reg, value)
}
func (o *GPIO_Type) GetBT_SELECT() uint32 {
	return volatile.LoadUint32(&o.BT_SELECT.Reg)
}

// GPIO.OUT: GPIO0 ~ 31 output register
func (o *GPIO_Type) SetOUT(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, value)
}
func (o *GPIO_Type) GetOUT() uint32 {
	return volatile.LoadUint32(&o.OUT.Reg)
}

// GPIO.OUT_W1TS: GPIO0 ~ 31 output bit set register
func (o *GPIO_Type) SetOUT_W1TS(value uint32) {
	volatile.StoreUint32(&o.OUT_W1TS.Reg, value)
}
func (o *GPIO_Type) GetOUT_W1TS() uint32 {
	return volatile.LoadUint32(&o.OUT_W1TS.Reg)
}

// GPIO.OUT_W1TC: GPIO0 ~ 31 output bit clear register
func (o *GPIO_Type) SetOUT_W1TC(value uint32) {
	volatile.StoreUint32(&o.OUT_W1TC.Reg, value)
}
func (o *GPIO_Type) GetOUT_W1TC() uint32 {
	return volatile.LoadUint32(&o.OUT_W1TC.Reg)
}

// GPIO.OUT1: GPIO32 ~ 53 output register
func (o *GPIO_Type) SetOUT1_DATA_ORIG(value uint32) {
	volatile.StoreUint32(&o.OUT1.Reg, volatile.LoadUint32(&o.OUT1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetOUT1_DATA_ORIG() uint32 {
	return volatile.LoadUint32(&o.OUT1.Reg) & 0x3fffff
}

// GPIO.OUT1_W1TS: GPIO32 ~ 53 output bit set register
func (o *GPIO_Type) SetOUT1_W1TS(value uint32) {
	volatile.StoreUint32(&o.OUT1_W1TS.Reg, volatile.LoadUint32(&o.OUT1_W1TS.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetOUT1_W1TS() uint32 {
	return volatile.LoadUint32(&o.OUT1_W1TS.Reg) & 0x3fffff
}

// GPIO.OUT1_W1TC: GPIO32 ~ 53 output bit clear register
func (o *GPIO_Type) SetOUT1_W1TC(value uint32) {
	volatile.StoreUint32(&o.OUT1_W1TC.Reg, volatile.LoadUint32(&o.OUT1_W1TC.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetOUT1_W1TC() uint32 {
	return volatile.LoadUint32(&o.OUT1_W1TC.Reg) & 0x3fffff
}

// GPIO.SDIO_SELECT: GPIO SDIO selection register
func (o *GPIO_Type) SetSDIO_SELECT_SDIO_SEL(value uint32) {
	volatile.StoreUint32(&o.SDIO_SELECT.Reg, volatile.LoadUint32(&o.SDIO_SELECT.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetSDIO_SELECT_SDIO_SEL() uint32 {
	return volatile.LoadUint32(&o.SDIO_SELECT.Reg) & 0xff
}

// GPIO.ENABLE: GPIO0 ~ 31 output enable register
func (o *GPIO_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, value)
}
func (o *GPIO_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg)
}

// GPIO.ENABLE_W1TS: GPIO0 ~ 31 output enable bit set register
func (o *GPIO_Type) SetENABLE_W1TS(value uint32) {
	volatile.StoreUint32(&o.ENABLE_W1TS.Reg, value)
}
func (o *GPIO_Type) GetENABLE_W1TS() uint32 {
	return volatile.LoadUint32(&o.ENABLE_W1TS.Reg)
}

// GPIO.ENABLE_W1TC: GPIO0 ~ 31 output enable bit clear register
func (o *GPIO_Type) SetENABLE_W1TC(value uint32) {
	volatile.StoreUint32(&o.ENABLE_W1TC.Reg, value)
}
func (o *GPIO_Type) GetENABLE_W1TC() uint32 {
	return volatile.LoadUint32(&o.ENABLE_W1TC.Reg)
}

// GPIO.ENABLE1: GPIO32 ~ 53 output enable register
func (o *GPIO_Type) SetENABLE1_DATA(value uint32) {
	volatile.StoreUint32(&o.ENABLE1.Reg, volatile.LoadUint32(&o.ENABLE1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetENABLE1_DATA() uint32 {
	return volatile.LoadUint32(&o.ENABLE1.Reg) & 0x3fffff
}

// GPIO.ENABLE1_W1TS: GPIO32 ~ 53 output enable bit set register
func (o *GPIO_Type) SetENABLE1_W1TS(value uint32) {
	volatile.StoreUint32(&o.ENABLE1_W1TS.Reg, volatile.LoadUint32(&o.ENABLE1_W1TS.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetENABLE1_W1TS() uint32 {
	return volatile.LoadUint32(&o.ENABLE1_W1TS.Reg) & 0x3fffff
}

// GPIO.ENABLE1_W1TC: GPIO32 ~ 53 output enable bit clear register
func (o *GPIO_Type) SetENABLE1_W1TC(value uint32) {
	volatile.StoreUint32(&o.ENABLE1_W1TC.Reg, volatile.LoadUint32(&o.ENABLE1_W1TC.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetENABLE1_W1TC() uint32 {
	return volatile.LoadUint32(&o.ENABLE1_W1TC.Reg) & 0x3fffff
}

// GPIO.STRAP: Bootstrap pin value register
func (o *GPIO_Type) SetSTRAP_STRAPPING(value uint32) {
	volatile.StoreUint32(&o.STRAP.Reg, volatile.LoadUint32(&o.STRAP.Reg)&^(0xffff)|value)
}
func (o *GPIO_Type) GetSTRAP_STRAPPING() uint32 {
	return volatile.LoadUint32(&o.STRAP.Reg) & 0xffff
}

// GPIO.IN: GPIO0 ~ 31 input register
func (o *GPIO_Type) SetIN(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, value)
}
func (o *GPIO_Type) GetIN() uint32 {
	return volatile.LoadUint32(&o.IN.Reg)
}

// GPIO.IN1: GPIO32 ~ 53 input register
func (o *GPIO_Type) SetIN1_IN_DATA1_NEXT(value uint32) {
	volatile.StoreUint32(&o.IN1.Reg, volatile.LoadUint32(&o.IN1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetIN1_IN_DATA1_NEXT() uint32 {
	return volatile.LoadUint32(&o.IN1.Reg) & 0x3fffff
}

// GPIO.STATUS: GPIO0 ~ 31 interrupt status register
func (o *GPIO_Type) SetSTATUS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, value)
}
func (o *GPIO_Type) GetSTATUS() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg)
}

// GPIO.STATUS_W1TS: GPIO0 ~ 31 interrupt status bit set register
func (o *GPIO_Type) SetSTATUS_W1TS(value uint32) {
	volatile.StoreUint32(&o.STATUS_W1TS.Reg, value)
}
func (o *GPIO_Type) GetSTATUS_W1TS() uint32 {
	return volatile.LoadUint32(&o.STATUS_W1TS.Reg)
}

// GPIO.STATUS_W1TC: GPIO0 ~ 31 interrupt status bit clear register
func (o *GPIO_Type) SetSTATUS_W1TC(value uint32) {
	volatile.StoreUint32(&o.STATUS_W1TC.Reg, value)
}
func (o *GPIO_Type) GetSTATUS_W1TC() uint32 {
	return volatile.LoadUint32(&o.STATUS_W1TC.Reg)
}

// GPIO.STATUS1: GPIO32 ~ 53 interrupt status register
func (o *GPIO_Type) SetSTATUS1_INTERRUPT(value uint32) {
	volatile.StoreUint32(&o.STATUS1.Reg, volatile.LoadUint32(&o.STATUS1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetSTATUS1_INTERRUPT() uint32 {
	return volatile.LoadUint32(&o.STATUS1.Reg) & 0x3fffff
}

// GPIO.STATUS1_W1TS: GPIO32 ~ 53 interrupt status bit set register
func (o *GPIO_Type) SetSTATUS1_W1TS(value uint32) {
	volatile.StoreUint32(&o.STATUS1_W1TS.Reg, volatile.LoadUint32(&o.STATUS1_W1TS.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetSTATUS1_W1TS() uint32 {
	return volatile.LoadUint32(&o.STATUS1_W1TS.Reg) & 0x3fffff
}

// GPIO.STATUS1_W1TC: GPIO32 ~ 53 interrupt status bit clear register
func (o *GPIO_Type) SetSTATUS1_W1TC(value uint32) {
	volatile.StoreUint32(&o.STATUS1_W1TC.Reg, volatile.LoadUint32(&o.STATUS1_W1TC.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetSTATUS1_W1TC() uint32 {
	return volatile.LoadUint32(&o.STATUS1_W1TC.Reg) & 0x3fffff
}

// GPIO.PCPU_INT: GPIO0 ~ 31 PRO_CPU interrupt status register
func (o *GPIO_Type) SetPCPU_INT(value uint32) {
	volatile.StoreUint32(&o.PCPU_INT.Reg, value)
}
func (o *GPIO_Type) GetPCPU_INT() uint32 {
	return volatile.LoadUint32(&o.PCPU_INT.Reg)
}

// GPIO.PCPU_NMI_INT: GPIO0 ~ 31 PRO_CPU non-maskable interrupt status register
func (o *GPIO_Type) SetPCPU_NMI_INT(value uint32) {
	volatile.StoreUint32(&o.PCPU_NMI_INT.Reg, value)
}
func (o *GPIO_Type) GetPCPU_NMI_INT() uint32 {
	return volatile.LoadUint32(&o.PCPU_NMI_INT.Reg)
}

// GPIO.CPUSDIO_INT: GPIO0 ~ 31 CPU SDIO interrupt status register
func (o *GPIO_Type) SetCPUSDIO_INT(value uint32) {
	volatile.StoreUint32(&o.CPUSDIO_INT.Reg, value)
}
func (o *GPIO_Type) GetCPUSDIO_INT() uint32 {
	return volatile.LoadUint32(&o.CPUSDIO_INT.Reg)
}

// GPIO.PCPU_INT1: GPIO32 ~ 53 PRO_CPU interrupt status register
func (o *GPIO_Type) SetPCPU_INT1_PROCPU1_INT(value uint32) {
	volatile.StoreUint32(&o.PCPU_INT1.Reg, volatile.LoadUint32(&o.PCPU_INT1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetPCPU_INT1_PROCPU1_INT() uint32 {
	return volatile.LoadUint32(&o.PCPU_INT1.Reg) & 0x3fffff
}

// GPIO.PCPU_NMI_INT1: GPIO32 ~ 53 PRO_CPU non-maskable interrupt status register
func (o *GPIO_Type) SetPCPU_NMI_INT1_PROCPU_NMI1_INT(value uint32) {
	volatile.StoreUint32(&o.PCPU_NMI_INT1.Reg, volatile.LoadUint32(&o.PCPU_NMI_INT1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetPCPU_NMI_INT1_PROCPU_NMI1_INT() uint32 {
	return volatile.LoadUint32(&o.PCPU_NMI_INT1.Reg) & 0x3fffff
}

// GPIO.CPUSDIO_INT1: GPIO32 ~ 53 CPU SDIO interrupt status register
func (o *GPIO_Type) SetCPUSDIO_INT1_SDIO1_INT(value uint32) {
	volatile.StoreUint32(&o.CPUSDIO_INT1.Reg, volatile.LoadUint32(&o.CPUSDIO_INT1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetCPUSDIO_INT1_SDIO1_INT() uint32 {
	return volatile.LoadUint32(&o.CPUSDIO_INT1.Reg) & 0x3fffff
}

// GPIO.PIN0: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN0_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN0_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN0.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN0_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN0_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN0_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN0_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN0_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN0_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN0_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN0_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN0_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN0_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x3e000) >> 13
}

// GPIO.PIN1: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN1_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN1_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN1.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN1_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN1_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN1_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN1_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN1_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN1_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN1_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN1_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN1_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN1_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x3e000) >> 13
}

// GPIO.PIN2: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN2_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN2_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN2.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN2_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN2_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN2_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN2_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN2_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN2_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN2_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN2_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN2_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN2_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x3e000) >> 13
}

// GPIO.PIN3: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN3_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN3_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN3.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN3_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN3_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN3_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN3_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN3_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN3_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN3_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN3_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN3_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN3_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN3_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN3_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x3e000) >> 13
}

// GPIO.PIN4: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN4_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN4_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN4.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN4_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN4_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN4_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN4_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN4_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN4_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN4_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN4_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN4_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN4_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN4_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN4_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x3e000) >> 13
}

// GPIO.PIN5: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN5_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN5_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN5.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN5_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN5_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN5_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN5_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN5_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN5_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN5_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN5_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN5_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN5_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN5_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN5_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x3e000) >> 13
}

// GPIO.PIN6: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN6_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN6_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN6.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN6_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN6_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN6_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN6_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN6_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN6_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN6_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN6_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN6_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN6_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN6_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN6_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x3e000) >> 13
}

// GPIO.PIN7: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN7_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN7_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN7.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN7_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN7_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN7_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN7_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN7_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN7_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN7_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN7_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN7_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN7_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN7_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN7_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x3e000) >> 13
}

// GPIO.PIN8: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN8_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN8_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN8.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN8_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN8_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN8_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN8_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN8_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN8_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN8_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN8_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN8_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN8_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN8_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN8_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x3e000) >> 13
}

// GPIO.PIN9: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN9_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN9_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN9.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN9_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN9_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN9_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN9_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN9_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN9_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN9_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN9_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN9_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN9_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN9_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN9_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x3e000) >> 13
}

// GPIO.PIN10: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN10_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN10_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN10.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN10_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN10_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN10_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN10_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN10_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN10_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN10_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN10_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN10_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN10_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN10_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN10_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x3e000) >> 13
}

// GPIO.PIN11: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN11_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN11_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN11.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN11_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN11_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN11_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN11_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN11_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN11_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN11_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN11_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN11_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN11_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN11_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN11_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x3e000) >> 13
}

// GPIO.PIN12: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN12_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN12_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN12.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN12_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN12_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN12_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN12_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN12_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN12_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN12_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN12_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN12_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN12_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN12_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN12_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x3e000) >> 13
}

// GPIO.PIN13: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN13_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN13_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN13.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN13_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN13_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN13_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN13_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN13_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN13_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN13_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN13_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN13_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN13_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN13_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN13_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x3e000) >> 13
}

// GPIO.PIN14: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN14_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN14_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN14.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN14_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN14_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN14_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN14_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN14_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN14_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN14_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN14_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN14_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN14_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN14_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN14_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x3e000) >> 13
}

// GPIO.PIN15: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN15_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN15_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN15.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN15_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN15_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN15_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN15_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN15_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN15_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN15_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN15_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN15_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN15_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN15_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN15_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x3e000) >> 13
}

// GPIO.PIN16: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN16_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN16_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN16.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN16_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN16_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN16_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN16_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN16_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN16_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN16_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN16_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN16_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN16_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN16_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN16_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x3e000) >> 13
}

// GPIO.PIN17: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN17_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN17_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN17.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN17_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN17_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN17_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN17_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN17_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN17_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN17_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN17_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN17_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN17_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN17_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN17_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x3e000) >> 13
}

// GPIO.PIN18: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN18_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN18_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN18.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN18_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN18_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN18_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN18_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN18_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN18_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN18_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN18_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN18_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN18_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN18_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN18_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x3e000) >> 13
}

// GPIO.PIN19: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN19_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN19_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN19.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN19_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN19_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN19_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN19_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN19_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN19_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN19_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN19_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN19_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN19_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN19_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN19_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x3e000) >> 13
}

// GPIO.PIN20: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN20_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN20_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN20.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN20_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN20_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN20_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN20_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN20_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN20_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN20_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN20_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN20_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN20_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN20_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN20_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x3e000) >> 13
}

// GPIO.PIN21: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN21_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN21_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN21.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN21_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN21_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN21_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN21_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN21_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN21_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN21_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN21_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN21_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN21_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN21_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN21_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x3e000) >> 13
}

// GPIO.PIN22: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN22_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN22_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN22.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN22_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN22_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN22_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN22_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN22_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN22_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN22_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN22_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN22_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN22_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN22_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN22_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x3e000) >> 13
}

// GPIO.PIN23: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN23_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN23_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN23.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN23_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN23_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN23_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN23_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN23_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN23_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN23_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN23_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN23_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN23_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN23_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN23_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x3e000) >> 13
}

// GPIO.PIN24: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN24_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN24_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN24.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN24_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN24_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN24_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN24_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN24_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN24_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN24_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN24_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN24_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN24_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN24_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN24_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x3e000) >> 13
}

// GPIO.PIN25: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN25_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN25_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN25.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN25_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN25_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN25_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN25_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN25_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN25_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN25_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN25_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN25_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN25_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN25_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN25_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x3e000) >> 13
}

// GPIO.PIN26: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN26_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN26_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN26.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN26_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN26_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN26_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN26_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN26_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN26_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN26_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN26_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN26_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN26_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN26_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN26_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x3e000) >> 13
}

// GPIO.PIN27: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN27_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN27_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN27.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN27_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN27_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN27_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN27_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN27_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN27_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN27_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN27_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN27_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN27_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN27_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN27_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x3e000) >> 13
}

// GPIO.PIN28: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN28_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN28_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN28.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN28_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN28_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN28_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN28_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN28_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN28_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN28_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN28_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN28_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN28_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN28_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN28_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x3e000) >> 13
}

// GPIO.PIN29: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN29_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN29_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN29.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN29_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN29_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN29_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN29_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN29_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN29_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN29_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN29_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN29_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN29_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN29_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN29_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x3e000) >> 13
}

// GPIO.PIN30: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN30_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN30_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN30.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN30_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN30_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN30_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN30_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN30_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN30_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN30_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN30_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN30_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN30_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN30_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN30_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x3e000) >> 13
}

// GPIO.PIN31: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN31_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN31_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN31.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN31_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN31_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN31_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN31_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN31_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN31_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN31_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN31_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN31_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN31_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN31_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN31_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x3e000) >> 13
}

// GPIO.PIN32: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN32_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN32_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN32.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN32_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN32_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN32_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN32_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN32_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN32_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN32_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN32_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN32_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN32_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN32_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN32_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x3e000) >> 13
}

// GPIO.PIN33: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN33_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN33_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN33.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN33_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN33_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN33_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN33_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN33_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN33_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN33_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN33_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN33_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN33_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN33_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN33_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x3e000) >> 13
}

// GPIO.PIN34: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN34_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN34_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN34.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN34_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN34_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN34_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN34_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN34_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN34_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN34_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN34_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN34_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN34_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN34_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN34_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x3e000) >> 13
}

// GPIO.PIN35: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN35_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN35_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN35.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN35_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN35_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN35_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN35_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN35_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN35_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN35_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN35_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN35_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN35_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN35_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN35.Reg, volatile.LoadUint32(&o.PIN35.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN35_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN35.Reg) & 0x3e000) >> 13
}

// GPIO.PIN36: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN36_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN36_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN36.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN36_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN36_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN36_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN36_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN36_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN36_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN36_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN36_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN36_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN36_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN36_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN36.Reg, volatile.LoadUint32(&o.PIN36.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN36_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN36.Reg) & 0x3e000) >> 13
}

// GPIO.PIN37: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN37_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN37_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN37.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN37_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN37_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN37_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN37_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN37_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN37_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN37_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN37_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN37_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN37_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN37_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN37.Reg, volatile.LoadUint32(&o.PIN37.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN37_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN37.Reg) & 0x3e000) >> 13
}

// GPIO.PIN38: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN38_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN38_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN38.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN38_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN38_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN38_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN38_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN38_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN38_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN38_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN38_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN38_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN38_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN38_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN38.Reg, volatile.LoadUint32(&o.PIN38.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN38_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN38.Reg) & 0x3e000) >> 13
}

// GPIO.PIN39: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN39_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN39_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN39.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN39_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN39_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN39_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN39_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN39_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN39_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN39_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN39_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN39_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN39_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN39_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN39.Reg, volatile.LoadUint32(&o.PIN39.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN39_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN39.Reg) & 0x3e000) >> 13
}

// GPIO.PIN40: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN40_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN40.Reg, volatile.LoadUint32(&o.PIN40.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN40_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN40.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN40_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN40.Reg, volatile.LoadUint32(&o.PIN40.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN40_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN40.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN40_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN40.Reg, volatile.LoadUint32(&o.PIN40.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN40_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN40.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN40_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN40.Reg, volatile.LoadUint32(&o.PIN40.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN40_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN40.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN40_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN40.Reg, volatile.LoadUint32(&o.PIN40.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN40_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN40.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN40_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN40.Reg, volatile.LoadUint32(&o.PIN40.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN40_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN40.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN40_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN40.Reg, volatile.LoadUint32(&o.PIN40.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN40_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN40.Reg) & 0x3e000) >> 13
}

// GPIO.PIN41: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN41_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN41.Reg, volatile.LoadUint32(&o.PIN41.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN41_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN41.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN41_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN41.Reg, volatile.LoadUint32(&o.PIN41.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN41_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN41.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN41_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN41.Reg, volatile.LoadUint32(&o.PIN41.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN41_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN41.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN41_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN41.Reg, volatile.LoadUint32(&o.PIN41.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN41_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN41.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN41_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN41.Reg, volatile.LoadUint32(&o.PIN41.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN41_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN41.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN41_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN41.Reg, volatile.LoadUint32(&o.PIN41.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN41_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN41.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN41_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN41.Reg, volatile.LoadUint32(&o.PIN41.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN41_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN41.Reg) & 0x3e000) >> 13
}

// GPIO.PIN42: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN42_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN42.Reg, volatile.LoadUint32(&o.PIN42.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN42_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN42.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN42_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN42.Reg, volatile.LoadUint32(&o.PIN42.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN42_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN42.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN42_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN42.Reg, volatile.LoadUint32(&o.PIN42.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN42_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN42.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN42_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN42.Reg, volatile.LoadUint32(&o.PIN42.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN42_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN42.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN42_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN42.Reg, volatile.LoadUint32(&o.PIN42.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN42_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN42.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN42_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN42.Reg, volatile.LoadUint32(&o.PIN42.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN42_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN42.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN42_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN42.Reg, volatile.LoadUint32(&o.PIN42.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN42_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN42.Reg) & 0x3e000) >> 13
}

// GPIO.PIN43: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN43_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN43.Reg, volatile.LoadUint32(&o.PIN43.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN43_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN43.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN43_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN43.Reg, volatile.LoadUint32(&o.PIN43.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN43_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN43.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN43_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN43.Reg, volatile.LoadUint32(&o.PIN43.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN43_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN43.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN43_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN43.Reg, volatile.LoadUint32(&o.PIN43.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN43_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN43.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN43_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN43.Reg, volatile.LoadUint32(&o.PIN43.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN43_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN43.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN43_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN43.Reg, volatile.LoadUint32(&o.PIN43.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN43_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN43.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN43_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN43.Reg, volatile.LoadUint32(&o.PIN43.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN43_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN43.Reg) & 0x3e000) >> 13
}

// GPIO.PIN44: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN44_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN44.Reg, volatile.LoadUint32(&o.PIN44.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN44_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN44.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN44_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN44.Reg, volatile.LoadUint32(&o.PIN44.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN44_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN44.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN44_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN44.Reg, volatile.LoadUint32(&o.PIN44.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN44_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN44.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN44_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN44.Reg, volatile.LoadUint32(&o.PIN44.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN44_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN44.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN44_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN44.Reg, volatile.LoadUint32(&o.PIN44.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN44_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN44.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN44_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN44.Reg, volatile.LoadUint32(&o.PIN44.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN44_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN44.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN44_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN44.Reg, volatile.LoadUint32(&o.PIN44.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN44_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN44.Reg) & 0x3e000) >> 13
}

// GPIO.PIN45: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN45_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN45.Reg, volatile.LoadUint32(&o.PIN45.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN45_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN45.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN45_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN45.Reg, volatile.LoadUint32(&o.PIN45.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN45_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN45.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN45_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN45.Reg, volatile.LoadUint32(&o.PIN45.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN45_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN45.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN45_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN45.Reg, volatile.LoadUint32(&o.PIN45.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN45_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN45.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN45_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN45.Reg, volatile.LoadUint32(&o.PIN45.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN45_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN45.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN45_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN45.Reg, volatile.LoadUint32(&o.PIN45.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN45_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN45.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN45_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN45.Reg, volatile.LoadUint32(&o.PIN45.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN45_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN45.Reg) & 0x3e000) >> 13
}

// GPIO.PIN46: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN46_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN46.Reg, volatile.LoadUint32(&o.PIN46.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN46_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN46.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN46_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN46.Reg, volatile.LoadUint32(&o.PIN46.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN46_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN46.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN46_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN46.Reg, volatile.LoadUint32(&o.PIN46.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN46_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN46.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN46_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN46.Reg, volatile.LoadUint32(&o.PIN46.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN46_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN46.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN46_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN46.Reg, volatile.LoadUint32(&o.PIN46.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN46_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN46.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN46_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN46.Reg, volatile.LoadUint32(&o.PIN46.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN46_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN46.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN46_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN46.Reg, volatile.LoadUint32(&o.PIN46.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN46_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN46.Reg) & 0x3e000) >> 13
}

// GPIO.PIN47: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN47_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN47.Reg, volatile.LoadUint32(&o.PIN47.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN47_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN47.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN47_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN47.Reg, volatile.LoadUint32(&o.PIN47.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN47_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN47.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN47_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN47.Reg, volatile.LoadUint32(&o.PIN47.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN47_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN47.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN47_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN47.Reg, volatile.LoadUint32(&o.PIN47.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN47_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN47.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN47_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN47.Reg, volatile.LoadUint32(&o.PIN47.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN47_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN47.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN47_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN47.Reg, volatile.LoadUint32(&o.PIN47.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN47_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN47.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN47_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN47.Reg, volatile.LoadUint32(&o.PIN47.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN47_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN47.Reg) & 0x3e000) >> 13
}

// GPIO.PIN48: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN48_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN48.Reg, volatile.LoadUint32(&o.PIN48.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN48_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN48.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN48_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN48.Reg, volatile.LoadUint32(&o.PIN48.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN48_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN48.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN48_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN48.Reg, volatile.LoadUint32(&o.PIN48.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN48_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN48.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN48_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN48.Reg, volatile.LoadUint32(&o.PIN48.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN48_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN48.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN48_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN48.Reg, volatile.LoadUint32(&o.PIN48.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN48_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN48.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN48_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN48.Reg, volatile.LoadUint32(&o.PIN48.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN48_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN48.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN48_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN48.Reg, volatile.LoadUint32(&o.PIN48.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN48_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN48.Reg) & 0x3e000) >> 13
}

// GPIO.PIN49: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN49_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN49.Reg, volatile.LoadUint32(&o.PIN49.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN49_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN49.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN49_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN49.Reg, volatile.LoadUint32(&o.PIN49.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN49_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN49.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN49_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN49.Reg, volatile.LoadUint32(&o.PIN49.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN49_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN49.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN49_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN49.Reg, volatile.LoadUint32(&o.PIN49.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN49_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN49.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN49_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN49.Reg, volatile.LoadUint32(&o.PIN49.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN49_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN49.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN49_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN49.Reg, volatile.LoadUint32(&o.PIN49.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN49_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN49.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN49_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN49.Reg, volatile.LoadUint32(&o.PIN49.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN49_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN49.Reg) & 0x3e000) >> 13
}

// GPIO.PIN50: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN50_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN50.Reg, volatile.LoadUint32(&o.PIN50.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN50_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN50.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN50_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN50.Reg, volatile.LoadUint32(&o.PIN50.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN50_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN50.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN50_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN50.Reg, volatile.LoadUint32(&o.PIN50.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN50_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN50.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN50_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN50.Reg, volatile.LoadUint32(&o.PIN50.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN50_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN50.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN50_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN50.Reg, volatile.LoadUint32(&o.PIN50.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN50_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN50.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN50_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN50.Reg, volatile.LoadUint32(&o.PIN50.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN50_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN50.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN50_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN50.Reg, volatile.LoadUint32(&o.PIN50.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN50_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN50.Reg) & 0x3e000) >> 13
}

// GPIO.PIN51: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN51_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN51.Reg, volatile.LoadUint32(&o.PIN51.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN51_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN51.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN51_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN51.Reg, volatile.LoadUint32(&o.PIN51.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN51_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN51.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN51_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN51.Reg, volatile.LoadUint32(&o.PIN51.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN51_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN51.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN51_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN51.Reg, volatile.LoadUint32(&o.PIN51.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN51_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN51.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN51_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN51.Reg, volatile.LoadUint32(&o.PIN51.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN51_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN51.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN51_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN51.Reg, volatile.LoadUint32(&o.PIN51.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN51_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN51.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN51_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN51.Reg, volatile.LoadUint32(&o.PIN51.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN51_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN51.Reg) & 0x3e000) >> 13
}

// GPIO.PIN52: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN52_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN52.Reg, volatile.LoadUint32(&o.PIN52.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN52_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN52.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN52_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN52.Reg, volatile.LoadUint32(&o.PIN52.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN52_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN52.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN52_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN52.Reg, volatile.LoadUint32(&o.PIN52.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN52_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN52.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN52_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN52.Reg, volatile.LoadUint32(&o.PIN52.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN52_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN52.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN52_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN52.Reg, volatile.LoadUint32(&o.PIN52.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN52_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN52.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN52_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN52.Reg, volatile.LoadUint32(&o.PIN52.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN52_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN52.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN52_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN52.Reg, volatile.LoadUint32(&o.PIN52.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN52_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN52.Reg) & 0x3e000) >> 13
}

// GPIO.PIN53: Configuration for GPIO pin %s
func (o *GPIO_Type) SetPIN53_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN53.Reg, volatile.LoadUint32(&o.PIN53.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN53_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN53.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN53_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN53.Reg, volatile.LoadUint32(&o.PIN53.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN53_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN53.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN53_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN53.Reg, volatile.LoadUint32(&o.PIN53.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN53_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN53.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN53_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN53.Reg, volatile.LoadUint32(&o.PIN53.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN53_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN53.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN53_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN53.Reg, volatile.LoadUint32(&o.PIN53.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN53_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN53.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN53_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN53.Reg, volatile.LoadUint32(&o.PIN53.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN53_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN53.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN53_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN53.Reg, volatile.LoadUint32(&o.PIN53.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN53_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN53.Reg) & 0x3e000) >> 13
}

// GPIO.STATUS_NEXT: GPIO0 ~ 31 interrupt source register
func (o *GPIO_Type) SetSTATUS_NEXT(value uint32) {
	volatile.StoreUint32(&o.STATUS_NEXT.Reg, value)
}
func (o *GPIO_Type) GetSTATUS_NEXT() uint32 {
	return volatile.LoadUint32(&o.STATUS_NEXT.Reg)
}

// GPIO.STATUS_NEXT1: GPIO32 ~ 53 interrupt source register
func (o *GPIO_Type) SetSTATUS_NEXT1_STATUS1_INTERRUPT_NEXT(value uint32) {
	volatile.StoreUint32(&o.STATUS_NEXT1.Reg, volatile.LoadUint32(&o.STATUS_NEXT1.Reg)&^(0x3fffff)|value)
}
func (o *GPIO_Type) GetSTATUS_NEXT1_STATUS1_INTERRUPT_NEXT() uint32 {
	return volatile.LoadUint32(&o.STATUS_NEXT1.Reg) & 0x3fffff
}

// GPIO.FUNC0_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC1_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC2_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC3_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC4_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC5_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC6_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC7_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC8_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC9_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC10_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC11_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC12_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC13_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC14_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC15_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC16_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC17_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC18_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC19_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC20_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC21_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC22_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC23_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC24_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC25_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC26_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC27_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC28_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC29_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC30_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC31_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC32_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC33_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC34_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC35_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC36_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC37_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC38_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC39_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC40_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC41_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC42_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC43_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC44_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC45_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC46_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC47_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC48_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC49_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC50_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC51_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC52_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC53_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC54_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC55_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC56_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC57_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC58_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC59_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC60_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC61_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC62_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC63_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC64_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC65_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC66_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC67_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC68_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC69_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC70_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC71_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC72_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC73_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC74_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC75_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC76_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC77_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC78_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC79_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC80_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC81_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC82_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC83_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC84_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC85_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC86_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC87_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC88_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC89_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC90_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC91_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC92_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC93_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC94_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC95_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC96_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC97_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC98_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC99_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC100_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC101_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC102_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC103_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC104_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC105_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC106_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC107_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC108_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC109_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC110_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC111_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC112_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC113_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC114_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC115_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC116_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC117_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC118_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC119_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC120_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC121_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC122_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC123_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC124_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC125_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC126_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC127_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC128_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC128_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC128_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC128_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC128_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC128_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC128_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC128_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC128_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC128_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC128_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC129_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC129_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC129_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC129_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC129_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC129_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC129_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC129_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC129_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC129_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC129_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC130_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC130_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC130_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC130_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC130_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC130_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC130_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC130_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC130_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC130_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC130_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC131_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC131_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC131_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC131_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC131_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC131_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC131_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC131_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC131_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC131_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC131_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC132_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC132_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC132_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC132_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC132_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC132_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC132_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC132_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC132_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC132_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC132_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC133_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC133_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC133_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC133_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC133_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC133_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC133_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC133_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC133_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC133_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC133_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC134_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC134_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC134_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC134_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC134_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC134_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC134_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC134_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC134_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC134_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC134_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC135_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC135_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC135_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC135_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC135_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC135_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC135_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC135_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC135_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC135_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC135_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC136_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC136_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC136_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC136_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC136_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC136_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC136_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC136_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC136_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC136_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC136_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC137_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC137_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC137_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC137_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC137_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC137_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC137_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC137_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC137_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC137_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC137_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC138_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC138_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC138_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC138_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC138_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC138_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC138_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC138_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC138_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC138_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC138_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC139_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC139_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC139_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC139_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC139_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC139_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC139_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC139_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC139_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC139_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC139_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC140_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC140_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC140_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC140_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC140_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC140_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC140_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC140_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC140_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC140_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC140_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC141_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC141_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC141_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC141_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC141_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC141_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC141_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC141_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC141_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC141_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC141_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC142_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC142_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC142_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC142_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC142_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC142_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC142_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC142_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC142_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC142_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC142_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC143_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC143_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC143_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC143_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC143_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC143_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC143_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC143_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC143_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC143_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC143_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC144_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC144_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC144_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC144_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC144_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC144_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC144_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC144_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC144_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC144_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC144_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC145_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC145_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC145_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC145_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC145_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC145_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC145_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC145_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC145_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC145_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC145_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC146_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC146_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC146_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC146_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC146_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC146_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC146_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC146_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC146_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC146_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC146_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC147_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC147_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC147_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC147_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC147_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC147_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC147_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC147_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC147_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC147_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC147_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC148_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC148_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC148_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC148_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC148_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC148_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC148_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC148_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC148_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC148_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC148_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC149_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC149_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC149_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC149_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC149_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC149_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC149_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC149_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC149_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC149_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC149_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC150_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC150_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC150_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC150_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC150_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC150_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC150_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC150_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC150_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC150_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC150_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC151_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC151_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC151_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC151_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC151_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC151_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC151_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC151_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC151_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC151_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC151_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC152_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC152_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC152_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC152_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC152_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC152_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC152_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC152_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC152_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC152_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC152_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC153_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC153_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC153_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC153_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC153_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC153_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC153_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC153_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC153_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC153_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC153_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC154_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC154_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC154_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC154_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC154_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC154_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC154_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC154_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC154_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC154_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC154_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC155_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC155_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC155_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC155_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC155_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC155_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC155_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC155_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC155_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC155_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC155_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC156_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC156_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC156_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC156_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC156_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC156_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC156_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC156_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC156_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC156_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC156_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC157_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC157_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC157_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC157_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC157_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC157_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC157_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC157_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC157_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC157_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC157_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC158_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC158_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC158_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC158_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC158_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC158_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC158_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC158_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC158_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC158_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC158_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC159_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC159_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC159_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC159_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC159_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC159_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC159_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC159_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC159_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC159_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC159_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC160_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC160_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC160_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC160_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC160_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC160_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC160_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC160_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC160_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC160_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC160_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC161_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC161_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC161_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC161_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC161_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC161_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC161_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC161_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC161_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC161_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC161_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC162_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC162_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC162_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC162_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC162_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC162_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC162_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC162_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC162_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC162_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC162_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC163_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC163_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC163_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC163_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC163_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC163_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC163_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC163_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC163_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC163_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC163_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC164_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC164_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC164_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC164_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC164_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC164_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC164_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC164_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC164_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC164_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC164_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC165_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC165_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC165_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC165_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC165_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC165_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC165_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC165_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC165_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC165_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC165_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC166_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC166_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC166_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC166_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC166_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC166_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC166_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC166_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC166_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC166_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC166_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC167_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC167_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC167_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC167_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC167_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC167_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC167_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC167_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC167_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC167_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC167_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC168_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC168_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC168_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC168_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC168_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC168_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC168_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC168_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC168_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC168_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC168_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC169_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC169_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC169_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC169_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC169_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC169_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC169_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC169_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC169_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC169_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC169_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC170_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC170_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC170_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC170_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC170_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC170_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC170_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC170_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC170_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC170_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC170_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC171_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC171_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC171_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC171_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC171_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC171_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC171_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC171_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC171_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC171_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC171_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC172_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC172_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC172_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC172_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC172_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC172_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC172_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC172_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC172_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC172_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC172_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC173_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC173_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC173_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC173_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC173_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC173_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC173_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC173_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC173_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC173_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC173_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC174_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC174_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC174_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC174_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC174_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC174_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC174_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC174_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC174_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC174_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC174_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC175_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC175_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC175_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC175_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC175_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC175_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC175_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC175_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC175_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC175_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC175_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC176_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC176_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC176_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC176_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC176_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC176_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC176_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC176_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC176_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC176_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC176_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC177_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC177_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC177_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC177_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC177_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC177_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC177_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC177_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC177_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC177_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC177_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC178_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC178_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC178_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC178_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC178_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC178_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC178_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC178_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC178_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC178_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC178_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC179_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC179_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC179_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC179_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC179_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC179_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC179_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC179_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC179_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC179_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC179_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC180_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC180_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC180_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC180_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC180_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC180_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC180_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC180_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC180_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC180_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC180_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC181_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC181_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC181_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC181_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC181_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC181_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC181_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC181_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC181_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC181_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC181_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC182_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC182_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC182_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC182_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC182_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC182_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC182_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC182_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC182_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC182_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC182_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC183_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC183_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC183_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC183_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC183_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC183_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC183_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC183_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC183_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC183_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC183_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC184_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC184_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC184_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC184_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC184_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC184_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC184_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC184_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC184_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC184_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC184_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC185_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC185_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC185_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC185_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC185_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC185_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC185_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC185_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC185_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC185_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC185_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC186_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC186_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC186_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC186_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC186_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC186_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC186_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC186_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC186_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC186_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC186_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC187_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC187_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC187_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC187_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC187_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC187_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC187_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC187_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC187_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC187_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC187_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC188_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC188_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC188_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC188_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC188_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC188_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC188_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC188_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC188_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC188_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC188_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC189_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC189_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC189_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC189_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC189_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC189_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC189_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC189_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC189_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC189_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC189_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC190_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC190_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC190_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC190_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC190_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC190_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC190_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC190_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC190_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC190_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC190_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC191_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC191_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC191_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC191_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC191_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC191_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC191_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC191_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC191_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC191_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC191_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC192_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC192_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC192_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC192_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC192_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC192_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC192_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC192_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC192_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC192_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC192_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC193_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC193_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC193_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC193_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC193_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC193_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC193_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC193_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC193_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC193_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC193_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC194_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC194_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC194_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC194_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC194_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC194_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC194_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC194_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC194_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC194_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC194_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC195_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC195_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC195_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC195_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC195_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC195_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC195_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC195_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC195_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC195_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC195_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC196_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC196_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC196_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC196_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC196_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC196_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC196_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC196_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC196_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC196_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC196_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC197_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC197_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC197_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC197_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC197_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC197_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC197_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC197_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC197_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC197_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC197_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC198_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC198_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC198_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC198_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC198_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC198_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC198_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC198_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC198_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC198_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC198_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC199_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC199_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC199_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC199_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC199_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC199_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC199_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC199_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC199_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC199_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC199_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC200_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC200_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC200_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC200_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC200_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC200_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC200_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC200_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC200_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC200_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC200_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC201_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC201_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC201_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC201_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC201_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC201_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC201_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC201_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC201_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC201_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC201_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC202_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC202_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC202_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC202_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC202_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC202_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC202_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC202_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC202_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC202_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC202_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC203_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC203_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC203_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC203_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC203_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC203_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC203_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC203_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC203_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC203_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC203_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC204_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC204_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC204_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC204_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC204_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC204_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC204_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC204_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC204_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC204_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC204_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC205_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC205_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC205_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC205_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC205_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC205_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC205_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC205_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC205_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC205_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC205_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC206_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC206_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC206_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC206_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC206_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC206_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC206_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC206_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC206_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC206_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC206_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC207_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC207_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC207_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC207_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC207_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC207_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC207_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC207_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC207_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC207_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC207_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC208_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC208_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC208_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC208_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC208_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC208_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC208_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC208_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC208_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC208_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC208_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC209_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC209_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC209_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC209_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC209_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC209_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC209_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC209_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC209_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC209_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC209_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC210_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC210_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC210_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC210_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC210_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC210_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC210_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC210_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC210_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC210_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC210_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC211_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC211_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC211_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC211_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC211_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC211_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC211_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC211_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC211_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC211_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC211_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC212_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC212_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC212_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC212_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC212_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC212_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC212_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC212_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC212_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC212_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC212_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC213_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC213_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC213_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC213_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC213_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC213_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC213_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC213_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC213_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC213_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC213_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC214_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC214_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC214_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC214_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC214_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC214_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC214_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC214_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC214_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC214_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC214_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC215_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC215_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC215_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC215_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC215_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC215_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC215_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC215_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC215_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC215_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC215_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC216_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC216_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC216_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC216_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC216_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC216_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC216_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC216_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC216_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC216_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC216_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC217_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC217_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC217_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC217_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC217_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC217_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC217_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC217_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC217_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC217_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC217_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC218_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC218_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC218_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC218_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC218_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC218_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC218_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC218_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC218_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC218_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC218_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC219_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC219_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC219_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC219_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC219_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC219_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC219_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC219_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC219_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC219_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC219_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC220_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC220_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC220_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC220_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC220_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC220_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC220_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC220_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC220_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC220_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC220_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC221_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC221_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC221_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC221_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC221_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC221_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC221_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC221_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC221_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC221_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC221_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC222_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC222_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC222_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC222_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC222_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC222_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC222_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC222_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC222_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC222_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC222_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC223_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC223_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC223_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC223_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC223_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC223_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC223_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC223_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC223_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC223_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC223_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC224_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC224_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC224_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC224_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC224_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC224_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC224_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC224_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC224_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC224_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC224_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC225_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC225_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC225_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC225_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC225_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC225_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC225_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC225_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC225_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC225_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC225_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC226_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC226_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC226_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC226_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC226_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC226_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC226_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC226_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC226_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC226_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC226_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC227_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC227_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC227_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC227_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC227_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC227_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC227_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC227_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC227_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC227_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC227_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC228_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC228_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC228_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC228_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC228_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC228_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC228_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC228_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC228_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC228_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC228_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC229_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC229_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC229_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC229_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC229_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC229_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC229_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC229_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC229_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC229_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC229_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC230_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC230_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC230_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC230_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC230_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC230_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC230_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC230_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC230_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC230_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC230_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC231_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC231_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC231_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC231_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC231_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC231_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC231_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC231_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC231_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC231_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC231_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC232_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC232_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC232_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC232_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC232_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC232_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC232_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC232_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC232_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC232_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC232_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC233_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC233_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC233_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC233_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC233_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC233_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC233_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC233_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC233_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC233_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC233_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC234_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC234_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC234_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC234_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC234_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC234_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC234_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC234_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC234_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC234_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC234_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC235_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC235_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC235_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC235_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC235_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC235_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC235_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC235_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC235_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC235_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC235_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC236_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC236_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC236_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC236_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC236_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC236_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC236_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC236_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC236_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC236_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC236_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC237_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC237_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC237_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC237_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC237_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC237_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC237_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC237_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC237_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC237_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC237_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC238_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC238_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC238_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC238_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC238_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC238_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC238_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC238_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC238_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC238_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC238_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC239_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC239_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC239_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC239_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC239_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC239_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC239_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC239_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC239_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC239_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC239_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC240_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC240_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC240_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC240_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC240_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC240_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC240_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC240_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC240_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC240_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC240_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC241_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC241_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC241_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC241_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC241_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC241_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC241_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC241_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC241_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC241_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC241_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC242_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC242_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC242_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC242_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC242_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC242_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC242_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC242_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC242_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC242_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC242_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC243_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC243_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC243_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC243_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC243_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC243_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC243_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC243_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC243_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC243_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC243_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC244_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC244_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC244_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC244_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC244_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC244_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC244_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC244_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC244_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC244_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC244_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC245_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC245_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC245_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC245_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC245_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC245_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC245_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC245_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC245_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC245_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC245_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC246_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC246_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC246_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC246_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC246_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC246_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC246_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC246_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC246_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC246_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC246_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC247_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC247_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC247_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC247_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC247_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC247_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC247_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC247_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC247_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC247_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC247_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC248_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC248_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC248_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC248_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC248_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC248_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC248_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC248_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC248_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC248_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC248_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC249_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC249_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC249_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC249_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC249_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC249_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC249_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC249_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC249_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC249_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC249_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC250_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC250_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC250_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC250_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC250_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC250_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC250_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC250_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC250_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC250_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC250_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC251_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC251_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC251_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC251_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC251_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC251_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC251_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC251_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC251_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC251_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC251_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC252_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC252_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC252_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC252_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC252_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC252_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC252_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC252_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC252_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC252_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC252_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC253_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC253_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC253_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC253_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC253_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC253_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC253_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC253_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC253_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC253_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC253_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC254_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC254_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC254_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC254_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC254_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC254_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC254_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC254_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC254_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC254_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC254_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC255_IN_SEL_CFG: Peripheral function %s input selection register
func (o *GPIO_Type) SetFUNC255_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC255_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC255_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC255_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC255_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC255_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC255_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC255_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC255_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC255_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC0_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC1_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC2_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC3_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC4_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC5_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC6_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC7_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC8_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC9_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC10_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC11_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC12_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC13_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC14_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC15_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC16_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC17_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC18_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC19_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC20_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC21_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC22_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC23_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC24_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC25_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC26_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC26_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC26_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC26_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC26_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC26_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC26_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC26_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC26_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC27_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC27_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC27_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC27_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC27_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC27_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC27_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC27_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC27_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC28_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC28_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC28_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC28_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC28_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC28_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC28_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC28_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC28_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC29_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC29_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC29_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC29_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC29_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC29_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC29_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC29_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC29_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC30_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC30_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC30_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC30_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC30_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC30_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC30_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC30_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC30_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC31_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC31_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC31_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC31_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC31_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC31_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC31_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC31_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC31_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC32_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC32_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC32_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC32_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC32_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC32_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC32_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC32_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC32_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC33_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC33_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC33_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC33_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC33_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC33_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC33_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC33_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC33_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC34_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC34_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC34_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC34_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC34_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC34_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC34_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC34_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC34_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC35_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC35_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC35_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC35_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC35_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC35_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC35_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC35_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC35_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC36_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC36_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC36_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC36_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC36_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC36_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC36_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC36_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC36_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC37_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC37_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC37_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC37_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC37_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC37_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC37_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC37_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC37_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC38_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC38_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC38_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC38_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC38_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC38_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC38_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC38_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC38_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC39_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC39_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC39_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC39_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC39_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC39_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC39_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC39_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC39_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC40_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC40_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC40_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC40_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC40_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC40_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC40_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC40_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC40_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC40_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC40_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC40_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC40_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC41_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC41_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC41_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC41_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC41_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC41_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC41_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC41_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC41_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC41_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC41_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC41_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC41_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC42_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC42_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC42_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC42_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC42_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC42_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC42_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC42_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC42_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC42_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC42_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC42_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC42_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC43_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC43_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC43_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC43_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC43_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC43_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC43_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC43_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC43_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC43_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC43_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC43_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC43_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC44_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC44_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC44_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC44_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC44_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC44_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC44_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC44_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC44_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC44_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC44_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC44_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC44_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC45_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC45_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC45_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC45_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC45_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC45_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC45_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC45_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC45_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC45_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC45_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC45_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC45_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC46_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC46_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC46_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC46_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC46_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC46_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC46_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC46_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC46_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC46_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC46_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC46_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC46_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC47_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC47_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC47_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC47_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC47_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC47_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC47_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC47_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC47_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC47_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC47_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC47_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC47_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC48_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC48_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC48_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC48_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC48_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC48_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC48_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC48_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC48_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC48_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC48_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC48_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC48_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC49_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC49_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC49_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC49_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC49_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC49_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC49_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC49_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC49_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC49_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC49_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC49_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC49_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC50_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC50_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC50_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC50_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC50_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC50_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC50_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC50_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC50_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC50_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC50_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC50_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC50_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC51_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC51_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC51_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC51_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC51_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC51_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC51_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC51_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC51_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC51_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC51_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC51_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC51_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC52_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC52_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC52_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC52_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC52_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC52_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC52_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC52_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC52_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC52_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC52_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC52_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC52_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.FUNC53_OUT_SEL_CFG: Peripheral output selection for GPIO %s
func (o *GPIO_Type) SetFUNC53_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_OUT_SEL_CFG.Reg)&^(0x1ff)|value)
}
func (o *GPIO_Type) GetFUNC53_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC53_OUT_SEL_CFG.Reg) & 0x1ff
}
func (o *GPIO_Type) SetFUNC53_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC53_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC53_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC53_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC53_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC53_OUT_SEL_CFG.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetFUNC53_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_OUT_SEL_CFG.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetFUNC53_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC53_OUT_SEL_CFG.Reg) & 0x800) >> 11
}

// GPIO.CLOCK_GATE: GPIO clock gating register
func (o *GPIO_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// GPIO.REG_DATE: Version control register
func (o *GPIO_Type) SetREG_DATE_DATE(value uint32) {
	volatile.StoreUint32(&o.REG_DATE.Reg, volatile.LoadUint32(&o.REG_DATE.Reg)&^(0xfffffff)|value)
}
func (o *GPIO_Type) GetREG_DATE_DATE() uint32 {
	return volatile.LoadUint32(&o.REG_DATE.Reg) & 0xfffffff
}

// Sigma-Delta Modulation
type GPIOSD_Type struct {
	SIGMADELTA0        volatile.Register32 // 0x0
	SIGMADELTA1        volatile.Register32 // 0x4
	SIGMADELTA2        volatile.Register32 // 0x8
	SIGMADELTA3        volatile.Register32 // 0xC
	SIGMADELTA4        volatile.Register32 // 0x10
	SIGMADELTA5        volatile.Register32 // 0x14
	SIGMADELTA6        volatile.Register32 // 0x18
	SIGMADELTA7        volatile.Register32 // 0x1C
	SIGMADELTA_CG      volatile.Register32 // 0x20
	SIGMADELTA_MISC    volatile.Register32 // 0x24
	SIGMADELTA_VERSION volatile.Register32 // 0x28
}

// GPIOSD.SIGMADELTA0: Duty-cycle configuration register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA0_SD_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA0.Reg, volatile.LoadUint32(&o.SIGMADELTA0.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA0_SD_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA0.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA0_SD_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA0.Reg, volatile.LoadUint32(&o.SIGMADELTA0.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA0_SD_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA0.Reg) & 0xff00) >> 8
}

// GPIOSD.SIGMADELTA1: Duty-cycle configuration register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA1_SD_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA1.Reg, volatile.LoadUint32(&o.SIGMADELTA1.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA1_SD_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA1.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA1_SD_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA1.Reg, volatile.LoadUint32(&o.SIGMADELTA1.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA1_SD_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA1.Reg) & 0xff00) >> 8
}

// GPIOSD.SIGMADELTA2: Duty-cycle configuration register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA2_SD_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA2.Reg, volatile.LoadUint32(&o.SIGMADELTA2.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA2_SD_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA2.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA2_SD_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA2.Reg, volatile.LoadUint32(&o.SIGMADELTA2.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA2_SD_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA2.Reg) & 0xff00) >> 8
}

// GPIOSD.SIGMADELTA3: Duty-cycle configuration register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA3_SD_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA3.Reg, volatile.LoadUint32(&o.SIGMADELTA3.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA3_SD_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA3.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA3_SD_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA3.Reg, volatile.LoadUint32(&o.SIGMADELTA3.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA3_SD_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA3.Reg) & 0xff00) >> 8
}

// GPIOSD.SIGMADELTA4: Duty-cycle configuration register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA4_SD_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA4.Reg, volatile.LoadUint32(&o.SIGMADELTA4.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA4_SD_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA4.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA4_SD_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA4.Reg, volatile.LoadUint32(&o.SIGMADELTA4.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA4_SD_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA4.Reg) & 0xff00) >> 8
}

// GPIOSD.SIGMADELTA5: Duty-cycle configuration register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA5_SD_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA5.Reg, volatile.LoadUint32(&o.SIGMADELTA5.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA5_SD_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA5.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA5_SD_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA5.Reg, volatile.LoadUint32(&o.SIGMADELTA5.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA5_SD_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA5.Reg) & 0xff00) >> 8
}

// GPIOSD.SIGMADELTA6: Duty-cycle configuration register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA6_SD_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA6.Reg, volatile.LoadUint32(&o.SIGMADELTA6.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA6_SD_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA6.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA6_SD_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA6.Reg, volatile.LoadUint32(&o.SIGMADELTA6.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA6_SD_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA6.Reg) & 0xff00) >> 8
}

// GPIOSD.SIGMADELTA7: Duty-cycle configuration register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA7_SD_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA7.Reg, volatile.LoadUint32(&o.SIGMADELTA7.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA7_SD_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA7.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA7_SD_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA7.Reg, volatile.LoadUint32(&o.SIGMADELTA7.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA7_SD_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA7.Reg) & 0xff00) >> 8
}

// GPIOSD.SIGMADELTA_CG: Clock gating configuration register
func (o *GPIOSD_Type) SetSIGMADELTA_CG_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA_CG.Reg, volatile.LoadUint32(&o.SIGMADELTA_CG.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOSD_Type) GetSIGMADELTA_CG_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA_CG.Reg) & 0x80000000) >> 31
}

// GPIOSD.SIGMADELTA_MISC: MISC register
func (o *GPIOSD_Type) SetSIGMADELTA_MISC_FUNCTION_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA_MISC.Reg, volatile.LoadUint32(&o.SIGMADELTA_MISC.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOSD_Type) GetSIGMADELTA_MISC_FUNCTION_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA_MISC.Reg) & 0x40000000) >> 30
}
func (o *GPIOSD_Type) SetSIGMADELTA_MISC_SPI_SWAP(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA_MISC.Reg, volatile.LoadUint32(&o.SIGMADELTA_MISC.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOSD_Type) GetSIGMADELTA_MISC_SPI_SWAP() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA_MISC.Reg) & 0x80000000) >> 31
}

// GPIOSD.SIGMADELTA_VERSION: Version control register
func (o *GPIOSD_Type) SetSIGMADELTA_VERSION_GPIO_SD_DATE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA_VERSION.Reg, volatile.LoadUint32(&o.SIGMADELTA_VERSION.Reg)&^(0xfffffff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA_VERSION_GPIO_SD_DATE() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA_VERSION.Reg) & 0xfffffff
}

// HMAC (Hash-based Message Authentication Code) Accelerator
type HMAC_Type struct {
	_                   [64]byte
	SET_START           volatile.Register32 // 0x40
	SET_PARA_PURPOSE    volatile.Register32 // 0x44
	SET_PARA_KEY        volatile.Register32 // 0x48
	SET_PARA_FINISH     volatile.Register32 // 0x4C
	SET_MESSAGE_ONE     volatile.Register32 // 0x50
	SET_MESSAGE_ING     volatile.Register32 // 0x54
	SET_MESSAGE_END     volatile.Register32 // 0x58
	SET_RESULT_FINISH   volatile.Register32 // 0x5C
	SET_INVALIDATE_JTAG volatile.Register32 // 0x60
	SET_INVALIDATE_DS   volatile.Register32 // 0x64
	QUERY_ERROR         volatile.Register32 // 0x68
	QUERY_BUSY          volatile.Register32 // 0x6C
	_                   [16]byte
	WR_MESSAGE_0        volatile.Register32 // 0x80
	WR_MESSAGE_1        volatile.Register32 // 0x84
	WR_MESSAGE_2        volatile.Register32 // 0x88
	WR_MESSAGE_3        volatile.Register32 // 0x8C
	WR_MESSAGE_4        volatile.Register32 // 0x90
	WR_MESSAGE_5        volatile.Register32 // 0x94
	WR_MESSAGE_6        volatile.Register32 // 0x98
	WR_MESSAGE_7        volatile.Register32 // 0x9C
	WR_MESSAGE_8        volatile.Register32 // 0xA0
	WR_MESSAGE_9        volatile.Register32 // 0xA4
	WR_MESSAGE_10       volatile.Register32 // 0xA8
	WR_MESSAGE_11       volatile.Register32 // 0xAC
	WR_MESSAGE_12       volatile.Register32 // 0xB0
	WR_MESSAGE_13       volatile.Register32 // 0xB4
	WR_MESSAGE_14       volatile.Register32 // 0xB8
	WR_MESSAGE_15       volatile.Register32 // 0xBC
	RD_RESULT_0         volatile.Register32 // 0xC0
	RD_RESULT_1         volatile.Register32 // 0xC4
	RD_RESULT_2         volatile.Register32 // 0xC8
	RD_RESULT_3         volatile.Register32 // 0xCC
	RD_RESULT_4         volatile.Register32 // 0xD0
	RD_RESULT_5         volatile.Register32 // 0xD4
	RD_RESULT_6         volatile.Register32 // 0xD8
	RD_RESULT_7         volatile.Register32 // 0xDC
	_                   [16]byte
	SET_MESSAGE_PAD     volatile.Register32 // 0xF0
	ONE_BLOCK           volatile.Register32 // 0xF4
	DATE                volatile.Register32 // 0xF8
}

// HMAC.SET_START: HMAC start control register
func (o *HMAC_Type) SetSET_START(value uint32) {
	volatile.StoreUint32(&o.SET_START.Reg, volatile.LoadUint32(&o.SET_START.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_START() uint32 {
	return volatile.LoadUint32(&o.SET_START.Reg) & 0x1
}

// HMAC.SET_PARA_PURPOSE: HMAC parameter configuration register
func (o *HMAC_Type) SetSET_PARA_PURPOSE_PURPOSE_SET(value uint32) {
	volatile.StoreUint32(&o.SET_PARA_PURPOSE.Reg, volatile.LoadUint32(&o.SET_PARA_PURPOSE.Reg)&^(0xf)|value)
}
func (o *HMAC_Type) GetSET_PARA_PURPOSE_PURPOSE_SET() uint32 {
	return volatile.LoadUint32(&o.SET_PARA_PURPOSE.Reg) & 0xf
}

// HMAC.SET_PARA_KEY: HMAC key configuration register
func (o *HMAC_Type) SetSET_PARA_KEY_KEY_SET(value uint32) {
	volatile.StoreUint32(&o.SET_PARA_KEY.Reg, volatile.LoadUint32(&o.SET_PARA_KEY.Reg)&^(0x7)|value)
}
func (o *HMAC_Type) GetSET_PARA_KEY_KEY_SET() uint32 {
	return volatile.LoadUint32(&o.SET_PARA_KEY.Reg) & 0x7
}

// HMAC.SET_PARA_FINISH: HMAC configuration completion register
func (o *HMAC_Type) SetSET_PARA_FINISH_SET_PARA_END(value uint32) {
	volatile.StoreUint32(&o.SET_PARA_FINISH.Reg, volatile.LoadUint32(&o.SET_PARA_FINISH.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_PARA_FINISH_SET_PARA_END() uint32 {
	return volatile.LoadUint32(&o.SET_PARA_FINISH.Reg) & 0x1
}

// HMAC.SET_MESSAGE_ONE: HMAC one message control register
func (o *HMAC_Type) SetSET_MESSAGE_ONE_SET_TEXT_ONE(value uint32) {
	volatile.StoreUint32(&o.SET_MESSAGE_ONE.Reg, volatile.LoadUint32(&o.SET_MESSAGE_ONE.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_MESSAGE_ONE_SET_TEXT_ONE() uint32 {
	return volatile.LoadUint32(&o.SET_MESSAGE_ONE.Reg) & 0x1
}

// HMAC.SET_MESSAGE_ING: HMAC message continue register
func (o *HMAC_Type) SetSET_MESSAGE_ING_SET_TEXT_ING(value uint32) {
	volatile.StoreUint32(&o.SET_MESSAGE_ING.Reg, volatile.LoadUint32(&o.SET_MESSAGE_ING.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_MESSAGE_ING_SET_TEXT_ING() uint32 {
	return volatile.LoadUint32(&o.SET_MESSAGE_ING.Reg) & 0x1
}

// HMAC.SET_MESSAGE_END: HMAC message end register
func (o *HMAC_Type) SetSET_MESSAGE_END_SET_TEXT_END(value uint32) {
	volatile.StoreUint32(&o.SET_MESSAGE_END.Reg, volatile.LoadUint32(&o.SET_MESSAGE_END.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_MESSAGE_END_SET_TEXT_END() uint32 {
	return volatile.LoadUint32(&o.SET_MESSAGE_END.Reg) & 0x1
}

// HMAC.SET_RESULT_FINISH: HMAC read result completion register
func (o *HMAC_Type) SetSET_RESULT_FINISH_SET_RESULT_END(value uint32) {
	volatile.StoreUint32(&o.SET_RESULT_FINISH.Reg, volatile.LoadUint32(&o.SET_RESULT_FINISH.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_RESULT_FINISH_SET_RESULT_END() uint32 {
	return volatile.LoadUint32(&o.SET_RESULT_FINISH.Reg) & 0x1
}

// HMAC.SET_INVALIDATE_JTAG: Invalidate JTAG result register
func (o *HMAC_Type) SetSET_INVALIDATE_JTAG(value uint32) {
	volatile.StoreUint32(&o.SET_INVALIDATE_JTAG.Reg, volatile.LoadUint32(&o.SET_INVALIDATE_JTAG.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_INVALIDATE_JTAG() uint32 {
	return volatile.LoadUint32(&o.SET_INVALIDATE_JTAG.Reg) & 0x1
}

// HMAC.SET_INVALIDATE_DS: Invalidate digital signature result register
func (o *HMAC_Type) SetSET_INVALIDATE_DS(value uint32) {
	volatile.StoreUint32(&o.SET_INVALIDATE_DS.Reg, volatile.LoadUint32(&o.SET_INVALIDATE_DS.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_INVALIDATE_DS() uint32 {
	return volatile.LoadUint32(&o.SET_INVALIDATE_DS.Reg) & 0x1
}

// HMAC.QUERY_ERROR: The matching result between key and purpose user configured
func (o *HMAC_Type) SetQUERY_ERROR_QUERY_CHECK(value uint32) {
	volatile.StoreUint32(&o.QUERY_ERROR.Reg, volatile.LoadUint32(&o.QUERY_ERROR.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetQUERY_ERROR_QUERY_CHECK() uint32 {
	return volatile.LoadUint32(&o.QUERY_ERROR.Reg) & 0x1
}

// HMAC.QUERY_BUSY: The busy state of HMAC module
func (o *HMAC_Type) SetQUERY_BUSY_BUSY_STATE(value uint32) {
	volatile.StoreUint32(&o.QUERY_BUSY.Reg, volatile.LoadUint32(&o.QUERY_BUSY.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetQUERY_BUSY_BUSY_STATE() uint32 {
	return volatile.LoadUint32(&o.QUERY_BUSY.Reg) & 0x1
}

// HMAC.WR_MESSAGE_0: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_0(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_0.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_0() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_0.Reg)
}

// HMAC.WR_MESSAGE_1: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_1(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_1.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_1() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_1.Reg)
}

// HMAC.WR_MESSAGE_2: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_2(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_2.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_2() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_2.Reg)
}

// HMAC.WR_MESSAGE_3: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_3(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_3.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_3() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_3.Reg)
}

// HMAC.WR_MESSAGE_4: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_4(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_4.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_4() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_4.Reg)
}

// HMAC.WR_MESSAGE_5: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_5(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_5.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_5() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_5.Reg)
}

// HMAC.WR_MESSAGE_6: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_6(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_6.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_6() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_6.Reg)
}

// HMAC.WR_MESSAGE_7: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_7(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_7.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_7() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_7.Reg)
}

// HMAC.WR_MESSAGE_8: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_8(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_8.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_8() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_8.Reg)
}

// HMAC.WR_MESSAGE_9: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_9(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_9.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_9() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_9.Reg)
}

// HMAC.WR_MESSAGE_10: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_10(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_10.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_10() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_10.Reg)
}

// HMAC.WR_MESSAGE_11: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_11(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_11.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_11() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_11.Reg)
}

// HMAC.WR_MESSAGE_12: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_12(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_12.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_12() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_12.Reg)
}

// HMAC.WR_MESSAGE_13: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_13(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_13.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_13() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_13.Reg)
}

// HMAC.WR_MESSAGE_14: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_14(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_14.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_14() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_14.Reg)
}

// HMAC.WR_MESSAGE_15: Message register %s
func (o *HMAC_Type) SetWR_MESSAGE_15(value uint32) {
	volatile.StoreUint32(&o.WR_MESSAGE_15.Reg, value)
}
func (o *HMAC_Type) GetWR_MESSAGE_15() uint32 {
	return volatile.LoadUint32(&o.WR_MESSAGE_15.Reg)
}

// HMAC.RD_RESULT_0: Hash result register %s
func (o *HMAC_Type) SetRD_RESULT_0(value uint32) {
	volatile.StoreUint32(&o.RD_RESULT_0.Reg, value)
}
func (o *HMAC_Type) GetRD_RESULT_0() uint32 {
	return volatile.LoadUint32(&o.RD_RESULT_0.Reg)
}

// HMAC.RD_RESULT_1: Hash result register %s
func (o *HMAC_Type) SetRD_RESULT_1(value uint32) {
	volatile.StoreUint32(&o.RD_RESULT_1.Reg, value)
}
func (o *HMAC_Type) GetRD_RESULT_1() uint32 {
	return volatile.LoadUint32(&o.RD_RESULT_1.Reg)
}

// HMAC.RD_RESULT_2: Hash result register %s
func (o *HMAC_Type) SetRD_RESULT_2(value uint32) {
	volatile.StoreUint32(&o.RD_RESULT_2.Reg, value)
}
func (o *HMAC_Type) GetRD_RESULT_2() uint32 {
	return volatile.LoadUint32(&o.RD_RESULT_2.Reg)
}

// HMAC.RD_RESULT_3: Hash result register %s
func (o *HMAC_Type) SetRD_RESULT_3(value uint32) {
	volatile.StoreUint32(&o.RD_RESULT_3.Reg, value)
}
func (o *HMAC_Type) GetRD_RESULT_3() uint32 {
	return volatile.LoadUint32(&o.RD_RESULT_3.Reg)
}

// HMAC.RD_RESULT_4: Hash result register %s
func (o *HMAC_Type) SetRD_RESULT_4(value uint32) {
	volatile.StoreUint32(&o.RD_RESULT_4.Reg, value)
}
func (o *HMAC_Type) GetRD_RESULT_4() uint32 {
	return volatile.LoadUint32(&o.RD_RESULT_4.Reg)
}

// HMAC.RD_RESULT_5: Hash result register %s
func (o *HMAC_Type) SetRD_RESULT_5(value uint32) {
	volatile.StoreUint32(&o.RD_RESULT_5.Reg, value)
}
func (o *HMAC_Type) GetRD_RESULT_5() uint32 {
	return volatile.LoadUint32(&o.RD_RESULT_5.Reg)
}

// HMAC.RD_RESULT_6: Hash result register %s
func (o *HMAC_Type) SetRD_RESULT_6(value uint32) {
	volatile.StoreUint32(&o.RD_RESULT_6.Reg, value)
}
func (o *HMAC_Type) GetRD_RESULT_6() uint32 {
	return volatile.LoadUint32(&o.RD_RESULT_6.Reg)
}

// HMAC.RD_RESULT_7: Hash result register %s
func (o *HMAC_Type) SetRD_RESULT_7(value uint32) {
	volatile.StoreUint32(&o.RD_RESULT_7.Reg, value)
}
func (o *HMAC_Type) GetRD_RESULT_7() uint32 {
	return volatile.LoadUint32(&o.RD_RESULT_7.Reg)
}

// HMAC.SET_MESSAGE_PAD: Software padding register
func (o *HMAC_Type) SetSET_MESSAGE_PAD_SET_TEXT_PAD(value uint32) {
	volatile.StoreUint32(&o.SET_MESSAGE_PAD.Reg, volatile.LoadUint32(&o.SET_MESSAGE_PAD.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_MESSAGE_PAD_SET_TEXT_PAD() uint32 {
	return volatile.LoadUint32(&o.SET_MESSAGE_PAD.Reg) & 0x1
}

// HMAC.ONE_BLOCK: One block message register.
func (o *HMAC_Type) SetONE_BLOCK_SET_ONE_BLOCK(value uint32) {
	volatile.StoreUint32(&o.ONE_BLOCK.Reg, volatile.LoadUint32(&o.ONE_BLOCK.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetONE_BLOCK_SET_ONE_BLOCK() uint32 {
	return volatile.LoadUint32(&o.ONE_BLOCK.Reg) & 0x1
}

// HMAC.DATE: Version control register
func (o *HMAC_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x3fffffff)|value)
}
func (o *HMAC_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x3fffffff
}

// I2C (Inter-Integrated Circuit) Controller 0
type I2C_Type struct {
	SCL_LOW_PERIOD       volatile.Register32 // 0x0
	CTR                  volatile.Register32 // 0x4
	SR                   volatile.Register32 // 0x8
	TO                   volatile.Register32 // 0xC
	SLAVE_ADDR           volatile.Register32 // 0x10
	FIFO_ST              volatile.Register32 // 0x14
	FIFO_CONF            volatile.Register32 // 0x18
	DATA                 volatile.Register32 // 0x1C
	INT_RAW              volatile.Register32 // 0x20
	INT_CLR              volatile.Register32 // 0x24
	INT_ENA              volatile.Register32 // 0x28
	INT_STATUS           volatile.Register32 // 0x2C
	SDA_HOLD             volatile.Register32 // 0x30
	SDA_SAMPLE           volatile.Register32 // 0x34
	SCL_HIGH_PERIOD      volatile.Register32 // 0x38
	_                    [4]byte
	SCL_START_HOLD       volatile.Register32 // 0x40
	SCL_RSTART_SETUP     volatile.Register32 // 0x44
	SCL_STOP_HOLD        volatile.Register32 // 0x48
	SCL_STOP_SETUP       volatile.Register32 // 0x4C
	SCL_FILTER_CFG       volatile.Register32 // 0x50
	SDA_FILTER_CFG       volatile.Register32 // 0x54
	COMD0                volatile.Register32 // 0x58
	COMD1                volatile.Register32 // 0x5C
	COMD2                volatile.Register32 // 0x60
	COMD3                volatile.Register32 // 0x64
	COMD4                volatile.Register32 // 0x68
	COMD5                volatile.Register32 // 0x6C
	COMD6                volatile.Register32 // 0x70
	COMD7                volatile.Register32 // 0x74
	COMD8                volatile.Register32 // 0x78
	COMD9                volatile.Register32 // 0x7C
	COMD10               volatile.Register32 // 0x80
	COMD11               volatile.Register32 // 0x84
	COMD12               volatile.Register32 // 0x88
	COMD13               volatile.Register32 // 0x8C
	COMD14               volatile.Register32 // 0x90
	COMD15               volatile.Register32 // 0x94
	SCL_ST_TIME_OUT      volatile.Register32 // 0x98
	SCL_MAIN_ST_TIME_OUT volatile.Register32 // 0x9C
	SCL_SP_CONF          volatile.Register32 // 0xA0
	SCL_STRETCH_CONF     volatile.Register32 // 0xA4
	_                    [80]byte
	DATE                 volatile.Register32 // 0xF8
}

// I2C.SCL_LOW_PERIOD: Configures the low level width of the SCL clock
func (o *I2C_Type) SetSCL_LOW_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_LOW_PERIOD.Reg, volatile.LoadUint32(&o.SCL_LOW_PERIOD.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetSCL_LOW_PERIOD() uint32 {
	return volatile.LoadUint32(&o.SCL_LOW_PERIOD.Reg) & 0x3fff
}

// I2C.CTR: Transmission setting
func (o *I2C_Type) SetCTR_SDA_FORCE_OUT(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCTR_SDA_FORCE_OUT() uint32 {
	return volatile.LoadUint32(&o.CTR.Reg) & 0x1
}
func (o *I2C_Type) SetCTR_SCL_FORCE_OUT(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCTR_SCL_FORCE_OUT() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCTR_SAMPLE_SCL_LEVEL(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCTR_SAMPLE_SCL_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCTR_RX_FULL_ACK_LEVEL(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCTR_RX_FULL_ACK_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCTR_MS_MODE(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCTR_MS_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCTR_TRANS_START(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCTR_TRANS_START() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCTR_TX_LSB_FIRST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCTR_TX_LSB_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCTR_RX_LSB_FIRST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCTR_RX_LSB_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCTR_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetCTR_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetCTR_ARBITRATION_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetCTR_ARBITRATION_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetCTR_FSM_RST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCTR_FSM_RST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCTR_REF_ALWAYS_ON(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCTR_REF_ALWAYS_ON() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x800) >> 11
}

// I2C.SR: Describe I2C work status
func (o *I2C_Type) SetSR_RESP_REC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSR_RESP_REC() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *I2C_Type) SetSR_SLAVE_RW(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetSR_SLAVE_RW() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetSR_TIME_OUT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetSR_TIME_OUT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetSR_ARB_LOST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetSR_ARB_LOST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetSR_BUS_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSR_BUS_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSR_SLAVE_ADDRESSED(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetSR_SLAVE_ADDRESSED() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetSR_BYTE_TRANS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSR_BYTE_TRANS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetSR_RXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x3f00)|value<<8)
}
func (o *I2C_Type) GetSR_RXFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x3f00) >> 8
}
func (o *I2C_Type) SetSR_STRETCH_CAUSE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xc000)|value<<14)
}
func (o *I2C_Type) GetSR_STRETCH_CAUSE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xc000) >> 14
}
func (o *I2C_Type) SetSR_TXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xfc0000)|value<<18)
}
func (o *I2C_Type) GetSR_TXFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xfc0000) >> 18
}
func (o *I2C_Type) SetSR_SCL_MAIN_STATE_LAST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7000000)|value<<24)
}
func (o *I2C_Type) GetSR_SCL_MAIN_STATE_LAST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x7000000) >> 24
}
func (o *I2C_Type) SetSR_SCL_STATE_LAST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x70000000)|value<<28)
}
func (o *I2C_Type) GetSR_SCL_STATE_LAST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x70000000) >> 28
}

// I2C.TO: Setting time out control for receiving data
func (o *I2C_Type) SetTO_TIME_OUT_VALUE(value uint32) {
	volatile.StoreUint32(&o.TO.Reg, volatile.LoadUint32(&o.TO.Reg)&^(0xffffff)|value)
}
func (o *I2C_Type) GetTO_TIME_OUT_VALUE() uint32 {
	return volatile.LoadUint32(&o.TO.Reg) & 0xffffff
}
func (o *I2C_Type) SetTO_TIME_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.TO.Reg, volatile.LoadUint32(&o.TO.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetTO_TIME_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.TO.Reg) & 0x1000000) >> 24
}

// I2C.SLAVE_ADDR: Local slave address setting
func (o *I2C_Type) SetSLAVE_ADDR(value uint32) {
	volatile.StoreUint32(&o.SLAVE_ADDR.Reg, volatile.LoadUint32(&o.SLAVE_ADDR.Reg)&^(0x7fff)|value)
}
func (o *I2C_Type) GetSLAVE_ADDR() uint32 {
	return volatile.LoadUint32(&o.SLAVE_ADDR.Reg) & 0x7fff
}
func (o *I2C_Type) SetSLAVE_ADDR_ADDR_10BIT_EN(value uint32) {
	volatile.StoreUint32(&o.SLAVE_ADDR.Reg, volatile.LoadUint32(&o.SLAVE_ADDR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetSLAVE_ADDR_ADDR_10BIT_EN() uint32 {
	return (volatile.LoadUint32(&o.SLAVE_ADDR.Reg) & 0x80000000) >> 31
}

// I2C.FIFO_ST: FIFO status register
func (o *I2C_Type) SetFIFO_ST_RXFIFO_START_ADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetFIFO_ST_RXFIFO_START_ADDR() uint32 {
	return volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x1f
}
func (o *I2C_Type) SetFIFO_ST_RXFIFO_END_ADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x3e0)|value<<5)
}
func (o *I2C_Type) GetFIFO_ST_RXFIFO_END_ADDR() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x3e0) >> 5
}
func (o *I2C_Type) SetFIFO_ST_TXFIFO_START_ADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x7c00)|value<<10)
}
func (o *I2C_Type) GetFIFO_ST_TXFIFO_START_ADDR() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x7c00) >> 10
}
func (o *I2C_Type) SetFIFO_ST_TXFIFO_END_ADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0xf8000)|value<<15)
}
func (o *I2C_Type) GetFIFO_ST_TXFIFO_END_ADDR() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0xf8000) >> 15
}
func (o *I2C_Type) SetFIFO_ST_RX_UPDATE(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetFIFO_ST_RX_UPDATE() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetFIFO_ST_TX_UPDATE(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetFIFO_ST_TX_UPDATE() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x200000) >> 21
}
func (o *I2C_Type) SetFIFO_ST_SLAVE_RW_POINT(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x3fc00000)|value<<22)
}
func (o *I2C_Type) GetFIFO_ST_SLAVE_RW_POINT() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x3fc00000) >> 22
}

// I2C.FIFO_CONF: FIFO configuration register
func (o *I2C_Type) SetFIFO_CONF_RXFIFO_WM_THRHD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetFIFO_CONF_RXFIFO_WM_THRHD() uint32 {
	return volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x1f
}
func (o *I2C_Type) SetFIFO_CONF_TXFIFO_WM_THRHD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x3e0)|value<<5)
}
func (o *I2C_Type) GetFIFO_CONF_TXFIFO_WM_THRHD() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x3e0) >> 5
}
func (o *I2C_Type) SetFIFO_CONF_NONFIFO_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetFIFO_CONF_NONFIFO_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetFIFO_CONF_FIFO_ADDR_CFG_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetFIFO_CONF_FIFO_ADDR_CFG_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetFIFO_CONF_RX_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetFIFO_CONF_RX_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetFIFO_CONF_TX_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetFIFO_CONF_TX_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetFIFO_CONF_NONFIFO_RX_THRES(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0xfc000)|value<<14)
}
func (o *I2C_Type) GetFIFO_CONF_NONFIFO_RX_THRES() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0xfc000) >> 14
}
func (o *I2C_Type) SetFIFO_CONF_NONFIFO_TX_THRES(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x3f00000)|value<<20)
}
func (o *I2C_Type) GetFIFO_CONF_NONFIFO_TX_THRES() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x3f00000) >> 20
}
func (o *I2C_Type) SetFIFO_CONF_FIFO_PRT_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x4000000)|value<<26)
}
func (o *I2C_Type) GetFIFO_CONF_FIFO_PRT_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x4000000) >> 26
}

// I2C.DATA: RX FIFO read data
func (o *I2C_Type) SetDATA_FIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetDATA_FIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg) & 0xff
}

// I2C.INT_RAW: Raw interrupt status
func (o *I2C_Type) SetINT_RAW_RXFIFO_WM_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_RAW_RXFIFO_WM_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *I2C_Type) SetINT_RAW_TXFIFO_WM_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_RAW_TXFIFO_WM_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_RAW_RXFIFO_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_RAW_RXFIFO_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_RAW_END_DETECT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_RAW_END_DETECT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_RAW_BYTE_TRANS_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_RAW_BYTE_TRANS_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_RAW_ARBITRATION_LOST_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_RAW_ARBITRATION_LOST_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_RAW_MST_TXFIFO_UDF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_RAW_MST_TXFIFO_UDF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_RAW_TRANS_COMPLETE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_RAW_TRANS_COMPLETE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_RAW_TIME_OUT_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_RAW_TIME_OUT_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_RAW_TRANS_START_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_RAW_TRANS_START_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_RAW_NACK_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_RAW_NACK_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_RAW_TXFIFO_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_RAW_TXFIFO_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_RAW_RXFIFO_UDF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_RAW_RXFIFO_UDF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_RAW_SCL_ST_TO_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_RAW_SCL_ST_TO_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_RAW_SCL_MAIN_ST_TO_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_RAW_SCL_MAIN_ST_TO_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_RAW_DET_START_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_RAW_DET_START_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetINT_RAW_SLAVE_STRETCH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetINT_RAW_SLAVE_STRETCH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10000) >> 16
}

// I2C.INT_CLR: Interrupt clear bits
func (o *I2C_Type) SetINT_CLR_RXFIFO_WM_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_CLR_RXFIFO_WM_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *I2C_Type) SetINT_CLR_TXFIFO_WM_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_CLR_TXFIFO_WM_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_CLR_RXFIFO_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_CLR_RXFIFO_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_CLR_END_DETECT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_CLR_END_DETECT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_CLR_BYTE_TRANS_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_CLR_BYTE_TRANS_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_CLR_ARBITRATION_LOST_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_CLR_ARBITRATION_LOST_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_CLR_MST_TXFIFO_UDF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_CLR_MST_TXFIFO_UDF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_CLR_TRANS_COMPLETE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_CLR_TRANS_COMPLETE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_CLR_TIME_OUT_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_CLR_TIME_OUT_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_CLR_TRANS_START_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_CLR_TRANS_START_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_CLR_NACK_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_CLR_NACK_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_CLR_TXFIFO_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_CLR_TXFIFO_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_CLR_RXFIFO_UDF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_CLR_RXFIFO_UDF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_CLR_SCL_ST_TO_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_CLR_SCL_ST_TO_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_CLR_SCL_MAIN_ST_TO_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_CLR_SCL_MAIN_ST_TO_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_CLR_DET_START_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_CLR_DET_START_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetINT_CLR_SLAVE_STRETCH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetINT_CLR_SLAVE_STRETCH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10000) >> 16
}

// I2C.INT_ENA: Interrupt enable bits
func (o *I2C_Type) SetINT_ENA_RXFIFO_WM_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_ENA_RXFIFO_WM_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *I2C_Type) SetINT_ENA_TXFIFO_WM_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_ENA_TXFIFO_WM_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_ENA_RXFIFO_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_ENA_RXFIFO_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_ENA_END_DETECT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_ENA_END_DETECT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_ENA_BYTE_TRANS_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_ENA_BYTE_TRANS_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_ENA_ARBITRATION_LOST_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_ENA_ARBITRATION_LOST_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_ENA_MST_TXFIFO_UDF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_ENA_MST_TXFIFO_UDF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_ENA_TRANS_COMPLETE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_ENA_TRANS_COMPLETE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_ENA_TIME_OUT_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_ENA_TIME_OUT_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_ENA_TRANS_START_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_ENA_TRANS_START_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_ENA_NACK_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_ENA_NACK_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_ENA_TXFIFO_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_ENA_TXFIFO_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_ENA_RXFIFO_UDF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_ENA_RXFIFO_UDF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_ENA_SCL_ST_TO_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_ENA_SCL_ST_TO_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_ENA_SCL_MAIN_ST_TO_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_ENA_SCL_MAIN_ST_TO_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_ENA_DET_START_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_ENA_DET_START_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetINT_ENA_SLAVE_STRETCH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetINT_ENA_SLAVE_STRETCH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10000) >> 16
}

// I2C.INT_STATUS: Status of captured I2C communication events
func (o *I2C_Type) SetINT_STATUS_RXFIFO_WM_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetINT_STATUS_RXFIFO_WM_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x1
}
func (o *I2C_Type) SetINT_STATUS_TXFIFO_WM_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetINT_STATUS_TXFIFO_WM_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetINT_STATUS_RXFIFO_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetINT_STATUS_RXFIFO_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetINT_STATUS_END_DETECT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetINT_STATUS_END_DETECT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetINT_STATUS_BYTE_TRANS_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetINT_STATUS_BYTE_TRANS_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetINT_STATUS_ARBITRATION_LOST_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetINT_STATUS_ARBITRATION_LOST_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetINT_STATUS_MST_TXFIFO_UDF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetINT_STATUS_MST_TXFIFO_UDF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetINT_STATUS_TRANS_COMPLETE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetINT_STATUS_TRANS_COMPLETE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetINT_STATUS_TIME_OUT_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetINT_STATUS_TIME_OUT_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetINT_STATUS_TRANS_START_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetINT_STATUS_TRANS_START_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetINT_STATUS_NACK_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetINT_STATUS_NACK_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetINT_STATUS_TXFIFO_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetINT_STATUS_TXFIFO_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetINT_STATUS_RXFIFO_UDF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetINT_STATUS_RXFIFO_UDF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetINT_STATUS_SCL_ST_TO_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetINT_STATUS_SCL_ST_TO_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetINT_STATUS_SCL_MAIN_ST_TO_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetINT_STATUS_SCL_MAIN_ST_TO_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetINT_STATUS_DET_START_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetINT_STATUS_DET_START_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetINT_STATUS_SLAVE_STRETCH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_STATUS.Reg, volatile.LoadUint32(&o.INT_STATUS.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetINT_STATUS_SLAVE_STRETCH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_STATUS.Reg) & 0x10000) >> 16
}

// I2C.SDA_HOLD: Configures the hold time after a negative SCL edge
func (o *I2C_Type) SetSDA_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.SDA_HOLD.Reg, volatile.LoadUint32(&o.SDA_HOLD.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetSDA_HOLD_TIME() uint32 {
	return volatile.LoadUint32(&o.SDA_HOLD.Reg) & 0x3ff
}

// I2C.SDA_SAMPLE: Configures the sample time after a positive SCL edge
func (o *I2C_Type) SetSDA_SAMPLE_TIME(value uint32) {
	volatile.StoreUint32(&o.SDA_SAMPLE.Reg, volatile.LoadUint32(&o.SDA_SAMPLE.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetSDA_SAMPLE_TIME() uint32 {
	return volatile.LoadUint32(&o.SDA_SAMPLE.Reg) & 0x3ff
}

// I2C.SCL_HIGH_PERIOD: Configures the high level width of the SCL clock
func (o *I2C_Type) SetSCL_HIGH_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_HIGH_PERIOD.Reg, volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetSCL_HIGH_PERIOD() uint32 {
	return volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg) & 0x3fff
}
func (o *I2C_Type) SetSCL_HIGH_PERIOD_SCL_WAIT_HIGH_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_HIGH_PERIOD.Reg, volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg)&^(0xfffc000)|value<<14)
}
func (o *I2C_Type) GetSCL_HIGH_PERIOD_SCL_WAIT_HIGH_PERIOD() uint32 {
	return (volatile.LoadUint32(&o.SCL_HIGH_PERIOD.Reg) & 0xfffc000) >> 14
}

// I2C.SCL_START_HOLD: Configures the interval between pulling SDA low and pulling SCL low when the master generates a START condition
func (o *I2C_Type) SetSCL_START_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_START_HOLD.Reg, volatile.LoadUint32(&o.SCL_START_HOLD.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetSCL_START_HOLD_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_START_HOLD.Reg) & 0x3ff
}

// I2C.SCL_RSTART_SETUP: Configures the interval between the positive edge of SCL and the negative edge of SDA
func (o *I2C_Type) SetSCL_RSTART_SETUP_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_RSTART_SETUP.Reg, volatile.LoadUint32(&o.SCL_RSTART_SETUP.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetSCL_RSTART_SETUP_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_RSTART_SETUP.Reg) & 0x3ff
}

// I2C.SCL_STOP_HOLD: Configures the delay after the SCL clock edge for a stop condition
func (o *I2C_Type) SetSCL_STOP_HOLD_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_STOP_HOLD.Reg, volatile.LoadUint32(&o.SCL_STOP_HOLD.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetSCL_STOP_HOLD_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_STOP_HOLD.Reg) & 0x3fff
}

// I2C.SCL_STOP_SETUP: Configures the delay between the SDA and SCL positive edge for a stop condition
func (o *I2C_Type) SetSCL_STOP_SETUP_TIME(value uint32) {
	volatile.StoreUint32(&o.SCL_STOP_SETUP.Reg, volatile.LoadUint32(&o.SCL_STOP_SETUP.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetSCL_STOP_SETUP_TIME() uint32 {
	return volatile.LoadUint32(&o.SCL_STOP_SETUP.Reg) & 0x3ff
}

// I2C.SCL_FILTER_CFG: SCL filter configuration register
func (o *I2C_Type) SetSCL_FILTER_CFG_SCL_FILTER_THRES(value uint32) {
	volatile.StoreUint32(&o.SCL_FILTER_CFG.Reg, volatile.LoadUint32(&o.SCL_FILTER_CFG.Reg)&^(0xf)|value)
}
func (o *I2C_Type) GetSCL_FILTER_CFG_SCL_FILTER_THRES() uint32 {
	return volatile.LoadUint32(&o.SCL_FILTER_CFG.Reg) & 0xf
}
func (o *I2C_Type) SetSCL_FILTER_CFG_SCL_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_FILTER_CFG.Reg, volatile.LoadUint32(&o.SCL_FILTER_CFG.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSCL_FILTER_CFG_SCL_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.SCL_FILTER_CFG.Reg) & 0x10) >> 4
}

// I2C.SDA_FILTER_CFG: SDA filter configuration register
func (o *I2C_Type) SetSDA_FILTER_CFG_SDA_FILTER_THRES(value uint32) {
	volatile.StoreUint32(&o.SDA_FILTER_CFG.Reg, volatile.LoadUint32(&o.SDA_FILTER_CFG.Reg)&^(0xf)|value)
}
func (o *I2C_Type) GetSDA_FILTER_CFG_SDA_FILTER_THRES() uint32 {
	return volatile.LoadUint32(&o.SDA_FILTER_CFG.Reg) & 0xf
}
func (o *I2C_Type) SetSDA_FILTER_CFG_SDA_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.SDA_FILTER_CFG.Reg, volatile.LoadUint32(&o.SDA_FILTER_CFG.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSDA_FILTER_CFG_SDA_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.SDA_FILTER_CFG.Reg) & 0x10) >> 4
}

// I2C.COMD0: I2C command register %s
func (o *I2C_Type) SetCOMD0_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD0.Reg, volatile.LoadUint32(&o.COMD0.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD0_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD0.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD0_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD0.Reg, volatile.LoadUint32(&o.COMD0.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD0_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD0.Reg) & 0x80000000) >> 31
}

// I2C.COMD1: I2C command register %s
func (o *I2C_Type) SetCOMD1_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD1.Reg, volatile.LoadUint32(&o.COMD1.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD1_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD1.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD1_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD1.Reg, volatile.LoadUint32(&o.COMD1.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD1_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD1.Reg) & 0x80000000) >> 31
}

// I2C.COMD2: I2C command register %s
func (o *I2C_Type) SetCOMD2_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD2.Reg, volatile.LoadUint32(&o.COMD2.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD2_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD2.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD2_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD2.Reg, volatile.LoadUint32(&o.COMD2.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD2_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD2.Reg) & 0x80000000) >> 31
}

// I2C.COMD3: I2C command register %s
func (o *I2C_Type) SetCOMD3_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD3.Reg, volatile.LoadUint32(&o.COMD3.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD3_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD3.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD3_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD3.Reg, volatile.LoadUint32(&o.COMD3.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD3_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD3.Reg) & 0x80000000) >> 31
}

// I2C.COMD4: I2C command register %s
func (o *I2C_Type) SetCOMD4_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD4.Reg, volatile.LoadUint32(&o.COMD4.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD4_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD4.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD4_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD4.Reg, volatile.LoadUint32(&o.COMD4.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD4_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD4.Reg) & 0x80000000) >> 31
}

// I2C.COMD5: I2C command register %s
func (o *I2C_Type) SetCOMD5_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD5.Reg, volatile.LoadUint32(&o.COMD5.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD5_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD5.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD5_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD5.Reg, volatile.LoadUint32(&o.COMD5.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD5_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD5.Reg) & 0x80000000) >> 31
}

// I2C.COMD6: I2C command register %s
func (o *I2C_Type) SetCOMD6_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD6.Reg, volatile.LoadUint32(&o.COMD6.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD6_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD6.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD6_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD6.Reg, volatile.LoadUint32(&o.COMD6.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD6_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD6.Reg) & 0x80000000) >> 31
}

// I2C.COMD7: I2C command register %s
func (o *I2C_Type) SetCOMD7_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD7.Reg, volatile.LoadUint32(&o.COMD7.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD7_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD7.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD7_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD7.Reg, volatile.LoadUint32(&o.COMD7.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD7_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD7.Reg) & 0x80000000) >> 31
}

// I2C.COMD8: I2C command register %s
func (o *I2C_Type) SetCOMD8_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD8.Reg, volatile.LoadUint32(&o.COMD8.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD8_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD8.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD8_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD8.Reg, volatile.LoadUint32(&o.COMD8.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD8_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD8.Reg) & 0x80000000) >> 31
}

// I2C.COMD9: I2C command register %s
func (o *I2C_Type) SetCOMD9_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD9.Reg, volatile.LoadUint32(&o.COMD9.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD9_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD9.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD9_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD9.Reg, volatile.LoadUint32(&o.COMD9.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD9_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD9.Reg) & 0x80000000) >> 31
}

// I2C.COMD10: I2C command register %s
func (o *I2C_Type) SetCOMD10_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD10.Reg, volatile.LoadUint32(&o.COMD10.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD10_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD10.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD10_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD10.Reg, volatile.LoadUint32(&o.COMD10.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD10_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD10.Reg) & 0x80000000) >> 31
}

// I2C.COMD11: I2C command register %s
func (o *I2C_Type) SetCOMD11_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD11.Reg, volatile.LoadUint32(&o.COMD11.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD11_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD11.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD11_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD11.Reg, volatile.LoadUint32(&o.COMD11.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD11_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD11.Reg) & 0x80000000) >> 31
}

// I2C.COMD12: I2C command register %s
func (o *I2C_Type) SetCOMD12_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD12.Reg, volatile.LoadUint32(&o.COMD12.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD12_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD12.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD12_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD12.Reg, volatile.LoadUint32(&o.COMD12.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD12_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD12.Reg) & 0x80000000) >> 31
}

// I2C.COMD13: I2C command register %s
func (o *I2C_Type) SetCOMD13_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD13.Reg, volatile.LoadUint32(&o.COMD13.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD13_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD13.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD13_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD13.Reg, volatile.LoadUint32(&o.COMD13.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD13_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD13.Reg) & 0x80000000) >> 31
}

// I2C.COMD14: I2C command register %s
func (o *I2C_Type) SetCOMD14_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD14.Reg, volatile.LoadUint32(&o.COMD14.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD14_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD14.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD14_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD14.Reg, volatile.LoadUint32(&o.COMD14.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD14_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD14.Reg) & 0x80000000) >> 31
}

// I2C.COMD15: I2C command register %s
func (o *I2C_Type) SetCOMD15_COMMAND(value uint32) {
	volatile.StoreUint32(&o.COMD15.Reg, volatile.LoadUint32(&o.COMD15.Reg)&^(0x3fff)|value)
}
func (o *I2C_Type) GetCOMD15_COMMAND() uint32 {
	return volatile.LoadUint32(&o.COMD15.Reg) & 0x3fff
}
func (o *I2C_Type) SetCOMD15_COMMAND_DONE(value uint32) {
	volatile.StoreUint32(&o.COMD15.Reg, volatile.LoadUint32(&o.COMD15.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetCOMD15_COMMAND_DONE() uint32 {
	return (volatile.LoadUint32(&o.COMD15.Reg) & 0x80000000) >> 31
}

// I2C.SCL_ST_TIME_OUT: SCL status time out register
func (o *I2C_Type) SetSCL_ST_TIME_OUT_SCL_ST_TO(value uint32) {
	volatile.StoreUint32(&o.SCL_ST_TIME_OUT.Reg, volatile.LoadUint32(&o.SCL_ST_TIME_OUT.Reg)&^(0xffffff)|value)
}
func (o *I2C_Type) GetSCL_ST_TIME_OUT_SCL_ST_TO() uint32 {
	return volatile.LoadUint32(&o.SCL_ST_TIME_OUT.Reg) & 0xffffff
}

// I2C.SCL_MAIN_ST_TIME_OUT: SCL main status time out register
func (o *I2C_Type) SetSCL_MAIN_ST_TIME_OUT_SCL_MAIN_ST_TO(value uint32) {
	volatile.StoreUint32(&o.SCL_MAIN_ST_TIME_OUT.Reg, volatile.LoadUint32(&o.SCL_MAIN_ST_TIME_OUT.Reg)&^(0xffffff)|value)
}
func (o *I2C_Type) GetSCL_MAIN_ST_TIME_OUT_SCL_MAIN_ST_TO() uint32 {
	return volatile.LoadUint32(&o.SCL_MAIN_ST_TIME_OUT.Reg) & 0xffffff
}

// I2C.SCL_SP_CONF: Power configuration register
func (o *I2C_Type) SetSCL_SP_CONF_SCL_RST_SLV_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSCL_SP_CONF_SCL_RST_SLV_EN() uint32 {
	return volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x1
}
func (o *I2C_Type) SetSCL_SP_CONF_SCL_RST_SLV_NUM(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x3e)|value<<1)
}
func (o *I2C_Type) GetSCL_SP_CONF_SCL_RST_SLV_NUM() uint32 {
	return (volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x3e) >> 1
}
func (o *I2C_Type) SetSCL_SP_CONF_SCL_PD_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetSCL_SP_CONF_SCL_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetSCL_SP_CONF_SDA_PD_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_SP_CONF.Reg, volatile.LoadUint32(&o.SCL_SP_CONF.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetSCL_SP_CONF_SDA_PD_EN() uint32 {
	return (volatile.LoadUint32(&o.SCL_SP_CONF.Reg) & 0x80) >> 7
}

// I2C.SCL_STRETCH_CONF: Set SCL stretch of I2C slave
func (o *I2C_Type) SetSCL_STRETCH_CONF_STRETCH_PROTECT_NUM(value uint32) {
	volatile.StoreUint32(&o.SCL_STRETCH_CONF.Reg, volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetSCL_STRETCH_CONF_STRETCH_PROTECT_NUM() uint32 {
	return volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg) & 0x3ff
}
func (o *I2C_Type) SetSCL_STRETCH_CONF_SLAVE_SCL_STRETCH_EN(value uint32) {
	volatile.StoreUint32(&o.SCL_STRETCH_CONF.Reg, volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetSCL_STRETCH_CONF_SLAVE_SCL_STRETCH_EN() uint32 {
	return (volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetSCL_STRETCH_CONF_SLAVE_SCL_STRETCH_CLR(value uint32) {
	volatile.StoreUint32(&o.SCL_STRETCH_CONF.Reg, volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetSCL_STRETCH_CONF_SLAVE_SCL_STRETCH_CLR() uint32 {
	return (volatile.LoadUint32(&o.SCL_STRETCH_CONF.Reg) & 0x800) >> 11
}

// I2C.DATE: Version control register
func (o *I2C_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *I2C_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// I2S (Inter-IC Sound) Controller 0
type I2S_Type struct {
	_                    [8]byte
	CONF                 volatile.Register32 // 0x8
	INT_RAW              volatile.Register32 // 0xC
	INT_ST               volatile.Register32 // 0x10
	INT_ENA              volatile.Register32 // 0x14
	INT_CLR              volatile.Register32 // 0x18
	TIMING               volatile.Register32 // 0x1C
	FIFO_CONF            volatile.Register32 // 0x20
	RXEOF_NUM            volatile.Register32 // 0x24
	CONF_SIGLE_DATA      volatile.Register32 // 0x28
	CONF_CHAN            volatile.Register32 // 0x2C
	OUT_LINK             volatile.Register32 // 0x30
	IN_LINK              volatile.Register32 // 0x34
	OUT_EOF_DES_ADDR     volatile.Register32 // 0x38
	IN_EOF_DES_ADDR      volatile.Register32 // 0x3C
	OUT_EOF_BFR_DES_ADDR volatile.Register32 // 0x40
	_                    [4]byte
	INLINK_DSCR          volatile.Register32 // 0x48
	INLINK_DSCR_BF0      volatile.Register32 // 0x4C
	INLINK_DSCR_BF1      volatile.Register32 // 0x50
	OUTLINK_DSCR         volatile.Register32 // 0x54
	OUTLINK_DSCR_BF0     volatile.Register32 // 0x58
	OUTLINK_DSCR_BF1     volatile.Register32 // 0x5C
	LC_CONF              volatile.Register32 // 0x60
	OUTFIFO_PUSH         volatile.Register32 // 0x64
	INFIFO_POP           volatile.Register32 // 0x68
	LC_STATE0            volatile.Register32 // 0x6C
	LC_STATE1            volatile.Register32 // 0x70
	LC_HUNG_CONF         volatile.Register32 // 0x74
	_                    [40]byte
	CONF1                volatile.Register32 // 0xA0
	PD_CONF              volatile.Register32 // 0xA4
	CONF2                volatile.Register32 // 0xA8
	CLKM_CONF            volatile.Register32 // 0xAC
	SAMPLE_RATE_CONF     volatile.Register32 // 0xB0
	_                    [8]byte
	STATE                volatile.Register32 // 0xBC
	_                    [60]byte
	DATE                 volatile.Register32 // 0xFC
}

// I2S.CONF: I2S configuration register
func (o *I2S_Type) SetCONF_TX_RESET(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetCONF_TX_RESET() uint32 {
	return volatile.LoadUint32(&o.CONF.Reg) & 0x1
}
func (o *I2S_Type) SetCONF_RX_RESET(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetCONF_RX_RESET() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetCONF_TX_FIFO_RESET(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetCONF_TX_FIFO_RESET() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetCONF_RX_FIFO_RESET(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetCONF_RX_FIFO_RESET() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetCONF_TX_START(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetCONF_TX_START() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetCONF_RX_START(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetCONF_RX_START() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetCONF_TX_SLAVE_MOD(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetCONF_TX_SLAVE_MOD() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetCONF_RX_SLAVE_MOD(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetCONF_RX_SLAVE_MOD() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetCONF_TX_RIGHT_FIRST(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetCONF_TX_RIGHT_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetCONF_RX_RIGHT_FIRST(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetCONF_RX_RIGHT_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetCONF_TX_MSB_SHIFT(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetCONF_TX_MSB_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetCONF_RX_MSB_SHIFT(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetCONF_RX_MSB_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetCONF_TX_SHORT_SYNC(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetCONF_TX_SHORT_SYNC() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetCONF_RX_SHORT_SYNC(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetCONF_RX_SHORT_SYNC() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x2000) >> 13
}
func (o *I2S_Type) SetCONF_TX_MONO(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x4000)|value<<14)
}
func (o *I2S_Type) GetCONF_TX_MONO() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x4000) >> 14
}
func (o *I2S_Type) SetCONF_RX_MONO(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetCONF_RX_MONO() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetCONF_TX_MSB_RIGHT(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetCONF_TX_MSB_RIGHT() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x10000) >> 16
}
func (o *I2S_Type) SetCONF_RX_MSB_RIGHT(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x20000)|value<<17)
}
func (o *I2S_Type) GetCONF_RX_MSB_RIGHT() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x20000) >> 17
}
func (o *I2S_Type) SetCONF_TX_LSB_FIRST_DMA(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x40000)|value<<18)
}
func (o *I2S_Type) GetCONF_TX_LSB_FIRST_DMA() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x40000) >> 18
}
func (o *I2S_Type) SetCONF_RX_LSB_FIRST_DMA(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x80000)|value<<19)
}
func (o *I2S_Type) GetCONF_RX_LSB_FIRST_DMA() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x80000) >> 19
}
func (o *I2S_Type) SetCONF_SIG_LOOPBACK(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x100000)|value<<20)
}
func (o *I2S_Type) GetCONF_SIG_LOOPBACK() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x100000) >> 20
}
func (o *I2S_Type) SetCONF_TX_FIFO_RESET_ST(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x200000)|value<<21)
}
func (o *I2S_Type) GetCONF_TX_FIFO_RESET_ST() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x200000) >> 21
}
func (o *I2S_Type) SetCONF_RX_FIFO_RESET_ST(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x400000)|value<<22)
}
func (o *I2S_Type) GetCONF_RX_FIFO_RESET_ST() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x400000) >> 22
}
func (o *I2S_Type) SetCONF_TX_RESET_ST(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x800000)|value<<23)
}
func (o *I2S_Type) GetCONF_TX_RESET_ST() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x800000) >> 23
}
func (o *I2S_Type) SetCONF_TX_DMA_EQUAL(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S_Type) GetCONF_TX_DMA_EQUAL() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x1000000) >> 24
}
func (o *I2S_Type) SetCONF_RX_DMA_EQUAL(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x2000000)|value<<25)
}
func (o *I2S_Type) GetCONF_RX_DMA_EQUAL() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x2000000) >> 25
}
func (o *I2S_Type) SetCONF_PRE_REQ_EN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x4000000)|value<<26)
}
func (o *I2S_Type) GetCONF_PRE_REQ_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x4000000) >> 26
}
func (o *I2S_Type) SetCONF_TX_BIG_ENDIAN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x8000000)|value<<27)
}
func (o *I2S_Type) GetCONF_TX_BIG_ENDIAN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x8000000) >> 27
}
func (o *I2S_Type) SetCONF_RX_BIG_ENDIAN(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S_Type) GetCONF_RX_BIG_ENDIAN() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x10000000) >> 28
}
func (o *I2S_Type) SetCONF_RX_RESET_ST(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S_Type) GetCONF_RX_RESET_ST() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x20000000) >> 29
}

// I2S.INT_RAW: Raw interrupt status
func (o *I2S_Type) SetINT_RAW_RX_TAKE_DATA_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetINT_RAW_RX_TAKE_DATA_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *I2S_Type) SetINT_RAW_TX_PUT_DATA_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINT_RAW_TX_PUT_DATA_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINT_RAW_RX_WFULL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINT_RAW_RX_WFULL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINT_RAW_RX_REMPTY_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetINT_RAW_RX_REMPTY_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetINT_RAW_TX_WFULL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetINT_RAW_TX_WFULL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetINT_RAW_TX_REMPTY_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINT_RAW_TX_REMPTY_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetINT_RAW_RX_HUNG_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetINT_RAW_RX_HUNG_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetINT_RAW_TX_HUNG_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetINT_RAW_TX_HUNG_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetINT_RAW_IN_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetINT_RAW_IN_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetINT_RAW_IN_SUC_EOF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetINT_RAW_IN_SUC_EOF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetINT_RAW_IN_ERR_EOF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetINT_RAW_IN_ERR_EOF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetINT_RAW_OUT_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetINT_RAW_OUT_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetINT_RAW_OUT_EOF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetINT_RAW_OUT_EOF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetINT_RAW_IN_DSCR_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetINT_RAW_IN_DSCR_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2000) >> 13
}
func (o *I2S_Type) SetINT_RAW_OUT_DSCR_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4000)|value<<14)
}
func (o *I2S_Type) GetINT_RAW_OUT_DSCR_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4000) >> 14
}
func (o *I2S_Type) SetINT_RAW_IN_DSCR_EMPTY_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetINT_RAW_IN_DSCR_EMPTY_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetINT_RAW_OUT_TOTAL_EOF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetINT_RAW_OUT_TOTAL_EOF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10000) >> 16
}
func (o *I2S_Type) SetINT_RAW_V_SYNC_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20000)|value<<17)
}
func (o *I2S_Type) GetINT_RAW_V_SYNC_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20000) >> 17
}

// I2S.INT_ST: Masked interrupt status
func (o *I2S_Type) SetINT_ST_RX_TAKE_DATA_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetINT_ST_RX_TAKE_DATA_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *I2S_Type) SetINT_ST_TX_PUT_DATA_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINT_ST_TX_PUT_DATA_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINT_ST_RX_WFULL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINT_ST_RX_WFULL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINT_ST_RX_REMPTY_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetINT_ST_RX_REMPTY_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetINT_ST_TX_WFULL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetINT_ST_TX_WFULL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetINT_ST_TX_REMPTY_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINT_ST_TX_REMPTY_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetINT_ST_RX_HUNG_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetINT_ST_RX_HUNG_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetINT_ST_TX_HUNG_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetINT_ST_TX_HUNG_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetINT_ST_IN_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetINT_ST_IN_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetINT_ST_IN_SUC_EOF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetINT_ST_IN_SUC_EOF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetINT_ST_IN_ERR_EOF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetINT_ST_IN_ERR_EOF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetINT_ST_OUT_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetINT_ST_OUT_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetINT_ST_OUT_EOF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetINT_ST_OUT_EOF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetINT_ST_IN_DSCR_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetINT_ST_IN_DSCR_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2000) >> 13
}
func (o *I2S_Type) SetINT_ST_OUT_DSCR_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4000)|value<<14)
}
func (o *I2S_Type) GetINT_ST_OUT_DSCR_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4000) >> 14
}
func (o *I2S_Type) SetINT_ST_IN_DSCR_EMPTY_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetINT_ST_IN_DSCR_EMPTY_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetINT_ST_OUT_TOTAL_EOF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetINT_ST_OUT_TOTAL_EOF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10000) >> 16
}
func (o *I2S_Type) SetINT_ST_V_SYNC_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20000)|value<<17)
}
func (o *I2S_Type) GetINT_ST_V_SYNC_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20000) >> 17
}

// I2S.INT_ENA: Interrupt enable bits
func (o *I2S_Type) SetINT_ENA_RX_TAKE_DATA_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetINT_ENA_RX_TAKE_DATA_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *I2S_Type) SetINT_ENA_TX_PUT_DATA_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINT_ENA_TX_PUT_DATA_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINT_ENA_RX_WFULL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINT_ENA_RX_WFULL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINT_ENA_RX_REMPTY_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetINT_ENA_RX_REMPTY_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetINT_ENA_TX_WFULL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetINT_ENA_TX_WFULL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetINT_ENA_TX_REMPTY_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINT_ENA_TX_REMPTY_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetINT_ENA_RX_HUNG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetINT_ENA_RX_HUNG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetINT_ENA_TX_HUNG_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetINT_ENA_TX_HUNG_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetINT_ENA_IN_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetINT_ENA_IN_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetINT_ENA_IN_SUC_EOF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetINT_ENA_IN_SUC_EOF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetINT_ENA_IN_ERR_EOF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetINT_ENA_IN_ERR_EOF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetINT_ENA_OUT_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetINT_ENA_OUT_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetINT_ENA_OUT_EOF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetINT_ENA_OUT_EOF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetINT_ENA_IN_DSCR_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetINT_ENA_IN_DSCR_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2000) >> 13
}
func (o *I2S_Type) SetINT_ENA_OUT_DSCR_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4000)|value<<14)
}
func (o *I2S_Type) GetINT_ENA_OUT_DSCR_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4000) >> 14
}
func (o *I2S_Type) SetINT_ENA_IN_DSCR_EMPTY_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetINT_ENA_IN_DSCR_EMPTY_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetINT_ENA_OUT_TOTAL_EOF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetINT_ENA_OUT_TOTAL_EOF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10000) >> 16
}
func (o *I2S_Type) SetINT_ENA_V_SYNC_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20000)|value<<17)
}
func (o *I2S_Type) GetINT_ENA_V_SYNC_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20000) >> 17
}

// I2S.INT_CLR: Interrupt clear bits
func (o *I2S_Type) SetINT_CLR_TAKE_DATA_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetINT_CLR_TAKE_DATA_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *I2S_Type) SetINT_CLR_PUT_DATA_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINT_CLR_PUT_DATA_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINT_CLR_RX_WFULL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINT_CLR_RX_WFULL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINT_CLR_RX_REMPTY_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetINT_CLR_RX_REMPTY_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetINT_CLR_TX_WFULL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetINT_CLR_TX_WFULL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetINT_CLR_TX_REMPTY_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINT_CLR_TX_REMPTY_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetINT_CLR_RX_HUNG_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetINT_CLR_RX_HUNG_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetINT_CLR_TX_HUNG_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetINT_CLR_TX_HUNG_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetINT_CLR_IN_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetINT_CLR_IN_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetINT_CLR_IN_SUC_EOF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetINT_CLR_IN_SUC_EOF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetINT_CLR_IN_ERR_EOF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetINT_CLR_IN_ERR_EOF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetINT_CLR_OUT_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetINT_CLR_OUT_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetINT_CLR_OUT_EOF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetINT_CLR_OUT_EOF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetINT_CLR_IN_DSCR_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetINT_CLR_IN_DSCR_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2000) >> 13
}
func (o *I2S_Type) SetINT_CLR_OUT_DSCR_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *I2S_Type) GetINT_CLR_OUT_DSCR_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4000) >> 14
}
func (o *I2S_Type) SetINT_CLR_IN_DSCR_EMPTY_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetINT_CLR_IN_DSCR_EMPTY_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetINT_CLR_OUT_TOTAL_EOF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetINT_CLR_OUT_TOTAL_EOF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10000) >> 16
}
func (o *I2S_Type) SetINT_CLR_V_SYNC_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20000)|value<<17)
}
func (o *I2S_Type) GetINT_CLR_V_SYNC_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20000) >> 17
}

// I2S.TIMING: I2S timing register
func (o *I2S_Type) SetTIMING_TX_BCK_IN_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x3)|value)
}
func (o *I2S_Type) GetTIMING_TX_BCK_IN_DELAY() uint32 {
	return volatile.LoadUint32(&o.TIMING.Reg) & 0x3
}
func (o *I2S_Type) SetTIMING_TX_WS_IN_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0xc)|value<<2)
}
func (o *I2S_Type) GetTIMING_TX_WS_IN_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0xc) >> 2
}
func (o *I2S_Type) SetTIMING_RX_BCK_IN_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x30)|value<<4)
}
func (o *I2S_Type) GetTIMING_RX_BCK_IN_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0x30) >> 4
}
func (o *I2S_Type) SetTIMING_RX_WS_IN_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0xc0)|value<<6)
}
func (o *I2S_Type) GetTIMING_RX_WS_IN_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0xc0) >> 6
}
func (o *I2S_Type) SetTIMING_RX_SD_IN_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x300)|value<<8)
}
func (o *I2S_Type) GetTIMING_RX_SD_IN_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0x300) >> 8
}
func (o *I2S_Type) SetTIMING_TX_BCK_OUT_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0xc00)|value<<10)
}
func (o *I2S_Type) GetTIMING_TX_BCK_OUT_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0xc00) >> 10
}
func (o *I2S_Type) SetTIMING_TX_WS_OUT_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x3000)|value<<12)
}
func (o *I2S_Type) GetTIMING_TX_WS_OUT_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0x3000) >> 12
}
func (o *I2S_Type) SetTIMING_TX_SD_OUT_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0xc000)|value<<14)
}
func (o *I2S_Type) GetTIMING_TX_SD_OUT_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0xc000) >> 14
}
func (o *I2S_Type) SetTIMING_RX_WS_OUT_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x30000)|value<<16)
}
func (o *I2S_Type) GetTIMING_RX_WS_OUT_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0x30000) >> 16
}
func (o *I2S_Type) SetTIMING_RX_BCK_OUT_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0xc0000)|value<<18)
}
func (o *I2S_Type) GetTIMING_RX_BCK_OUT_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0xc0000) >> 18
}
func (o *I2S_Type) SetTIMING_TX_DSYNC_SW(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x100000)|value<<20)
}
func (o *I2S_Type) GetTIMING_TX_DSYNC_SW() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0x100000) >> 20
}
func (o *I2S_Type) SetTIMING_RX_DSYNC_SW(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x200000)|value<<21)
}
func (o *I2S_Type) GetTIMING_RX_DSYNC_SW() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0x200000) >> 21
}
func (o *I2S_Type) SetTIMING_DATA_ENABLE_DELAY(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0xc00000)|value<<22)
}
func (o *I2S_Type) GetTIMING_DATA_ENABLE_DELAY() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0xc00000) >> 22
}
func (o *I2S_Type) SetTIMING_TX_BCK_IN_INV(value uint32) {
	volatile.StoreUint32(&o.TIMING.Reg, volatile.LoadUint32(&o.TIMING.Reg)&^(0x1000000)|value<<24)
}
func (o *I2S_Type) GetTIMING_TX_BCK_IN_INV() uint32 {
	return (volatile.LoadUint32(&o.TIMING.Reg) & 0x1000000) >> 24
}

// I2S.FIFO_CONF: I2S FIFO configuration register
func (o *I2S_Type) SetFIFO_CONF_RX_DATA_NUM(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x3f)|value)
}
func (o *I2S_Type) GetFIFO_CONF_RX_DATA_NUM() uint32 {
	return volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x3f
}
func (o *I2S_Type) SetFIFO_CONF_TX_DATA_NUM(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0xfc0)|value<<6)
}
func (o *I2S_Type) GetFIFO_CONF_TX_DATA_NUM() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0xfc0) >> 6
}
func (o *I2S_Type) SetFIFO_CONF_DSCR_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetFIFO_CONF_DSCR_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetFIFO_CONF_TX_FIFO_MOD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0xe000)|value<<13)
}
func (o *I2S_Type) GetFIFO_CONF_TX_FIFO_MOD() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0xe000) >> 13
}
func (o *I2S_Type) SetFIFO_CONF_RX_FIFO_MOD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x70000)|value<<16)
}
func (o *I2S_Type) GetFIFO_CONF_RX_FIFO_MOD() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x70000) >> 16
}
func (o *I2S_Type) SetFIFO_CONF_TX_FIFO_MOD_FORCE_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x80000)|value<<19)
}
func (o *I2S_Type) GetFIFO_CONF_TX_FIFO_MOD_FORCE_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x80000) >> 19
}
func (o *I2S_Type) SetFIFO_CONF_RX_FIFO_MOD_FORCE_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *I2S_Type) GetFIFO_CONF_RX_FIFO_MOD_FORCE_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x100000) >> 20
}
func (o *I2S_Type) SetFIFO_CONF_RX_FIFO_SYNC(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x200000)|value<<21)
}
func (o *I2S_Type) GetFIFO_CONF_RX_FIFO_SYNC() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x200000) >> 21
}
func (o *I2S_Type) SetFIFO_CONF_RX_24MSB_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x400000)|value<<22)
}
func (o *I2S_Type) GetFIFO_CONF_RX_24MSB_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x400000) >> 22
}
func (o *I2S_Type) SetFIFO_CONF_TX_24MSB_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x800000)|value<<23)
}
func (o *I2S_Type) GetFIFO_CONF_TX_24MSB_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x800000) >> 23
}

// I2S.RXEOF_NUM: I2S DMA RX EOF data length
func (o *I2S_Type) SetRXEOF_NUM(value uint32) {
	volatile.StoreUint32(&o.RXEOF_NUM.Reg, value)
}
func (o *I2S_Type) GetRXEOF_NUM() uint32 {
	return volatile.LoadUint32(&o.RXEOF_NUM.Reg)
}

// I2S.CONF_SIGLE_DATA: Constant single channel data
func (o *I2S_Type) SetCONF_SIGLE_DATA(value uint32) {
	volatile.StoreUint32(&o.CONF_SIGLE_DATA.Reg, value)
}
func (o *I2S_Type) GetCONF_SIGLE_DATA() uint32 {
	return volatile.LoadUint32(&o.CONF_SIGLE_DATA.Reg)
}

// I2S.CONF_CHAN: I2S channel configuration register
func (o *I2S_Type) SetCONF_CHAN_TX_CHAN_MOD(value uint32) {
	volatile.StoreUint32(&o.CONF_CHAN.Reg, volatile.LoadUint32(&o.CONF_CHAN.Reg)&^(0x7)|value)
}
func (o *I2S_Type) GetCONF_CHAN_TX_CHAN_MOD() uint32 {
	return volatile.LoadUint32(&o.CONF_CHAN.Reg) & 0x7
}
func (o *I2S_Type) SetCONF_CHAN_RX_CHAN_MOD(value uint32) {
	volatile.StoreUint32(&o.CONF_CHAN.Reg, volatile.LoadUint32(&o.CONF_CHAN.Reg)&^(0x18)|value<<3)
}
func (o *I2S_Type) GetCONF_CHAN_RX_CHAN_MOD() uint32 {
	return (volatile.LoadUint32(&o.CONF_CHAN.Reg) & 0x18) >> 3
}

// I2S.OUT_LINK: I2S DMA TX configuration register
func (o *I2S_Type) SetOUT_LINK_OUTLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK.Reg, volatile.LoadUint32(&o.OUT_LINK.Reg)&^(0xfffff)|value)
}
func (o *I2S_Type) GetOUT_LINK_OUTLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK.Reg) & 0xfffff
}
func (o *I2S_Type) SetOUT_LINK_OUTLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK.Reg, volatile.LoadUint32(&o.OUT_LINK.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S_Type) GetOUT_LINK_OUTLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK.Reg) & 0x10000000) >> 28
}
func (o *I2S_Type) SetOUT_LINK_OUTLINK_START(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK.Reg, volatile.LoadUint32(&o.OUT_LINK.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S_Type) GetOUT_LINK_OUTLINK_START() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK.Reg) & 0x20000000) >> 29
}
func (o *I2S_Type) SetOUT_LINK_OUTLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK.Reg, volatile.LoadUint32(&o.OUT_LINK.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S_Type) GetOUT_LINK_OUTLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK.Reg) & 0x40000000) >> 30
}
func (o *I2S_Type) SetOUT_LINK_OUTLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK.Reg, volatile.LoadUint32(&o.OUT_LINK.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetOUT_LINK_OUTLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK.Reg) & 0x80000000) >> 31
}

// I2S.IN_LINK: I2S DMA RX configuration register
func (o *I2S_Type) SetIN_LINK_INLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_LINK.Reg, volatile.LoadUint32(&o.IN_LINK.Reg)&^(0xfffff)|value)
}
func (o *I2S_Type) GetIN_LINK_INLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_LINK.Reg) & 0xfffff
}
func (o *I2S_Type) SetIN_LINK_INLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.IN_LINK.Reg, volatile.LoadUint32(&o.IN_LINK.Reg)&^(0x10000000)|value<<28)
}
func (o *I2S_Type) GetIN_LINK_INLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK.Reg) & 0x10000000) >> 28
}
func (o *I2S_Type) SetIN_LINK_INLINK_START(value uint32) {
	volatile.StoreUint32(&o.IN_LINK.Reg, volatile.LoadUint32(&o.IN_LINK.Reg)&^(0x20000000)|value<<29)
}
func (o *I2S_Type) GetIN_LINK_INLINK_START() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK.Reg) & 0x20000000) >> 29
}
func (o *I2S_Type) SetIN_LINK_INLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.IN_LINK.Reg, volatile.LoadUint32(&o.IN_LINK.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S_Type) GetIN_LINK_INLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK.Reg) & 0x40000000) >> 30
}
func (o *I2S_Type) SetIN_LINK_INLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.IN_LINK.Reg, volatile.LoadUint32(&o.IN_LINK.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetIN_LINK_INLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK.Reg) & 0x80000000) >> 31
}

// I2S.OUT_EOF_DES_ADDR: Address of outlink descriptor that produces EOF
func (o *I2S_Type) SetOUT_EOF_DES_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR.Reg, value)
}
func (o *I2S_Type) GetOUT_EOF_DES_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR.Reg)
}

// I2S.IN_EOF_DES_ADDR: Address of inlink descriptor that produces EOF
func (o *I2S_Type) SetIN_EOF_DES_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_EOF_DES_ADDR.Reg, value)
}
func (o *I2S_Type) GetIN_EOF_DES_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_EOF_DES_ADDR.Reg)
}

// I2S.OUT_EOF_BFR_DES_ADDR: Address of buffer relative to the outlink descriptor that produces EOF
func (o *I2S_Type) SetOUT_EOF_BFR_DES_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR.Reg, value)
}
func (o *I2S_Type) GetOUT_EOF_BFR_DES_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR.Reg)
}

// I2S.INLINK_DSCR: Address of current inlink descriptor
func (o *I2S_Type) SetINLINK_DSCR(value uint32) {
	volatile.StoreUint32(&o.INLINK_DSCR.Reg, value)
}
func (o *I2S_Type) GetINLINK_DSCR() uint32 {
	return volatile.LoadUint32(&o.INLINK_DSCR.Reg)
}

// I2S.INLINK_DSCR_BF0: Address of next inlink descriptor
func (o *I2S_Type) SetINLINK_DSCR_BF0(value uint32) {
	volatile.StoreUint32(&o.INLINK_DSCR_BF0.Reg, value)
}
func (o *I2S_Type) GetINLINK_DSCR_BF0() uint32 {
	return volatile.LoadUint32(&o.INLINK_DSCR_BF0.Reg)
}

// I2S.INLINK_DSCR_BF1: Address of next inlink data buffer
func (o *I2S_Type) SetINLINK_DSCR_BF1(value uint32) {
	volatile.StoreUint32(&o.INLINK_DSCR_BF1.Reg, value)
}
func (o *I2S_Type) GetINLINK_DSCR_BF1() uint32 {
	return volatile.LoadUint32(&o.INLINK_DSCR_BF1.Reg)
}

// I2S.OUTLINK_DSCR: Address of current outlink descriptor
func (o *I2S_Type) SetOUTLINK_DSCR(value uint32) {
	volatile.StoreUint32(&o.OUTLINK_DSCR.Reg, value)
}
func (o *I2S_Type) GetOUTLINK_DSCR() uint32 {
	return volatile.LoadUint32(&o.OUTLINK_DSCR.Reg)
}

// I2S.OUTLINK_DSCR_BF0: Address of next outlink descriptor
func (o *I2S_Type) SetOUTLINK_DSCR_BF0(value uint32) {
	volatile.StoreUint32(&o.OUTLINK_DSCR_BF0.Reg, value)
}
func (o *I2S_Type) GetOUTLINK_DSCR_BF0() uint32 {
	return volatile.LoadUint32(&o.OUTLINK_DSCR_BF0.Reg)
}

// I2S.OUTLINK_DSCR_BF1: Address of next outlink data buffer
func (o *I2S_Type) SetOUTLINK_DSCR_BF1(value uint32) {
	volatile.StoreUint32(&o.OUTLINK_DSCR_BF1.Reg, value)
}
func (o *I2S_Type) GetOUTLINK_DSCR_BF1() uint32 {
	return volatile.LoadUint32(&o.OUTLINK_DSCR_BF1.Reg)
}

// I2S.LC_CONF: I2S DMA configuration register
func (o *I2S_Type) SetLC_CONF_IN_RST(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetLC_CONF_IN_RST() uint32 {
	return volatile.LoadUint32(&o.LC_CONF.Reg) & 0x1
}
func (o *I2S_Type) SetLC_CONF_OUT_RST(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetLC_CONF_OUT_RST() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetLC_CONF_AHBM_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetLC_CONF_AHBM_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetLC_CONF_AHBM_RST(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetLC_CONF_AHBM_RST() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetLC_CONF_OUT_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetLC_CONF_OUT_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetLC_CONF_IN_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetLC_CONF_IN_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetLC_CONF_OUT_AUTO_WRBACK(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetLC_CONF_OUT_AUTO_WRBACK() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetLC_CONF_OUT_NO_RESTART_CLR(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetLC_CONF_OUT_NO_RESTART_CLR() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetLC_CONF_OUT_EOF_MODE(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetLC_CONF_OUT_EOF_MODE() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetLC_CONF_OUTDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetLC_CONF_OUTDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetLC_CONF_INDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetLC_CONF_INDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetLC_CONF_OUT_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetLC_CONF_OUT_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x800) >> 11
}
func (o *I2S_Type) SetLC_CONF_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *I2S_Type) GetLC_CONF_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x1000) >> 12
}
func (o *I2S_Type) SetLC_CONF_MEM_TRANS_EN(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *I2S_Type) GetLC_CONF_MEM_TRANS_EN() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0x2000) >> 13
}
func (o *I2S_Type) SetLC_CONF_EXT_MEM_BK_SIZE(value uint32) {
	volatile.StoreUint32(&o.LC_CONF.Reg, volatile.LoadUint32(&o.LC_CONF.Reg)&^(0xc000)|value<<14)
}
func (o *I2S_Type) GetLC_CONF_EXT_MEM_BK_SIZE() uint32 {
	return (volatile.LoadUint32(&o.LC_CONF.Reg) & 0xc000) >> 14
}

// I2S.OUTFIFO_PUSH: APB out FIFO mode register
func (o *I2S_Type) SetOUTFIFO_PUSH_OUTFIFO_WDATA(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_PUSH.Reg, volatile.LoadUint32(&o.OUTFIFO_PUSH.Reg)&^(0x1ff)|value)
}
func (o *I2S_Type) GetOUTFIFO_PUSH_OUTFIFO_WDATA() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_PUSH.Reg) & 0x1ff
}
func (o *I2S_Type) SetOUTFIFO_PUSH(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_PUSH.Reg, volatile.LoadUint32(&o.OUTFIFO_PUSH.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetOUTFIFO_PUSH() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_PUSH.Reg) & 0x10000) >> 16
}

// I2S.INFIFO_POP: APB in FIFO mode register
func (o *I2S_Type) SetINFIFO_POP_INFIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.INFIFO_POP.Reg, volatile.LoadUint32(&o.INFIFO_POP.Reg)&^(0xfff)|value)
}
func (o *I2S_Type) GetINFIFO_POP_INFIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.INFIFO_POP.Reg) & 0xfff
}
func (o *I2S_Type) SetINFIFO_POP(value uint32) {
	volatile.StoreUint32(&o.INFIFO_POP.Reg, volatile.LoadUint32(&o.INFIFO_POP.Reg)&^(0x10000)|value<<16)
}
func (o *I2S_Type) GetINFIFO_POP() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_POP.Reg) & 0x10000) >> 16
}

// I2S.LC_STATE0: I2S DMA TX status
func (o *I2S_Type) SetLC_STATE0_OUTLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.LC_STATE0.Reg, volatile.LoadUint32(&o.LC_STATE0.Reg)&^(0x3ffff)|value)
}
func (o *I2S_Type) GetLC_STATE0_OUTLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.LC_STATE0.Reg) & 0x3ffff
}
func (o *I2S_Type) SetLC_STATE0_OUT_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.LC_STATE0.Reg, volatile.LoadUint32(&o.LC_STATE0.Reg)&^(0xc0000)|value<<18)
}
func (o *I2S_Type) GetLC_STATE0_OUT_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.LC_STATE0.Reg) & 0xc0000) >> 18
}
func (o *I2S_Type) SetLC_STATE0_OUT_STATE(value uint32) {
	volatile.StoreUint32(&o.LC_STATE0.Reg, volatile.LoadUint32(&o.LC_STATE0.Reg)&^(0x700000)|value<<20)
}
func (o *I2S_Type) GetLC_STATE0_OUT_STATE() uint32 {
	return (volatile.LoadUint32(&o.LC_STATE0.Reg) & 0x700000) >> 20
}
func (o *I2S_Type) SetLC_STATE0_OUTFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.LC_STATE0.Reg, volatile.LoadUint32(&o.LC_STATE0.Reg)&^(0x3f800000)|value<<23)
}
func (o *I2S_Type) GetLC_STATE0_OUTFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.LC_STATE0.Reg) & 0x3f800000) >> 23
}
func (o *I2S_Type) SetLC_STATE0_OUT_FULL(value uint32) {
	volatile.StoreUint32(&o.LC_STATE0.Reg, volatile.LoadUint32(&o.LC_STATE0.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S_Type) GetLC_STATE0_OUT_FULL() uint32 {
	return (volatile.LoadUint32(&o.LC_STATE0.Reg) & 0x40000000) >> 30
}
func (o *I2S_Type) SetLC_STATE0_OUT_EMPTY(value uint32) {
	volatile.StoreUint32(&o.LC_STATE0.Reg, volatile.LoadUint32(&o.LC_STATE0.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetLC_STATE0_OUT_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.LC_STATE0.Reg) & 0x80000000) >> 31
}

// I2S.LC_STATE1: I2S DMA RX status
func (o *I2S_Type) SetLC_STATE1_INLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.LC_STATE1.Reg, volatile.LoadUint32(&o.LC_STATE1.Reg)&^(0x3ffff)|value)
}
func (o *I2S_Type) GetLC_STATE1_INLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.LC_STATE1.Reg) & 0x3ffff
}
func (o *I2S_Type) SetLC_STATE1_IN_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.LC_STATE1.Reg, volatile.LoadUint32(&o.LC_STATE1.Reg)&^(0xc0000)|value<<18)
}
func (o *I2S_Type) GetLC_STATE1_IN_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.LC_STATE1.Reg) & 0xc0000) >> 18
}
func (o *I2S_Type) SetLC_STATE1_IN_STATE(value uint32) {
	volatile.StoreUint32(&o.LC_STATE1.Reg, volatile.LoadUint32(&o.LC_STATE1.Reg)&^(0x700000)|value<<20)
}
func (o *I2S_Type) GetLC_STATE1_IN_STATE() uint32 {
	return (volatile.LoadUint32(&o.LC_STATE1.Reg) & 0x700000) >> 20
}
func (o *I2S_Type) SetLC_STATE1_INFIFO_CNT_DEBUG(value uint32) {
	volatile.StoreUint32(&o.LC_STATE1.Reg, volatile.LoadUint32(&o.LC_STATE1.Reg)&^(0x3f800000)|value<<23)
}
func (o *I2S_Type) GetLC_STATE1_INFIFO_CNT_DEBUG() uint32 {
	return (volatile.LoadUint32(&o.LC_STATE1.Reg) & 0x3f800000) >> 23
}
func (o *I2S_Type) SetLC_STATE1_IN_FULL(value uint32) {
	volatile.StoreUint32(&o.LC_STATE1.Reg, volatile.LoadUint32(&o.LC_STATE1.Reg)&^(0x40000000)|value<<30)
}
func (o *I2S_Type) GetLC_STATE1_IN_FULL() uint32 {
	return (volatile.LoadUint32(&o.LC_STATE1.Reg) & 0x40000000) >> 30
}
func (o *I2S_Type) SetLC_STATE1_IN_EMPTY(value uint32) {
	volatile.StoreUint32(&o.LC_STATE1.Reg, volatile.LoadUint32(&o.LC_STATE1.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_Type) GetLC_STATE1_IN_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.LC_STATE1.Reg) & 0x80000000) >> 31
}

// I2S.LC_HUNG_CONF: I2S Hung configuration register
func (o *I2S_Type) SetLC_HUNG_CONF_LC_FIFO_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.LC_HUNG_CONF.Reg, volatile.LoadUint32(&o.LC_HUNG_CONF.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetLC_HUNG_CONF_LC_FIFO_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.LC_HUNG_CONF.Reg) & 0xff
}
func (o *I2S_Type) SetLC_HUNG_CONF_LC_FIFO_TIMEOUT_SHIFT(value uint32) {
	volatile.StoreUint32(&o.LC_HUNG_CONF.Reg, volatile.LoadUint32(&o.LC_HUNG_CONF.Reg)&^(0x700)|value<<8)
}
func (o *I2S_Type) GetLC_HUNG_CONF_LC_FIFO_TIMEOUT_SHIFT() uint32 {
	return (volatile.LoadUint32(&o.LC_HUNG_CONF.Reg) & 0x700) >> 8
}
func (o *I2S_Type) SetLC_HUNG_CONF_LC_FIFO_TIMEOUT_ENA(value uint32) {
	volatile.StoreUint32(&o.LC_HUNG_CONF.Reg, volatile.LoadUint32(&o.LC_HUNG_CONF.Reg)&^(0x800)|value<<11)
}
func (o *I2S_Type) GetLC_HUNG_CONF_LC_FIFO_TIMEOUT_ENA() uint32 {
	return (volatile.LoadUint32(&o.LC_HUNG_CONF.Reg) & 0x800) >> 11
}

// I2S.CONF1: I2S configuration register 1
func (o *I2S_Type) SetCONF1_TX_PCM_CONF(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x7)|value)
}
func (o *I2S_Type) GetCONF1_TX_PCM_CONF() uint32 {
	return volatile.LoadUint32(&o.CONF1.Reg) & 0x7
}
func (o *I2S_Type) SetCONF1_TX_PCM_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetCONF1_TX_PCM_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetCONF1_RX_PCM_CONF(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x70)|value<<4)
}
func (o *I2S_Type) GetCONF1_RX_PCM_CONF() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x70) >> 4
}
func (o *I2S_Type) SetCONF1_RX_PCM_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetCONF1_RX_PCM_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetCONF1_TX_STOP_EN(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetCONF1_TX_STOP_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetCONF1_TX_ZEROS_RM_EN(value uint32) {
	volatile.StoreUint32(&o.CONF1.Reg, volatile.LoadUint32(&o.CONF1.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetCONF1_TX_ZEROS_RM_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF1.Reg) & 0x200) >> 9
}

// I2S.PD_CONF: I2S power-down configuration register
func (o *I2S_Type) SetPD_CONF_FIFO_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.PD_CONF.Reg, volatile.LoadUint32(&o.PD_CONF.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetPD_CONF_FIFO_FORCE_PD() uint32 {
	return volatile.LoadUint32(&o.PD_CONF.Reg) & 0x1
}
func (o *I2S_Type) SetPD_CONF_FIFO_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.PD_CONF.Reg, volatile.LoadUint32(&o.PD_CONF.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetPD_CONF_FIFO_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.PD_CONF.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetPD_CONF_PLC_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.PD_CONF.Reg, volatile.LoadUint32(&o.PD_CONF.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetPD_CONF_PLC_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.PD_CONF.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetPD_CONF_PLC_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.PD_CONF.Reg, volatile.LoadUint32(&o.PD_CONF.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetPD_CONF_PLC_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.PD_CONF.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetPD_CONF_DMA_RAM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.PD_CONF.Reg, volatile.LoadUint32(&o.PD_CONF.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetPD_CONF_DMA_RAM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.PD_CONF.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetPD_CONF_DMA_RAM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.PD_CONF.Reg, volatile.LoadUint32(&o.PD_CONF.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetPD_CONF_DMA_RAM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.PD_CONF.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetPD_CONF_DMA_RAM_CLK_FO(value uint32) {
	volatile.StoreUint32(&o.PD_CONF.Reg, volatile.LoadUint32(&o.PD_CONF.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetPD_CONF_DMA_RAM_CLK_FO() uint32 {
	return (volatile.LoadUint32(&o.PD_CONF.Reg) & 0x40) >> 6
}

// I2S.CONF2: I2S configuration register 2
func (o *I2S_Type) SetCONF2_CAMERA_EN(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetCONF2_CAMERA_EN() uint32 {
	return volatile.LoadUint32(&o.CONF2.Reg) & 0x1
}
func (o *I2S_Type) SetCONF2_LCD_TX_WRX2_EN(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetCONF2_LCD_TX_WRX2_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetCONF2_LCD_TX_SDX2_EN(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetCONF2_LCD_TX_SDX2_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetCONF2_DATA_ENABLE_TEST_EN(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetCONF2_DATA_ENABLE_TEST_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetCONF2_DATA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetCONF2_DATA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetCONF2_LCD_EN(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetCONF2_LCD_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetCONF2_EXT_ADC_START_EN(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x40)|value<<6)
}
func (o *I2S_Type) GetCONF2_EXT_ADC_START_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x40) >> 6
}
func (o *I2S_Type) SetCONF2_INTER_VALID_EN(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x80)|value<<7)
}
func (o *I2S_Type) GetCONF2_INTER_VALID_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x80) >> 7
}
func (o *I2S_Type) SetCONF2_CAM_SYNC_FIFO_RESET(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x100)|value<<8)
}
func (o *I2S_Type) GetCONF2_CAM_SYNC_FIFO_RESET() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x100) >> 8
}
func (o *I2S_Type) SetCONF2_CAM_CLK_LOOPBACK(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x200)|value<<9)
}
func (o *I2S_Type) GetCONF2_CAM_CLK_LOOPBACK() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x200) >> 9
}
func (o *I2S_Type) SetCONF2_VSYNC_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x400)|value<<10)
}
func (o *I2S_Type) GetCONF2_VSYNC_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x400) >> 10
}
func (o *I2S_Type) SetCONF2_VSYNC_FILTER_THRES(value uint32) {
	volatile.StoreUint32(&o.CONF2.Reg, volatile.LoadUint32(&o.CONF2.Reg)&^(0x3800)|value<<11)
}
func (o *I2S_Type) GetCONF2_VSYNC_FILTER_THRES() uint32 {
	return (volatile.LoadUint32(&o.CONF2.Reg) & 0x3800) >> 11
}

// I2S.CLKM_CONF: I2S module clock configuration register
func (o *I2S_Type) SetCLKM_CONF_CLKM_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetCLKM_CONF_CLKM_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0xff
}
func (o *I2S_Type) SetCLKM_CONF_CLKM_DIV_B(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x3f00)|value<<8)
}
func (o *I2S_Type) GetCLKM_CONF_CLKM_DIV_B() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x3f00) >> 8
}
func (o *I2S_Type) SetCLKM_CONF_CLKM_DIV_A(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0xfc000)|value<<14)
}
func (o *I2S_Type) GetCLKM_CONF_CLKM_DIV_A() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0xfc000) >> 14
}
func (o *I2S_Type) SetCLKM_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *I2S_Type) GetCLKM_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x100000) >> 20
}
func (o *I2S_Type) SetCLKM_CONF_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x600000)|value<<21)
}
func (o *I2S_Type) GetCLKM_CONF_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x600000) >> 21
}

// I2S.SAMPLE_RATE_CONF: I2S sample rate register
func (o *I2S_Type) SetSAMPLE_RATE_CONF_TX_BCK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_RATE_CONF.Reg, volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg)&^(0x3f)|value)
}
func (o *I2S_Type) GetSAMPLE_RATE_CONF_TX_BCK_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg) & 0x3f
}
func (o *I2S_Type) SetSAMPLE_RATE_CONF_RX_BCK_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_RATE_CONF.Reg, volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg)&^(0xfc0)|value<<6)
}
func (o *I2S_Type) GetSAMPLE_RATE_CONF_RX_BCK_DIV_NUM() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg) & 0xfc0) >> 6
}
func (o *I2S_Type) SetSAMPLE_RATE_CONF_TX_BITS_MOD(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_RATE_CONF.Reg, volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg)&^(0x3f000)|value<<12)
}
func (o *I2S_Type) GetSAMPLE_RATE_CONF_TX_BITS_MOD() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg) & 0x3f000) >> 12
}
func (o *I2S_Type) SetSAMPLE_RATE_CONF_RX_BITS_MOD(value uint32) {
	volatile.StoreUint32(&o.SAMPLE_RATE_CONF.Reg, volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg)&^(0xfc0000)|value<<18)
}
func (o *I2S_Type) GetSAMPLE_RATE_CONF_RX_BITS_MOD() uint32 {
	return (volatile.LoadUint32(&o.SAMPLE_RATE_CONF.Reg) & 0xfc0000) >> 18
}

// I2S.STATE: I2S TX status register
func (o *I2S_Type) SetSTATE_TX_IDLE(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetSTATE_TX_IDLE() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0x1
}

// I2S.DATE: Version control register
func (o *I2S_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *I2S_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// Interrupt Controller (Core 0)
type INTERRUPT_CORE0_Type struct {
	PRO_MAC_INTR_MAP               volatile.Register32 // 0x0
	PRO_MAC_NMI_MAP                volatile.Register32 // 0x4
	PRO_PWR_INTR_MAP               volatile.Register32 // 0x8
	PRO_BB_INT_MAP                 volatile.Register32 // 0xC
	PRO_BT_MAC_INT_MAP             volatile.Register32 // 0x10
	PRO_BT_BB_INT_MAP              volatile.Register32 // 0x14
	PRO_BT_BB_NMI_MAP              volatile.Register32 // 0x18
	PRO_RWBT_IRQ_MAP               volatile.Register32 // 0x1C
	PRO_RWBLE_IRQ_MAP              volatile.Register32 // 0x20
	PRO_RWBT_NMI_MAP               volatile.Register32 // 0x24
	PRO_RWBLE_NMI_MAP              volatile.Register32 // 0x28
	PRO_SLC0_INTR_MAP              volatile.Register32 // 0x2C
	PRO_SLC1_INTR_MAP              volatile.Register32 // 0x30
	PRO_UHCI0_INTR_MAP             volatile.Register32 // 0x34
	PRO_UHCI1_INTR_MAP             volatile.Register32 // 0x38
	PRO_TG_T0_LEVEL_INT_MAP        volatile.Register32 // 0x3C
	PRO_TG_T1_LEVEL_INT_MAP        volatile.Register32 // 0x40
	PRO_TG_WDT_LEVEL_INT_MAP       volatile.Register32 // 0x44
	PRO_TG_LACT_LEVEL_INT_MAP      volatile.Register32 // 0x48
	PRO_TG1_T0_LEVEL_INT_MAP       volatile.Register32 // 0x4C
	PRO_TG1_T1_LEVEL_INT_MAP       volatile.Register32 // 0x50
	PRO_TG1_WDT_LEVEL_INT_MAP      volatile.Register32 // 0x54
	PRO_TG1_LACT_LEVEL_INT_MAP     volatile.Register32 // 0x58
	PRO_GPIO_INTERRUPT_PRO_MAP     volatile.Register32 // 0x5C
	PRO_GPIO_INTERRUPT_PRO_NMI_MAP volatile.Register32 // 0x60
	PRO_GPIO_INTERRUPT_APP_MAP     volatile.Register32 // 0x64
	PRO_GPIO_INTERRUPT_APP_NMI_MAP volatile.Register32 // 0x68
	PRO_DEDICATED_GPIO_IN_INTR_MAP volatile.Register32 // 0x6C
	PRO_CPU_INTR_FROM_CPU_0_MAP    volatile.Register32 // 0x70
	PRO_CPU_INTR_FROM_CPU_1_MAP    volatile.Register32 // 0x74
	PRO_CPU_INTR_FROM_CPU_2_MAP    volatile.Register32 // 0x78
	PRO_CPU_INTR_FROM_CPU_3_MAP    volatile.Register32 // 0x7C
	PRO_SPI_INTR_1_MAP             volatile.Register32 // 0x80
	PRO_SPI_INTR_2_MAP             volatile.Register32 // 0x84
	PRO_SPI_INTR_3_MAP             volatile.Register32 // 0x88
	PRO_I2S0_INT_MAP               volatile.Register32 // 0x8C
	PRO_I2S1_INT_MAP               volatile.Register32 // 0x90
	PRO_UART_INTR_MAP              volatile.Register32 // 0x94
	PRO_UART1_INTR_MAP             volatile.Register32 // 0x98
	PRO_UART2_INTR_MAP             volatile.Register32 // 0x9C
	PRO_SDIO_HOST_INTERRUPT_MAP    volatile.Register32 // 0xA0
	PRO_PWM0_INTR_MAP              volatile.Register32 // 0xA4
	PRO_PWM1_INTR_MAP              volatile.Register32 // 0xA8
	PRO_PWM2_INTR_MAP              volatile.Register32 // 0xAC
	PRO_PWM3_INTR_MAP              volatile.Register32 // 0xB0
	PRO_LEDC_INT_MAP               volatile.Register32 // 0xB4
	PRO_EFUSE_INT_MAP              volatile.Register32 // 0xB8
	PRO_CAN_INT_MAP                volatile.Register32 // 0xBC
	PRO_USB_INTR_MAP               volatile.Register32 // 0xC0
	PRO_RTC_CORE_INTR_MAP          volatile.Register32 // 0xC4
	PRO_RMT_INTR_MAP               volatile.Register32 // 0xC8
	PRO_PCNT_INTR_MAP              volatile.Register32 // 0xCC
	PRO_I2C_EXT0_INTR_MAP          volatile.Register32 // 0xD0
	PRO_I2C_EXT1_INTR_MAP          volatile.Register32 // 0xD4
	PRO_RSA_INTR_MAP               volatile.Register32 // 0xD8
	PRO_SHA_INTR_MAP               volatile.Register32 // 0xDC
	PRO_AES_INTR_MAP               volatile.Register32 // 0xE0
	PRO_SPI2_DMA_INT_MAP           volatile.Register32 // 0xE4
	PRO_SPI3_DMA_INT_MAP           volatile.Register32 // 0xE8
	PRO_WDG_INT_MAP                volatile.Register32 // 0xEC
	PRO_TIMER_INT1_MAP             volatile.Register32 // 0xF0
	PRO_TIMER_INT2_MAP             volatile.Register32 // 0xF4
	PRO_TG_T0_EDGE_INT_MAP         volatile.Register32 // 0xF8
	PRO_TG_T1_EDGE_INT_MAP         volatile.Register32 // 0xFC
	PRO_TG_WDT_EDGE_INT_MAP        volatile.Register32 // 0x100
	PRO_TG_LACT_EDGE_INT_MAP       volatile.Register32 // 0x104
	PRO_TG1_T0_EDGE_INT_MAP        volatile.Register32 // 0x108
	PRO_TG1_T1_EDGE_INT_MAP        volatile.Register32 // 0x10C
	PRO_TG1_WDT_EDGE_INT_MAP       volatile.Register32 // 0x110
	PRO_TG1_LACT_EDGE_INT_MAP      volatile.Register32 // 0x114
	PRO_CACHE_IA_INT_MAP           volatile.Register32 // 0x118
	PRO_SYSTIMER_TARGET0_INT_MAP   volatile.Register32 // 0x11C
	PRO_SYSTIMER_TARGET1_INT_MAP   volatile.Register32 // 0x120
	PRO_SYSTIMER_TARGET2_INT_MAP   volatile.Register32 // 0x124
	PRO_ASSIST_DEBUG_INTR_MAP      volatile.Register32 // 0x128
	PRO_PMS_PRO_IRAM0_ILG_INTR_MAP volatile.Register32 // 0x12C
	PRO_PMS_PRO_DRAM0_ILG_INTR_MAP volatile.Register32 // 0x130
	PRO_PMS_PRO_DPORT_ILG_INTR_MAP volatile.Register32 // 0x134
	PRO_PMS_PRO_AHB_ILG_INTR_MAP   volatile.Register32 // 0x138
	PRO_PMS_PRO_CACHE_ILG_INTR_MAP volatile.Register32 // 0x13C
	PRO_PMS_DMA_APB_I_ILG_INTR_MAP volatile.Register32 // 0x140
	PRO_PMS_DMA_RX_I_ILG_INTR_MAP  volatile.Register32 // 0x144
	PRO_PMS_DMA_TX_I_ILG_INTR_MAP  volatile.Register32 // 0x148
	PRO_SPI_MEM_REJECT_INTR_MAP    volatile.Register32 // 0x14C
	PRO_DMA_COPY_INTR_MAP          volatile.Register32 // 0x150
	PRO_SPI4_DMA_INT_MAP           volatile.Register32 // 0x154
	PRO_SPI_INTR_4_MAP             volatile.Register32 // 0x158
	PRO_DCACHE_PRELOAD_INT_MAP     volatile.Register32 // 0x15C
	PRO_ICACHE_PRELOAD_INT_MAP     volatile.Register32 // 0x160
	PRO_APB_ADC_INT_MAP            volatile.Register32 // 0x164
	PRO_CRYPTO_DMA_INT_MAP         volatile.Register32 // 0x168
	PRO_CPU_PERI_ERROR_INT_MAP     volatile.Register32 // 0x16C
	PRO_APB_PERI_ERROR_INT_MAP     volatile.Register32 // 0x170
	PRO_DCACHE_SYNC_INT_MAP        volatile.Register32 // 0x174
	PRO_ICACHE_SYNC_INT_MAP        volatile.Register32 // 0x178
	PRO_INTR_STATUS_0              volatile.Register32 // 0x17C
	PRO_INTR_STATUS_1              volatile.Register32 // 0x180
	PRO_INTR_STATUS_2              volatile.Register32 // 0x184
	CLOCK_GATE                     volatile.Register32 // 0x188
	_                              [3696]byte
	REG_DATE                       volatile.Register32 // 0xFFC
}

// INTERRUPT_CORE0.PRO_MAC_INTR_MAP: MAC_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_MAC_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_MAC_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_MAC_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_MAC_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_MAC_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_MAC_NMI_MAP: MAC_NMI interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_MAC_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_MAC_NMI_MAP.Reg, volatile.LoadUint32(&o.PRO_MAC_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_MAC_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_MAC_NMI_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_PWR_INTR_MAP: PWR_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_PWR_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PWR_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PWR_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_PWR_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PWR_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_BB_INT_MAP: BB_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_BB_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_BB_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_BB_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_BB_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_BB_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_BT_MAC_INT_MAP: BT_MAC_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_BT_MAC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_BT_MAC_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_BT_MAC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_BT_MAC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_BT_MAC_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_BT_BB_INT_MAP: BT_BB_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_BT_BB_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_BT_BB_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_BT_BB_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_BT_BB_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_BT_BB_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_BT_BB_NMI_MAP: BT_BB_NMI interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_BT_BB_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_BT_BB_NMI_MAP.Reg, volatile.LoadUint32(&o.PRO_BT_BB_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_BT_BB_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_BT_BB_NMI_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_RWBT_IRQ_MAP: RWBT_IRQ interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_RWBT_IRQ_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_RWBT_IRQ_MAP.Reg, volatile.LoadUint32(&o.PRO_RWBT_IRQ_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_RWBT_IRQ_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_RWBT_IRQ_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_RWBLE_IRQ_MAP: RWBLE_IRQ interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_RWBLE_IRQ_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_RWBLE_IRQ_MAP.Reg, volatile.LoadUint32(&o.PRO_RWBLE_IRQ_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_RWBLE_IRQ_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_RWBLE_IRQ_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_RWBT_NMI_MAP: RWBT_NMI interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_RWBT_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_RWBT_NMI_MAP.Reg, volatile.LoadUint32(&o.PRO_RWBT_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_RWBT_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_RWBT_NMI_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_RWBLE_NMI_MAP: RWBLE_NMI interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_RWBLE_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_RWBLE_NMI_MAP.Reg, volatile.LoadUint32(&o.PRO_RWBLE_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_RWBLE_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_RWBLE_NMI_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_SLC0_INTR_MAP: SLC0_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_SLC0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SLC0_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_SLC0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_SLC0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SLC0_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_SLC1_INTR_MAP: SLC1_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_SLC1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SLC1_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_SLC1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_SLC1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SLC1_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_UHCI0_INTR_MAP: UHCI0_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_UHCI0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_UHCI0_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_UHCI0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_UHCI0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_UHCI0_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_UHCI1_INTR_MAP: UHCI1_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_UHCI1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_UHCI1_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_UHCI1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_UHCI1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_UHCI1_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG_T0_LEVEL_INT_MAP: TG_T0_LEVEL_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG_T0_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_T0_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_T0_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG_T0_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_T0_LEVEL_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG_T1_LEVEL_INT_MAP: TG_T1_LEVEL_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG_T1_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_T1_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_T1_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG_T1_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_T1_LEVEL_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG_WDT_LEVEL_INT_MAP: TG_WDT_LEVEL_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG_WDT_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_WDT_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_WDT_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG_WDT_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_WDT_LEVEL_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG_LACT_LEVEL_INT_MAP: TG_LACT_LEVEL_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG_LACT_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_LACT_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_LACT_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG_LACT_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_LACT_LEVEL_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG1_T0_LEVEL_INT_MAP: TG1_T0_LEVEL_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG1_T0_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_T0_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_T0_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG1_T0_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_T0_LEVEL_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG1_T1_LEVEL_INT_MAP: TG1_T1_LEVEL_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG1_T1_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_T1_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_T1_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG1_T1_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_T1_LEVEL_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG1_WDT_LEVEL_INT_MAP: TG1_WDT_LEVEL_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG1_WDT_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_WDT_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_WDT_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG1_WDT_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_WDT_LEVEL_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG1_LACT_LEVEL_INT_MAP: TG1_LACT_LEVEL_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG1_LACT_LEVEL_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_LACT_LEVEL_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_LACT_LEVEL_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG1_LACT_LEVEL_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_LACT_LEVEL_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_GPIO_INTERRUPT_PRO_MAP: GPIO_INTERRUPT_PRO interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_GPIO_INTERRUPT_PRO_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_GPIO_INTERRUPT_PRO_MAP.Reg, volatile.LoadUint32(&o.PRO_GPIO_INTERRUPT_PRO_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_GPIO_INTERRUPT_PRO_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_GPIO_INTERRUPT_PRO_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_GPIO_INTERRUPT_PRO_NMI_MAP: GPIO_INTERRUPT_PRO_NMI interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_GPIO_INTERRUPT_PRO_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_GPIO_INTERRUPT_PRO_NMI_MAP.Reg, volatile.LoadUint32(&o.PRO_GPIO_INTERRUPT_PRO_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_GPIO_INTERRUPT_PRO_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_GPIO_INTERRUPT_PRO_NMI_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_GPIO_INTERRUPT_APP_MAP: GPIO_INTERRUPT_APP interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_GPIO_INTERRUPT_APP_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_GPIO_INTERRUPT_APP_MAP.Reg, volatile.LoadUint32(&o.PRO_GPIO_INTERRUPT_APP_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_GPIO_INTERRUPT_APP_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_GPIO_INTERRUPT_APP_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_GPIO_INTERRUPT_APP_NMI_MAP: GPIO_INTERRUPT_APP_NMI interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_GPIO_INTERRUPT_APP_NMI_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_GPIO_INTERRUPT_APP_NMI_MAP.Reg, volatile.LoadUint32(&o.PRO_GPIO_INTERRUPT_APP_NMI_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_GPIO_INTERRUPT_APP_NMI_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_GPIO_INTERRUPT_APP_NMI_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_DEDICATED_GPIO_IN_INTR_MAP: DEDICATED_GPIO_IN_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_DEDICATED_GPIO_IN_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_DEDICATED_GPIO_IN_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_DEDICATED_GPIO_IN_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_DEDICATED_GPIO_IN_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_DEDICATED_GPIO_IN_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_CPU_INTR_FROM_CPU_0_MAP: CPU_INTR_FROM_CPU_0 interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_CPU_INTR_FROM_CPU_0_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_INTR_FROM_CPU_0_MAP.Reg, volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_0_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_CPU_INTR_FROM_CPU_0_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_0_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_CPU_INTR_FROM_CPU_1_MAP: CPU_INTR_FROM_CPU_1 interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_CPU_INTR_FROM_CPU_1_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_INTR_FROM_CPU_1_MAP.Reg, volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_1_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_CPU_INTR_FROM_CPU_1_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_1_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_CPU_INTR_FROM_CPU_2_MAP: CPU_INTR_FROM_CPU_2 interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_CPU_INTR_FROM_CPU_2_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_INTR_FROM_CPU_2_MAP.Reg, volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_2_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_CPU_INTR_FROM_CPU_2_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_2_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_CPU_INTR_FROM_CPU_3_MAP: CPU_INTR_FROM_CPU_3 interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_CPU_INTR_FROM_CPU_3_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_INTR_FROM_CPU_3_MAP.Reg, volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_3_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_CPU_INTR_FROM_CPU_3_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_INTR_FROM_CPU_3_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_SPI_INTR_1_MAP: SPI_INTR_1 interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_SPI_INTR_1_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SPI_INTR_1_MAP.Reg, volatile.LoadUint32(&o.PRO_SPI_INTR_1_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_SPI_INTR_1_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SPI_INTR_1_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_SPI_INTR_2_MAP: SPI_INTR_2 interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_SPI_INTR_2_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SPI_INTR_2_MAP.Reg, volatile.LoadUint32(&o.PRO_SPI_INTR_2_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_SPI_INTR_2_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SPI_INTR_2_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_SPI_INTR_3_MAP: SPI_INTR_3 interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_SPI_INTR_3_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SPI_INTR_3_MAP.Reg, volatile.LoadUint32(&o.PRO_SPI_INTR_3_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_SPI_INTR_3_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SPI_INTR_3_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_I2S0_INT_MAP: I2S0_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_I2S0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_I2S0_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_I2S0_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_I2S0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_I2S0_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_I2S1_INT_MAP: I2S1_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_I2S1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_I2S1_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_I2S1_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_I2S1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_I2S1_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_UART_INTR_MAP: UART_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_UART_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_UART_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_UART_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_UART_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_UART_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_UART1_INTR_MAP: UART1_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_UART1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_UART1_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_UART1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_UART1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_UART1_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_UART2_INTR_MAP: UART2_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_UART2_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_UART2_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_UART2_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_UART2_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_UART2_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_SDIO_HOST_INTERRUPT_MAP: SDIO_HOST_INTERRUPT configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_SDIO_HOST_INTERRUPT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SDIO_HOST_INTERRUPT_MAP.Reg, volatile.LoadUint32(&o.PRO_SDIO_HOST_INTERRUPT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_SDIO_HOST_INTERRUPT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SDIO_HOST_INTERRUPT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_PWM0_INTR_MAP: PWM0_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_PWM0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PWM0_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PWM0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_PWM0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PWM0_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_PWM1_INTR_MAP: PWM1_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_PWM1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PWM1_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PWM1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_PWM1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PWM1_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_PWM2_INTR_MAP: PWM2_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_PWM2_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PWM2_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PWM2_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_PWM2_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PWM2_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_PWM3_INTR_MAP: PWM3_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_PWM3_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PWM3_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PWM3_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_PWM3_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PWM3_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_LEDC_INT_MAP: LEDC_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_LEDC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_LEDC_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_LEDC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_LEDC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_LEDC_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_EFUSE_INT_MAP: EFUSE_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_EFUSE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_EFUSE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_EFUSE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_EFUSE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_EFUSE_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_CAN_INT_MAP: CAN_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_CAN_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_CAN_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_CAN_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_CAN_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_CAN_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_USB_INTR_MAP: USB_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_USB_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_USB_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_USB_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_USB_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_USB_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_RTC_CORE_INTR_MAP: RTC_CORE_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_RTC_CORE_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_RTC_CORE_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_RTC_CORE_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_RTC_CORE_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_RTC_CORE_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_RMT_INTR_MAP: RMT_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_RMT_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_RMT_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_RMT_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_RMT_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_RMT_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_PCNT_INTR_MAP: PCNT_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_PCNT_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PCNT_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PCNT_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_PCNT_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PCNT_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_I2C_EXT0_INTR_MAP: I2C_EXT0_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_I2C_EXT0_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_I2C_EXT0_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_I2C_EXT0_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_I2C_EXT0_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_I2C_EXT0_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_I2C_EXT1_INTR_MAP: I2C_EXT1_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_I2C_EXT1_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_I2C_EXT1_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_I2C_EXT1_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_I2C_EXT1_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_I2C_EXT1_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_RSA_INTR_MAP: RSA_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_RSA_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_RSA_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_RSA_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_RSA_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_RSA_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_SHA_INTR_MAP: SHA_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_SHA_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SHA_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_SHA_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_SHA_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SHA_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_AES_INTR_MAP: AES_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_AES_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_AES_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_AES_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_AES_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_AES_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_SPI2_DMA_INT_MAP: SPI2_DMA_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_SPI2_DMA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SPI2_DMA_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_SPI2_DMA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_SPI2_DMA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SPI2_DMA_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_SPI3_DMA_INT_MAP: SPI3_DMA_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_SPI3_DMA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SPI3_DMA_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_SPI3_DMA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_SPI3_DMA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SPI3_DMA_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_WDG_INT_MAP: WDG_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_WDG_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_WDG_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_WDG_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_WDG_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_WDG_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TIMER_INT1_MAP: TIMER_INT1 interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TIMER_INT1_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TIMER_INT1_MAP.Reg, volatile.LoadUint32(&o.PRO_TIMER_INT1_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TIMER_INT1_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TIMER_INT1_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TIMER_INT2_MAP: TIMER_INT2 interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TIMER_INT2_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TIMER_INT2_MAP.Reg, volatile.LoadUint32(&o.PRO_TIMER_INT2_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TIMER_INT2_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TIMER_INT2_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG_T0_EDGE_INT_MAP: TG_T0_EDGE_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG_T0_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_T0_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_T0_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG_T0_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_T0_EDGE_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG_T1_EDGE_INT_MAP: TG_T1_EDGE_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG_T1_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_T1_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_T1_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG_T1_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_T1_EDGE_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG_WDT_EDGE_INT_MAP: TG_WDT_EDGE_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG_WDT_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_WDT_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_WDT_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG_WDT_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_WDT_EDGE_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG_LACT_EDGE_INT_MAP: TG_LACT_EDGE_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG_LACT_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG_LACT_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG_LACT_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG_LACT_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG_LACT_EDGE_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG1_T0_EDGE_INT_MAP: TG1_T0_EDGE_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG1_T0_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_T0_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_T0_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG1_T0_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_T0_EDGE_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG1_T1_EDGE_INT_MAP: TG1_T1_EDGE_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG1_T1_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_T1_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_T1_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG1_T1_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_T1_EDGE_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG1_WDT_EDGE_INT_MAP: TG1_WDT_EDGE_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG1_WDT_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_WDT_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_WDT_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG1_WDT_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_WDT_EDGE_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_TG1_LACT_EDGE_INT_MAP: TG1_LACT_EDGE_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_TG1_LACT_EDGE_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_TG1_LACT_EDGE_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_TG1_LACT_EDGE_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_TG1_LACT_EDGE_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_TG1_LACT_EDGE_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_CACHE_IA_INT_MAP: CACHE_IA_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_CACHE_IA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_CACHE_IA_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_CACHE_IA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_CACHE_IA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_CACHE_IA_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_SYSTIMER_TARGET0_INT_MAP: SYSTIMER_TARGET0_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_SYSTIMER_TARGET0_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SYSTIMER_TARGET0_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_SYSTIMER_TARGET0_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_SYSTIMER_TARGET0_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SYSTIMER_TARGET0_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_SYSTIMER_TARGET1_INT_MAP: SYSTIMER_TARGET1_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_SYSTIMER_TARGET1_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SYSTIMER_TARGET1_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_SYSTIMER_TARGET1_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_SYSTIMER_TARGET1_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SYSTIMER_TARGET1_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_SYSTIMER_TARGET2_INT_MAP: SYSTIMER_TARGET2_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_SYSTIMER_TARGET2_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SYSTIMER_TARGET2_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_SYSTIMER_TARGET2_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_SYSTIMER_TARGET2_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SYSTIMER_TARGET2_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_ASSIST_DEBUG_INTR_MAP: ASSIST_DEBUG_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_ASSIST_DEBUG_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_ASSIST_DEBUG_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_ASSIST_DEBUG_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_ASSIST_DEBUG_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_ASSIST_DEBUG_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_PMS_PRO_IRAM0_ILG_INTR_MAP: PMS_PRO_IRAM0_ILG interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_PMS_PRO_IRAM0_ILG_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PMS_PRO_IRAM0_ILG_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PMS_PRO_IRAM0_ILG_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_PMS_PRO_IRAM0_ILG_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PMS_PRO_IRAM0_ILG_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_PMS_PRO_DRAM0_ILG_INTR_MAP: PMS_PRO_DRAM0_ILG interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_PMS_PRO_DRAM0_ILG_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PMS_PRO_DRAM0_ILG_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PMS_PRO_DRAM0_ILG_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_PMS_PRO_DRAM0_ILG_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PMS_PRO_DRAM0_ILG_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_PMS_PRO_DPORT_ILG_INTR_MAP: PMS_PRO_DPORT_ILG interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_PMS_PRO_DPORT_ILG_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PMS_PRO_DPORT_ILG_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PMS_PRO_DPORT_ILG_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_PMS_PRO_DPORT_ILG_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PMS_PRO_DPORT_ILG_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_PMS_PRO_AHB_ILG_INTR_MAP: PMS_PRO_AHB_ILG interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_PMS_PRO_AHB_ILG_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PMS_PRO_AHB_ILG_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PMS_PRO_AHB_ILG_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_PMS_PRO_AHB_ILG_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PMS_PRO_AHB_ILG_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_PMS_PRO_CACHE_ILG_INTR_MAP: PMS_PRO_CACHE_ILG interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_PMS_PRO_CACHE_ILG_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PMS_PRO_CACHE_ILG_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PMS_PRO_CACHE_ILG_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_PMS_PRO_CACHE_ILG_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PMS_PRO_CACHE_ILG_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_PMS_DMA_APB_I_ILG_INTR_MAP: PMS_DMA_APB_I_ILG interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_PMS_DMA_APB_I_ILG_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PMS_DMA_APB_I_ILG_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PMS_DMA_APB_I_ILG_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_PMS_DMA_APB_I_ILG_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PMS_DMA_APB_I_ILG_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_PMS_DMA_RX_I_ILG_INTR_MAP: PMS_DMA_RX_I_ILG interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_PMS_DMA_RX_I_ILG_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PMS_DMA_RX_I_ILG_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PMS_DMA_RX_I_ILG_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_PMS_DMA_RX_I_ILG_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PMS_DMA_RX_I_ILG_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_PMS_DMA_TX_I_ILG_INTR_MAP: PMS_DMA_TX_I_ILG interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_PMS_DMA_TX_I_ILG_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_PMS_DMA_TX_I_ILG_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_PMS_DMA_TX_I_ILG_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_PMS_DMA_TX_I_ILG_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_PMS_DMA_TX_I_ILG_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_SPI_MEM_REJECT_INTR_MAP: SPI_MEM_REJECT_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_SPI_MEM_REJECT_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SPI_MEM_REJECT_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_SPI_MEM_REJECT_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_SPI_MEM_REJECT_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SPI_MEM_REJECT_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_DMA_COPY_INTR_MAP: DMA_COPY_INTR interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_DMA_COPY_INTR_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_DMA_COPY_INTR_MAP.Reg, volatile.LoadUint32(&o.PRO_DMA_COPY_INTR_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_DMA_COPY_INTR_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_DMA_COPY_INTR_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_SPI4_DMA_INT_MAP: SPI4_DMA_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_SPI4_DMA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SPI4_DMA_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_SPI4_DMA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_SPI4_DMA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SPI4_DMA_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_SPI_INTR_4_MAP: SPI_INTR_4 interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_SPI_INTR_4_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_SPI_INTR_4_MAP.Reg, volatile.LoadUint32(&o.PRO_SPI_INTR_4_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_SPI_INTR_4_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_SPI_INTR_4_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_DCACHE_PRELOAD_INT_MAP: DCACHE_PRELOAD_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_DCACHE_PRELOAD_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_PRELOAD_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_DCACHE_PRELOAD_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_DCACHE_PRELOAD_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_PRELOAD_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_ICACHE_PRELOAD_INT_MAP: ICACHE_PRELOAD_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_ICACHE_PRELOAD_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_PRELOAD_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_ICACHE_PRELOAD_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_ICACHE_PRELOAD_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_PRELOAD_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_APB_ADC_INT_MAP: APB_ADC_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_APB_ADC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_APB_ADC_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_APB_ADC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_APB_ADC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_APB_ADC_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_CRYPTO_DMA_INT_MAP: CRYPTO_DMA_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_CRYPTO_DMA_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_CRYPTO_DMA_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_CRYPTO_DMA_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_CRYPTO_DMA_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_CRYPTO_DMA_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_CPU_PERI_ERROR_INT_MAP: CPU_PERI_ERROR_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_CPU_PERI_ERROR_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_CPU_PERI_ERROR_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_CPU_PERI_ERROR_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_CPU_PERI_ERROR_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_CPU_PERI_ERROR_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_APB_PERI_ERROR_INT_MAP: APB_PERI_ERROR_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_APB_PERI_ERROR_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_APB_PERI_ERROR_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_APB_PERI_ERROR_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_APB_PERI_ERROR_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_APB_PERI_ERROR_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_DCACHE_SYNC_INT_MAP: DCACHE_SYNC_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_DCACHE_SYNC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_DCACHE_SYNC_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_DCACHE_SYNC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_DCACHE_SYNC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_DCACHE_SYNC_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_ICACHE_SYNC_INT_MAP: ICACHE_SYNC_INT interrupt configuration register
func (o *INTERRUPT_CORE0_Type) SetPRO_ICACHE_SYNC_INT_MAP(value uint32) {
	volatile.StoreUint32(&o.PRO_ICACHE_SYNC_INT_MAP.Reg, volatile.LoadUint32(&o.PRO_ICACHE_SYNC_INT_MAP.Reg)&^(0x1f)|value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_ICACHE_SYNC_INT_MAP() uint32 {
	return volatile.LoadUint32(&o.PRO_ICACHE_SYNC_INT_MAP.Reg) & 0x1f
}

// INTERRUPT_CORE0.PRO_INTR_STATUS_0: Interrupt status register 0
func (o *INTERRUPT_CORE0_Type) SetPRO_INTR_STATUS_0(value uint32) {
	volatile.StoreUint32(&o.PRO_INTR_STATUS_0.Reg, value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_INTR_STATUS_0() uint32 {
	return volatile.LoadUint32(&o.PRO_INTR_STATUS_0.Reg)
}

// INTERRUPT_CORE0.PRO_INTR_STATUS_1: Interrupt status register 1
func (o *INTERRUPT_CORE0_Type) SetPRO_INTR_STATUS_1(value uint32) {
	volatile.StoreUint32(&o.PRO_INTR_STATUS_1.Reg, value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_INTR_STATUS_1() uint32 {
	return volatile.LoadUint32(&o.PRO_INTR_STATUS_1.Reg)
}

// INTERRUPT_CORE0.PRO_INTR_STATUS_2: Interrupt status register 2
func (o *INTERRUPT_CORE0_Type) SetPRO_INTR_STATUS_2(value uint32) {
	volatile.StoreUint32(&o.PRO_INTR_STATUS_2.Reg, value)
}
func (o *INTERRUPT_CORE0_Type) GetPRO_INTR_STATUS_2() uint32 {
	return volatile.LoadUint32(&o.PRO_INTR_STATUS_2.Reg)
}

// INTERRUPT_CORE0.CLOCK_GATE: NMI interrupt signals mask register
func (o *INTERRUPT_CORE0_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *INTERRUPT_CORE0_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}
func (o *INTERRUPT_CORE0_Type) SetCLOCK_GATE_PRO_NMI_MASK_HW(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x2)|value<<1)
}
func (o *INTERRUPT_CORE0_Type) GetCLOCK_GATE_PRO_NMI_MASK_HW() uint32 {
	return (volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x2) >> 1
}

// INTERRUPT_CORE0.REG_DATE: Version control register
func (o *INTERRUPT_CORE0_Type) SetREG_DATE_INTERRUPT_REG_DATE(value uint32) {
	volatile.StoreUint32(&o.REG_DATE.Reg, volatile.LoadUint32(&o.REG_DATE.Reg)&^(0xfffffff)|value)
}
func (o *INTERRUPT_CORE0_Type) GetREG_DATE_INTERRUPT_REG_DATE() uint32 {
	return volatile.LoadUint32(&o.REG_DATE.Reg) & 0xfffffff
}

// Input/Output Multiplexer
type IO_MUX_Type struct {
	PIN_CTRL volatile.Register32 // 0x0
	GPIO0    volatile.Register32 // 0x4
	GPIO1    volatile.Register32 // 0x8
	GPIO2    volatile.Register32 // 0xC
	GPIO3    volatile.Register32 // 0x10
	GPIO4    volatile.Register32 // 0x14
	GPIO5    volatile.Register32 // 0x18
	GPIO6    volatile.Register32 // 0x1C
	GPIO7    volatile.Register32 // 0x20
	GPIO8    volatile.Register32 // 0x24
	GPIO9    volatile.Register32 // 0x28
	GPIO10   volatile.Register32 // 0x2C
	GPIO11   volatile.Register32 // 0x30
	GPIO12   volatile.Register32 // 0x34
	GPIO13   volatile.Register32 // 0x38
	GPIO14   volatile.Register32 // 0x3C
	GPIO15   volatile.Register32 // 0x40
	GPIO16   volatile.Register32 // 0x44
	GPIO17   volatile.Register32 // 0x48
	GPIO18   volatile.Register32 // 0x4C
	GPIO19   volatile.Register32 // 0x50
	GPIO20   volatile.Register32 // 0x54
	GPIO21   volatile.Register32 // 0x58
	_        [16]byte
	GPIO26   volatile.Register32 // 0x6C
	GPIO27   volatile.Register32 // 0x70
	GPIO28   volatile.Register32 // 0x74
	GPIO29   volatile.Register32 // 0x78
	GPIO30   volatile.Register32 // 0x7C
	GPIO31   volatile.Register32 // 0x80
	GPIO32   volatile.Register32 // 0x84
	GPIO33   volatile.Register32 // 0x88
	GPIO34   volatile.Register32 // 0x8C
	GPIO35   volatile.Register32 // 0x90
	GPIO36   volatile.Register32 // 0x94
	GPIO37   volatile.Register32 // 0x98
	GPIO38   volatile.Register32 // 0x9C
	GPIO39   volatile.Register32 // 0xA0
	GPIO40   volatile.Register32 // 0xA4
	GPIO41   volatile.Register32 // 0xA8
	GPIO42   volatile.Register32 // 0xAC
	GPIO43   volatile.Register32 // 0xB0
	GPIO44   volatile.Register32 // 0xB4
	GPIO45   volatile.Register32 // 0xB8
	GPIO46   volatile.Register32 // 0xBC
	_        [60]byte
	DATE     volatile.Register32 // 0xFC
}

// IO_MUX.PIN_CTRL: Clock output configuration register
func (o *IO_MUX_Type) SetPIN_CTRL_PIN_CLK_OUT1(value uint32) {
	volatile.StoreUint32(&o.PIN_CTRL.Reg, volatile.LoadUint32(&o.PIN_CTRL.Reg)&^(0xf)|value)
}
func (o *IO_MUX_Type) GetPIN_CTRL_PIN_CLK_OUT1() uint32 {
	return volatile.LoadUint32(&o.PIN_CTRL.Reg) & 0xf
}
func (o *IO_MUX_Type) SetPIN_CTRL_PIN_CLK_OUT2(value uint32) {
	volatile.StoreUint32(&o.PIN_CTRL.Reg, volatile.LoadUint32(&o.PIN_CTRL.Reg)&^(0xf0)|value<<4)
}
func (o *IO_MUX_Type) GetPIN_CTRL_PIN_CLK_OUT2() uint32 {
	return (volatile.LoadUint32(&o.PIN_CTRL.Reg) & 0xf0) >> 4
}
func (o *IO_MUX_Type) SetPIN_CTRL_PIN_CLK_OUT3(value uint32) {
	volatile.StoreUint32(&o.PIN_CTRL.Reg, volatile.LoadUint32(&o.PIN_CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *IO_MUX_Type) GetPIN_CTRL_PIN_CLK_OUT3() uint32 {
	return (volatile.LoadUint32(&o.PIN_CTRL.Reg) & 0xf00) >> 8
}
func (o *IO_MUX_Type) SetPIN_CTRL_SWITCH_PRT_NUM(value uint32) {
	volatile.StoreUint32(&o.PIN_CTRL.Reg, volatile.LoadUint32(&o.PIN_CTRL.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetPIN_CTRL_SWITCH_PRT_NUM() uint32 {
	return (volatile.LoadUint32(&o.PIN_CTRL.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetPIN_CTRL_PAD_POWER_CTRL(value uint32) {
	volatile.StoreUint32(&o.PIN_CTRL.Reg, volatile.LoadUint32(&o.PIN_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetPIN_CTRL_PAD_POWER_CTRL() uint32 {
	return (volatile.LoadUint32(&o.PIN_CTRL.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO0: Configuration register for pin GPIO0
func (o *IO_MUX_Type) SetGPIO0_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO0.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO0_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO0_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO0_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO0_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO0_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO0_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO0_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO0_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO0_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO0_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO0_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO0_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO0_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO0.Reg, volatile.LoadUint32(&o.GPIO0.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO0_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO0.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO1: Configuration register for pin GPIO1
func (o *IO_MUX_Type) SetGPIO1_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO1.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO1_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO1_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO1_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO1_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO1_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO1_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO1_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO1_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO1_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO1_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO1_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO1_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO1_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO1.Reg, volatile.LoadUint32(&o.GPIO1.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO1_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO1.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO2: Configuration register for pin GPIO2
func (o *IO_MUX_Type) SetGPIO2_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO2.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO2_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO2_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO2_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO2_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO2_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO2_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO2_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO2_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO2_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO2_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO2_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO2_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO2_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO2.Reg, volatile.LoadUint32(&o.GPIO2.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO2_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO2.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO3: Configuration register for pin GPIO3
func (o *IO_MUX_Type) SetGPIO3_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO3.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO3_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO3_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO3_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO3_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO3_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO3_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO3_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO3_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO3_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO3_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO3_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO3_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO3_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO3.Reg, volatile.LoadUint32(&o.GPIO3.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO3_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO3.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO4: Configuration register for pin GPIO4
func (o *IO_MUX_Type) SetGPIO4_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO4.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO4_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO4_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO4_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO4_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO4_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO4_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO4_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO4_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO4_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO4_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO4_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO4_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO4_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO4.Reg, volatile.LoadUint32(&o.GPIO4.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO4_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO4.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO5: Configuration register for pin GPIO5
func (o *IO_MUX_Type) SetGPIO5_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO5.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO5_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO5_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO5_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO5_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO5_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO5_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO5_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO5_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO5_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO5_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO5_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO5_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO5_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO5.Reg, volatile.LoadUint32(&o.GPIO5.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO5_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO5.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO6: Configuration register for pin GPIO6
func (o *IO_MUX_Type) SetGPIO6_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO6.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO6_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO6_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO6_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO6_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO6_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO6_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO6_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO6_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO6_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO6_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO6_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO6_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO6_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO6.Reg, volatile.LoadUint32(&o.GPIO6.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO6_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO6.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO7: Configuration register for pin GPIO7
func (o *IO_MUX_Type) SetGPIO7_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO7.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO7_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO7_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO7_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO7_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO7_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO7_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO7_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO7_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO7_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO7_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO7_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO7_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO7_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO7.Reg, volatile.LoadUint32(&o.GPIO7.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO7_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO7.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO8: Configuration register for pin GPIO8
func (o *IO_MUX_Type) SetGPIO8_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO8.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO8_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO8_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO8_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO8_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO8_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO8_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO8_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO8_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO8_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO8_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO8_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO8_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO8_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO8.Reg, volatile.LoadUint32(&o.GPIO8.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO8_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO8.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO9: Configuration register for pin GPIO9
func (o *IO_MUX_Type) SetGPIO9_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO9.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO9_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO9_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO9_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO9_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO9_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO9_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO9_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO9_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO9_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO9_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO9_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO9_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO9_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO9.Reg, volatile.LoadUint32(&o.GPIO9.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO9_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO9.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO10: Configuration register for pin GPIO10
func (o *IO_MUX_Type) SetGPIO10_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO10.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO10_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO10_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO10_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO10_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO10_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO10_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO10_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO10_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO10_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO10_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO10_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO10_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO10_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO10.Reg, volatile.LoadUint32(&o.GPIO10.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO10_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO10.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO11: Configuration register for pin GPIO11
func (o *IO_MUX_Type) SetGPIO11_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO11.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO11_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO11_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO11_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO11_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO11_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO11_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO11_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO11_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO11_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO11_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO11_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO11_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO11_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO11.Reg, volatile.LoadUint32(&o.GPIO11.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO11_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO11.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO12: Configuration register for pin GPIO12
func (o *IO_MUX_Type) SetGPIO12_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO12.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO12_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO12_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO12_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO12_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO12_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO12_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO12_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO12_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO12_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO12_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO12_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO12_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO12_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO12.Reg, volatile.LoadUint32(&o.GPIO12.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO12_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO12.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO13: Configuration register for pin GPIO13
func (o *IO_MUX_Type) SetGPIO13_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO13.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO13_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO13_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO13_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO13_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO13_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO13_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO13_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO13_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO13_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO13_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO13_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO13_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO13_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO13.Reg, volatile.LoadUint32(&o.GPIO13.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO13_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO13.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO14: Configuration register for pin GPIO14
func (o *IO_MUX_Type) SetGPIO14_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO14.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO14_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO14_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO14_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO14_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO14_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO14_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO14_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO14_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO14_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO14_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO14_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO14_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO14_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO14.Reg, volatile.LoadUint32(&o.GPIO14.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO14_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO14.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO15: Configuration register for pin GPIO15
func (o *IO_MUX_Type) SetGPIO15_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO15.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO15_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO15_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO15_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO15_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO15_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO15_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO15_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO15_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO15_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO15_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO15_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO15_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO15_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO15.Reg, volatile.LoadUint32(&o.GPIO15.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO15_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO15.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO16: Configuration register for pin GPIO16
func (o *IO_MUX_Type) SetGPIO16_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO16.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO16_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO16_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO16_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO16_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO16_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO16_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO16_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO16_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO16_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO16_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO16_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO16_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO16_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO16.Reg, volatile.LoadUint32(&o.GPIO16.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO16_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO16.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO17: Configuration register for pin GPIO17
func (o *IO_MUX_Type) SetGPIO17_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO17.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO17_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO17_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO17_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO17_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO17_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO17_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO17_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO17_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO17_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO17_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO17_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO17_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO17_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO17.Reg, volatile.LoadUint32(&o.GPIO17.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO17_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO17.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO18: Configuration register for pin GPIO18
func (o *IO_MUX_Type) SetGPIO18_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO18.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO18_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO18_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO18_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO18_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO18_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO18_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO18_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO18_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO18_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO18_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO18_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO18_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO18_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO18.Reg, volatile.LoadUint32(&o.GPIO18.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO18_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO18.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO19: Configuration register for pin GPIO19
func (o *IO_MUX_Type) SetGPIO19_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO19.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO19_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO19_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO19_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO19_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO19_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO19_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO19_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO19_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO19_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO19_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO19_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO19_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO19_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO19.Reg, volatile.LoadUint32(&o.GPIO19.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO19_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO19.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO20: Configuration register for pin GPIO20
func (o *IO_MUX_Type) SetGPIO20_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO20.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO20_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO20_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO20_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO20_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO20_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO20_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO20_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO20_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO20_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO20_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO20_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO20_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO20_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO20.Reg, volatile.LoadUint32(&o.GPIO20.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO20_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO20.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO21: Configuration register for pin GPIO21
func (o *IO_MUX_Type) SetGPIO21_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO21.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO21_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO21_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO21_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO21_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO21_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO21_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO21_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO21_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO21_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO21_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO21_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO21_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO21_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO21_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO21_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO21_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO21.Reg, volatile.LoadUint32(&o.GPIO21.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO21_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO21.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO26: Configuration register for pin GPIO26
func (o *IO_MUX_Type) SetGPIO26_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO26_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO26.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO26_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO26_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO26_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO26_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO26_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO26_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO26_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO26_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO26_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO26_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO26_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO26_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO26_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO26_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO26_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO26_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO26_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO26_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO26_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO26.Reg, volatile.LoadUint32(&o.GPIO26.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO26_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO26.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO27: Configuration register for pin GPIO27
func (o *IO_MUX_Type) SetGPIO27_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO27_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO27.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO27_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO27_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO27_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO27_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO27_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO27_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO27_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO27_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO27_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO27_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO27_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO27_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO27_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO27_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO27_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO27_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO27_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO27_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO27_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO27.Reg, volatile.LoadUint32(&o.GPIO27.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO27_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO27.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO28: Configuration register for pin GPIO28
func (o *IO_MUX_Type) SetGPIO28_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO28_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO28.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO28_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO28_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO28_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO28_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO28_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO28_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO28_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO28_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO28_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO28_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO28_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO28_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO28_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO28_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO28_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO28_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO28_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO28_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO28_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO28.Reg, volatile.LoadUint32(&o.GPIO28.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO28_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO28.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO29: Configuration register for pin GPIO29
func (o *IO_MUX_Type) SetGPIO29_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO29_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO29.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO29_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO29_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO29_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO29_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO29_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO29_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO29_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO29_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO29_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO29_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO29_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO29_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO29_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO29_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO29_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO29_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO29_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO29_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO29_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO29.Reg, volatile.LoadUint32(&o.GPIO29.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO29_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO29.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO30: Configuration register for pin GPIO30
func (o *IO_MUX_Type) SetGPIO30_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO30_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO30.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO30_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO30_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO30_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO30_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO30_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO30_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO30_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO30_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO30_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO30_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO30_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO30_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO30_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO30_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO30_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO30_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO30_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO30_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO30_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO30.Reg, volatile.LoadUint32(&o.GPIO30.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO30_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO30.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO31: Configuration register for pin GPIO31
func (o *IO_MUX_Type) SetGPIO31_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO31_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO31.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO31_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO31_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO31_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO31_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO31_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO31_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO31_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO31_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO31_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO31_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO31_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO31_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO31_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO31_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO31_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO31_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO31_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO31_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO31_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO31.Reg, volatile.LoadUint32(&o.GPIO31.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO31_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO31.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO32: Configuration register for pin GPIO32
func (o *IO_MUX_Type) SetGPIO32_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO32_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO32.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO32_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO32_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO32_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO32_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO32_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO32_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO32_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO32_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO32_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO32_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO32_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO32_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO32_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO32_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO32_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO32_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO32_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO32_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO32_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO32.Reg, volatile.LoadUint32(&o.GPIO32.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO32_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO32.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO33: Configuration register for pin GPIO33
func (o *IO_MUX_Type) SetGPIO33_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO33_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO33.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO33_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO33_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO33_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO33_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO33_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO33_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO33_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO33_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO33_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO33_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO33_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO33_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO33_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO33_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO33_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO33_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO33_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO33_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO33_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO33.Reg, volatile.LoadUint32(&o.GPIO33.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO33_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO33.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO34: Configuration register for pin GPIO34
func (o *IO_MUX_Type) SetGPIO34_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO34_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO34.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO34_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO34_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO34_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO34_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO34_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO34_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO34_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO34_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO34_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO34_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO34_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO34_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO34_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO34_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO34_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO34_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO34_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO34_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO34_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO34.Reg, volatile.LoadUint32(&o.GPIO34.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO34_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO34.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO35: Configuration register for pin GPIO35
func (o *IO_MUX_Type) SetGPIO35_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO35_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO35.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO35_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO35_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO35_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO35_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO35_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO35_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO35_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO35_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO35_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO35_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO35_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO35_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO35_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO35_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO35_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO35_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO35_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO35_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO35_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO35.Reg, volatile.LoadUint32(&o.GPIO35.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO35_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO35.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO36: Configuration register for pin GPIO36
func (o *IO_MUX_Type) SetGPIO36_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO36_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO36.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO36_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO36_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO36_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO36_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO36_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO36_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO36_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO36_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO36_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO36_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO36_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO36_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO36_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO36_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO36_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO36_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO36_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO36_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO36_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO36.Reg, volatile.LoadUint32(&o.GPIO36.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO36_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO36.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO37: Configuration register for pin GPIO37
func (o *IO_MUX_Type) SetGPIO37_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO37_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO37.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO37_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO37_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO37_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO37_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO37_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO37_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO37_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO37_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO37_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO37_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO37_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO37_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO37_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO37_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO37_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO37_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO37_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO37_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO37_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO37.Reg, volatile.LoadUint32(&o.GPIO37.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO37_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO37.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO38: Configuration register for pin GPIO38
func (o *IO_MUX_Type) SetGPIO38_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO38_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO38.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO38_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO38_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO38_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO38_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO38_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO38_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO38_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO38_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO38_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO38_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO38_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO38_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO38_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO38_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO38_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO38_FUN_DRV() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0xc00) >> 10
}
func (o *IO_MUX_Type) SetGPIO38_MCU_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x7000)|value<<12)
}
func (o *IO_MUX_Type) GetGPIO38_MCU_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x7000) >> 12
}
func (o *IO_MUX_Type) SetGPIO38_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.GPIO38.Reg, volatile.LoadUint32(&o.GPIO38.Reg)&^(0x8000)|value<<15)
}
func (o *IO_MUX_Type) GetGPIO38_FILTER_EN() uint32 {
	return (volatile.LoadUint32(&o.GPIO38.Reg) & 0x8000) >> 15
}

// IO_MUX.GPIO39: Configuration register for pin GPIO39
func (o *IO_MUX_Type) SetGPIO39_MCU_OE(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x1)|value)
}
func (o *IO_MUX_Type) GetGPIO39_MCU_OE() uint32 {
	return volatile.LoadUint32(&o.GPIO39.Reg) & 0x1
}
func (o *IO_MUX_Type) SetGPIO39_SLP_SEL(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x2)|value<<1)
}
func (o *IO_MUX_Type) GetGPIO39_SLP_SEL() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x2) >> 1
}
func (o *IO_MUX_Type) SetGPIO39_MCU_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x4)|value<<2)
}
func (o *IO_MUX_Type) GetGPIO39_MCU_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x4) >> 2
}
func (o *IO_MUX_Type) SetGPIO39_MCU_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x8)|value<<3)
}
func (o *IO_MUX_Type) GetGPIO39_MCU_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x8) >> 3
}
func (o *IO_MUX_Type) SetGPIO39_MCU_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x10)|value<<4)
}
func (o *IO_MUX_Type) GetGPIO39_MCU_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x10) >> 4
}
func (o *IO_MUX_Type) SetGPIO39_FUN_WPD(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x80)|value<<7)
}
func (o *IO_MUX_Type) GetGPIO39_FUN_WPD() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x80) >> 7
}
func (o *IO_MUX_Type) SetGPIO39_FUN_WPU(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x100)|value<<8)
}
func (o *IO_MUX_Type) GetGPIO39_FUN_WPU() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x100) >> 8
}
func (o *IO_MUX_Type) SetGPIO39_FUN_IE(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0x200)|value<<9)
}
func (o *IO_MUX_Type) GetGPIO39_FUN_IE() uint32 {
	return (volatile.LoadUint32(&o.GPIO39.Reg) & 0x200) >> 9
}
func (o *IO_MUX_Type) SetGPIO39_FUN_DRV(value uint32) {
	volatile.StoreUint32(&o.GPIO39.Reg, volatile.LoadUint32(&o.GPIO39.Reg)&^(0xc00)|value<<10)
}
func (o *IO_MUX_Type) GetGPIO39_F